package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidInputDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdFeeDo;
import cn.com.duiba.nezha.alg.alg.vo.ee.AdControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.*;


@Slf4j
public class BidControl {

    //行业ID---6:教育, 9:二电, 15:会籍卡, 16:运营商, 21:保险
    public static List<Long> tradeList = Arrays.asList(15L, 16L);


    /**
     * 出价控制
     * 描述：
     * 包含所有算法出价调节策略
     * 1、出价维稳调节
     * 2、价格保护
     * 3、探价
     * 4、底价放弃
     * 5、预算平滑（暂无）
     * 6、纠偏出价调节（暂无）
     *
     * 输入说明：
     * 1、所有配置集合
     * 2、算法控制参数对象
     * 输出说明：
     * 1、出价、是否放弃
     * 2、控制参数
     */

    /**
     * 批量接口
     *
     * @param advertMap   竞价广告列表
     * @param paramsModel 控制参数对象
     */
    public static Map<String, AdBidResultDo> bidControl(Map<String, AdBidInputDo> advertMap, OcpxControlModel paramsModel) {
        Map<String, AdBidResultDo> ret = new HashMap<>();

        for (Map.Entry<String, AdBidInputDo> entry : advertMap.entrySet()) {

            String key = entry.getKey();
            AdBidInputDo adBidInputDo = entry.getValue();

            AdBidResultDo adBidResultDo = bidControl(adBidInputDo, paramsModel);

            //todo 临时测试
            //adBidResultDo.setDeepFeeFactor(1.1);

            adBidResultDo.setKey(key);
            ret.put(key, adBidResultDo);
        }
        return ret;
    }

    /**
     * 单广告接口
     *
     * @param adBidInputDo 竞价广告
     * @param paramsModel  控制参数对象
     */
    public static AdBidResultDo bidControl(AdBidInputDo adBidInputDo, OcpxControlModel paramsModel) {
        AdBidResultDo adBidResultDo = new AdBidResultDo();


        adBidResultDo.setAdvertId(adBidInputDo.getAdvertId());
        adBidResultDo.setPackageId(adBidInputDo.getPackageId());
        adBidResultDo.setSlotId(adBidInputDo.getSlotId());
        adBidResultDo.setReservePriceGiveUp(false);
        adBidResultDo.setReserveFee(adBidInputDo.getReserveFee());



        if (adBidInputDo.getChargeType() == null) {
            adBidInputDo.setChargeType(0);
        }
        adBidResultDo.setChargeType(adBidInputDo.getChargeType());

        adBidResultDo.setIsSupport(adBidInputDo.getIsSupport());

        adBidResultDo.setCtr(adBidInputDo.getCtr());


        adBidResultDo.setAccountId(adBidInputDo.getAccountId());
        adBidResultDo.setPcfactor(1.0); //pcfactor默认为1.0


        /**
         * cpc 广告
         */
        if (adBidInputDo.getChargeType() == 1) {

            adBidResultDo.setFee(adBidInputDo.getFee());

            AdBidParamsDo cpcAdBidParamsDo = new AdBidParamsDo();
            cpcAdBidParamsDo.setIsNewOTest(adBidInputDo.getIsNewOTest());
            cpcAdBidParamsDo.setNewOAbTestId(adBidInputDo.getNewOAbTestId());
            adBidResultDo.setAdBidParamsDo(cpcAdBidParamsDo);

        }

        /**
         * ocpc广告
         */

        if (adBidInputDo.getChargeType() == 2) {

            long fee = getOcpcFee(adBidInputDo.getCvr(), adBidInputDo.getAFee(), adBidInputDo.getAppAFee(), adBidInputDo.getSpecialAccountWeight());

            adBidResultDo.setFee(fee);
            adBidResultDo.setFactor(1.0);
            adBidResultDo.setDeepFeeFactor(1.0);

            if (AssertUtil.isNotEmpty(paramsModel)) {

                AdBidParamsDo adBidParamsDo = getBidParams(adBidInputDo, paramsModel, fee);

                if (AssertUtil.isNotEmpty(adBidParamsDo)) {
                    adBidResultDo.setFee(adBidParamsDo.getFee());
                    adBidResultDo.setFactor(adBidParamsDo.getFactor());
                    adBidResultDo.setPcfactor(adBidParamsDo.getPcFactor()); // 竞价结果对象中返回pcfactor，在竞价列表中打印出来，分析发券结构变化情况
                    adBidResultDo.setAdBidParamsDo(adBidParamsDo);
                    adBidResultDo.setReservePriceGiveUp(adBidParamsDo.getIsGiveUp());
                    adBidResultDo.setDcvrGiveUp(adBidParamsDo.getDcvrGiveUp());

                    adBidResultDo.setDeepFeeFactor(adBidParamsDo.getDeepFeeFactor());
                }

            }

        }


        return adBidResultDo;
    }


    public static AdBidParamsDo getBidParams(AdBidInputDo adBidInputDo,
                                             OcpxControlModel paramsModel, long fee) {

        AdBidParamsDo adBidParamsDo = new AdBidParamsDo();

        Long advertId = adBidInputDo.getAdvertId();
        Long packageId = adBidInputDo.getPackageId();
        Long slotId = adBidInputDo.getSlotId();
        Long cpcFee = adBidInputDo.getFee(); //默认参考cpc出价

//        long floorFee = adBidInputDo.getReserveFee();
        /**
         * 参数计算
         */

        adBidParamsDo.setFee(fee);

        adBidParamsDo.setOriginalFee(fee);

        adBidParamsDo.setAdvertId(advertId);
        adBidParamsDo.setNewTradeId(adBidInputDo.getNewTradeTagId());

        adBidParamsDo.setSlotId(slotId);
        adBidParamsDo.setPackageId(packageId);
        adBidParamsDo.setAFee(adBidInputDo.getAFee());//ocpx 广告 转化目标出价（配置的）
        adBidParamsDo.setAppAFee(adBidInputDo.getAppAFee());//ocpx 广告 媒体 转化目标出价（******   新增 !!!! *******）
        adBidParamsDo.setDeepFee(adBidInputDo.getDeepFee());//深度目标成本（2020.11.12）
        adBidParamsDo.setDcvrLowerBound(adBidInputDo.getDcvrLowerBound());// dcvr降价阈值 2023.10.31



        adBidParamsDo.setChargeType(adBidInputDo.getChargeType()); //是否ocpc，1：cpc、2：ocpc
        adBidParamsDo.setCvrType(adBidInputDo.getCvrType());//ocpx 转化目标类型，目前支持：0、2、3（2020.09.10）
        adBidParamsDo.setDeepCvrType(adBidInputDo.getDeepCvrType());//ocpx 深度转化目标类型，目前支持：8（2020.09.10）
        adBidParamsDo.setPreDcvr(adBidInputDo.getPreDcvr());//预估深度转化率

        adBidParamsDo.setFactor(1.0);
        adBidParamsDo.setReserveFee(adBidInputDo.getReserveFee());
        adBidParamsDo.setReservePriceWhite(adBidInputDo.getReservePriceWhite());

        adBidParamsDo.setIsAutoTarget(adBidInputDo.getIsAutoTarget());

        adBidParamsDo.setAbTestId(adBidInputDo.getAbTestId());
        adBidParamsDo.setFastAbTestId(adBidInputDo.getFastAbTestId());
        adBidParamsDo.setIsNewOTest(adBidInputDo.getIsNewOTest());
        adBidParamsDo.setNewOAbTestId(adBidInputDo.getNewOAbTestId());
        adBidParamsDo.setIsColdTest(adBidInputDo.getIsColdTest());
        adBidParamsDo.setColdAbTestId(adBidInputDo.getColdAbTestId());
        adBidParamsDo.setPreCalibrateTestId(adBidInputDo.getPreCalibrateTestId());

        adBidParamsDo.setDeepControlType(adBidInputDo.getDeepControlType());
        adBidParamsDo.setDoubleMode(adBidInputDo.getDoubleMode());

        adBidParamsDo.setBidControlType(adBidInputDo.getBidControlType());

        adBidParamsDo.setDeepAllEffect(adBidInputDo.getDeepAllEffect());

        adBidParamsDo.setReleaseTarget(adBidInputDo.getReleaseTarget());

        adBidParamsDo.setDeepDelayType(adBidInputDo.getDeepDelayType());// 双出价后端延迟类型： null：无  1：10分钟内   2：10分钟以上

        adBidParamsDo.setAppLimitReleaseMark(adBidInputDo.getAppLimitReleaseMark());

        adBidParamsDo.setPriceRiseMark(adBidInputDo.getPriceRiseMark());


        adBidParamsDo.setEeAbTestId(adBidInputDo.getEeAbTestId());//2022.2.16

        adBidParamsDo.setUpSpeedAbTestId(adBidInputDo.getUpSpeedAbTestId());//2022.2.16


//        System.out.println("ocpxControlSubModel=" + JSON.toJSONString(ocpxControlSubModel));



        /**
         * 处理逻辑
         *
         * 功能点：成本控制（跑量、底价、出价保护-过度出价，使用同一套参数）、双出价、出价保护-冷启动、试探
         *
         * 成本控制：
         *    跑量模式： releaseTarget=2、3
         *
         *
         *
         */


        /**
         * 选择成本控制对象
         * 12.3
         */
        //校准功能
        //CvrCalibrator.calibrate(adBidParamsDo, adBidInputDo.getIsotonicCalibrator(), adBidInputDo.getPreCvr());

        OcpxControlSubModel pModel = adBidInputDo.getOcpxControlSubModel();

        if (pModel != null) {


            /**
             * 策略
             */


            /**
             * 0 策略模式   常规成本控制、跑量成本控制、双出价成本控制
             * 白名单测试优先级：新o测试>双出价>跑量>冷启动
             */
            int costParamsType = 1; //默认

//            if (adBidParamsDo.getIsNewOTest() != null && adBidParamsDo.getIsNewOTest().equals(2)) {
//                //新o白名单测试
//                if (adBidParamsDo.getNewOAbTestId() != null && adBidParamsDo.getNewOAbTestId().equals(2)) {
//                    costParamsType = 2;
//                }
//
//            } else

            if (adBidParamsDo.getDeepControlType() != null) {

                //双出价白名单测试（附加：全切测试--仅实验组生效）
                if (adBidParamsDo.getAbTestId() != null && adBidParamsDo.getAbTestId().equals(2)) {
                    //costParamsType = 2; 关闭，测试期间使用
                }

            }

//                else if (adBidParamsDo.getReleaseTarget() != null && adBidParamsDo.getReleaseTarget() > 1L && adBidParamsDo.getReleaseTarget() != 4L
//                    && adBidParamsDo.getBidControlType() != null && adBidParamsDo.getBidControlType().equals(2)) {
//
//                //跑量测试模式: 选择跑量模式，按行业白名单开启测试
//                if (adBidParamsDo.getFastAbTestId() != null && adBidParamsDo.getFastAbTestId().equals(2)) {
//                    costParamsType = 2;
//                }
//
//            } else
//
//                if (adBidParamsDo.getIsColdTest() != null && adBidParamsDo.getIsColdTest().equals(2)) {
//                //冷启动白名单测试
//                if (adBidParamsDo.getColdAbTestId() != null && adBidParamsDo.getColdAbTestId().equals(2)) {
//                    costParamsType = 2;
//                }

//            }

            /**
             *  成本维稳
             */


//            costControl(adBidParamsDo, pModel.getOcpxControlParams(costParamsType), pModel.getOcpxControlParams(costParamsType, slotId), pModel.getAtOcpxControlParams(costParamsType));


            cvrCalibrate(adBidParamsDo, pModel.getOcpxControlParams(costParamsType), pModel.getOcpxControlParams(costParamsType, slotId));
            /**
             *  双出价
             *
             */

            deepControl(adBidParamsDo, pModel.getDeepControlParams(costParamsType),
                    pModel.getDeepControlParams(costParamsType, slotId), pModel.getOcpxControlParams(costParamsType),
                    pModel.getOcpxControlParams(costParamsType, slotId));


            /**
             *  底价控制参数
             */

            //floorPriceControl(adBidParamsDo, pModel.getOcpxControlParams(), pModel.getOcpxControlParams(1, slotId));

            /**
             *  出价保护-过度出价
             *
             */

            protectControl(adBidParamsDo, pModel.getOcpxControlParams(costParamsType), pModel.getOcpxControlParams(costParamsType, slotId), pModel.getAtOcpxControlParams(costParamsType), costParamsType);


        }

        /**
         * 6 出价保护-冷启动
         */
        //coldControl(adBidParamsDo, paramsModel.getAdSlotControlParams(advertId, slotId), paramsModel.getSlotControlParams(slotId), cpcFee);


        /**
         * 返回结果封装
         */

        return adBidParamsDo;
    }


    /**
     * 策略：成本维稳
     *
     * @return
     */
    public static void costControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams, OcpxControlParams atPkParams) {

        //维稳参数
        Long factorType = null;//维稳类型，1 配置  2 广告位 3 at 4 无

        Double factor = 1.0;// 维稳因子
        Double pcFactor = 1.0;// 预估值校准因子
        Double fcFactor = 1.0;// 跑量因子
        String updateTime = null;// 参数更新时间

        /**
         * 校准因子计算中间值埋点
         */
        Long cvrCnt = (long)0; // 累计的转化pv
        Double pcvrSum = 0.0001; // 累计的pcvr和
        Double pcvrBias = 0.0001; // 预估偏差
        Double confidenceWeight = 0.0001; // 数据的置信程度


        Long fee = adBidParamsDo.getFee();

        /**
         * 维稳重置
         */
        Integer resetType = OcpxControlParams.getResetType(pkParams);

        /**
         * 维稳调控优先级  自动定向>广告位>整体
         */
        OcpcFactorParams slotFactorParams = OcpxControlParams.getOcpcFactors(slotParams);
        OcpcFactorParams pkFactorParams = OcpxControlParams.getOcpcFactors(pkParams);
        OcpcFactorParams atPkFactorParams = OcpxControlParams.getOcpcFactors(atPkParams);
//        将校准逻辑放在cvrCalibrate方法里，不用此处的逻辑。
//        OcpcFactorParams slotFactorParams = OcpxControlParams.getOcpcFactorsWithCaliAB(slotParams, adBidParamsDo);
//        OcpcFactorParams pkFactorParams = OcpxControlParams.getOcpcFactorsWithCaliAB(pkParams, adBidParamsDo);
//        OcpcFactorParams atPkFactorParams = OcpxControlParams.getOcpcFactorsWithCaliAB(atPkParams, adBidParamsDo);


        Double slotFactor = slotFactorParams.getFactor();
        Double pkFactor = pkFactorParams.getFactor();
        Double atPkFactor = atPkFactorParams.getFactor();

//        if (atPkFactor != null && adBidParamsDo.getIsAutoTarget() != null && adBidParamsDo.getIsAutoTarget()) {
//            factorType = 3L;
//            factor = atPkFactor;
//            pcFactor = atPkFactorParams.getPcFactor();
//            fcFactor = atPkFactorParams.getFcFactor();
//
//
//            updateTime = OcpxControlParams.getUpdateTime(atPkParams);
//
//
//        } else

        if (pkFactor != null) {
            factorType = 1L;
            factor = pkFactor;
            pcFactor = pkFactorParams.getPcFactor();
            fcFactor = pkFactorParams.getFcFactor();
            updateTime = OcpxControlParams.getUpdateTime(pkParams);
            cvrCnt = OcpxControlParams.getCvrCnt(pkParams);
            pcvrSum = OcpxControlParams.getPcvrSum(pkParams);
            pcvrBias = OcpxControlParams.getPcvrBias(pkParams);
            confidenceWeight = OcpxControlParams.getConfidenceWeight(pkParams);

        }
        if (slotFactor != null) {
            factorType = 2L;
            factor = slotFactor;
            pcFactor = slotFactorParams.getPcFactor();
            fcFactor = slotFactorParams.getFcFactor();
            updateTime = OcpxControlParams.getUpdateTime(slotParams);

            cvrCnt = OcpxControlParams.getCvrCnt(slotParams);
            pcvrSum = OcpxControlParams.getPcvrSum(slotParams);
            pcvrBias = OcpxControlParams.getPcvrBias(slotParams);
            confidenceWeight = OcpxControlParams.getConfidenceWeight(slotParams);

        } else {
            if (Math.random() < 0.0001) {
                log.info("All param is null. pkId is " + adBidParamsDo.getPackageId() + "slotId is " + adBidParamsDo.getSlotId() + "abTest id is " + adBidParamsDo.getAbTestId());
            }
        }


        Long feeNew = Math.round(fee * factor);


        //维稳重置标记
        adBidParamsDo.setResetType(resetType);


        //维稳参数
        adBidParamsDo.setFactorType(factorType);
        adBidParamsDo.setFactor(factor * adBidParamsDo.getFactor()); // 由于之前此factor显式设定为1.0，此处不会报错的
        adBidParamsDo.setFee(feeNew);
        adBidParamsDo.setKbFee(feeNew);

        adBidParamsDo.setPcFactor(pcFactor);
        adBidParamsDo.setFcFactor(fcFactor);
        adBidParamsDo.setUpdateTime(updateTime);

        // 校准因子中间值埋点
        adBidParamsDo.setCvrCnt(cvrCnt);
        adBidParamsDo.setPcvrSum(pcvrSum);
        adBidParamsDo.setPcvrBias(pcvrBias);
        adBidParamsDo.setConfidenceWeight(confidenceWeight);


    }

    /**
     * 策略：双出价维稳
     *
     * @return
     */
    public static void deepControl(AdBidParamsDo adBidParamsDo, DeepControlParams pkParams,
                                   DeepControlParams slotParams, OcpxControlParams pkCostParams,
                                   OcpxControlParams slotCostParams) {

        Long fee = adBidParamsDo.getFee();

        /**
         * 未开启双出价 直接返回
         */
        if (AssertUtil.isAnyEmpty(
                adBidParamsDo.getDeepControlType(),
                adBidParamsDo.getDeepFee(),
                adBidParamsDo.getDeepCvrType())
        ) {
            return;
        }


        boolean deepStatus = true;
        /**
         * 会籍卡、盲盒、运营商，仅实验组 生效
         */
        if (adBidParamsDo.getNewTradeId() != null && (
                adBidParamsDo.getNewTradeId().equals(15L)
                || adBidParamsDo.getNewTradeId().equals(1L)
                || adBidParamsDo.getNewTradeId().equals(16L)

        )

        ) {
            deepStatus = false;
            if (adBidParamsDo.getAbTestId() != null && adBidParamsDo.getAbTestId().equals(2)) {
                deepStatus = true;
            }
        }

        //冗余逻辑，防止未携带 newTradeId
        if (adBidParamsDo.getNewTradeId() == null) {
            deepStatus = false;
            if (adBidParamsDo.getAbTestId() != null && adBidParamsDo.getAbTestId().equals(2)) {
                deepStatus = true;
            }
        }


        DeepControlParams useParams = new DeepControlParams();
        OcpxControlParams useCostParams = new OcpxControlParams();

        //判断哪个维度的参数有计算

        if (slotParams.getDeepFactor() != null) {
            useParams = slotParams;
            useCostParams = slotCostParams;

        } else if (pkParams.getDeepFactor() != null) {
            useParams = pkParams;
            useCostParams = pkCostParams;

        }

        DeepControlFactors useFactorDto = DeepBidControl.getDeepFactor(useCostParams, useParams, adBidParamsDo);

        //关于保率双出价的逻辑
        // Boolean dcvrGiveUp = DeepBidControl.dcvrConstrain(useParams, adBidParamsDo);
        //adBidParamsDo.setDcvrGiveUp(dcvrGiveUp);


        if (deepStatus && useFactorDto.getDeepFactor() != null) {
            //调整出价
            adBidParamsDo.setFee(Math.round(fee * useFactorDto.getDeepFactor()));
            adBidParamsDo.setDeepControlFactor(useFactorDto.getDeepFactor());
            //计费因子
            adBidParamsDo.setDeepFeeFactor(useFactorDto.getDeepFeeFactor());
            adBidParamsDo.setDcvrLowerBound(useFactorDto.getDcvrLowerBound());
        }

        adBidParamsDo.setPkStatDcvr(useParams.getPkStatDcvr());
        adBidParamsDo.setSlotStatDcvr(useParams.getSlotStatDcvr());
        adBidParamsDo.setDeepConfWeight(useParams.getConfWeight());

        adBidParamsDo.setStatDeepFactor(useFactorDto.getStatDeepFactor());
        adBidParamsDo.setPreDeepFactor(useFactorDto.getPreDeepFactor());


    }

    public static void cvrCalibrate(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams) {
        Double pcFactor = 1.0;// 预估值校准因子 和原来的维稳因子兼容。
        String updateTime = null;// 参数更新时间
        /**
         * 校准因子计算中间值埋点
         */
        Long cvrCnt = (long)0; // 累计的转化pv
        Double pcvrSum = 0.0001; // 累计的pcvr和
        Double pcvrBias = 0.0001; // 预估偏差
        Double confidenceWeight = 0.0001; // 数据的置信程度


        Long fee = adBidParamsDo.getFee();
        if (pkParams != null) {
            pcFactor = pkParams.getPcFactor();
            updateTime = OcpxControlParams.getUpdateTime(pkParams);
            cvrCnt = OcpxControlParams.getCvrCnt(pkParams);
            pcvrSum = OcpxControlParams.getPcvrSum(pkParams);
            pcvrBias = OcpxControlParams.getPcvrBias(pkParams);
            confidenceWeight = OcpxControlParams.getConfidenceWeight(pkParams);
        }

        if (slotParams != null) {
            pcFactor = slotParams.getPcFactor();
            updateTime = OcpxControlParams.getUpdateTime(slotParams);
            cvrCnt = OcpxControlParams.getCvrCnt(slotParams);
            pcvrSum = OcpxControlParams.getPcvrSum(slotParams);
            pcvrBias = OcpxControlParams.getPcvrBias(slotParams);
            confidenceWeight = OcpxControlParams.getConfidenceWeight(slotParams);
        }

        Long feeNew = fee;
        // 当命中实验，在fee上生效校准因子；
        // 2024.04.23 , 货到行业偏差不大，理论消耗arpu负向，不对货到作校准
        // 2024.05.07, 运营商行业理论消耗arpu负向，不对运营商行业作校准
        List<Long> undebiasTradeIdList = Arrays.asList(9L, 16L);

        if (adBidParamsDo.getPreCalibrateTestId() != null && adBidParamsDo.getNewTradeId() != null && !undebiasTradeIdList.contains(adBidParamsDo.getNewTradeId())) {
            // 2024.04.23 , 将校准因子实验设成 5(实验组), 2.5(实验组), 2.5(对照组)
            if (adBidParamsDo.getPreCalibrateTestId() == 602 || adBidParamsDo.getPreCalibrateTestId() == 603) {
                feeNew = Math.round(fee * pcFactor);
            }
        }


        adBidParamsDo.setFee(feeNew);
        adBidParamsDo.setPcFactor(pcFactor);
        adBidParamsDo.setUpdateTime(updateTime);
        // 校准因子中间值埋点
        adBidParamsDo.setCvrCnt(cvrCnt);
        adBidParamsDo.setPcvrSum(pcvrSum);
        adBidParamsDo.setPcvrBias(pcvrBias);
        adBidParamsDo.setConfidenceWeight(confidenceWeight);

    }
    /**
     * 策略：冷启动控制
     * <p>
     * 广告在广告位上历史投放较少时，限制过高出价
     * 90%出价，限制在平均出价下
     * 10%出价，限制在平均出价*2倍下
     *
     * @return
     */
    public static void coldControl(AdBidParamsDo adBidParamsDo, AdControlParams adControlParams, SlotControlParams slotControlParams, Long cpcFee) {

        //出价保护-冷启动
        Boolean coldProject = null;// 出价保护- 是否冷启动保护

        Long coldProjectFeeDiff = null;// 出价保护-冷启动出价下降

        Long fee = adBidParamsDo.getFee();


        if (slotControlParams != null) {


            if (adControlParams == null
                    || adControlParams.getIsColdStart() == null
                    || adControlParams.getIsColdStart()) {

                coldProject = true;

                Long feeNew = SlotControlParams.getFee(fee, cpcFee, slotControlParams);

                coldProjectFeeDiff = fee - feeNew;
                fee = feeNew;

            }
        }

        //出价保护-冷启动
        adBidParamsDo.setFee(fee);
        adBidParamsDo.setDefaultFee(cpcFee);
        adBidParamsDo.setColdProject(coldProject);
        adBidParamsDo.setColdProjectFeeDiff(coldProjectFeeDiff);

    }


    /**
     * 策略：成本控制策略
     *
     * @return
     */
    public static void protectControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams, OcpxControlParams atPkParams, int costParamsType) {

        //出价保护-过度出价
        Boolean secondPriceProject = null;// 出价保护，是否二阶保护
        Double secondProtectPriceFactor = null;// 出价保护，二阶因子
        Double extraCFactor = 1.0; // 突破二价程度
        Integer extraCSwitch = 0;  // 是否突破二价

        Long costReplase = null;// 超成本情况，使用该出价替代预估出价
        Long costDiff = null;//低成本模式，在预估出价上+

        if (atPkParams != null && atPkParams.getCFactor() != null) {

            secondProtectPriceFactor = atPkParams.getCFactor();
            extraCFactor = atPkParams.getExtraCFactor();
            extraCSwitch = atPkParams.getExtraCSwitch();
            costReplase = atPkParams.getCostReplase();
            costDiff = atPkParams.getCostDiff();

        } else if (slotParams != null && slotParams.getCFactor() != null) {

            secondProtectPriceFactor = slotParams.getCFactor();
            extraCFactor = slotParams.getExtraCFactor();
            extraCSwitch = slotParams.getExtraCSwitch();
            costReplase = slotParams.getCostReplase();
            costDiff = slotParams.getCostDiff();
        } else if (pkParams != null && pkParams.getCFactor() != null) {

            secondProtectPriceFactor = pkParams.getCFactor();
            extraCFactor = pkParams.getExtraCFactor();
            extraCSwitch = pkParams.getExtraCSwitch();
            costReplase = pkParams.getCostReplase();
            costDiff = pkParams.getCostDiff();

        }

        //todo


//        Double slotProtectPriceFactor = OcpxControlParams.getCostFactorWithProtect(slotParams, costParamsType);
//        Double slotProtectPriceFactor = OcpxControlParams.getCostFactorWithProtect(slotParams, costParamsType);
//
//
//        Double pkProtectPriceFactor = OcpxControlParams.getCostFactorWithProtect(pkParams, costParamsType);
//
//        Double atProtectPriceFactor = OcpxControlParams.getCostFactorWithProtect(atPkParams, costParamsType);
//
//        if (atProtectPriceFactor != null && adBidParamsDo.getIsAutoTarget() != null && adBidParamsDo.getIsAutoTarget()) {
//            secondProtectPriceFactor = atProtectPriceFactor;
//            extraCFactor = atPkParams.getExtraCFactor();
//            extraCSwitch = atPkParams.getExtraCSwitch();
//        } else if (slotProtectPriceFactor != null) {
//            secondProtectPriceFactor = slotProtectPriceFactor;
//            extraCFactor = slotParams.getExtraCFactor();
//            extraCSwitch = slotParams.getExtraCSwitch();
//        } else if (pkProtectPriceFactor != null) {
//            secondProtectPriceFactor = pkProtectPriceFactor;
//            extraCFactor = pkParams.getExtraCFactor();
//            extraCSwitch = pkParams.getExtraCSwitch();
//        }


        if (secondProtectPriceFactor != null) {
            secondPriceProject = true;

            /**
             * 当前出价保护 后置 在最后环节计算
             */

        }

        //出价保护-过度出价
        adBidParamsDo.setSecondPriceProject(secondPriceProject);
        adBidParamsDo.setCFactor(secondProtectPriceFactor);
        adBidParamsDo.setExtraCFactor(extraCFactor);
        adBidParamsDo.setExtraCSwitch(extraCSwitch);

        adBidParamsDo.setCostDiff(costDiff);
        adBidParamsDo.setCostReplase(costReplase);
    }

    /**
     * 策略：底价控制
     *
     * @return
     */
    public static void floorPriceControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams) {

        //底价控制参数

        Boolean isGiveUp = null;

        if (adBidParamsDo.getReservePriceWhite() != null && adBidParamsDo.getReservePriceWhite()) {
            adBidParamsDo.setReservePriceWhite(true);
            return;
        }


        Long giveUpFee = null;// 底价放弃阈值-出价

        Double giveUpRatio = null;// 底价放弃阈值-概率


        if (slotParams != null && slotParams.getFConf() != null && slotParams.getFConf()) {
            giveUpFee = slotParams.getFPriceThre();
            giveUpRatio = slotParams.getFGiveUpProb();
        } else if (pkParams != null && pkParams.getFConf() != null) {
            giveUpFee = pkParams.getFPriceThre();
            giveUpRatio = pkParams.getFGiveUpProb();

        } else {
            return;
        }

        //本次是否放弃
        double rate = Math.random();
        if (giveUpRatio != null && giveUpFee != null) {

            if (rate < giveUpRatio && adBidParamsDo.getFee() <= giveUpFee) {
                isGiveUp = true;
            }
        }


        //底价控制参数
        adBidParamsDo.setIsGiveUp(isGiveUp);

        adBidParamsDo.setGiveUpFee(giveUpFee);

        adBidParamsDo.setGiveUpRatio(giveUpRatio);

    }


    /**
     * 维稳重置
     * 描述：
     * 包含两种重置情况：
     * 1、配置重置
     * 2、配置修改目标、调整出价
     * <p>
     * 输入说明：
     * 1、配置基础信息
     * 2、算法控制参数对象
     * <p>
     * 输出说明：
     * 1、配置重置：
     * 2、算法控制参数对象（更新）
     * <p>
     * <p>
     * /**
     *
     * @param advertId  广告ID
     * @param packageId 配置ID
     * @param type      2 初始化重置（管理后台手动）  1：出价 或目标重置
     */
    public static void reSet(Long advertId, Long packageId, Integer type, OcpxControlModel paramsModel) {

        if (AssertUtil.isAllNotEmpty(advertId, packageId, type, paramsModel)) {

            OcpxControlSubModel ocpxControlSubModel = paramsModel.getOcpxControlSubModel(advertId, packageId);

            if (ocpxControlSubModel != null) {
                OcpxControlParams ocpxControlParams = ocpxControlSubModel.getOcpxControlParams();

                if (ocpxControlParams != null) {
                    ocpxControlParams.setResetType(type);
                }
            }
        }

    }


    /**
     * 维稳重置
     * 描述：
     * 包含两种重置情况：
     * 1、配置重置
     * 2、配置修改目标、调整出价
     * <p>
     * 输入说明：
     * 1、配置基础信息
     * 2、算法控制参数对象
     * <p>
     * 输出说明：
     * 1、配置重置：
     * 2、算法控制参数对象（更新）
     * <p>
     * <p>
     * /**
     *
     * @param advertId  广告ID
     * @param packageId 配置ID
     * @param type      2 初始化重置（管理后台手动）  1：出价 或目标重置
     */
    public static void reSet(Long advertId, Long packageId, Integer type, OcpxControlSubModel ocpxControlSubModel) {

        if (AssertUtil.isAllNotEmpty(advertId, packageId, type, ocpxControlSubModel)) {

            if (ocpxControlSubModel != null) {
                OcpxControlParams ocpxControlParams = ocpxControlSubModel.getOcpxControlParams();

                if (ocpxControlParams != null) {
                    ocpxControlParams.setResetType(type);
                }

                OcpxControlParams ocpxControlParams2 = ocpxControlSubModel.getOcpxControlParams(2);
                if (ocpxControlParams2 != null) {
                    ocpxControlParams2.setResetType(type);
                }


                OcpxControlParams ocpxControlParams3 = ocpxControlSubModel.getOcpxControlParams(3);
                if (ocpxControlParams3 != null) {
                    ocpxControlParams3.setResetType(type);
                }

            }
        }

    }

    /**
     * 重新出价（出价保护）
     * 描述
     * 对在白名单，且排序Top的配置，调整价格，保护出价
     * 输入说明：
     * top1：ctr1、fee1
     * top2：ctr2、fee2
     * 维稳出价结果对象
     * 输出说明：
     * 1、配置重置：
     * 2、维稳出价结果对象（更新）
     */

    /**
     * @param top1          排序第一的配置
     * @param top2          排序第二的配置
     * @param bidResultTop1 排序第一的出价结果对象
     *                      <p>
     *                      return              重新出价
     */
    public static AdBidResultDo reBid(AdFeeDo top1, AdFeeDo top2, AdBidResultDo bidResultTop1) {

        if (bidResultTop1 != null) {
            return bidResultTop1;
        }

        //异常处理
        if (AssertUtil.isEmpty(top1)) {
            return bidResultTop1;
        }

        if (bidResultTop1 != null) {
            bidResultTop1.setFee(top1.getFee());
        }

        if (bidResultTop1 != null && bidResultTop1.getAdBidParamsDo() != null) {


            //
            Boolean isSecondPriceProject = bidResultTop1.getAdBidParamsDo().getSecondPriceProject();
            Double protectPriceFactor = bidResultTop1.getAdBidParamsDo().getCFactor();

            Long costReplase = bidResultTop1.getAdBidParamsDo().getCostReplase();// 超成本情况，使用该出价替代预估出价
            Long costDiff = bidResultTop1.getAdBidParamsDo().getCostDiff();//低成本模式，在预估出价上+


            //是否突破二价的逻辑
            Double extraCFactor = bidResultTop1.getAdBidParamsDo().getExtraCFactor();
            Integer extraCSwitch = bidResultTop1.getAdBidParamsDo().getExtraCSwitch();
            if (extraCSwitch != null && extraCSwitch == 1 && extraCFactor != null && !AssertUtil.isEmpty(top2)) {
                top2.setFee(Math.round(extraCFactor * top2.getFee()));
                if (Math.random() < 0.001) {
                    log.info("extraCFactor " + extraCFactor.toString() + " extraCSwitch" + extraCSwitch.toString() +
                            " advertId " + top1.getAdvertId() + " pkId " + top1.getPackageId());
                }
            }


            Long reserveFee = bidResultTop1.getReserveFee();
            if (reserveFee == null) {
                reserveFee = 1L;
            }

            if (isSecondPriceProject != null && isSecondPriceProject && protectPriceFactor != null && top1.getFee() > reserveFee) {

                // 加价
                if (protectPriceFactor > 1.0) {
                    long protectFee = Math.round(top1.getFee() * protectPriceFactor);
                    bidResultTop1.setFee(protectFee);

                } else {

                    // 降价
                    //由于有了首张券功能，经常没有第二名，这个操作会导致一折计费，暂且关闭了
                    //if (protectPriceFactor < 0.4) {
                    //    protectPriceFactor = 0.1;
                    //}

                    long protectFee = Math.round(top1.getFee() * protectPriceFactor);

                    protectFee = Math.max(protectFee, reserveFee);

                    long secondFee = protectFee;


                    if (!AssertUtil.isEmpty(top2)) {
                        // top2 不为空情况下 计算二价
                        secondFee = getSecondFee(top1.getCtr(), top2.getCtr(), top2.getFee());
                    }


                    // 新出价，二阶基、原出价基础上 平滑
                    long feeNew = Math.max(secondFee, protectFee);
                    feeNew = Math.min(top1.getFee(), feeNew);
                    bidResultTop1.setFee(feeNew);
                    bidResultTop1.getAdBidParamsDo().setOriginalFee(top1.getFee());

                }


            }

            /**
             *出价熔断
             * 1、超成本，出价=低价替换出价
             * 2、欠成本，出价=出价+补充出价
             */
            if (costReplase != null && costReplase > 0) {
                bidResultTop1.setFee(costReplase);
            } else if (costDiff != null) {

                Long feeNew = bidResultTop1.getFee() + costDiff;
                bidResultTop1.setFee(Math.max(feeNew, 1L));
            }

        }
        return bidResultTop1;
    }

    /**
     * 随机选取冷启动配置中的一个，该冷启动的fee用top1胜出广告的出价替换。
     * @param top1
     * @param coldAdList
     * @return
     */
    public static AdFeeDo reRank(AdFeeDo top1, List<AdFeeDo> coldAdList) {
        // 如果当前没有冷启动配置，返回胜出的top1广告
        if (AssertUtil.isEmpty(coldAdList)) {
            return top1;
        }
        Random r = new Random();
        int idx = r.nextInt(coldAdList.size());
        AdFeeDo coldAd = coldAdList.get(idx);

        //top1的ctr和冷启动配置的ctr默认没有偏差
        double ctr_rate = 1.0;
        // 万一模型在冷启动ctr上预估不准确，和top1的ctr相差不超过20%
        if (top1.getCtr() != null && coldAd.getCtr() != null) {
            ctr_rate = (top1.getCtr() + 0.01) / (coldAd.getCtr() + 0.01);
        }
        ctr_rate = MathUtil.stdwithBoundary(ctr_rate, 0.8, 1.2);

        double coldAd_fee = top1.getFee().doubleValue() * ctr_rate;

        coldAd.setFee(new Double(coldAd_fee).longValue());
        return coldAd;
    }


    private static long getSecondFee(double ctr1, double ctr2, long fee2) {
        double feeNew = ctr2 * fee2 / ctr1;
        return Math.round(feeNew) + 1;
    }


    private static long getOcpcFee(double cvr, long afee, Long appFee, Double specialAccountWeight) {

        return appFee == null ? getOcpcFee(cvr, afee, specialAccountWeight) : getOcpcFee(cvr, appFee, specialAccountWeight);
    }

    private static long getOcpcFee(double cvr, long afee, Double specialAccountWeight) {
        if (specialAccountWeight == null) {
            specialAccountWeight = 1.0;
        }
        return Math.round(cvr * afee * specialAccountWeight);
    }

//
//    /**
//     * 探索排序第一流量重新出价（出价保护）
//     * 描述
//     * 对探索流量，调整价格，保护出价
//     * <p>
//     * 输入说明：
//     * 排序第一的探索配置 top1：ctr1、fee1
//     * 排序第一的非探索配置 top2：ctr2、fee2
//     * <p>
//     * 排序第一维稳出价结果对象
//     * <p>
//     * 输出说明：
//     * 1、配置重置：
//     * 2、维稳出价结果对象（更新）
//     *
//     * @param top1          排序第一的探索配置
//     * @param top2          排序第一的非探索配置
//     * @param bidResultTop1 排序第一的探索配置结果对象
//     *                      <p>
//     *                      return              重新出价
//     */
//    public static AdBidResultDo exploreReBid(AdFeeDo top1, AdFeeDo top2,
//                                             AdBidResultDo bidResultTop1,
//                                             Boolean isSupport) {
//
//        //异常处理
//        if (AssertUtil.isEmpty(bidResultTop1)) {
//            return bidResultTop1;
//        }
//
//        if (isSupport) { // 如果是探索扶持流量，则加价系数只作用在排序竞价环节，未调价
//            bidResultTop1.setFee(top1.getFee());
//        } else if (top1 != null && top2 != null) {
//            // max(探索第一不加价，和非探索第一)
//            double val = Math.min(
//                    Math.max(top1.getFee() / bidResultTop1.getExploreFactor(),
//                            (top2.getCtr() * top2.getFee() + 0.01) / top1.getCtr()), top1.getFee());
//            bidResultTop1.setFee(
//                    new Double(val).longValue()
//            );
//        } else if (top1 != null) {
//            // 如果全是探索流量，则使用不加价的价格
//            bidResultTop1.setFee(
//                    new Double(top1.getFee() / bidResultTop1.getExploreFactor()).longValue()
//            );
//        }
//
//        return bidResultTop1;
//    }

}
