package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.vo.AdvertRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Optional;


@Slf4j
public class DeepBidControl {

    static Double targetCost = 1.0; // 预估因子瞄准目标

    //普通情况下的计算双出价因子方法，其中的各个数字为离线取数所得或人工设置
    public static DeepControlFactors calculateNormal(Long deepFee, Long aFee, Double preDcvr, Double confWeight,
                                                     Double preMergeWeight,
                                                     Double statFactor, Double preMergeDiffU, Double preMergeDiffL,
                                                     Double preDeepCalibrate, Double deepSupportFactor) {


        DeepControlFactors retDto = new DeepControlFactors();


        /**
         * 计算预估dcvr，调节因子
         */
        if (preDeepCalibrate == null) {
            preDeepCalibrate = 1.0;
        }

        Double preFactor = targetCost * deepFee * Math.min(preDcvr * preDeepCalibrate, 1.0) / aFee;



        //预估异常降级
        if (preDcvr < 0.0000001) {
            preMergeWeight = 0.0;
        }
        Double factor = (confWeight * preMergeWeight) * preFactor + (1 - confWeight * preMergeWeight) * statFactor;

        /**
         * 约束范围
         */
        //factor = MathUtil.formatDouble(MathUtil.stdwithBoundary(factor, preMergeDiffL, preMergeDiffU),4);
        factor = MathUtil.formatDouble(MathUtil.stdwithBoundary(factor, 0.6, 1.1), 4);

        /**
         * 计算 计费因子deepFeeFactor=
         * 1、当深度因子factor>1.0时，计费打折扣 deepFeeFactor = 1.0 + (factor - 1.0) * deepSupportFactor;
         * 2、当深度因子factor在0.8～1.0范围时，factor=1.0 and deepFeeFactor=1.0
         * 3、当深度因子factor<0.8时，deepFeeFactor=factor
         */
        Double deepFeeFactor = factor;

        if (factor > 1.0) {
            deepFeeFactor = 1.0 + (factor - 1.0) * deepSupportFactor;
        }
        if (factor <= 1.0 && factor >= 0.8) {
            factor = 1.0;
            deepFeeFactor = 1.0;
        }

        if(preDcvr!=null && preDcvr<0.8 && preDcvr>0.1){
            factor = 1.0;
            deepFeeFactor = 1.0;
        }


        /**
         * 封装返回参数
         */
        retDto.setPreDeepFactor(preFactor);
        retDto.setStatDeepFactor(statFactor);
        retDto.setDeepFactor(factor);
        retDto.setDeepFeeFactor(deepFeeFactor);

        return retDto;

    }
    //普通情况下的计算双出价因子方法，其中的各个数字为离线取数所得或人工设置
    public static DeepControlFactors calculate(Long deepFee, Long aFee, Double preDcvr, Double statDcvr, Double confWeight,
                                               double deepSupportFactor,double dcvrLowerBound) {


        DeepControlFactors retDto = new DeepControlFactors();


        /**
         * 计算预估dcvr，深度因子
         */
        Double preFactor =1.0;
        double preWeight = 0.0;
        if(preDcvr!=null && preDcvr>0.00001){
            preFactor = MathUtil.formatDouble(targetCost * deepFee * Math.min(preDcvr, 1.0) / aFee,5);
            preWeight=1.0;
        }

        /**
         * 计算统计dcvr，深度因子
         */
        Double statFactor =1.0;
        double statWeight = 0.0;
        if(statDcvr!=null && statDcvr>0.000001){
            statFactor = MathUtil.formatDouble(targetCost * deepFee * Math.min(statDcvr, 1.0) / aFee,5);
            statWeight=1.0;
        }

        if(confWeight==null){
            confWeight=0.5;
        }

        /**
         * 预估+统计，融合因子
         */
        Double deepFactor = (confWeight * preWeight) * preFactor + (1 - confWeight * preWeight) * statFactor;

        double lowB=1.0;//因子上、下限约束
        double upB=1.1;
        if(preDcvr!=null && preDcvr>0.00001 && preDcvr<dcvrLowerBound){
            lowB=0.6;
        }
        deepFactor = MathUtil.formatDouble(MathUtil.stdwithBoundary(deepFactor, lowB, upB), 5);

        Double deepFeeFactor = 1.0 + (deepFactor - 1.0) * deepSupportFactor;

        /**
         * 降率模式：
         * 1、当深度因子factor>1.0时，计费打折扣 deepFeeFactor = 1.0 + (factor - 1.0) * deepSupportFactor;
         * 2、当深度因子dcvr<dcvrLowerBound 时，
         */

        if(preDcvr!=null && preDcvr>0.00001 && preDcvr<dcvrLowerBound){
            deepFactor=0.5 * deepFactor;
            deepFeeFactor=0.5 * deepFeeFactor;
        }

        /**
         * 封装返回参数
         */
        retDto.setPreDeepFactor(preFactor);
        retDto.setStatDeepFactor(statFactor);
        retDto.setDeepFactor(deepFactor);
        retDto.setDeepFeeFactor(deepFeeFactor);

        return retDto;

    }


    /**
     * 获取深度调价因子 流量调价
     *
     * @param params
     * @return
     */
    public static DeepControlFactors getDeepFactor(OcpxControlParams costParams, DeepControlParams params,
                                                   AdBidParamsDo adBidParamsDo) {
        //取计算所需属性
        //Integer appLimitReleaseMark = adBidParamsDo.getAppLimitReleaseMark();


        Long deepFee = adBidParamsDo.getDeepFee();

        /**
         * todo
         * 11.21，实验期间生效
         * 使用算法计算深度成本出价
         */
        if (params.getDeepAFee() != null) {
            deepFee = params.getDeepAFee();
        }


        Long aFee = adBidParamsDo.getAFee();
        Long appAFee = adBidParamsDo.getAppAFee();
        Long usefulAfee = aFee;
        if (appAFee != null && appAFee > 0) {
            usefulAfee = appAFee;
        }
        Double preDcvr = adBidParamsDo.getPreDcvr();

        DeepControlFactors retDto = new DeepControlFactors();


        if (params == null || params.getDeepFactor() == null) {
            return retDto;
        }


        Double statFactor = params.getDeepFactor();

        ////限流释放媒体-深度目标调价因子
//        if (appLimitReleaseMark != null && appLimitReleaseMark.equals(1) && params.getLimitDeepFactor() != null) {
//            ret = params.getLimitDeepFactor();
//            statFactor = params.getLimitDeepFactor();
//        }

        //默认取统计的因子
        retDto.setDeepFactor(statFactor);
        retDto.setStatDeepFactor(statFactor);

        //Long controlType = params.getControlType();
        Double confWeight = params.getConfWeight();
        Double slotStatDcvr = params.getSlotStatDcvr();
        Double pkSlotStatDcvr = params.getPkStatDcvr();

        if(slotStatDcvr==null){
            slotStatDcvr=pkSlotStatDcvr;
        }

        Double preMergeWeight = params.getPreMergeWeight();
        Double preMergeDiffU = params.getPreMergeDiffU();
        Double preMergeDiffL = params.getPreMergeDiffL();

        Double dcvrLowerBound = adBidParamsDo.getDcvrLowerBound();
        if(dcvrLowerBound == null){
            dcvrLowerBound=0.0001;
        }

        double deepSupportFactor = params.getDeepSupportFactor();

        if (AssertUtil.isAllNotEmpty(confWeight, preDcvr, deepFee, usefulAfee, preMergeWeight, preMergeDiffU,
                preMergeDiffL, statFactor)) {

//            retDto = DeepBidControl.calculateNormal(deepFee, usefulAfee, preDcvr, confWeight, preMergeWeight, statFactor,
//                    preMergeDiffU, preMergeDiffL, preDeepCalibrate, deepSupportFactor);


            // 降率
//            if(adBidParamsDo.getAdvertId()!=null && adBidParamsDo.getAdvertId().equals(88327L)){
//                dcvrLowerBound=0.85;
//            }
            retDto = calculate(deepFee, usefulAfee, preDcvr,slotStatDcvr, confWeight, deepSupportFactor,dcvrLowerBound);
        }

        /**
         *
         */
        retDto.setUsedDeepAFee(deepFee);
        retDto.setDcvrLowerBound(dcvrLowerBound);

        return retDto;
    }

    public static Boolean dcvrConstrain(DeepControlParams params, AdBidParamsDo adBidParamsDo) {
        Boolean result = false;
//        Integer dcvrConstraint = params.getDcvrConstraint();
//        Double dcvrLowerBound = params.getDcvrLowerBound();
//        Integer dcvrConstraintABId = adBidParamsDo.getDcvrConstraintABId();
//        Double preDcvr = adBidParamsDo.getPreDcvr();
//        if (AssertUtil.isAllNotEmpty(dcvrConstraint, dcvrConstraintABId, preDcvr, dcvrLowerBound)) {
//            if (dcvrConstraint == 1 && dcvrConstraintABId == 2 && preDcvr < dcvrLowerBound) {
//                result = true;
//            }
//        }
        return result;
    }

    public static void main(String[] args) {
        //Boolean a = null;
        //System.out.println(a == true);

        String str2 = "[{\"ctr\":0.190892,\"t_tag\":\"15\",\"ad\":79991,\"fee\":4,\"rankScore\":0.7636,\"preDcvr\":0.0,\"cy\":3,\"scvr\":0.0017,\"arpu\":0.7636,\"pk\":0,\"pre_ctr\":0.15726,\"sctr\":0.493581,\"pre_cvr\":0.0026,\"cvr\":0.00251},{\"ctr\":0.114657,\"t_tag\":\"1\",\"ad\":80651,\"fee\":5,\"rankScore\":0.5733,\"preDcvr\":0.0,\"cy\":3,\"scvr\":0.01,\"arpu\":0.5733,\"pk\":198617,\"pre_ctr\":0.07141,\"sctr\":0.50388,\"pre_cvr\":0.00053,\"cvr\":0.001477}]";

        //AdEEBaseDoV2 ret = JSON.parseObject(str, AdEEBaseDoV2.class);

        List<AdvertRcmdDo> ret = JSON.parseArray(str2, AdvertRcmdDo.class);

        DeepControlFactors retDto = calculate(1435L, 1200L, 0.77,0.75, 0.5, 0.5,0.85);
        System.out.println(JSON.toJSONString(retDto));

    }
}
