package cn.com.duiba.nezha.alg.alg.coldstartandexplore;

import cn.com.duiba.nezha.alg.alg.vo.NdAdvertParams;
import cn.com.duiba.nezha.alg.alg.vo.NdAdvertResultV3Do;
import cn.com.duiba.nezha.alg.alg.vo.NdAdvertV3Info;
import cn.com.duiba.nezha.alg.alg.vo.NdFilterAppInfo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * 备注：在NdAdvertSupportV2的基础上修改：
 *      1、加入探索广告黑名单
 *      2、媒体筛选中CVR阈值划定由配置 => 做一个定时任务每天动态生成CVR阈值(目前还未做)
 *      3、四个维度的输入数据由由历史 => 历史+实时
 *      4、曝光加权因子和调权因子的上限做成可配置的  注：上线发布的时候先设置调权因子上限为1.0，观察数据表现再做调整；最后确保扶持后的非定向广告有30%左右的获胜率
 *      5、针对两套参数分别设置了不同的加权函数
 *      6、日志打印问题 => 对每个参竞的非定向广告新增 原始CTR、CVR，曝光加权因子，调权因子，当前流量上参竞的非定向广告的个数，非定向广告的序
 *
 *      7、新增媒体3日消耗均值<=800元的媒体过滤条件，目的是放进一些每日消耗较大的中部媒体
*/
public class NdAdvertSupportV3 {
    private static final Logger logger= LoggerFactory.getLogger(NdAdvertSupportV3.class);

    static class RectifyNdAdvertResInfo {
        double rectifyBid = 0.0;   // 修正后的bid，用于调权因子制定阶段的辅助排序
        NdAdvertResultV3Do ndAdvertResult;
    }

    /**
     * 出价降序排
     * @param NdAdvertResultDo
     * @return
     */
    public static Comparator<RectifyNdAdvertResInfo> iComparator = new Comparator<RectifyNdAdvertResInfo>() {
        @Override
        public int compare(RectifyNdAdvertResInfo r1, RectifyNdAdvertResInfo r2) { return (int) (r2.rectifyBid- r1.rectifyBid >= 0 ? 1 : -1); }
    };

    /**
     * @description 非定向广告拓量/冷启动策略
     * @param
     * @return
     */
    public static List<NdAdvertResultV3Do> NDAdvertColdStartAndExpose(NdFilterAppInfo ndFilterAppInfo,
                                                                      NdAdvertParams ndAdvertParams,
                                                                      List<NdAdvertV3Info> ndAdvertInfoList,
                                                                      List<Long> ndAdvertBlackList) {

        // 拓量/冷启动结果初始化
        List<NdAdvertResultV3Do> res = new ArrayList<>();
        // 按修正后的bid降序活动队列(rectifyBid=pCtr*rectifyCvr*bid*[f(exposeCnt)])
        Queue<RectifyNdAdvertResInfo> candis = new PriorityQueue<>(iComparator);
        // 用于辅助判断调权因子制定
        Set<Long> tmpSet = new HashSet<>();
        // 参竞非定向广告的个数
        int numOfBidNd = ndAdvertInfoList.size();

        if (AssertUtil.isAnyEmpty(ndAdvertInfoList, ndFilterAppInfo, ndAdvertParams)) {
            return res;
        }

        // 筛选媒体，在小媒体或较差的媒体不做非定向广告的拓量/冷启动
        Long hisAppConvert = ndFilterAppInfo.getHisAppConvert();
        Double hisAppCVR = ndFilterAppInfo.getHisAppCVR();
        Long hisAppConsume = ndFilterAppInfo.getHisAppConsume();
        Double triDayAppCVR = ndFilterAppInfo.getTriDayAppCVR();
        Long triDayAppConsume = ndFilterAppInfo.getTriDayAppConsume();
        if (hisAppConvert <= ndAdvertParams.getAppConvertThreshold() || hisAppCVR <= ndAdvertParams.getAppCVRThreshold() || hisAppConsume <= ndAdvertParams.getAppConsumeThreshold()) {
            if (triDayAppConsume == null || MathUtil.division(triDayAppConsume, 3L) <= ndAdvertParams.getAppTriDayConsumeThreshold()) {
                return res;
            }
        }

        // 将要计算调权因子的广告按降序（curRectifyBid）添加到candis（Queen）中，不用调权因子的直接修正CVR后添加到res.
        for (int i=0; i < ndAdvertInfoList.size(); i++) {
            double curRectifyBid = 0.0;
            double exposureFactor = 1.0;
            Integer exposeConfidenceThreshold;      //辅助判断是否需要做扶持
            Double exposeConsumePercentThreshold;   //辅助判断是否需要做扶持
            Integer exposeConfidenceThreshold2;     //辅助判断是否需要做扶持
            NdAdvertV3Info curNdAdvertInfo =  ndAdvertInfoList.get(i);
            Long curAdvert = curNdAdvertInfo.getAdvertId();
            RectifyNdAdvertResInfo rectifyNdAdvertResInfo = new RectifyNdAdvertResInfo();
            Long hisSlotAdvExpose = curNdAdvertInfo.getHisExpose();
            Long hisAdvertExploreConsume = curNdAdvertInfo.getHisAdvertExploreConsume();
            Long hisAdvertConsume = curNdAdvertInfo.getHisAdvertConsume();
            Map<String, Object> AdjustCVRRes = getAdjustCVR(ndAdvertParams, curNdAdvertInfo);
            double adjustWeight = (double) AdjustCVRRes.get("adjustWeight");
            double adjustCvr = (double) AdjustCVRRes.get("adjustCvr");
            String paramType = ((double) AdjustCVRRes.get("paramType") == 1.0) ? "firstSet" : "secondSet";   //1.0表示使用的是第一套扶持参数；2.0表示使用的是第二套扶持参数；
            String curNdAdvertLevel = (String) AdjustCVRRes.get("curNdAdvertLevel");
            double preCtr = curNdAdvertInfo.getPreCtr();      // 注：本版本中未对CTR进行修正
            Long bid = curNdAdvertInfo.getBid();

            if (paramType.equals("firstSet")) {
                exposeConfidenceThreshold = ndAdvertParams.getExposeConfidenceThreshold();
                exposeConsumePercentThreshold = ndAdvertParams.getExposeConsumePercentThreshold();
                exposeConfidenceThreshold2 = ndAdvertParams.getExposeConfidenceThreshold2();
            }else {
                exposeConfidenceThreshold = ndAdvertParams.getExposeConfidenceThresholdSet3();
                exposeConsumePercentThreshold = ndAdvertParams.getExposeConsumePercentThresholdSet2();
                exposeConfidenceThreshold2 = ndAdvertParams.getExposeConfidenceThresholdSet5();
            }

            if ((CollectionUtils.isEmpty(ndAdvertBlackList) || !ndAdvertBlackList.contains(curAdvert)) && (hisSlotAdvExpose <= exposeConfidenceThreshold || hisAdvertExploreConsume <= exposeConsumePercentThreshold * hisAdvertConsume)) {    // 需要做扶持(扶持条件出要满足曝光量、探索消耗占比外还需要满足当前广告不在黑名单中)
                if (hisSlotAdvExpose <= exposeConfidenceThreshold2) {
                    exposureFactor = functionOfExpose(hisSlotAdvExpose, ndAdvertParams, paramType);
                    curRectifyBid = preCtr * adjustCvr * bid * exposureFactor;
                }else {
                    curRectifyBid = preCtr * adjustCvr * bid;
                    tmpSet.add(curNdAdvertInfo.getAdvertId());
                }

                rectifyNdAdvertResInfo.ndAdvertResult = fillData(curNdAdvertInfo, 1.0, 1.0, adjustWeight, preCtr, adjustCvr, exposureFactor, numOfBidNd, 1, curNdAdvertLevel);
                rectifyNdAdvertResInfo.rectifyBid = curRectifyBid;
                candis.add(rectifyNdAdvertResInfo);     // 放到降序队列中，稍后用于调权因子制定时使用
            }else {     // 不需要做扶持
                res.add(fillData(curNdAdvertInfo, 1.0, 1.0, adjustWeight, preCtr, adjustCvr, 1.0, numOfBidNd, -1, null));     // rankOfCurNdInCandis=-1时说明探索结束，该类广告需要加入黑名单
            }
        }

        // 对candis（Queen）中的广告，求取调权因子
        int lengthOfCandis = candis.size();
        List<Double> functionOfRectifyFacList = functionOfRectifyFac(lengthOfCandis, ndAdvertParams);
        for (int idx=0; idx < lengthOfCandis; idx++) {
            double curFactor = functionOfRectifyFacList.get(idx);
            RectifyNdAdvertResInfo curRectifyNdAdvertResInfo= candis.poll();
            if (tmpSet.contains(curRectifyNdAdvertResInfo.ndAdvertResult.getAdvertId())) {
                curRectifyNdAdvertResInfo.ndAdvertResult.setAdjustFactor(1.0);
            }else {
                curRectifyNdAdvertResInfo.ndAdvertResult.setAdjustFactor(curFactor);
            }
            curRectifyNdAdvertResInfo.ndAdvertResult.setRankOfCurNdInCandis(idx+1);
            res.add(curRectifyNdAdvertResInfo.ndAdvertResult);
        }

        return res;
    }

    /**
     * @description 对非定向广告的CVR进行修正；目的：打压高点击低转化广告
     * @param ndAdvertInfo
     * @return CVR修正因子及修正后的CVR值
     */
    public static Map<String, Object> getAdjustCVR(NdAdvertParams ndAdvertParams, NdAdvertV3Info ndAdvertInfo){

        Map<String, Object> res = new HashMap<>();
        if (AssertUtil.isAnyEmpty(ndAdvertParams, ndAdvertInfo)) {
            return null;
        }

        // 获取统计信息
        Double preCvr = ndAdvertInfo.getPreCvr();
        Long hisClick = ndAdvertInfo.getHisClick();
        Long hisConvert = ndAdvertInfo.getHisConvert();
        Double staCvr = Optional.ofNullable(MathUtil.division(hisConvert, hisClick, 6)).orElse(0.0);
        Long advTradeSlotDayClick = ndAdvertInfo.getAdvTradeSlotDayStats().getClick();
        Long advTradeAppDayClick = ndAdvertInfo.getAdvTradeAppDayStats().getClick();
        Long advTradeAppTradeDayClick = ndAdvertInfo.getAdvTradeAppTradeDayStats().getClick();
        Long advTradeSlotTriDayClick = ndAdvertInfo.getAdvTradeSlotTriDayStats().getClick();
        Long advTradeAppTriDayClick = ndAdvertInfo.getAdvTradeAppTriDayStats().getClick();
        Long advTradeAppTradeTriDayClick = ndAdvertInfo.getAdvTradeAppTradeTriDayStats().getClick();
        Long advTradeSlotDayConvert = ndAdvertInfo.getAdvTradeSlotDayStats().getConvert();
        Long advTradeAppDayConvert = ndAdvertInfo.getAdvTradeAppDayStats().getConvert();
        Long advTradeAppTradeDayConvert = ndAdvertInfo.getAdvTradeAppTradeDayStats().getConvert();
        Long advTradeSlotTriDayConvert = ndAdvertInfo.getAdvTradeSlotTriDayStats().getConvert();
        Long advTradeAppTriDayConvert = ndAdvertInfo.getAdvTradeAppTriDayStats().getConvert();
        Long advTradeAppTradeTriDayConvert = ndAdvertInfo.getAdvTradeAppTradeTriDayStats().getConvert();

        // 计算各统计维度CVR
        Double advTradeSlotDayCvr = Optional.ofNullable(MathUtil.division(advTradeSlotDayConvert, advTradeSlotDayClick, 6)).orElse(0.0);
        Double advTradeAppDayCvr = Optional.ofNullable(MathUtil.division(advTradeAppDayConvert, advTradeAppDayClick, 6)).orElse(0.0);
        Double advTradeAppTradeDayCvr = Optional.ofNullable(MathUtil.division(advTradeAppTradeDayConvert, advTradeAppTradeDayClick, 6)).orElse(0.0);
        Double advTradeSlotTriDayCvr = Optional.ofNullable(MathUtil.division(advTradeSlotTriDayConvert, advTradeSlotTriDayClick, 6)).orElse(0.0);
        Double advTradeAppTriDayCvr = Optional.ofNullable(MathUtil.division(advTradeAppTriDayConvert, advTradeAppTriDayClick, 6)).orElse(0.0);
        Double advTradeAppTradeTriDayCvr = Optional.ofNullable(MathUtil.division(advTradeAppTradeTriDayConvert, advTradeAppTradeTriDayClick, 6)).orElse(0.0);

        List<Long> clickList = Arrays.asList(advTradeSlotDayClick, advTradeAppDayClick, advTradeAppTradeDayClick, advTradeSlotTriDayClick,
                advTradeAppTriDayClick, advTradeAppTradeTriDayClick);
        List<Double> cvrList = Arrays.asList(advTradeSlotDayCvr, advTradeAppDayCvr, advTradeAppTradeDayCvr, advTradeSlotTriDayCvr,
                advTradeAppTriDayCvr, advTradeAppTradeTriDayCvr);

        // 确认走哪套扶持参数,并求取相应的CVR调整系数
        double adjustWeight = 1.0;
        String paramType = "firstSet";
        if (Collections.max(cvrList) < ndAdvertParams.getMinDimStatsCvrThreshold()) {     // CVR较低行业，需要使用第二套扶持参数
            paramType = "secondSet";
        }else {     // 用第一套扶持参数
            paramType = "firstSet";
        }
        HashMap<String, Object> AdjustWeightRes = getAdjustWeight(ndAdvertParams, clickList, cvrList, paramType, hisClick, staCvr);
        adjustWeight = (double) AdjustWeightRes.get("adjustWeight");
        String curNdAdvertLevel = (String) AdjustWeightRes.get("curNdAdvertLevel");

        // CVR调整策略。各变量与文档中的对应关系：preCvr ==> pcvr；hisClick ==> x；staCvr ==> y1；minDimsStatCvr ==> y2；adjustWeight ==> a
        double adjustCvr = preCvr;
        if (hisClick >= (paramType.equals("firstSet") ? ndAdvertParams.getSepStageThreshold() : ndAdvertParams.getSepStageThresholdSet2()) && staCvr >= Math.pow(10, -8)) {    // 根据CVR调整系数计算得到调整后的adjustCvr
//            adjustCvr = (1 - adjustWeight) * preCvr + adjustWeight * staCvr;
            adjustWeight = 1.0;
        } else { adjustCvr *= adjustWeight; }

        res.put("adjustWeight", adjustWeight);
        res.put("adjustCvr", adjustCvr);
        res.put("paramType", (paramType.equals("firstSet") ? 1.0 : 2.0));   //1.0表示使用的是第一套扶持参数；2.0表示使用的是第二套扶持参数；
        res.put("curNdAdvertLevel", curNdAdvertLevel);

        return res;
    }

    /**
     * 求取数据充分的最小粒度维度上统计CVR值
     * @param ndAdvertParams
     * @param clickList
     * @param cvrList
     * @param paramType
     * @return minDimsStatCvr
     */
    public static Double getMinDimsStatCvr(NdAdvertParams ndAdvertParams, List<Long> clickList, List<Double> cvrList, String paramType) {
        Double minDimsStatCvr = 0.0;

        if (clickList.get(clickList.size() -1) <= (paramType.equals("secondSet") ? ndAdvertParams.getClickConfidenceThresholdSet2() : ndAdvertParams.getClickConfidenceThreshold())) {
            minDimsStatCvr = cvrList.get(clickList.size() -1);
        }else {
            for (int index=0; index<clickList.size(); index++) {
                if (clickList.get(index) >= (paramType.equals("secondSet") ? ndAdvertParams.getClickConfidenceThresholdSet2() : ndAdvertParams.getClickConfidenceThreshold())) {
                    minDimsStatCvr = cvrList.get(index);
                    break;
                }
            }
        }

        return minDimsStatCvr;
    }

    /**
     * CVR调整系数
     */
//    public static Double getAdjustWeight(NdAdvertParams ndAdvertParams, List<Long> clickList, List<Double> cvrList, String paramType, Long hisClick, Double staCvr) {
    public static HashMap<String, Object> getAdjustWeight(NdAdvertParams ndAdvertParams, List<Long> clickList, List<Double> cvrList, String paramType, Long hisClick, Double staCvr) {
        HashMap<String, Object> res = new HashMap<String, Object>();

        double adjustWeight = 1.0;
        String curNdAdvertLevel = "level1";
        double minDimsStatCvr = getMinDimsStatCvr(ndAdvertParams, clickList, cvrList, paramType);
        Integer sepStageThreshold;
        Integer coldStartThreshold1;
        Integer coldStartThreshold2;
        Integer coldStartThreshold3;

        // 根据paramType变量查看取哪套参数
        if (paramType.equals("firstSet")) {
            sepStageThreshold = ndAdvertParams.getSepStageThreshold();
            coldStartThreshold1 = ndAdvertParams.getColdStartThreshold1();
            coldStartThreshold2 = ndAdvertParams.getColdStartThreshold2();
            coldStartThreshold3 = ndAdvertParams.getColdStartThreshold3();
        }else {
            sepStageThreshold = ndAdvertParams.getSepStageThresholdSet2();
            coldStartThreshold1 = ndAdvertParams.getColdStartThresholdSet4();
            coldStartThreshold2 = ndAdvertParams.getColdStartThresholdSet5();
            coldStartThreshold3 = ndAdvertParams.getColdStartThresholdSet6();
        }

        if (hisClick < sepStageThreshold) {             // 冷启阶段
            boolean b = staCvr <= Math.pow(10, -8) || staCvr < 0.4 * minDimsStatCvr;
            if (coldStartThreshold1 <= hisClick && hisClick < coldStartThreshold2) {
                adjustWeight = b ? 0.9 : 1.0;
                curNdAdvertLevel = "level2";
            }else if (coldStartThreshold2 <= hisClick && hisClick < coldStartThreshold3) {
                if (b) {adjustWeight = 0.8;}else if (staCvr < 0.7 * minDimsStatCvr) {adjustWeight = 0.9;}else {adjustWeight = 1.0;}
                curNdAdvertLevel = "level3";
            }else if (hisClick >= coldStartThreshold3) {
                if (b) {adjustWeight = 0.7;}else if (staCvr < 0.7 * minDimsStatCvr) {adjustWeight = 0.8;}else {adjustWeight = 1.0;}
                curNdAdvertLevel = "level4";
            }else { adjustWeight = 1.0; }
        }else{              // 起量阶段
            if (staCvr <= Math.pow(10, -8)) { adjustWeight = 0.1; } else { adjustWeight = 0.3 + 0.4 * Math.min(1, MathUtil.division(hisClick, 2000, 6));}
            curNdAdvertLevel = "level5";
        }

        res.put("adjustWeight", adjustWeight);
        res.put("curNdAdvertLevel", curNdAdvertLevel);

        return res;
    }

    /**
     * 曝光次数加权函数
     * 函数设计准则：根据给定的加权上限及曝光阈值，求取斜率（即已知两个点=>(0, UpperBound), (exposeConfidenceThreshold, 1.0)）
     */
    public static double functionOfExpose(Long exposeCnt, NdAdvertParams ndAdvertParams, String paramType) {
        double res = 1.0;
        double k = 1.0;
        double b = 1.0;
        Integer exposeConfidenceThreshold = 600;

        if (paramType.equals("firstSet")) {
            k = ndAdvertParams.getExposureK1();
            b = ndAdvertParams.getExposureUpperBound1();
            exposeConfidenceThreshold = ndAdvertParams.getExposeConfidenceThreshold2();
        }else {
           k = ndAdvertParams.getExposureK2();
           b = ndAdvertParams.getExposureUpperBound2();
           exposeConfidenceThreshold = ndAdvertParams.getExposeConfidenceThresholdSet5();
        }

        if (exposeCnt <= exposeConfidenceThreshold) {
            res = k * exposeCnt + b;
        }

        return res;
    }

    /**
     * 调权因子加权函数
     *
     */
    public static List<Double> functionOfRectifyFac(int size, NdAdvertParams ndAdvertParams) {
        List<Double> res = new ArrayList<>();
        double weight = 1.0;
        double rankUpperBound = ndAdvertParams.getRankUpperBound();

        if (rankUpperBound <= 1.0) {
            for (int i=0; i<size; i++) {
                res.add(1.0);
            }
        }else {
            double inflectionPoint1 = rankUpperBound;
//            double inflectionPoint2 = rankUpperBound - (rankUpperBound - 1.0) * 0.6;
            double inflectionPoint2 = 0.4 * rankUpperBound + 0.6;
            Map<String, Double> KBMap1 = calculateKAndB(0, (int) (0.1 * size), inflectionPoint1, inflectionPoint2);     // 给予top10部分更大的斜率，让头部的加权因子有较快衰减==>top1的加权因子远大于其余部分，让其更易曝光
            Map<String, Double> KBMap2 = calculateKAndB((int) (0.1 * size), (int) (0.2 * size), inflectionPoint2, 1.0);
            double k1 = KBMap1.get("K");
            double k2 = KBMap2.get("K");
            double b1 = KBMap1.get("B");
            double b2 = KBMap1.get("B");

            for (int i=0; i<size; i++) {
                if (i <= (int) (0.1 * size)) {
                    weight = k1 * i + b1;
                }else if((int) (0.1 * size) < i && i <= (int) (0.2 * size)) {
                    weight = k2 * i + b2;
                }else { weight = 1.0; }

                weight = Math.round(weight * 1e6) / 1e6;
                res.add(Math.max(weight, 1.0));
            }
        }

        return res;
    }


    /**
     * 调权因子加权函数斜率及偏置的计算
     */
    private static Map<String, Double> calculateKAndB(int x0, int x1, double y0, double y1) {
        Map<String, Double> res = new HashMap<>();

        double k = MathUtil.division(y1 - y0, x1 - x0, 6);
        double b = y0 - k * x0;
        res.put("K", k);
        res.put("B", b);

        return res;
    }

    /**
     * 封装拓量/冷启动对非定向广告扶持结果数据
     * @return
     */
    private static NdAdvertResultV3Do fillData(NdAdvertV3Info ndAdvertInfo,
                                               double adjustFactor,
                                               double ctrRectifyFactor,
                                               double cvrRectifyFactor,
                                               double rectifyCtr,
                                               double rectifyCvr,
                                               double exposureFactor,
                                               int  numOfBidNd,
                                               int rankOfCurNdInCandis,
                                               String curNdAdvertLevel) {
        NdAdvertResultV3Do ndAdvertRes = new NdAdvertResultV3Do();

        ndAdvertRes.setAdvertId(ndAdvertInfo.getAdvertId());
        ndAdvertRes.setPlanId(ndAdvertInfo.getPlanId());
        ndAdvertRes.setSlotId(ndAdvertInfo.getSlotId());
        ndAdvertRes.setAppId(ndAdvertInfo.getAppId());
        ndAdvertRes.setAdvertType(ndAdvertInfo.getAdvertType());
        ndAdvertRes.setAdjustFactor(adjustFactor);
        ndAdvertRes.setCtrRectifyFactor(ctrRectifyFactor);
        ndAdvertRes.setCvrRectifyFactor(cvrRectifyFactor);
        ndAdvertRes.setRectifyCtr(rectifyCtr);
        ndAdvertRes.setRectifyCvr(rectifyCvr);
        ndAdvertRes.setExposureFactor(exposureFactor);
        ndAdvertRes.setNumOfBidNd(numOfBidNd);
        ndAdvertRes.setRankOfCurNdInCandis(rankOfCurNdInCandis);
        ndAdvertRes.setLevel(curNdAdvertLevel);

        return ndAdvertRes;
    }

}
