/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.advert.v2;

import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.ee.AdControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ee.AdExploreModel;
import cn.com.duiba.nezha.alg.alg.vo.ee.AppGroupDo;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidExploreStrategy {
    private static final Logger log = LoggerFactory.getLogger(BidExploreStrategy.class);

    public static void updateInfo(Map<String, AdBidResultDo> controlResultMap, AppGroupDo appGroupDo, Integer putIndex, Long slotId) {
        String appGroup = null;
        if (appGroupDo != null) {
            appGroup = appGroupDo.getAppGroupMap().get(slotId);
        }
        if (controlResultMap == null) {
            return;
        }
        for (Map.Entry<String, AdBidResultDo> entry : controlResultMap.entrySet()) {
            AdBidResultDo adBidResultDo = entry.getValue();
            AdBidParamsDo adBidParamsDo = adBidResultDo.getAdBidParamsDo();
            if (adBidParamsDo == null) continue;
            adBidParamsDo.setPutIndex(putIndex);
            adBidParamsDo.setAppGroup(appGroup);
        }
    }

    public static void bidExplore(Map<String, AdBidResultDo> controlResultMap, Map<Long, AdExploreModel> adEEModelMap, AppGroupDo appGroupDo, Integer putIndex, Long slotId) {
        if (adEEModelMap == null) {
            return;
        }
        if (putIndex != null && putIndex > 1) {
            return;
        }
        String appGroup = null;
        if (appGroupDo != null) {
            appGroup = appGroupDo.getAppGroupMap().get(slotId);
        }
        for (Map.Entry<String, AdBidResultDo> entry : controlResultMap.entrySet()) {
            AdBidResultDo adBidResultDo = entry.getValue();
            adBidResultDo.setAppGroup(appGroup);
            Long advertId = adBidResultDo.getAdvertId();
            BidExploreStrategy.bidExplore(adBidResultDo, adEEModelMap.get(advertId));
        }
    }

    public static void bidExplore(AdBidResultDo adBidResultDo, AdExploreModel adExploreModel) {
        if (adExploreModel == null) {
            return;
        }
        if (adBidResultDo.getChargeType() == 2) {
            Double eeFactor = null;
            Double qlFactor = null;
            eeFactor = BidExploreStrategy.exploreControl(adBidResultDo, adExploreModel);
            Double exploreFactor = MathUtil.max((Double)eeFactor, (Double)(qlFactor = BidExploreStrategy.qiliangControl(adBidResultDo, adExploreModel)));
            if (exploreFactor != null) {
                Long fee = adBidResultDo.getFee();
                Double feeNewTmp = (double)fee.longValue() * exploreFactor;
                Long feeNew = feeNewTmp.longValue();
                adBidResultDo.setExploreFactor(exploreFactor);
                adBidResultDo.setFee(feeNew);
                adBidResultDo.getAdBidParamsDo().setExplore(true);
                adBidResultDo.getAdBidParamsDo().setExploreFeeDiff(feeNew - fee);
                adBidResultDo.getAdBidParamsDo().setExploreFactor(exploreFactor);
                adBidResultDo.getAdBidParamsDo().setFee(feeNew);
                adBidResultDo.getAdBidParamsDo().setEeFee(feeNew);
            }
        }
    }

    public static Double exploreControl(AdBidResultDo adBidResultDo, AdExploreModel adExploreModel) {
        if (adBidResultDo.getIsSupport() != null && adBidResultDo.getIsSupport().booleanValue()) {
            return null;
        }
        Long slotId = adBidResultDo.getSlotId();
        String appGroup = adBidResultDo.getAppGroup();
        Double eeFactor = null;
        if (appGroup != null) {
            AdControlParams appGroupEEParams = adExploreModel.getAppGroupEEParamsMap().get(appGroup);
            eeFactor = AdExploreModel.getExploreFactor(appGroupEEParams);
        }
        if (eeFactor == null) {
            AdControlParams slotEEParams = adExploreModel.getSlotEEParamsMap().get(slotId);
            eeFactor = AdExploreModel.getExploreFactor(slotEEParams);
        }
        if (eeFactor == null) {
            AdControlParams adEEParams = adExploreModel.getAdEEParams();
            eeFactor = AdExploreModel.getExploreFactor(adEEParams);
        }
        return eeFactor;
    }

    public static Double qiliangControl(AdBidResultDo adBidResultDo, AdExploreModel adExploreModel) {
        Long packageId = adBidResultDo.getPackageId();
        AdControlParams params = adExploreModel.getQiliangParamsMap().get(packageId);
        if (params != null && params.getIsQiliang() != null && params.getIsQiliang().booleanValue()) {
            return params.getQlFactor();
        }
        return null;
    }
}

