/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxBid;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxFeatureParse;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxRcmd;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxRcmdAlg;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxRcmdBase;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.Model;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.PredictType;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxAppReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxBidReq;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxBidRet;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxIdeaAdFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxRecallReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxRecallRetDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.IdeaUnitDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.SlotFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.SlotFactorReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorReqDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.v2.AdxFeatureParseV2;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.v2023.AdContextFeatureDoV3;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxRcmd2 {
    public static final double COLD_RATE = 0.25;
    public static final double[] weightList = new double[]{100.0, 40.0, 20.0, 10.0, 5.0, 4.0, 3.0, 2.0, 1.0, 1.0};
    private static final Logger logger = LoggerFactory.getLogger(AdxRcmd.class);
    private static final Random random = new Random();

    public static void main(String[] args) {
        ArrayList<AdIdeaDo> adIdeaDos = new ArrayList<AdIdeaDo>();
        AdIdeaDo adIdeaDo = new AdIdeaDo();
        adIdeaDo.setPriceType(1);
        adIdeaDo.setResId(1120L);
        adIdeaDos.add(adIdeaDo);
        AdxAppReqDo adxAppReqDo = new AdxAppReqDo();
        adxAppReqDo.setBidEcpmThreadhold(0.11);
        adxAppReqDo.setPmpType(0);
        AdxRcmd2.bidding(adIdeaDos, adxAppReqDo);
    }

    public static Map<Long, FeatureMapDo> getFeatureMap(List<AdxIdeaAdFeatureDo> adxIdeaAdFeatureDos, AdxFeatureDo adxFeatureDo, Map<Long, AdxStatsDo> ideaAppStatsList, AdxStatsDo resoAppStats, DmpFeatureDto dmpFeatureDto) {
        HashMap<Long, FeatureMapDo> featureMap = new HashMap<Long, FeatureMapDo>();
        ideaAppStatsList = Optional.ofNullable(ideaAppStatsList).orElse(new HashMap());
        AdxIndexStatsDo resoApp1HourInfo = AdxStatData.getAdxTimeIndex(resoAppStats, "1hour");
        adxFeatureDo.setResoAppExpCntDay(resoApp1HourInfo.getExpCnt());
        adxFeatureDo.setResoAppClickCntDay(resoApp1HourInfo.getClickCnt());
        adxFeatureDo.setResoAppAdCostDay(resoApp1HourInfo.getAdvertConsume());
        Map<String, String> staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic(adxFeatureDo, resoAppStats);
        AdContextFeatureDoV3 contextDo = new AdContextFeatureDoV3();
        contextDo.setResourceId(adxFeatureDo.getResourceId());
        Map dmpFeatureMap = AdxFeatureParseV2.generateFeatureMapStatic((AdContextFeatureDoV3)contextDo, (DmpFeatureDto)dmpFeatureDto);
        staticFeatureMap.putAll(dmpFeatureMap);
        if (AssertUtil.isEmpty(adxIdeaAdFeatureDos)) {
            logger.warn("AdxRcmd.getFeatureMap adxIdeaAdFeatureDos is null");
            return featureMap;
        }
        for (AdxIdeaAdFeatureDo ideaAdDo : adxIdeaAdFeatureDos) {
            Long ideaId = ideaAdDo.getIdeaId();
            AdxFeatureDo dynamicDo = new AdxFeatureDo();
            BeanUtils.copy((Object)ideaAdDo, (Object)dynamicDo);
            AdxStatsDo ideaAppStats = Optional.ofNullable(ideaAppStatsList.get(ideaId)).orElse(new AdxStatsDo());
            AdxIndexStatsDo ideaApp1DayInfo = AdxStatData.getAdxTimeIndex(ideaAppStats, "1day");
            dynamicDo.setIdeaAppExpCntDay(ideaApp1DayInfo.getExpCnt());
            dynamicDo.setIdeaAppClickCntDay(ideaApp1DayInfo.getClickCnt());
            dynamicDo.setIdeaAppAdCostDay(ideaApp1DayInfo.getAdvertConsume());
            dynamicDo.setIdeaAppLaunchCntDay(ideaApp1DayInfo.getAdvertLaunch());
            dynamicDo.setIdeaAppAdClickCntDay(ideaApp1DayInfo.getAdvertClick());
            AdxIndexStatDo idea2DayInfo = Optional.ofNullable(ideaAppStats.getLast2DayStat()).orElse(new AdxIndexStatDo());
            dynamicDo.setIdea2dExp(idea2DayInfo.getExp());
            dynamicDo.setIdea2dClick(idea2DayInfo.getClick());
            dynamicDo.setIdea2dFlcClick(idea2DayInfo.getFlcActClick());
            Map<String, String> dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic(ideaAdDo, dynamicDo, adxFeatureDo);
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMap.put(ideaId, featureMapDo);
        }
        return featureMap;
    }

    public static Map<Long, Double> predict(Map<Long, FeatureMapDo> featureMap, Model model, PredictType predictType) throws Exception {
        Map<Long, Double> ret = new HashMap<Long, Double>();
        if (model == null) {
            logger.warn("AdxRcmd.predictCvr model is null");
            return ret;
        }
        if (MapUtils.isEmpty(featureMap) && random.nextInt(1000) < 1) {
            logger.warn("AdxRcmd.predictCvr params is not valid featureMap:{}", featureMap);
        }
        if (MapUtils.isEmpty(featureMap)) {
            return ret;
        }
        if (predictType == PredictType.CTR) {
            ret = model.predictCtr(featureMap);
        } else if (predictType == PredictType.PVLAUNCH) {
            ret = model.predictLaunchPv(featureMap);
        } else if (predictType == PredictType.ARPU) {
            ret = model.predictARPU(featureMap);
        } else if (predictType == PredictType.PVLAUNCHV2) {
            ret = model.predictLaunchPvV2(featureMap);
        } else if (predictType == PredictType.ARPUV2) {
            ret = model.predictARPUV2(featureMap);
        } else if (predictType == PredictType.CLICKPV) {
            ret = model.predictClickPv(featureMap);
        } else if (predictType == PredictType.ADCPC) {
            ret = model.predictAdCpc(featureMap);
        } else if (predictType == PredictType.SCORE) {
            ret = model.predictUserScore(featureMap);
        } else if (predictType == PredictType.SCOREV2) {
            ret = model.predictUserScoreV2(featureMap);
        } else if (predictType == PredictType.ADCPCV2) {
            ret = model.predictAdCpcV2(featureMap);
        } else if (predictType == PredictType.CTR_BAIDU_V2) {
            ret = model.predictCtrBaidu(featureMap);
        } else if (predictType == PredictType.CLICKPV_BAIDU_V2) {
            ret = model.predictClickPvBaidu(featureMap);
        } else if (predictType == PredictType.CPC_BAIDU_V2) {
            ret = model.predictAdCpcBaidu(featureMap);
        } else if (predictType == PredictType.CTR_V2) {
            ret = model.predictCtr_V2(featureMap);
        } else if (predictType == PredictType.CLICKPV_V2) {
            ret = model.predictClickPv_V2(featureMap);
        } else if (predictType == PredictType.CVR) {
            ret = model.predictCvr(featureMap);
        } else if (predictType == PredictType.CPC) {
            ret = model.predictCpc(featureMap);
        } else if (predictType == PredictType.CVRV2) {
            ret = model.predictCvr(featureMap);
        }
        return ret;
    }

    public static <T> Map<String, Map<T, Double>> predictCtrClick(Map<T, FeatureMapDo> featureMap, Model model, PredictType predictType) {
        Map<String, Map<T, Double>> ret = new HashMap<String, Map<T, Double>>();
        if (model == null) {
            logger.warn("AdxRcmd.predictCtrClick model is null");
            return ret;
        }
        if (MapUtils.isEmpty(featureMap) && random.nextInt(1000) < 1) {
            logger.warn("AdxRcmd.predictCtrClick params is not valid featureMap:{}", featureMap);
        }
        if (MapUtils.isEmpty(featureMap)) {
            return ret;
        }
        if (predictType == PredictType.ESMM) {
            ret = model.predictCtrClick(featureMap);
        } else if (predictType == PredictType.ESMMV2) {
            ret = model.predictCtrClickV2(model.getEsmmTFModelV2(), featureMap);
        } else if (predictType == PredictType.ESMMV3) {
            ret = model.predictCtrClickV2(model.getEsmmTFModelV3(), featureMap);
        }
        return ret;
    }

    public static List<AdxBidRet> bidding(List<AdIdeaDo> adIdeaDos, AdxAppReqDo adxAppReqDo) {
        List<AdxBidRet> adxBidRets = new ArrayList<AdxBidRet>();
        try {
            adxBidRets = adIdeaDos.stream().map(adIdeaDo -> {
                AdxFactorDo adxfactorDo = Optional.ofNullable(adIdeaDo.getAdxFactorDo()).orElse(new AdxFactorDo());
                AdxBidReq adxBidReq = AdxBid.buildAdxBidReq(adIdeaDo, adxfactorDo, adxAppReqDo);
                return AdxBid.getBid(adxBidReq);
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("AdxRcmd.bidding error", (Throwable)e);
        }
        return adxBidRets;
    }

    public static AdxBidRet getIdeaUnit(AdxBidRet adIdeaDo, List<IdeaUnitDo> ideaUnitDos, List<IdeaUnitDo> recallList) {
        if (AssertUtil.isEmpty((Object)adIdeaDo) || adIdeaDo.getIdeaId() == null) {
            logger.warn("AdxRcmd.getIdeaUnit adIdeaDo is null");
            return adIdeaDo;
        }
        Long ideaId = adIdeaDo.getIdeaId();
        if (AssertUtil.isEmpty(ideaUnitDos) || ideaUnitDos.size() < 1) {
            logger.warn("AdxRcmd.getIdeaUnit ideaUnitDos is null, adxIdeaId = {}", (Object)JSON.toJSONString((Object)ideaId));
            return adIdeaDo;
        }
        if (ideaUnitDos.size() == 1 && AssertUtil.isNotEmpty((Object)ideaUnitDos.get(0)) && AssertUtil.isNotEmpty((Object)ideaUnitDos.get(0).getIdeaUnitId())) {
            adIdeaDo.setIdeaUnitId(ideaUnitDos.get(0).getIdeaUnitId());
            return adIdeaDo;
        }
        if (AssertUtil.isEmpty(recallList) || recallList.size() < 1) {
            logger.info("AdxRcmd.getIdeaUnit recallList is null, adxIdeaId = {} ", (Object)JSON.toJSONString((Object)ideaId));
            Collections.shuffle(ideaUnitDos);
            adIdeaDo.setIdeaUnitId(ideaUnitDos.get(0).getIdeaUnitId());
            return adIdeaDo;
        }
        List<IdeaUnitDo> interList = AdxRcmdBase.getInterList(ideaUnitDos, recallList);
        if (AssertUtil.isEmpty(interList) || interList.size() < 1) {
            logger.info("AdxRcmd.getIdeaUnit interList is null, adxIdeaId = {} ", (Object)JSON.toJSONString((Object)ideaId));
            Collections.shuffle(ideaUnitDos);
            adIdeaDo.setIdeaUnitId(ideaUnitDos.get(0).getIdeaUnitId());
            return adIdeaDo;
        }
        long coldSize = 10L;
        long bestSize = 10L;
        List<IdeaUnitDo> coldList = interList.stream().filter(interDo -> interDo.getIsNew()).sorted(Comparator.comparing(IdeaUnitDo::getLt7DExp)).limit(coldSize).collect(Collectors.toList());
        List bestList = interList.stream().filter(interDo -> interDo.getIsNew() == false).sorted(Comparator.comparing(IdeaUnitDo::getAdEcpm).reversed()).limit(bestSize).collect(Collectors.toList());
        List<IdeaUnitDo> candidates = bestList.size() == 0 || coldList.size() > 0 && Math.random() < 0.2 ? coldList : bestList;
        Map<IdeaUnitDo, Double> weightMap = AdxRcmdBase.getWeightMap(candidates, weightList);
        IdeaUnitDo retIdeaUnitDo = Roulette.doubleMap(weightMap);
        adIdeaDo.setIdeaUnitId(retIdeaUnitDo.getIdeaUnitId());
        return adIdeaDo;
    }

    public static AdxRecallRetDo recallAdIdea(AdxRecallReqDo recallReqDo) {
        AdxRecallRetDo ret = new AdxRecallRetDo();
        try {
            ret = AdxRcmdAlg.recallAdIdeaRun(recallReqDo);
        }
        catch (Exception e) {
            logger.error("AdxRcmd.recallAdIdea", (Throwable)e);
        }
        return ret;
    }

    public static AdxFactorDo adIdeaFactorRun(AdxFactorReqDo adxFactorReqDo) {
        AdxFactorDo ret = adxFactorReqDo.getAdxFactorDo();
        try {
            ret = AdxRcmdAlg.adIdeaFactorRun(adxFactorReqDo);
        }
        catch (Exception e) {
            logger.error("AdxRcmd.ideaFactorRun", (Throwable)e);
        }
        return ret;
    }

    public static SlotFactorDo slotFactorRun(SlotFactorReqDo slotFactorReqDo) {
        SlotFactorDo ret = slotFactorReqDo.getSlotFactorDo();
        try {
            ret = AdxRcmdAlg.slotFactorRun(slotFactorReqDo);
        }
        catch (Exception e) {
            logger.error("AdxRcmd.slotFactorRun", (Throwable)e);
        }
        return ret;
    }
}

