/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rtbbid;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.rtbbid.AdxClickValuePredictAlg;
import cn.com.duiba.nezha.alg.alg.adx.rtbbid.AdxCpcAlgoBid;
import cn.com.duiba.nezha.alg.alg.adx.rtbbid.AdxRoiAlgoBid;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxClickAndJoinDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxPredAdDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.AdxRtbBidRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.AdxRtbBidResultDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtbBidAlg {
    private static final Logger logger = LoggerFactory.getLogger(RtbBidAlg.class);
    private static int[] CLICK_VALUE_BUCKET = new int[]{1, 2, 3, 5, 7, 10, 20, 50, 100};

    public static AdxRtbBidResultDo getRtbBidding(AdxRtbBidRequestDo bidRequestDo) {
        AdxRtbBidResultDo ret = new AdxRtbBidResultDo();
        try {
            if (RtbBidAlg.valid(bidRequestDo).booleanValue()) {
                Double preAdClickValue = RtbBidAlg.getPreAdClickValue(bidRequestDo);
                bidRequestDo.getAdxDoInfo().setPredClickValue(preAdClickValue);
                Integer clickValueLevel = AdxStatData.bucket(bidRequestDo.getAdxDoInfo().getTfPreClickValue(), CLICK_VALUE_BUCKET);
                Double clickValueRectifyFactor = AdxStatData.getClickValueRectifyFactor(clickValueLevel, bidRequestDo.getClickValueRectify());
                Double recTfPreClickValue = DataUtil.division((Double)bidRequestDo.getAdxDoInfo().getTfPreClickValue(), (Double)clickValueRectifyFactor);
                bidRequestDo.getAdxDoInfo().setRecTfPreClickValue(recTfPreClickValue);
                Integer algoBidMode = bidRequestDo.getAdxDoInfo().getAlgoBidMode();
                if (AssertUtil.isNotEmpty((Object)algoBidMode) && algoBidMode.equals(1)) {
                    ret = AdxRoiAlgoBid.getAdxAlgoPrice(bidRequestDo.getAdxDoInfo(), bidRequestDo.getAdxRoiControlInfo());
                } else if (AssertUtil.isNotEmpty((Object)algoBidMode) && algoBidMode.equals(2)) {
                    ret = AdxCpcAlgoBid.getAdxAlgoPrice(bidRequestDo);
                }
                ret.setPredClickValue(preAdClickValue);
                ret.setClickValueLevel(clickValueLevel);
                ret.setClickValueRectifyFactor(clickValueRectifyFactor);
            }
        }
        catch (Exception e) {
            logger.error("RtbBidAlg.getRtbBidding error", (Throwable)e);
        }
        return ret;
    }

    private static Boolean valid(AdxRtbBidRequestDo bidRequestDo) {
        Boolean ret = true;
        if (AssertUtil.isEmpty((Object)bidRequestDo)) {
            ret = false;
            logger.error("RtbBidAlg.getRtbBidding() input params valid , params bidRequestDo is null");
        } else if (AssertUtil.isEmpty((Object)bidRequestDo.getAdxDoInfo())) {
            ret = false;
            logger.error("RtbBidAlg.getRtbBidding() input params valid , params adxDoInfo is null");
        }
        return ret;
    }

    private static Double getPreAdClickValue(AdxRtbBidRequestDo bidRequestDo) {
        Integer preLaunchSwitch;
        Double ret = null;
        if (RtbBidAlg.valid(bidRequestDo).booleanValue() && AssertUtil.isNotEmpty((Object)(preLaunchSwitch = bidRequestDo.getAdxDoInfo().getPreLaunchSwitch())) && preLaunchSwitch.equals(1)) {
            AdxClickAndJoinDo mergeAdxClickAndJoinDo = bidRequestDo.getMergeAdxClickAndJoinDo();
            List<AdxPredAdDo> adxPredAdDoList = bidRequestDo.getAdxPredAdDoList();
            ret = AdxClickValuePredictAlg.getPredClickValue(mergeAdxClickAndJoinDo, adxPredAdDoList);
        }
        return ret;
    }
}

