/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adxhd.rec;

import cn.com.duiba.adx.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.nezha.alg.alg.adxhd.dto.AHContextFeatureDto;
import cn.com.duiba.nezha.alg.alg.adxhd.dto.AHIdeaBidReqDto;
import cn.com.duiba.nezha.alg.alg.adxhd.dto.AHIdeaBidResDto;
import cn.com.duiba.nezha.alg.alg.adxhd.model.AHOnnxModel;
import cn.com.duiba.nezha.alg.alg.adxhd.parse.AHFeatureParse;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AHBid {
    private static final Logger logger = LoggerFactory.getLogger(AHBid.class);
    private static final Map<Long, Double> defaultMap = new HashMap<Long, Double>();

    public static List<AHIdeaBidResDto> bidding(List<AHIdeaBidReqDto> ideaBidReqDtos, AHContextFeatureDto contextFeatureDto, DmpFeatureDto dmpFeatureDto, AHOnnxModel ahOnnxModel) {
        ArrayList<AHIdeaBidResDto> adxBidRets = new ArrayList<AHIdeaBidResDto>();
        if (AssertUtil.isEmpty(ideaBidReqDtos)) {
            logger.error("AHBid.bidding params error, ideaBidReqDtos is empty");
            return adxBidRets;
        }
        try {
            Map<Long, FeatureMapDo> featureMap = AHFeatureParse.generateFeatureMap(ideaBidReqDtos, contextFeatureDto, dmpFeatureDto);
            System.out.println("featureMap=" + JSONObject.toJSONString(featureMap));
            Map<Long, Double> pCtrMap = defaultMap;
            Map<Long, Double> pCvrMap = defaultMap;
            if (ahOnnxModel != null && AssertUtil.isAllNotEmpty((Object[])new Object[]{ahOnnxModel.getCtrOnnxModel(), ahOnnxModel.getCtrCodeModel(), ahOnnxModel.getCvrOnnxModel(), ahOnnxModel.getCvrCodeModel()})) {
                pCtrMap = ahOnnxModel.predictCtr(featureMap);
                pCvrMap = ahOnnxModel.predictCvr(featureMap);
            }
            for (AHIdeaBidReqDto ideaBidReqDto : ideaBidReqDtos) {
                Long ideaId = ideaBidReqDto.getIdeaId();
                Double pCtr = pCtrMap.get(ideaId);
                Double pCvr = pCvrMap.get(ideaId);
                FeatureMapDo featureMapDo = featureMap.get(ideaId);
                AHIdeaBidResDto ideaBidResDto = new AHIdeaBidResDto();
                ideaBidResDto.setIdeaId(ideaId);
                ideaBidResDto.setAhBidType(ideaBidReqDto.getAhBidType());
                ideaBidResDto.setCpc(ideaBidReqDto.getCpc());
                ideaBidResDto.setCpa(ideaBidReqDto.getCpa());
                ideaBidResDto.updatePrice(ideaBidReqDto, featureMapDo.getFeatureMap(), pCtr, pCvr);
                adxBidRets.add(ideaBidResDto);
            }
            return adxBidRets;
        }
        catch (Exception e) {
            logger.error("AHBid.bidding error", (Throwable)e);
            return adxBidRets;
        }
    }
}

