/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.api.facade.recall;

import cn.com.duiba.nezha.alg.api.dto.recall.RecallChannelResult;
import cn.com.duiba.nezha.alg.api.enums.RecallEnums;
import cn.com.duiba.nezha.alg.api.facade.recall.MergeRecallChannelFacade;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.junit.Test;

public class MergeRecallChannelFacadeImpl
implements MergeRecallChannelFacade {
    public Map<String, Map<RecallEnums.RecallChannelType, Double>> merge(Map<RecallEnums.RecallChannelType, Map<String, RecallChannelResult>> param) {
        HashMap<String, Map<RecallEnums.RecallChannelType, Double>> res = new HashMap<String, Map<RecallEnums.RecallChannelType, Double>>();
        if (MapUtils.isEmpty(param)) {
            return res;
        }
        for (Map.Entry<RecallEnums.RecallChannelType, Map<String, RecallChannelResult>> paramEntry : param.entrySet()) {
            RecallEnums.RecallChannelType curChannel = paramEntry.getKey();
            Map<String, RecallChannelResult> curRecallRes = paramEntry.getValue();
            for (Map.Entry<String, RecallChannelResult> entry : curRecallRes.entrySet()) {
                String curKey = entry.getKey();
                Double score = entry.getValue().getScore();
                Map scoreMap = (Map)res.get(curKey);
                if (scoreMap == null) {
                    HashMap<RecallEnums.RecallChannelType, Double> curRes = new HashMap<RecallEnums.RecallChannelType, Double>();
                    curRes.put(curChannel, score);
                    res.put(curKey, curRes);
                    continue;
                }
                scoreMap.put(curChannel, score);
            }
        }
        return res;
    }

    @Test
    public void test1() {
        HashMap<RecallEnums.RecallChannelType, Map<String, RecallChannelResult>> param = new HashMap<RecallEnums.RecallChannelType, Map<String, RecallChannelResult>>();
        RecallEnums.RecallChannelType channel1 = RecallEnums.RecallChannelType.Heat;
        RecallEnums.RecallChannelType channel2 = RecallEnums.RecallChannelType.IndustryGeneral;
        RecallEnums.RecallChannelType channel9 = RecallEnums.RecallChannelType.Random;
        RecallEnums.RecallChannelType channel10 = RecallEnums.RecallChannelType.AppIndustryGeneral;
        RecallChannelResult rcr1 = new RecallChannelResult();
        HashMap<String, RecallChannelResult> heatRecallRes = new HashMap<String, RecallChannelResult>();
        rcr1.setIndex("cvr0");
        rcr1.setAdvertId(Long.valueOf(123L));
        rcr1.setPackageId(Long.valueOf(999L));
        rcr1.setScore(Double.valueOf(0.9));
        heatRecallRes.put(rcr1.buildKey(), rcr1);
        RecallChannelResult rcr2 = new RecallChannelResult();
        rcr2.setIndex("weighted0");
        rcr2.setAdvertId(Long.valueOf(456L));
        rcr2.setPackageId(Long.valueOf(888L));
        rcr2.setScore(Double.valueOf(0.6));
        heatRecallRes.put(rcr2.buildKey(), rcr2);
        param.put(channel1, heatRecallRes);
        RecallChannelResult rcr3 = new RecallChannelResult();
        HashMap<String, RecallChannelResult> geneRecallRes = new HashMap<String, RecallChannelResult>();
        rcr3.setIndex("cvr0");
        rcr3.setAdvertId(Long.valueOf(123L));
        rcr3.setPackageId(Long.valueOf(999L));
        rcr3.setScore(Double.valueOf(0.7));
        geneRecallRes.put(rcr3.buildKey(), rcr3);
        RecallChannelResult rcr4 = new RecallChannelResult();
        rcr4.setIndex("weighted0");
        rcr4.setAdvertId(Long.valueOf(456L));
        rcr4.setPackageId(Long.valueOf(888L));
        rcr4.setScore(Double.valueOf(0.8));
        geneRecallRes.put(rcr4.buildKey(), rcr4);
        param.put(channel2, geneRecallRes);
        RecallChannelResult rcr6 = new RecallChannelResult();
        HashMap<String, RecallChannelResult> appGeneRecallRes = new HashMap<String, RecallChannelResult>();
        rcr6.setIndex("cvr0");
        rcr6.setAdvertId(Long.valueOf(123L));
        rcr6.setPackageId(Long.valueOf(999L));
        rcr6.setScore(Double.valueOf(0.7));
        appGeneRecallRes.put(rcr6.buildKey(), rcr6);
        RecallChannelResult rcr7 = new RecallChannelResult();
        rcr7.setIndex("weighted0");
        rcr7.setAdvertId(Long.valueOf(456L));
        rcr7.setPackageId(Long.valueOf(888L));
        rcr7.setScore(Double.valueOf(0.8));
        appGeneRecallRes.put(rcr7.buildKey(), rcr7);
        param.put(channel10, appGeneRecallRes);
        HashMap<String, RecallChannelResult> randomRecallRes = new HashMap<String, RecallChannelResult>();
        RecallChannelResult rcr5 = new RecallChannelResult();
        rcr5.setIndex("cvr0");
        rcr5.setAdvertId(Long.valueOf(123L));
        rcr5.setPackageId(Long.valueOf(999L));
        rcr5.setScore(Double.valueOf(0.44));
        randomRecallRes.put(rcr5.buildKey(), rcr5);
        param.put(channel9, randomRecallRes);
        MergeRecallChannelFacadeImpl curMerge = new MergeRecallChannelFacadeImpl();
        Map<String, Map<RecallEnums.RecallChannelType, Double>> k = curMerge.merge(param);
        System.out.println("res: " + k);
    }
}

