/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.directly;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyPkDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIdeaInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxDirectlyPk {
    private static final Logger logger = LoggerFactory.getLogger(AdxDirectlyPk.class);

    public static AdxDirectlyPkDo getPk(List<Long> ideaList, Long pkType, Map<Long, AdxIdeaInfoDo> ideaStatDoMap) {
        AdxDirectlyPkDo ret = new AdxDirectlyPkDo();
        try {
            Long winIdeaId = null;
            Long interIdeaId = null;
            Long directlyIdeaId = null;
            Long interPrice = null;
            Long directlyPrice = null;
            Double interRpm = null;
            Double directlyRpm = null;
            AdxIdeaInfoDo interIdeaInfo = null;
            AdxIdeaInfoDo directlyIdeaInfo = null;
            if (AssertUtil.isNotEmpty(ideaList)) {
                winIdeaId = ideaList.get(0);
                if ((long)ideaList.size() == 2L) {
                    double random1 = Math.random();
                    if (random1 <= 0.5) {
                        winIdeaId = ideaList.get(1);
                    }
                    if (AssertUtil.isNotEmpty(ideaStatDoMap)) {
                        for (Long ind : ideaList) {
                            AdxIdeaInfoDo ideaInfo = ideaStatDoMap.get(ind);
                            if (!AssertUtil.isNotEmpty((Object)ideaInfo)) continue;
                            if (AssertUtil.isNotEmpty((Object)ideaInfo.getPriceType()) && ideaInfo.getPriceType() != 2L) {
                                interIdeaId = ind;
                                interIdeaInfo = ideaInfo;
                                AdxIndexStatsDo interIndexStatMs = AdxStatData.indexStatCompute(interIdeaInfo.getIdeaMinStatDoMap());
                                interPrice = interIdeaInfo.getPrice();
                                interRpm = interIndexStatMs.getRpm();
                                continue;
                            }
                            if (!AssertUtil.isNotEmpty((Object)ideaInfo.getPriceType()) || ideaInfo.getPriceType() != 2L) continue;
                            directlyIdeaId = ind;
                            directlyIdeaInfo = ideaInfo;
                            AdxIndexStatsDo directlyIndexStatMs = AdxStatData.indexStatCompute(directlyIdeaInfo.getIdeaMinStatDoMap());
                            directlyPrice = directlyIdeaInfo.getPrice();
                            directlyRpm = directlyIndexStatMs.getRpm();
                        }
                        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{interIdeaId, directlyIdeaId})) {
                            winIdeaId = interIdeaId;
                            if (AssertUtil.isEmpty((Object)pkType) || pkType == 1L) {
                                if (AdxStatData.isEqual(directlyPrice, interPrice) || AssertUtil.isAnyEmpty((Object[])new Object[]{directlyPrice, interPrice})) {
                                    double random2 = Math.random();
                                    if (random2 <= 0.5) {
                                        winIdeaId = directlyIdeaId;
                                    }
                                } else if (AdxStatData.isLarger(directlyPrice, interPrice)) {
                                    winIdeaId = directlyIdeaId;
                                }
                            } else if (pkType == 2L) {
                                if (AdxStatData.isEqual(directlyRpm, interRpm) || AssertUtil.isAnyEmpty((Object[])new Object[]{directlyRpm, interRpm})) {
                                    double random3 = Math.random();
                                    if (random3 <= 0.5) {
                                        winIdeaId = directlyIdeaId;
                                    }
                                } else if (AdxStatData.isLarger(directlyRpm, interRpm)) {
                                    winIdeaId = directlyIdeaId;
                                }
                            }
                        }
                    }
                }
            }
            ret.setIdeaId(winIdeaId);
            ret.setInterPrice(interPrice);
            ret.setDirectlyPrice(directlyPrice);
            ret.setInterRpm(interRpm);
            ret.setDirectlyRpm(directlyRpm);
        }
        catch (Exception e) {
            logger.error("AdxDirectlyPk.getPk error:" + e);
        }
        return ret;
    }
}

