/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adxhd.dto;

import cn.com.duiba.nezha.alg.alg.adxhd.dto.AHIdeaBidReqDto;
import cn.com.duiba.nezha.alg.alg.adxhd.enums.AHBidType;
import cn.com.duiba.nezha.alg.alg.adxhd.enums.ConvertType;
import cn.com.duiba.nezha.alg.alg.adxhd.stat.AHStatCalcDto;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.Map;
import java.util.Optional;

public class AHIdeaBidResDto {
    public Long ideaId;
    private AHBidType ahBidType;
    private Double algPrice;
    private Double targetPrice;
    private ConvertType convertType;
    public Double pCtr;
    public Double pCvr;
    public Double sCtr;
    public Double sCvr;
    public Double ctr;
    public Double cvr;
    public Double cFactor;
    public Double ecpm;
    public AHStatCalcDto ideaStatDoStatCalcDo;
    public AHStatCalcDto ideaPkgStatDoStatCalcDo;
    public Map<String, String> featureMap;

    public void updatePrice(AHIdeaBidReqDto ideaBidReqDto, Map<String, String> featureMap, Double pCtr, Double pCvr) throws Exception {
        this.featureMap = featureMap;
        this.ideaStatDoStatCalcDo = Optional.ofNullable(ideaBidReqDto.getIdeaStatCalcDto()).orElse(new AHStatCalcDto());
        this.ideaPkgStatDoStatCalcDo = Optional.ofNullable(ideaBidReqDto.getIdeaPkgStatCalcDto()).orElse(new AHStatCalcDto());
        this.pCtr = pCtr;
        this.pCvr = pCvr;
        Double cFactor1 = this.ideaPkgStatDoStatCalcDo.getCFactor();
        Double sCtr1 = this.ideaPkgStatDoStatCalcDo.getSCtr();
        Double sCvr1 = this.ideaPkgStatDoStatCalcDo.getSCvr();
        Double cFactor2 = this.ideaStatDoStatCalcDo.getCFactor();
        Double sCtr2 = this.ideaStatDoStatCalcDo.getSCtr();
        Double sCvr2 = this.ideaStatDoStatCalcDo.getSCvr();
        this.sCtr = sCtr1 != null ? sCtr1 : sCtr2;
        this.sCvr = sCvr1 != null ? sCvr1 : sCvr2;
        this.cFactor = cFactor1 != null ? cFactor1 : cFactor2;
        this.cFactor = Math.max(Math.min(this.cFactor, 0.8), 1.1);
        this.ctr = AHIdeaBidResDto.getMergeCxr(pCtr, this.sCtr, 0.5, 0.5, 2.0);
        this.cvr = AHIdeaBidResDto.getMergeCxr(pCvr, this.sCvr, 0.5, 0.5, 2.0);
        if (AHBidType.ALG_OCPM.equals((Object)this.ahBidType) && AssertUtil.isAllNotEmpty((Object[])new Object[]{this.ctr, this.cvr, this.targetPrice, this.convertType})) {
            if (ConvertType.ALG_CLICK.equals((Object)this.convertType)) {
                this.algPrice = DataUtil.formatDouble((Double)(this.ctr * this.targetPrice * 1000.0 * this.cFactor), (int)5);
                this.ecpm = DataUtil.formatDouble((Double)(this.ctr * this.targetPrice * 1000.0), (int)5);
            } else if (ConvertType.ALG_TARGET.equals((Object)this.convertType)) {
                this.algPrice = DataUtil.formatDouble((Double)(this.ctr * this.cvr * this.targetPrice * 1000.0 * this.cFactor), (int)5);
                this.ecpm = DataUtil.formatDouble((Double)(this.ctr * this.cvr * this.targetPrice * 1000.0), (int)5);
            }
        }
        if (AHBidType.ALG_OCPC.equals((Object)this.ahBidType) && AssertUtil.isAllNotEmpty((Object[])new Object[]{this.ctr, this.cvr, this.targetPrice, this.convertType})) {
            if (ConvertType.ALG_CLICK.equals((Object)this.convertType)) {
                this.algPrice = DataUtil.formatDouble((Double)(this.targetPrice * this.cFactor), (int)5);
                this.ecpm = DataUtil.formatDouble((Double)(this.ctr * this.targetPrice * 1000.0), (int)5);
            } else if (ConvertType.ALG_TARGET.equals((Object)this.convertType)) {
                this.algPrice = DataUtil.formatDouble((Double)(this.cvr * this.targetPrice * this.cFactor), (int)5);
                this.ecpm = DataUtil.formatDouble((Double)(this.ctr * this.cvr * this.targetPrice * 1000.0), (int)5);
            }
        }
    }

    public static Double getMergeCxr(Double pCxr, Double sCxr, double pW, double lowerW, double upperW) {
        Double ret = 0.0;
        if (pCxr == null) {
            return sCxr;
        }
        if (sCxr == null) {
            return pCxr;
        }
        ret = pW * pCxr + (1.0 - pW) * sCxr;
        if ((ret = DataUtil.formatDouble((Double)ret, (int)5)) > upperW * sCxr) {
            ret = upperW * sCxr;
        }
        if (ret < lowerW * sCxr) {
            ret = lowerW * sCxr;
        }
        return ret;
    }

    public Long getIdeaId() {
        return this.ideaId;
    }

    public AHBidType getAhBidType() {
        return this.ahBidType;
    }

    public Double getAlgPrice() {
        return this.algPrice;
    }

    public Double getTargetPrice() {
        return this.targetPrice;
    }

    public ConvertType getConvertType() {
        return this.convertType;
    }

    public Double getPCtr() {
        return this.pCtr;
    }

    public Double getPCvr() {
        return this.pCvr;
    }

    public Double getSCtr() {
        return this.sCtr;
    }

    public Double getSCvr() {
        return this.sCvr;
    }

    public Double getCtr() {
        return this.ctr;
    }

    public Double getCvr() {
        return this.cvr;
    }

    public Double getCFactor() {
        return this.cFactor;
    }

    public Double getEcpm() {
        return this.ecpm;
    }

    public AHStatCalcDto getIdeaStatDoStatCalcDo() {
        return this.ideaStatDoStatCalcDo;
    }

    public AHStatCalcDto getIdeaPkgStatDoStatCalcDo() {
        return this.ideaPkgStatDoStatCalcDo;
    }

    public Map<String, String> getFeatureMap() {
        return this.featureMap;
    }

    public void setIdeaId(Long ideaId) {
        this.ideaId = ideaId;
    }

    public void setAhBidType(AHBidType ahBidType) {
        this.ahBidType = ahBidType;
    }

    public void setAlgPrice(Double algPrice) {
        this.algPrice = algPrice;
    }

    public void setTargetPrice(Double targetPrice) {
        this.targetPrice = targetPrice;
    }

    public void setConvertType(ConvertType convertType) {
        this.convertType = convertType;
    }

    public void setPCtr(Double pCtr) {
        this.pCtr = pCtr;
    }

    public void setPCvr(Double pCvr) {
        this.pCvr = pCvr;
    }

    public void setSCtr(Double sCtr) {
        this.sCtr = sCtr;
    }

    public void setSCvr(Double sCvr) {
        this.sCvr = sCvr;
    }

    public void setCtr(Double ctr) {
        this.ctr = ctr;
    }

    public void setCvr(Double cvr) {
        this.cvr = cvr;
    }

    public void setCFactor(Double cFactor) {
        this.cFactor = cFactor;
    }

    public void setEcpm(Double ecpm) {
        this.ecpm = ecpm;
    }

    public void setIdeaStatDoStatCalcDo(AHStatCalcDto ideaStatDoStatCalcDo) {
        this.ideaStatDoStatCalcDo = ideaStatDoStatCalcDo;
    }

    public void setIdeaPkgStatDoStatCalcDo(AHStatCalcDto ideaPkgStatDoStatCalcDo) {
        this.ideaPkgStatDoStatCalcDo = ideaPkgStatDoStatCalcDo;
    }

    public void setFeatureMap(Map<String, String> featureMap) {
        this.featureMap = featureMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AHIdeaBidResDto)) {
            return false;
        }
        AHIdeaBidResDto other = (AHIdeaBidResDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$ideaId = this.getIdeaId();
        Long other$ideaId = other.getIdeaId();
        if (this$ideaId == null ? other$ideaId != null : !((Object)this$ideaId).equals(other$ideaId)) {
            return false;
        }
        AHBidType this$ahBidType = this.getAhBidType();
        AHBidType other$ahBidType = other.getAhBidType();
        if (this$ahBidType == null ? other$ahBidType != null : !((Object)((Object)this$ahBidType)).equals((Object)other$ahBidType)) {
            return false;
        }
        Double this$algPrice = this.getAlgPrice();
        Double other$algPrice = other.getAlgPrice();
        if (this$algPrice == null ? other$algPrice != null : !((Object)this$algPrice).equals(other$algPrice)) {
            return false;
        }
        Double this$targetPrice = this.getTargetPrice();
        Double other$targetPrice = other.getTargetPrice();
        if (this$targetPrice == null ? other$targetPrice != null : !((Object)this$targetPrice).equals(other$targetPrice)) {
            return false;
        }
        ConvertType this$convertType = this.getConvertType();
        ConvertType other$convertType = other.getConvertType();
        if (this$convertType == null ? other$convertType != null : !((Object)((Object)this$convertType)).equals((Object)other$convertType)) {
            return false;
        }
        Double this$pCtr = this.getPCtr();
        Double other$pCtr = other.getPCtr();
        if (this$pCtr == null ? other$pCtr != null : !((Object)this$pCtr).equals(other$pCtr)) {
            return false;
        }
        Double this$pCvr = this.getPCvr();
        Double other$pCvr = other.getPCvr();
        if (this$pCvr == null ? other$pCvr != null : !((Object)this$pCvr).equals(other$pCvr)) {
            return false;
        }
        Double this$sCtr = this.getSCtr();
        Double other$sCtr = other.getSCtr();
        if (this$sCtr == null ? other$sCtr != null : !((Object)this$sCtr).equals(other$sCtr)) {
            return false;
        }
        Double this$sCvr = this.getSCvr();
        Double other$sCvr = other.getSCvr();
        if (this$sCvr == null ? other$sCvr != null : !((Object)this$sCvr).equals(other$sCvr)) {
            return false;
        }
        Double this$ctr = this.getCtr();
        Double other$ctr = other.getCtr();
        if (this$ctr == null ? other$ctr != null : !((Object)this$ctr).equals(other$ctr)) {
            return false;
        }
        Double this$cvr = this.getCvr();
        Double other$cvr = other.getCvr();
        if (this$cvr == null ? other$cvr != null : !((Object)this$cvr).equals(other$cvr)) {
            return false;
        }
        Double this$cFactor = this.getCFactor();
        Double other$cFactor = other.getCFactor();
        if (this$cFactor == null ? other$cFactor != null : !((Object)this$cFactor).equals(other$cFactor)) {
            return false;
        }
        Double this$ecpm = this.getEcpm();
        Double other$ecpm = other.getEcpm();
        if (this$ecpm == null ? other$ecpm != null : !((Object)this$ecpm).equals(other$ecpm)) {
            return false;
        }
        AHStatCalcDto this$ideaStatDoStatCalcDo = this.getIdeaStatDoStatCalcDo();
        AHStatCalcDto other$ideaStatDoStatCalcDo = other.getIdeaStatDoStatCalcDo();
        if (this$ideaStatDoStatCalcDo == null ? other$ideaStatDoStatCalcDo != null : !((Object)this$ideaStatDoStatCalcDo).equals(other$ideaStatDoStatCalcDo)) {
            return false;
        }
        AHStatCalcDto this$ideaPkgStatDoStatCalcDo = this.getIdeaPkgStatDoStatCalcDo();
        AHStatCalcDto other$ideaPkgStatDoStatCalcDo = other.getIdeaPkgStatDoStatCalcDo();
        if (this$ideaPkgStatDoStatCalcDo == null ? other$ideaPkgStatDoStatCalcDo != null : !((Object)this$ideaPkgStatDoStatCalcDo).equals(other$ideaPkgStatDoStatCalcDo)) {
            return false;
        }
        Map<String, String> this$featureMap = this.getFeatureMap();
        Map<String, String> other$featureMap = other.getFeatureMap();
        return !(this$featureMap == null ? other$featureMap != null : !((Object)this$featureMap).equals(other$featureMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AHIdeaBidResDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $ideaId = this.getIdeaId();
        result = result * 59 + ($ideaId == null ? 43 : ((Object)$ideaId).hashCode());
        AHBidType $ahBidType = this.getAhBidType();
        result = result * 59 + ($ahBidType == null ? 43 : ((Object)((Object)$ahBidType)).hashCode());
        Double $algPrice = this.getAlgPrice();
        result = result * 59 + ($algPrice == null ? 43 : ((Object)$algPrice).hashCode());
        Double $targetPrice = this.getTargetPrice();
        result = result * 59 + ($targetPrice == null ? 43 : ((Object)$targetPrice).hashCode());
        ConvertType $convertType = this.getConvertType();
        result = result * 59 + ($convertType == null ? 43 : ((Object)((Object)$convertType)).hashCode());
        Double $pCtr = this.getPCtr();
        result = result * 59 + ($pCtr == null ? 43 : ((Object)$pCtr).hashCode());
        Double $pCvr = this.getPCvr();
        result = result * 59 + ($pCvr == null ? 43 : ((Object)$pCvr).hashCode());
        Double $sCtr = this.getSCtr();
        result = result * 59 + ($sCtr == null ? 43 : ((Object)$sCtr).hashCode());
        Double $sCvr = this.getSCvr();
        result = result * 59 + ($sCvr == null ? 43 : ((Object)$sCvr).hashCode());
        Double $ctr = this.getCtr();
        result = result * 59 + ($ctr == null ? 43 : ((Object)$ctr).hashCode());
        Double $cvr = this.getCvr();
        result = result * 59 + ($cvr == null ? 43 : ((Object)$cvr).hashCode());
        Double $cFactor = this.getCFactor();
        result = result * 59 + ($cFactor == null ? 43 : ((Object)$cFactor).hashCode());
        Double $ecpm = this.getEcpm();
        result = result * 59 + ($ecpm == null ? 43 : ((Object)$ecpm).hashCode());
        AHStatCalcDto $ideaStatDoStatCalcDo = this.getIdeaStatDoStatCalcDo();
        result = result * 59 + ($ideaStatDoStatCalcDo == null ? 43 : ((Object)$ideaStatDoStatCalcDo).hashCode());
        AHStatCalcDto $ideaPkgStatDoStatCalcDo = this.getIdeaPkgStatDoStatCalcDo();
        result = result * 59 + ($ideaPkgStatDoStatCalcDo == null ? 43 : ((Object)$ideaPkgStatDoStatCalcDo).hashCode());
        Map<String, String> $featureMap = this.getFeatureMap();
        result = result * 59 + ($featureMap == null ? 43 : ((Object)$featureMap).hashCode());
        return result;
    }

    public String toString() {
        return "AHIdeaBidResDto(ideaId=" + this.getIdeaId() + ", ahBidType=" + (Object)((Object)this.getAhBidType()) + ", algPrice=" + this.getAlgPrice() + ", targetPrice=" + this.getTargetPrice() + ", convertType=" + (Object)((Object)this.getConvertType()) + ", pCtr=" + this.getPCtr() + ", pCvr=" + this.getPCvr() + ", sCtr=" + this.getSCtr() + ", sCvr=" + this.getSCvr() + ", ctr=" + this.getCtr() + ", cvr=" + this.getCvr() + ", cFactor=" + this.getCFactor() + ", ecpm=" + this.getEcpm() + ", ideaStatDoStatCalcDo=" + this.getIdeaStatDoStatCalcDo() + ", ideaPkgStatDoStatCalcDo=" + this.getIdeaPkgStatDoStatCalcDo() + ", featureMap=" + this.getFeatureMap() + ")";
    }
}

