/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adxhd.parse;

import cn.com.duiba.nezha.alg.alg.adxhd.parse.BaseParse;
import cn.com.duiba.nezha.alg.alg.adxhd.stat.AHStatCalcDto;
import cn.com.duiba.nezha.alg.alg.adxhd.stat.AHStatDto;
import cn.com.duiba.nezha.alg.alg.adxhd.stat.AHSubStatDto;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AHStatParse
extends BaseParse {
    private static final Logger logger = LoggerFactory.getLogger(AHStatParse.class);
    private static final Map<Long, AHStatDto> nullMap = new HashMap<Long, AHStatDto>();
    private static final AHSubStatDto nullDto = new AHSubStatDto();

    public static AHStatCalcDto parse(AHStatDto ahStatDo, Double targetRoi) throws Exception {
        AHStatCalcDto ahStatCalcDto = AHStatParse.stat(ahStatDo);
        if (AssertUtil.isEmpty((Object)ahStatDo)) {
            return ahStatCalcDto;
        }
        Double weight = ahStatCalcDto.getWeight();
        Boolean sCtrConf = ahStatCalcDto.getAdxExpPv() > 200.0;
        Double sCtr = sCtrConf != false ? DataUtil.division((Double)ahStatCalcDto.getAdxClickPv(), (Double)ahStatCalcDto.getAdxExpPv(), (int)5) : null;
        ahStatCalcDto.setSCtr(sCtr);
        ahStatCalcDto.setSCtrConf(sCtrConf);
        Boolean sCvrConf = ahStatCalcDto.getAdxClickPv() > 5000.0;
        Double sCvr = sCvrConf != false ? DataUtil.division((Double)ahStatCalcDto.getAdConvertPv(), (Double)ahStatCalcDto.getAdxClickPv(), (int)5) : null;
        ahStatCalcDto.setSCvr(sCvr);
        ahStatCalcDto.setSCvrConf(sCvrConf);
        Double uvCost = sCvrConf != false ? DataUtil.division((Double)ahStatCalcDto.getAdTargetCost(), (Double)ahStatCalcDto.getAdxClickPv(), (int)5) : null;
        ahStatCalcDto.setUvCost(uvCost);
        Boolean sRoiConf = ahStatCalcDto.getAdxCost() > 20000.0;
        Double sRoi = sRoiConf != false ? DataUtil.division((Double)ahStatCalcDto.getAdTargetCost(), (Double)ahStatCalcDto.getAdxCost(), (int)2) : null;
        ahStatCalcDto.setSRoi(sRoi);
        ahStatCalcDto.setSRoiConf(sRoiConf);
        Double cFactoAvg = sRoiConf != false ? DataUtil.division((Double)ahStatCalcDto.getCFactor(), (Double)ahStatCalcDto.getAdxExpPv(), (int)2) : null;
        ahStatCalcDto.setCFactoAvg(cFactoAvg);
        targetRoi = targetRoi != null ? targetRoi : 1.1;
        Double cFactor = sRoiConf != false ? cFactoAvg * DataUtil.division((Double)sRoi, (Double)targetRoi, (int)2) : 1.0;
        ahStatCalcDto.setCFactor(cFactor);
        HashMap<String, String> featureMap = new HashMap<String, String>(8);
        if (AssertUtil.isNotEmpty((String)ahStatDo.getAppPkgName())) {
            AHStatParse.putMap(featureMap, "fas_1004", AHStatParse.bucket((Number)ahStatCalcDto.getSCtr(), (Number[])ctrBucket));
            AHStatParse.putMap(featureMap, "fas_1005", AHStatParse.bucket((Number)ahStatCalcDto.getSCvr(), (Number[])cvrBucket));
            AHStatParse.putMap(featureMap, "fas_1006", AHStatParse.bucket((Number)ahStatCalcDto.getUvCost(), (Number[])uvCostBucket));
        } else {
            AHStatParse.putMap(featureMap, "fas_1001", AHStatParse.bucket((Number)ahStatCalcDto.getSCtr(), (Number[])ctrBucket));
            AHStatParse.putMap(featureMap, "fas_1002", AHStatParse.bucket((Number)ahStatCalcDto.getSCvr(), (Number[])cvrBucket));
            AHStatParse.putMap(featureMap, "fas_1003", AHStatParse.bucket((Number)ahStatCalcDto.getUvCost(), (Number[])uvCostBucket));
        }
        ahStatCalcDto.setFeatureMap(featureMap);
        return ahStatCalcDto;
    }

    private static AHStatCalcDto stat(AHStatDto ahStatDo) {
        AHStatCalcDto ahStatCalcDto = new AHStatCalcDto();
        double w1 = AHStatParse.acc(ahStatCalcDto, ahStatDo.getLast20MinStat(), 2000, 3.0, 0.1, 6.0);
        double w2 = AHStatParse.acc(ahStatCalcDto, ahStatDo.getLast1HourStat(), 2000, 2.0, 0.2, 4.0);
        double w3 = AHStatParse.acc(ahStatCalcDto, ahStatDo.getLast3HourStat(), 2000, 1.5, 1.0, 3.0);
        double w4 = AHStatParse.acc(ahStatCalcDto, ahStatDo.getLast1DayStat(), 2000, 1.0, 1.0, 1.0);
        double w5 = AHStatParse.acc(ahStatCalcDto, ahStatDo.getLast3DayStat(), 2000, 0.3, 0.3, 0.3);
        return ahStatCalcDto;
    }

    private static double acc(AHStatCalcDto cDto, AHSubStatDto sDto, int baseAdxClickPv, double ratio, double minWeight, double maxWeight) {
        sDto = Optional.ofNullable(sDto).orElse(nullDto);
        double weight = 1.0;
        Long adxClickPv = sDto.getAdxClickPv();
        if (adxClickPv != null) {
            weight = MathUtil.formatDouble((double)(ratio * ((double)adxClickPv.longValue() + 0.01) / (double)baseAdxClickPv), (int)5);
        }
        if (weight <= minWeight) {
            weight = minWeight;
        }
        if (weight >= maxWeight) {
            weight = maxWeight;
        }
        System.out.println("w=" + weight);
        cDto.setWeight(AHStatParse.add(cDto.getWeight(), weight, 1.0));
        cDto.setAdxSucPv(AHStatParse.add(cDto.getAdxSucPv(), sDto.getAdxSucPv(), weight));
        cDto.setAdxExpPv(AHStatParse.add(cDto.getAdxExpPv(), sDto.getAdxExpPv(), weight));
        cDto.setAdxClickPv(AHStatParse.add(cDto.getAdxClickPv(), sDto.getAdxClickPv(), weight));
        cDto.setSlotRequestPV(AHStatParse.add(cDto.getSlotRequestPV(), sDto.getSlotRequestPV(), weight));
        cDto.setAdExpPv(AHStatParse.add(cDto.getAdExpPv(), sDto.getAdExpPv(), weight));
        cDto.setAdClickPv(AHStatParse.add(cDto.getAdClickPv(), sDto.getAdClickPv(), weight));
        cDto.setAdConvertPv(AHStatParse.add(cDto.getAdConvertPv(), sDto.getAdConvertPv(), weight));
        cDto.setFactorAcc(AHStatParse.add(cDto.getFactorAcc(), sDto.getFactorAcc(), weight));
        cDto.setPCvrAcc(AHStatParse.add(cDto.getPCvrAcc(), sDto.getPCvrAcc(), weight));
        cDto.setPCtrAcc(AHStatParse.add(cDto.getPCtrAcc(), sDto.getPCtrAcc(), weight));
        cDto.setPriceAcc(AHStatParse.add(cDto.getPriceAcc(), sDto.getPriceAcc(), weight));
        cDto.setAdxCost(AHStatParse.add(cDto.getAdxCost(), sDto.getAdxCost(), weight));
        cDto.setAdTargetCost(AHStatParse.add(cDto.getAdTargetCost(), sDto.getAdTargetCost(), weight));
        return weight;
    }

    private static <T extends Number> double add(Double v1, T v2, double v2Weight) {
        double ret = 0.0;
        if (v1 != null) {
            ret += v1.doubleValue();
        }
        if (v2 != null) {
            ret += v2.doubleValue() * v2Weight;
        }
        return ret;
    }
}

