/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adxhd.rec;

import cn.com.duiba.adx.dmp.service.api.remoteservice.dto.DmpFeatureDto;
import cn.com.duiba.adx.dmp.service.api.remoteservice.dto.TBDmpAppPackageDiDto;
import cn.com.duiba.nezha.alg.alg.adxhd.dto.AHContextFeatureDto;
import cn.com.duiba.nezha.alg.alg.adxhd.dto.AHIdeaBidReqDto;
import cn.com.duiba.nezha.alg.alg.adxhd.dto.AHIdeaBidResDto;
import cn.com.duiba.nezha.alg.alg.adxhd.enums.AHBidType;
import cn.com.duiba.nezha.alg.alg.adxhd.model.AHModel;
import cn.com.duiba.nezha.alg.alg.adxhd.model.AHOnnxModel;
import cn.com.duiba.nezha.alg.alg.adxhd.parse.AHFeatureParse;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AHBid {
    private static final Logger logger = LoggerFactory.getLogger(AHBid.class);
    private static final Map<Long, Double> defaultMap = new HashMap<Long, Double>();

    public static List<AHIdeaBidResDto> bidding(List<AHIdeaBidReqDto> ideaBidReqDtos, AHContextFeatureDto contextFeatureDto, DmpFeatureDto dmpFeatureDto, AHOnnxModel ahOnnxModel, TBDmpAppPackageDiDto appPackageDiDto) {
        ArrayList<AHIdeaBidResDto> adxBidRets = new ArrayList<AHIdeaBidResDto>();
        if (AssertUtil.isEmpty(ideaBidReqDtos)) {
            logger.error("AHBid.bidding params error, ideaBidReqDtos is empty");
            return adxBidRets;
        }
        try {
            long startTime = System.currentTimeMillis();
            Map<Long, FeatureMapDo> featureMap = AHFeatureParse.generateFeatureMap(ideaBidReqDtos, contextFeatureDto, dmpFeatureDto, appPackageDiDto);
            long secondTime = System.currentTimeMillis();
            long feature_duration = secondTime - startTime;
            logger.info("panhangyi \uff0c\u6784\u5efa\u7279\u5f81\u8017\u65f6: " + feature_duration + " \u6beb\u79d2");
            HashMap<Long, FeatureMapDo> algFeatureMap = new HashMap<Long, FeatureMapDo>();
            for (AHIdeaBidReqDto ideaBidReqDto : ideaBidReqDtos) {
                Long ideaId = ideaBidReqDto.getIdeaId();
                if (ideaBidReqDto.getAhBidType() == null || AHBidType.OTHER.equals((Object)ideaBidReqDto.getAhBidType())) continue;
                algFeatureMap.put(ideaBidReqDto.getIdeaId(), featureMap.get(ideaId));
            }
            Map<Long, Double> pCtrMap = defaultMap;
            Map<Long, Double> pCvrMap = defaultMap;
            if (ahOnnxModel != null && AssertUtil.isAllNotEmpty((Object[])new Object[]{ahOnnxModel.getCtrOnnxModel(), ahOnnxModel.getCtrCodeModel(), ahOnnxModel.getCvrOnnxModel(), ahOnnxModel.getCvrCodeModel()}) && algFeatureMap.size() > 0) {
                long predictTime1 = System.currentTimeMillis();
                pCtrMap = ahOnnxModel.predictCtr(algFeatureMap);
                pCvrMap = ahOnnxModel.predictCvr(algFeatureMap);
                long predictTime2 = System.currentTimeMillis();
                long predict_dur = predictTime2 - predictTime1;
                logger.info("panhangyi , \u8fdb\u5165\u7b97\u6cd5\u6a21\u578b\u9884\u4f30 \uff1a" + predict_dur + " \u6beb\u79d2");
            }
            long thirdTime = System.currentTimeMillis();
            long predict_duration = thirdTime - secondTime;
            logger.info("panhangyi \uff0c \u9884\u4f30\u8017\u65f6\uff1a " + predict_duration + " \u6beb\u79d2");
            for (AHIdeaBidReqDto ideaBidReqDto : ideaBidReqDtos) {
                Long ideaId = ideaBidReqDto.getIdeaId();
                Double pCtr = 0.0;
                Double pCvr = 0.0;
                if (pCtrMap != null) {
                    pCtr = pCtrMap.getOrDefault(ideaId, 0.0);
                }
                if (pCvrMap != null) {
                    pCvr = pCvrMap.getOrDefault(ideaId, 0.0);
                }
                FeatureMapDo featureMapDo = featureMap.get(ideaId);
                AHIdeaBidResDto ideaBidResDto = new AHIdeaBidResDto();
                ideaBidResDto.setIdeaId(ideaId);
                ideaBidResDto.setAhBidType(ideaBidReqDto.getAhBidType());
                if (ideaBidReqDto.getTargetPrice() != null) {
                    ideaBidResDto.setTargetPrice(ideaBidReqDto.getTargetPrice() * 100.0);
                }
                ideaBidResDto.setConvertType(ideaBidReqDto.getConvertType());
                ideaBidResDto.updatePrice(ideaBidReqDto, featureMapDo.getFeatureMap(), pCtr, pCvr);
                adxBidRets.add(ideaBidResDto);
            }
            return adxBidRets;
        }
        catch (Exception e) {
            logger.error("AHBid.bidding error", (Throwable)e);
            return adxBidRets;
        }
    }

    public static List<AHIdeaBidResDto> bidding2(List<AHIdeaBidReqDto> ideaBidReqDtos, AHContextFeatureDto contextFeatureDto, DmpFeatureDto dmpFeatureDto, AHModel ahModel, TBDmpAppPackageDiDto appPackageDiDto) {
        ArrayList<AHIdeaBidResDto> adxBidRets = new ArrayList<AHIdeaBidResDto>();
        if (AssertUtil.isEmpty(ideaBidReqDtos)) {
            logger.error("AHBid.bidding params error, ideaBidReqDtos is empty");
            return adxBidRets;
        }
        try {
            Map<Long, FeatureMapDo> featureMap = AHFeatureParse.generateFeatureMap(ideaBidReqDtos, contextFeatureDto, dmpFeatureDto, appPackageDiDto);
            System.out.println("featureMap=" + JSONObject.toJSONString(featureMap));
            Map<Long, Double> pCtrMap = defaultMap;
            Map<Long, Double> pCvrMap = defaultMap;
            if (ahModel != null && AssertUtil.isAllNotEmpty((Object[])new Object[]{ahModel.getCtrTFModel(), ahModel.getCtrCodeModel(), ahModel.getCvrTFModel(), ahModel.getCvrCodeModel()})) {
                pCtrMap = ahModel.predictCtr(featureMap);
                pCvrMap = ahModel.predictCvr(featureMap);
            }
            for (AHIdeaBidReqDto ideaBidReqDto : ideaBidReqDtos) {
                Long ideaId = ideaBidReqDto.getIdeaId();
                Double pCtr = pCtrMap.get(ideaId);
                Double pCvr = pCvrMap.get(ideaId);
                FeatureMapDo featureMapDo = featureMap.get(ideaId);
                AHIdeaBidResDto ideaBidResDto = new AHIdeaBidResDto();
                ideaBidResDto.setIdeaId(ideaId);
                ideaBidResDto.setAhBidType(ideaBidReqDto.getAhBidType());
                if (ideaBidReqDto.getTargetPrice() != null) {
                    ideaBidResDto.setTargetPrice(ideaBidReqDto.getTargetPrice() * 100.0);
                }
                ideaBidResDto.setConvertType(ideaBidReqDto.getConvertType());
                ideaBidResDto.updatePrice(ideaBidReqDto, featureMapDo.getFeatureMap(), pCtr, pCvr);
                adxBidRets.add(ideaBidResDto);
            }
            return adxBidRets;
        }
        catch (Exception e) {
            logger.error("AHBid.bidding error", (Throwable)e);
            return adxBidRets;
        }
    }
}

