/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.dpa.intercept;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.vo.dpa.intercept.InterceptRcmdDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.DPAActFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.CandidateInterceptDo;
import cn.com.duiba.nezha.alg.feature.vo.DPAActFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.SlotActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserProfileFeature;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptRcmder {
    private static final Logger logger = LoggerFactory.getLogger(InterceptRcmder.class);
    static double[] pCpmBucket = new double[]{0.4, 0.6, 0.85, 0.95, 0.99, 1.0};
    static double[] pCpmWeight = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 85.0};

    public static Map<String, String> featureParse(DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) {
        Map DPAFeatureMap = DPAActFeatureParse.generateFeatureMapStatic((DPAActFeatureDo)dpa);
        Map slotActFeatureMap = DPAActFeatureParse.generateFeatureMapSlotAct((SlotActFeature)slotActFeature);
        Map userProfileFeatureMap = DPAActFeatureParse.generateFeatureMapUserProfile((UserProfileFeature)userProfileFeature);
        Map featureMap = DPAActFeatureParse.generateFeatureMapBase((FeatureDo)featureDo);
        Map userActFeatureMap = DPAActFeatureParse.generateFeatureMapUserAct((UserActFeature)userActFeature);
        DPAFeatureMap.putAll(slotActFeatureMap);
        DPAFeatureMap.putAll(userProfileFeatureMap);
        DPAFeatureMap.putAll(featureMap);
        DPAFeatureMap.putAll(userActFeatureMap);
        return DPAFeatureMap;
    }

    public static List<InterceptRcmdDo> recRank(CODER coderModel, TFServingClient tfServingClient, List<CandidateInterceptDo> candidateInterceptDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        List<InterceptRcmdDo> rets = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{dpa, candidateInterceptDos})) {
            logger.warn("InterceptRcmder recRank input params is null");
            return rets;
        }
        Map<String, String> staticFeatureMap = InterceptRcmder.featureParse(dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        HashMap<CandidateInterceptDo, FeatureMapDo> featureDoMap = new HashMap<CandidateInterceptDo, FeatureMapDo>();
        HashMap<CandidateInterceptDo, InterceptRcmdDo> retMap = new HashMap<CandidateInterceptDo, InterceptRcmdDo>();
        for (CandidateInterceptDo candidateInterceptDo : candidateInterceptDos) {
            InterceptRcmdDo interceptRcmdDo = new InterceptRcmdDo();
            interceptRcmdDo.setCandidateActivityDo(candidateInterceptDo);
            interceptRcmdDo.setActPackageType(2);
            interceptRcmdDo.setAppId(dpa.getAppId());
            interceptRcmdDo.setSlotId(dpa.getSlotId());
            interceptRcmdDo.setRid(dpa.getRid());
            interceptRcmdDo.setDeviceId(dpa.getDeviceId());
            interceptRcmdDo.setImei(dpa.getImei());
            interceptRcmdDo.setUa(dpa.getUa());
            interceptRcmdDo.setAreaCode(dpa.getAreaCode());
            interceptRcmdDo.setPriceSection(dpa.getPriceSection());
            Map dynamicFeatureMap = DPAActFeatureParse.generateInterceptFeaturemapDynamic((CandidateInterceptDo)candidateInterceptDo);
            HashMap<String, String> retFeatureMap = new HashMap<String, String>();
            retFeatureMap.putAll(staticFeatureMap);
            retFeatureMap.putAll(dynamicFeatureMap);
            interceptRcmdDo.setFeatureMap(retFeatureMap);
            retMap.put(candidateInterceptDo, interceptRcmdDo);
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(candidateInterceptDo, featureMapDo);
        }
        Map pRpmMap = new HashMap();
        if (InterceptRcmder.validModel(coderModel, tfServingClient).booleanValue()) {
            pRpmMap = coderModel.predictWithTFNew(featureDoMap, tfServingClient);
        }
        HashMap featureMap = new HashMap();
        HashMap<Long, Double> predMap = new HashMap<Long, Double>();
        for (Map.Entry pRmp : pRpmMap.entrySet()) {
            CandidateInterceptDo candidateInterceptDo = (CandidateInterceptDo)pRmp.getKey();
            Double pcpm = (Double)pRmp.getValue();
            if (candidateInterceptDo.getActivityId() != null && pcpm != null) {
                predMap.put(candidateInterceptDo.getActivityId(), pcpm);
            }
            InterceptRcmdDo interceptRcmdDo = (InterceptRcmdDo)retMap.get(candidateInterceptDo);
            interceptRcmdDo.setPCpm(pcpm);
            retMap.put(candidateInterceptDo, interceptRcmdDo);
        }
        rets = retMap.values().stream().filter(e -> e.getPCpm() != null).sorted(Comparator.comparing(InterceptRcmdDo::getPCpm).reversed()).collect(Collectors.toList());
        return rets;
    }

    public static InterceptRcmdDo recEE(CODER coderModel, TFServingClient tfServingClient, List<CandidateInterceptDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        InterceptRcmdDo ret = null;
        List<InterceptRcmdDo> rets = InterceptRcmder.recRank(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (rets == null) {
            logger.warn("InterceptRcmder reEE output is null");
            return ret;
        }
        ret = InterceptRcmder.ActRoulette(rets);
        return ret;
    }

    public static InterceptRcmdDo recSort(CODER coderModel, TFServingClient tfServingClient, List<CandidateInterceptDo> activityDos, DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) throws Exception {
        logger.info("\u5e38\u89c4\u6d3b\u52a8\u5019\u9009\u96c6\u6570\u91cf \uff1a" + activityDos.size());
        return InterceptRcmder.recEE(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
    }

    public static InterceptRcmdDo ActRoulette(List<InterceptRcmdDo> interceptRcmdDos) throws Exception {
        return InterceptRcmder.ActRoulette(interceptRcmdDos, 0.9);
    }

    public static InterceptRcmdDo ActRoulette(List<InterceptRcmdDo> interceptRcmdDos, double top1Weight) throws Exception {
        Double weight;
        InterceptRcmdDo interceptRcmdDo = null;
        if (interceptRcmdDos == null) {
            return interceptRcmdDo;
        }
        Double bestCpm = null;
        CandidateInterceptDo bestCpmKey = null;
        if (interceptRcmdDos.size() == 1) {
            return interceptRcmdDos.get(0);
        }
        for (InterceptRcmdDo rcmdDo : interceptRcmdDos) {
            Double cpm = rcmdDo.getPCpm();
            if (cpm == null || bestCpm != null && !(bestCpm < cpm)) continue;
            bestCpm = cpm;
            bestCpmKey = rcmdDo.getCandidateActivityDo();
        }
        HashMap<InterceptRcmdDo, Double> weightMap = new HashMap<InterceptRcmdDo, Double>();
        Double weightSum = 0.0;
        for (InterceptRcmdDo interceptRcmdDo2 : interceptRcmdDos) {
            Double cpm = interceptRcmdDo2.getPCpm();
            weight = InterceptRcmder.getCpmWeight(cpm, bestCpm);
            if (weight == null) {
                weight = 1.0;
            }
            weightSum = weightSum + weight;
            weightMap.put(interceptRcmdDo2, weight);
        }
        for (Map.Entry entry : weightMap.entrySet()) {
            InterceptRcmdDo rcmdDo = (InterceptRcmdDo)entry.getKey();
            weight = (Double)entry.getValue();
            if (bestCpmKey == null || !bestCpmKey.equals((Object)rcmdDo.getCandidateActivityDo()) || !(weight < weightSum * top1Weight)) continue;
            Double weightOther = weightSum - weight;
            weight = weightOther * top1Weight / (1.0 - top1Weight);
            weightSum = weightOther + weight;
            weightMap.put(rcmdDo, weight);
        }
        interceptRcmdDo = (InterceptRcmdDo)Roulette.doubleMap(weightMap);
        return interceptRcmdDo;
    }

    private static Boolean validModel(CODER coderModel, TFServingClient tfServingClient) {
        Boolean ret = true;
        if (tfServingClient == null || coderModel == null) {
            logger.warn("InterceptRcmder input valid ,params tfServing is null or coder is null");
            ret = false;
        }
        return ret;
    }

    private static Double getCpmWeight(Double rpm, Double bestRpm) {
        Double ret = 0.001;
        if (rpm != null && bestRpm != null) {
            Double ratio = DataUtil.division((Double)rpm, (Double)bestRpm, (int)3);
            if (bestRpm >= 0.0) {
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            }
        }
        return ret;
    }
}

