/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpcFactorParams;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;

public class OcpxControlParams {
    private Integer resetType;
    private Long cvrCnt;
    private Double pcvrSum;
    private Double pcvrBias;
    private Double confidenceWeight;
    private Boolean cConf;
    private Double fcFactor = 1.0;
    private Double cFactor;
    private Double pcFactor = 1.0;
    private Double extraCFactor = 1.0;
    private Integer extraCSwitch = 0;
    private Boolean fConf;
    private Long fPriceThre;
    private Double fGiveUpProb;
    private Double preDiscountUpperBound;
    private Double extraRiseLowerBound;
    private Long costReplase;
    private Long costDiff;
    private String updateTime;

    public static Double getCostAtFactor(OcpxControlParams params) {
        Double ret = null;
        if (params != null && params.getCConf() != null && params.getCConf().booleanValue()) {
            ret = params.getCFactor();
            if (params.getCFactor() != null && params.getPcFactor() != null) {
                if (params.getFcFactor() == null) {
                    params.setFcFactor(1.0);
                }
                ret = Math.max(params.getCFactor(), params.getFcFactor());
            }
        }
        return ret;
    }

    public static Double getCostFactor(OcpxControlParams params) {
        Double ret = null;
        if (params != null && params.getCConf() != null && params.getCConf().booleanValue()) {
            if (params.getFcFactor() == null) {
                params.setFcFactor(1.0);
            }
            ret = params.getPcFactor() * params.getFcFactor();
        }
        return ret;
    }

    public static OcpcFactorParams getOcpcFactors(OcpxControlParams params) {
        OcpcFactorParams ret = new OcpcFactorParams();
        if (params != null && params.getCConf() != null && params.getCConf().booleanValue()) {
            if (params.getFcFactor() == null) {
                params.setFcFactor(1.0);
            }
            Double factor = params.getPcFactor() * params.getFcFactor();
            String updateTime = params.getUpdateTime();
            Long durationMin = LocalDateUtil.getIntervalMinutes((String)updateTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
            if (durationMin == null || durationMin >= 120L) {
                factor = MathUtil.stdwithBoundary((double)factor, (double)1.0, (double)1.0);
            } else if (durationMin >= 60L) {
                factor = MathUtil.stdwithBoundary((double)factor, (double)0.95, (double)1.05);
            } else if (durationMin >= 30L) {
                factor = MathUtil.stdwithBoundary((double)factor, (double)0.9, (double)1.1);
            } else if (durationMin >= 20L) {
                factor = MathUtil.stdwithBoundary((double)factor, (double)0.8, (double)1.2);
            }
            ret.setFactor(factor);
            ret.setPcFactor(params.getPcFactor());
            ret.setFcFactor(params.getFcFactor());
        }
        return ret;
    }

    public static OcpcFactorParams getOcpcFactorsWithCaliAB(OcpxControlParams params, AdBidParamsDo adBidParamsDo) {
        OcpcFactorParams ret = new OcpcFactorParams();
        if (params != null && params.getCConf() != null && params.getCConf().booleanValue()) {
            String updateTime;
            Long durationMin;
            if (params.getFcFactor() == null) {
                params.setFcFactor(1.0);
            }
            Double factor = 1.0 * params.getFcFactor();
            if (adBidParamsDo.getPreCalibrateTestId() != null && adBidParamsDo.getPreCalibrateTestId() == 602) {
                factor = params.getPcFactor() * factor;
            }
            if ((durationMin = LocalDateUtil.getIntervalMinutes((String)(updateTime = params.getUpdateTime()), (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS)) == null || durationMin >= 120L) {
                factor = MathUtil.stdwithBoundary((double)factor, (double)1.0, (double)1.0);
            } else if (durationMin >= 60L) {
                factor = MathUtil.stdwithBoundary((double)factor, (double)0.95, (double)1.05);
            } else if (durationMin >= 30L) {
                factor = MathUtil.stdwithBoundary((double)factor, (double)0.9, (double)1.1);
            } else if (durationMin >= 20L) {
                factor = MathUtil.stdwithBoundary((double)factor, (double)0.8, (double)1.2);
            }
            ret.setFactor(factor);
            ret.setPcFactor(params.getPcFactor());
            ret.setFcFactor(params.getFcFactor());
        }
        return ret;
    }

    public static OcpcFactorParams getOcpcFactorsWithCali(OcpxControlParams params, AdBidParamsDo adBidParamsDo) {
        OcpcFactorParams ret = new OcpcFactorParams();
        if (params != null && params.getCConf() != null && params.getCConf().booleanValue()) {
            if (params.getFcFactor() == null) {
                params.setFcFactor(1.0);
            }
            Double factor = params.getPcFactor() * params.getFcFactor();
            String updateTime = params.getUpdateTime();
            Long durationMin = LocalDateUtil.getIntervalMinutes((String)updateTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
            if (durationMin == null || durationMin >= 120L) {
                factor = MathUtil.stdwithBoundary((double)factor, (double)1.0, (double)1.0);
            } else if (durationMin >= 60L) {
                factor = MathUtil.stdwithBoundary((double)factor, (double)0.95, (double)1.05);
            } else if (durationMin >= 30L) {
                factor = MathUtil.stdwithBoundary((double)factor, (double)0.9, (double)1.1);
            } else if (durationMin >= 20L) {
                factor = MathUtil.stdwithBoundary((double)factor, (double)0.8, (double)1.2);
            }
            ret.setFactor(factor);
            ret.setPcFactor(params.getPcFactor());
            ret.setFcFactor(params.getFcFactor());
        }
        return ret;
    }

    public static Double getCostFactorWithProtect(OcpxControlParams params, int costParamsType) {
        Double ret = null;
        if (params != null && params.getCFactor() != null) {
            ret = params.getCFactor();
        }
        return ret;
    }

    public static Integer getResetType(OcpxControlParams ocpxControlParams) {
        if (ocpxControlParams != null) {
            return ocpxControlParams.getResetType();
        }
        return null;
    }

    public static String getUpdateTime(OcpxControlParams ocpxControlParams) {
        if (ocpxControlParams != null) {
            return ocpxControlParams.getUpdateTime();
        }
        return null;
    }

    public static Long getCvrCnt(OcpxControlParams ocpxControlParams) {
        if (ocpxControlParams != null) {
            return ocpxControlParams.getCvrCnt();
        }
        return 0L;
    }

    public static Double getPcvrSum(OcpxControlParams ocpxControlParams) {
        if (ocpxControlParams != null) {
            return ocpxControlParams.getPcvrSum();
        }
        return 1.0E-4;
    }

    public static Double getPcvrBias(OcpxControlParams ocpxControlParams) {
        if (ocpxControlParams != null) {
            return ocpxControlParams.getPcvrBias();
        }
        return 1.0E-4;
    }

    public static Double getConfidenceWeight(OcpxControlParams ocpxControlParams) {
        if (ocpxControlParams != null) {
            return ocpxControlParams.getConfidenceWeight();
        }
        return 1.0E-4;
    }

    public Integer getResetType() {
        return this.resetType;
    }

    public Long getCvrCnt() {
        return this.cvrCnt;
    }

    public Double getPcvrSum() {
        return this.pcvrSum;
    }

    public Double getPcvrBias() {
        return this.pcvrBias;
    }

    public Double getConfidenceWeight() {
        return this.confidenceWeight;
    }

    public Boolean getCConf() {
        return this.cConf;
    }

    public Double getFcFactor() {
        return this.fcFactor;
    }

    public Double getCFactor() {
        return this.cFactor;
    }

    public Double getPcFactor() {
        return this.pcFactor;
    }

    public Double getExtraCFactor() {
        return this.extraCFactor;
    }

    public Integer getExtraCSwitch() {
        return this.extraCSwitch;
    }

    public Boolean getFConf() {
        return this.fConf;
    }

    public Long getFPriceThre() {
        return this.fPriceThre;
    }

    public Double getFGiveUpProb() {
        return this.fGiveUpProb;
    }

    public Double getPreDiscountUpperBound() {
        return this.preDiscountUpperBound;
    }

    public Double getExtraRiseLowerBound() {
        return this.extraRiseLowerBound;
    }

    public Long getCostReplase() {
        return this.costReplase;
    }

    public Long getCostDiff() {
        return this.costDiff;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setResetType(Integer resetType) {
        this.resetType = resetType;
    }

    public void setCvrCnt(Long cvrCnt) {
        this.cvrCnt = cvrCnt;
    }

    public void setPcvrSum(Double pcvrSum) {
        this.pcvrSum = pcvrSum;
    }

    public void setPcvrBias(Double pcvrBias) {
        this.pcvrBias = pcvrBias;
    }

    public void setConfidenceWeight(Double confidenceWeight) {
        this.confidenceWeight = confidenceWeight;
    }

    public void setCConf(Boolean cConf) {
        this.cConf = cConf;
    }

    public void setFcFactor(Double fcFactor) {
        this.fcFactor = fcFactor;
    }

    public void setCFactor(Double cFactor) {
        this.cFactor = cFactor;
    }

    public void setPcFactor(Double pcFactor) {
        this.pcFactor = pcFactor;
    }

    public void setExtraCFactor(Double extraCFactor) {
        this.extraCFactor = extraCFactor;
    }

    public void setExtraCSwitch(Integer extraCSwitch) {
        this.extraCSwitch = extraCSwitch;
    }

    public void setFConf(Boolean fConf) {
        this.fConf = fConf;
    }

    public void setFPriceThre(Long fPriceThre) {
        this.fPriceThre = fPriceThre;
    }

    public void setFGiveUpProb(Double fGiveUpProb) {
        this.fGiveUpProb = fGiveUpProb;
    }

    public void setPreDiscountUpperBound(Double preDiscountUpperBound) {
        this.preDiscountUpperBound = preDiscountUpperBound;
    }

    public void setExtraRiseLowerBound(Double extraRiseLowerBound) {
        this.extraRiseLowerBound = extraRiseLowerBound;
    }

    public void setCostReplase(Long costReplase) {
        this.costReplase = costReplase;
    }

    public void setCostDiff(Long costDiff) {
        this.costDiff = costDiff;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OcpxControlParams)) {
            return false;
        }
        OcpxControlParams other = (OcpxControlParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$resetType = this.getResetType();
        Integer other$resetType = other.getResetType();
        if (this$resetType == null ? other$resetType != null : !((Object)this$resetType).equals(other$resetType)) {
            return false;
        }
        Long this$cvrCnt = this.getCvrCnt();
        Long other$cvrCnt = other.getCvrCnt();
        if (this$cvrCnt == null ? other$cvrCnt != null : !((Object)this$cvrCnt).equals(other$cvrCnt)) {
            return false;
        }
        Double this$pcvrSum = this.getPcvrSum();
        Double other$pcvrSum = other.getPcvrSum();
        if (this$pcvrSum == null ? other$pcvrSum != null : !((Object)this$pcvrSum).equals(other$pcvrSum)) {
            return false;
        }
        Double this$pcvrBias = this.getPcvrBias();
        Double other$pcvrBias = other.getPcvrBias();
        if (this$pcvrBias == null ? other$pcvrBias != null : !((Object)this$pcvrBias).equals(other$pcvrBias)) {
            return false;
        }
        Double this$confidenceWeight = this.getConfidenceWeight();
        Double other$confidenceWeight = other.getConfidenceWeight();
        if (this$confidenceWeight == null ? other$confidenceWeight != null : !((Object)this$confidenceWeight).equals(other$confidenceWeight)) {
            return false;
        }
        Boolean this$cConf = this.getCConf();
        Boolean other$cConf = other.getCConf();
        if (this$cConf == null ? other$cConf != null : !((Object)this$cConf).equals(other$cConf)) {
            return false;
        }
        Double this$fcFactor = this.getFcFactor();
        Double other$fcFactor = other.getFcFactor();
        if (this$fcFactor == null ? other$fcFactor != null : !((Object)this$fcFactor).equals(other$fcFactor)) {
            return false;
        }
        Double this$cFactor = this.getCFactor();
        Double other$cFactor = other.getCFactor();
        if (this$cFactor == null ? other$cFactor != null : !((Object)this$cFactor).equals(other$cFactor)) {
            return false;
        }
        Double this$pcFactor = this.getPcFactor();
        Double other$pcFactor = other.getPcFactor();
        if (this$pcFactor == null ? other$pcFactor != null : !((Object)this$pcFactor).equals(other$pcFactor)) {
            return false;
        }
        Double this$extraCFactor = this.getExtraCFactor();
        Double other$extraCFactor = other.getExtraCFactor();
        if (this$extraCFactor == null ? other$extraCFactor != null : !((Object)this$extraCFactor).equals(other$extraCFactor)) {
            return false;
        }
        Integer this$extraCSwitch = this.getExtraCSwitch();
        Integer other$extraCSwitch = other.getExtraCSwitch();
        if (this$extraCSwitch == null ? other$extraCSwitch != null : !((Object)this$extraCSwitch).equals(other$extraCSwitch)) {
            return false;
        }
        Boolean this$fConf = this.getFConf();
        Boolean other$fConf = other.getFConf();
        if (this$fConf == null ? other$fConf != null : !((Object)this$fConf).equals(other$fConf)) {
            return false;
        }
        Long this$fPriceThre = this.getFPriceThre();
        Long other$fPriceThre = other.getFPriceThre();
        if (this$fPriceThre == null ? other$fPriceThre != null : !((Object)this$fPriceThre).equals(other$fPriceThre)) {
            return false;
        }
        Double this$fGiveUpProb = this.getFGiveUpProb();
        Double other$fGiveUpProb = other.getFGiveUpProb();
        if (this$fGiveUpProb == null ? other$fGiveUpProb != null : !((Object)this$fGiveUpProb).equals(other$fGiveUpProb)) {
            return false;
        }
        Double this$preDiscountUpperBound = this.getPreDiscountUpperBound();
        Double other$preDiscountUpperBound = other.getPreDiscountUpperBound();
        if (this$preDiscountUpperBound == null ? other$preDiscountUpperBound != null : !((Object)this$preDiscountUpperBound).equals(other$preDiscountUpperBound)) {
            return false;
        }
        Double this$extraRiseLowerBound = this.getExtraRiseLowerBound();
        Double other$extraRiseLowerBound = other.getExtraRiseLowerBound();
        if (this$extraRiseLowerBound == null ? other$extraRiseLowerBound != null : !((Object)this$extraRiseLowerBound).equals(other$extraRiseLowerBound)) {
            return false;
        }
        Long this$costReplase = this.getCostReplase();
        Long other$costReplase = other.getCostReplase();
        if (this$costReplase == null ? other$costReplase != null : !((Object)this$costReplase).equals(other$costReplase)) {
            return false;
        }
        Long this$costDiff = this.getCostDiff();
        Long other$costDiff = other.getCostDiff();
        if (this$costDiff == null ? other$costDiff != null : !((Object)this$costDiff).equals(other$costDiff)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OcpxControlParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $resetType = this.getResetType();
        result = result * 59 + ($resetType == null ? 43 : ((Object)$resetType).hashCode());
        Long $cvrCnt = this.getCvrCnt();
        result = result * 59 + ($cvrCnt == null ? 43 : ((Object)$cvrCnt).hashCode());
        Double $pcvrSum = this.getPcvrSum();
        result = result * 59 + ($pcvrSum == null ? 43 : ((Object)$pcvrSum).hashCode());
        Double $pcvrBias = this.getPcvrBias();
        result = result * 59 + ($pcvrBias == null ? 43 : ((Object)$pcvrBias).hashCode());
        Double $confidenceWeight = this.getConfidenceWeight();
        result = result * 59 + ($confidenceWeight == null ? 43 : ((Object)$confidenceWeight).hashCode());
        Boolean $cConf = this.getCConf();
        result = result * 59 + ($cConf == null ? 43 : ((Object)$cConf).hashCode());
        Double $fcFactor = this.getFcFactor();
        result = result * 59 + ($fcFactor == null ? 43 : ((Object)$fcFactor).hashCode());
        Double $cFactor = this.getCFactor();
        result = result * 59 + ($cFactor == null ? 43 : ((Object)$cFactor).hashCode());
        Double $pcFactor = this.getPcFactor();
        result = result * 59 + ($pcFactor == null ? 43 : ((Object)$pcFactor).hashCode());
        Double $extraCFactor = this.getExtraCFactor();
        result = result * 59 + ($extraCFactor == null ? 43 : ((Object)$extraCFactor).hashCode());
        Integer $extraCSwitch = this.getExtraCSwitch();
        result = result * 59 + ($extraCSwitch == null ? 43 : ((Object)$extraCSwitch).hashCode());
        Boolean $fConf = this.getFConf();
        result = result * 59 + ($fConf == null ? 43 : ((Object)$fConf).hashCode());
        Long $fPriceThre = this.getFPriceThre();
        result = result * 59 + ($fPriceThre == null ? 43 : ((Object)$fPriceThre).hashCode());
        Double $fGiveUpProb = this.getFGiveUpProb();
        result = result * 59 + ($fGiveUpProb == null ? 43 : ((Object)$fGiveUpProb).hashCode());
        Double $preDiscountUpperBound = this.getPreDiscountUpperBound();
        result = result * 59 + ($preDiscountUpperBound == null ? 43 : ((Object)$preDiscountUpperBound).hashCode());
        Double $extraRiseLowerBound = this.getExtraRiseLowerBound();
        result = result * 59 + ($extraRiseLowerBound == null ? 43 : ((Object)$extraRiseLowerBound).hashCode());
        Long $costReplase = this.getCostReplase();
        result = result * 59 + ($costReplase == null ? 43 : ((Object)$costReplase).hashCode());
        Long $costDiff = this.getCostDiff();
        result = result * 59 + ($costDiff == null ? 43 : ((Object)$costDiff).hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        return result;
    }

    public String toString() {
        return "OcpxControlParams(resetType=" + this.getResetType() + ", cvrCnt=" + this.getCvrCnt() + ", pcvrSum=" + this.getPcvrSum() + ", pcvrBias=" + this.getPcvrBias() + ", confidenceWeight=" + this.getConfidenceWeight() + ", cConf=" + this.getCConf() + ", fcFactor=" + this.getFcFactor() + ", cFactor=" + this.getCFactor() + ", pcFactor=" + this.getPcFactor() + ", extraCFactor=" + this.getExtraCFactor() + ", extraCSwitch=" + this.getExtraCSwitch() + ", fConf=" + this.getFConf() + ", fPriceThre=" + this.getFPriceThre() + ", fGiveUpProb=" + this.getFGiveUpProb() + ", preDiscountUpperBound=" + this.getPreDiscountUpperBound() + ", extraRiseLowerBound=" + this.getExtraRiseLowerBound() + ", costReplase=" + this.getCostReplase() + ", costDiff=" + this.getCostDiff() + ", updateTime=" + this.getUpdateTime() + ")";
    }
}

