/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.plugins;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.plugins.ResPlugInStatModel;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInStatDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.ActFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.ActFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActPlugInDQNRcmder {
    private static final Logger logger = LoggerFactory.getLogger(ActPlugInDQNRcmder.class);
    private static long ADX_MULTIPLIER = 10000000L;
    private static int MAP_DF_SIZE = 8;
    static double[] pCpmBucket = new double[]{0.5, 0.7, 0.8, 0.9, 0.95, 0.98, 1.0};
    static double[] pCpmWeight = new double[]{0.1, 0.5, 1.0, 2.0, 3.0, 5.0, 100.0};

    public static Map<String, String> feaureParse(ActFeatureDo actFeatureDo) {
        Map staticFeatureMap = ActFeatureParse.generateFeatureMapStatic((ActFeatureDo)actFeatureDo);
        Map dynamicFeatureMap = ActFeatureParse.generateFeatureMapDynamic((ActFeatureDo)actFeatureDo, (ActFeatureDo)actFeatureDo);
        dynamicFeatureMap.putAll(staticFeatureMap);
        return dynamicFeatureMap;
    }

    public static ResPlugInRcmdDo rcmd(List<ResPlugInRcmdDo> plugList, ActFeatureDo actFeatureDo, CODER coderModel, LocalTFModel ltfModel) throws Exception {
        ResPlugInRcmdDo ret = null;
        if (ActPlugInDQNRcmder.valid(plugList, actFeatureDo).booleanValue()) {
            HashMap<String, Map> featureMap = new HashMap<String, Map>();
            Map staticFeatureMap = ActFeatureParse.generateFeatureMapStatic((ActFeatureDo)actFeatureDo);
            for (ResPlugInRcmdDo resPlugInRcmdDo : plugList) {
                resPlugInRcmdDo.setKey();
                String key = resPlugInRcmdDo.getKey();
                ResPlugInStatDo statDo = resPlugInRcmdDo.getResPlugInStatDo();
                resPlugInRcmdDo.setSRpm(ResPlugInStatModel.getRpm(statDo));
                resPlugInRcmdDo.setSRoi(ResPlugInStatModel.getRoi(statDo));
                ActFeatureDo dynamicDo = new ActFeatureDo();
                dynamicDo.setResPlugInId(resPlugInRcmdDo.getResPlugInId());
                dynamicDo.setResPlugInIndex(resPlugInRcmdDo.getResPlugInIndex());
                Map dynamicFeatureMap = ActFeatureParse.generateFeatureMapDynamic((ActFeatureDo)dynamicDo, (ActFeatureDo)actFeatureDo);
                dynamicFeatureMap.putAll(staticFeatureMap);
                featureMap.put(key, dynamicFeatureMap);
            }
            Map pRpmMap = new HashMap();
            if (ActPlugInDQNRcmder.validModel(coderModel, ltfModel).booleanValue()) {
                pRpmMap = coderModel.predictWithLocalTF(featureMap, ltfModel);
            }
            HashMap<Long, List<ResPlugInRcmdDo>> rcmdMap = new HashMap<Long, List<ResPlugInRcmdDo>>();
            for (ResPlugInRcmdDo resPlugInRcmdDo : plugList) {
                String key = resPlugInRcmdDo.getKey();
                Double pRpm = (Double)pRpmMap.get(key);
                resPlugInRcmdDo.setPRpm(pRpm);
                Double mergeRpm = ActPlugInDQNRcmder.getMergeRpm(pRpm, resPlugInRcmdDo.getSRpm());
                resPlugInRcmdDo.setMergeRpm(mergeRpm);
                Long plugId = resPlugInRcmdDo.getResPlugInId();
                Long plugIndex = resPlugInRcmdDo.getResPlugInIndex();
                if (!rcmdMap.containsKey(plugId)) {
                    rcmdMap.put(plugId, new ArrayList());
                }
                if (plugId != null && plugIndex != null && (plugIndex > 4L || plugIndex == 0L) || plugId != null && plugIndex == null && plugIndex > 4L || plugId == null && plugIndex != null) continue;
                ((List)rcmdMap.get(plugId)).add(resPlugInRcmdDo);
            }
            ret = ActPlugInDQNRcmder.rcmdWithMap(rcmdMap);
        }
        return ret;
    }

    private static Boolean valid(List<ResPlugInRcmdDo> plugList, ActFeatureDo actFeatureDo) {
        Boolean ret = true;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{plugList, actFeatureDo})) {
            logger.error("ResPlugInRcmdDo.rcmd() input valid ,params plugList or adxFeatureDo is null");
            ret = false;
        }
        return ret;
    }

    private static Boolean validModel(CODER coderModel, LocalTFModel ltfModel) {
        Boolean ret = true;
        if (ltfModel == null || coderModel == null) {
            logger.error("ResPlugInRcmdDo.rcmd() input valid ,params ltfModel is null");
            ret = false;
        }
        return ret;
    }

    public static ResPlugInRcmdDo rcmdWithMap(Map<Long, List<ResPlugInRcmdDo>> plugMap) {
        ResPlugInRcmdDo ret = null;
        if (AssertUtil.isNotEmpty(plugMap)) {
            ArrayList<ResPlugInRcmdDo> plugList = new ArrayList<ResPlugInRcmdDo>();
            for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugMap.entrySet()) {
                ResPlugInRcmdDo plugRcmdDo;
                List<ResPlugInRcmdDo> plugIndexList = entry.getValue();
                if (plugIndexList != null && plugIndexList.size() == 1) {
                    plugRcmdDo = plugIndexList.get(0);
                    plugList.add(plugRcmdDo);
                    continue;
                }
                plugRcmdDo = ActPlugInDQNRcmder.rcmd(plugIndexList, true);
                if (plugRcmdDo == null) continue;
                plugList.add(plugRcmdDo);
            }
            ret = ActPlugInDQNRcmder.rcmd(plugList, false);
        }
        return ret;
    }

    public static ResPlugInRcmdDo rcmd(List<ResPlugInRcmdDo> plugList, boolean isIndex) {
        Double weight;
        ResPlugInRcmdDo ret = null;
        long size = plugList.size();
        Double bestRpm = null;
        String bestRpmKey = null;
        Double baseRpm = null;
        int i = 0;
        while ((long)i < size) {
            ResPlugInRcmdDo plugDo = plugList.get(i);
            Double rpm = plugDo.getMergeRpm();
            if (rpm != null && (bestRpm == null || bestRpm < rpm)) {
                bestRpm = rpm;
                bestRpmKey = plugDo.getKey();
            }
            if (plugDo.getResPlugInId() == null && plugDo.getResPlugInIndex() == null) {
                baseRpm = plugDo.getMergeRpm();
            }
            ++i;
        }
        HashMap<ResPlugInRcmdDo, Double> weightMap = new HashMap<ResPlugInRcmdDo, Double>(MAP_DF_SIZE);
        Double weightSum = 0.0;
        int i2 = 0;
        while ((long)i2 < size) {
            ResPlugInRcmdDo plugDo = plugList.get(i2);
            Double rpm = plugDo.getMergeRpm();
            weight = ActPlugInDQNRcmder.getRpmWeight(rpm, bestRpm);
            if (plugDo.getSRpm() == null) {
                weight = MathBase.noiseSmoother(weight, 0.05, 0.1);
            }
            if (weight != null) {
                weightMap.put(plugDo, weight);
                weightSum = weightSum + weight;
            } else {
                weightMap.put(plugDo, 1.0);
                weightSum = weightSum + 1.0;
            }
            ++i2;
        }
        for (Map.Entry entry : weightMap.entrySet()) {
            ResPlugInRcmdDo plugDo = (ResPlugInRcmdDo)entry.getKey();
            weight = (Double)entry.getValue();
            if (isIndex) {
                if (plugDo.getResPlugInIndex() == 3L) {
                    weight = ActPlugInDQNRcmder.min(weight, (weightSum - weight) * 0.05);
                }
                if (bestRpmKey != null && plugDo != null && bestRpmKey.equals(plugDo.getKey())) {
                    weight = ActPlugInDQNRcmder.max(weight, weightSum * 0.9);
                }
            }
            if (!isIndex && plugDo.getResPlugInIndex() == null) {
                weight = ActPlugInDQNRcmder.max(weight, weightSum * 0.05);
            }
            if (bestRpmKey != null && plugDo != null && bestRpmKey.equals(plugDo.getKey())) {
                weight = ActPlugInDQNRcmder.max(weight, weightSum * 0.9);
            }
            weightMap.put(plugDo, weight);
        }
        System.out.println("weightMap=" + JSON.toJSONString(weightMap));
        ret = (ResPlugInRcmdDo)Roulette.doubleMap(weightMap);
        return ret;
    }

    private static Double getRpmWeight(Double rpm, Double bestRpm) {
        Double ret = null;
        if (rpm != null && bestRpm != null) {
            Double ratio = DataUtil.division((Double)rpm, (Double)bestRpm, (int)3);
            if (bestRpm >= 0.0) {
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            }
        }
        return ret;
    }

    private static Double getMergeRpm(Double pRpm, Double sRpm) {
        Double ret = pRpm;
        if (pRpm == null) {
            ret = sRpm;
        }
        if (sRpm != null && pRpm != null) {
            if (sRpm <= 0.0) {
                sRpm = 0.0;
            } else {
                pRpm = MathBase.noiseSmoother(pRpm, 0.3 * sRpm, 2.0 * sRpm);
            }
            ret = 0.1 * pRpm + 0.9 * sRpm;
        }
        return ret;
    }

    private static Double max(Double v1, Double v2) {
        Double ret = null;
        if (v1 == null) {
            ret = v2;
        }
        if (v2 == null) {
            ret = v1;
        }
        if (v1 != null && v2 != null) {
            ret = v1 > v2 ? v1 : v2;
        }
        return ret;
    }

    private static Double min(Double v1, Double v2) {
        Double ret = null;
        if (v1 == null) {
            ret = v2;
        }
        if (v2 == null) {
            ret = v1;
        }
        if (v1 != null && v2 != null) {
            ret = v1 < v2 ? v1 : v2;
        }
        return ret;
    }
}

