package cn.com.duiba.nezha.alg.alg.plugins;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInStatDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.ActFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.ActFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


import java.util.*;

public class ActPlugInDQNRcmder {

    private static final Logger logger = LoggerFactory.getLogger(ActPlugInDQNRcmder.class);

    private static long ADX_MULTIPLIER = 10000000;

    private static int MAP_DF_SIZE = 8;


    /**
     * pcpm权重分配1 top1>0
     */
    static double[] pCpmBucket = {0.5, 0.7, 0.8, 0.90, 0.95, 0.98, 1};
    static double[] pCpmWeight = {0.1, 0.5, 1, 2, 3, 5, 100};

    /**
     * 特征解析
     *
     * @param
     * @return
     */
    public static Map<String, String> feaureParse(ActFeatureDo actFeatureDo) {
        //1 静态特征解析
        Map<String, String> staticFeatureMap = ActFeatureParse.generateFeatureMapStatic(actFeatureDo);
        Map<String, String> dynamicFeatureMap = ActFeatureParse.generateFeatureMapDynamic(actFeatureDo, actFeatureDo);
        dynamicFeatureMap.putAll(staticFeatureMap);
        return dynamicFeatureMap;
    }


    /**
     * 响应式插件推荐
     *
     * @param plugList
     * @return
     */
    public static ResPlugInRcmdDo rcmd(List<ResPlugInRcmdDo> plugList,
                                       ActFeatureDo actFeatureDo,
                                       CODER coderModel,
                                       LocalTFModel ltfModel) throws Exception {
        ResPlugInRcmdDo ret = null;


        if (valid(plugList, actFeatureDo)) {


            Map<String, Map<String, String>> featureMap = new HashMap<>();


            //1 静态特征解析
            Map<String, String> staticFeatureMap = ActFeatureParse.generateFeatureMapStatic(actFeatureDo);

            //2 封装1 统计ROI、RPM
            for (ResPlugInRcmdDo resPlugInRcmdDo : plugList) {
                resPlugInRcmdDo.setKey();

                String key = resPlugInRcmdDo.getKey();
                ResPlugInStatDo statDo = resPlugInRcmdDo.getResPlugInStatDo();

                resPlugInRcmdDo.setSRpm(ResPlugInStatModel.getRpm(statDo));
                resPlugInRcmdDo.setSRoi(ResPlugInStatModel.getRoi(statDo));


                // 解析动态特征
                ActFeatureDo dynamicDo = new ActFeatureDo();

                dynamicDo.setResPlugInId(resPlugInRcmdDo.getResPlugInId());
                dynamicDo.setResPlugInIndex(resPlugInRcmdDo.getResPlugInIndex());

                Map<String, String> dynamicFeatureMap = ActFeatureParse.generateFeatureMapDynamic(dynamicDo, actFeatureDo);
                dynamicFeatureMap.putAll(staticFeatureMap);

                // 封装特征
                featureMap.put(key, dynamicFeatureMap);


            }

            //3 模型预估RPM
            Map<String, Double> pRpmMap = new HashMap<>();

            if (validModel(coderModel, ltfModel)) {
                pRpmMap = coderModel.predictWithLocalTF(featureMap, ltfModel);
            }
            //4 封装2 预估RPM
            // 封装 按 插件、次序


            Map<Long, List<ResPlugInRcmdDo>> rcmdMap = new HashMap<>();

            for (ResPlugInRcmdDo resPlugInRcmdDo : plugList) {
                String key = resPlugInRcmdDo.getKey();

                Double pRpm = pRpmMap.get(key);
                resPlugInRcmdDo.setPRpm(pRpm);

                // 融合RPM
                Double mergeRpm = getMergeRpm(pRpm, resPlugInRcmdDo.getSRpm());

//                System.out.println("key="+key+",merge="+mergeRpm);

                resPlugInRcmdDo.setMergeRpm(mergeRpm);

                // 重新封装 新数据结构
                Long plugId = resPlugInRcmdDo.getResPlugInId();
                Long plugIndex = resPlugInRcmdDo.getResPlugInIndex();

                if (!rcmdMap.containsKey(plugId)) {
                    rcmdMap.put(plugId, new ArrayList<>());
                }

                // 过滤 有效次序约束 1～4
                if (plugId != null && plugIndex != null) {
                    if (plugIndex > 4 || plugIndex == 0) {
                        continue;
                    }
                }

                // 过滤无效次序 null
                if (plugId != null && plugIndex == null) {
                    if (plugIndex > 4)
                        continue;
                }

                // 过滤无效次序 非 null
                if (plugId == null && plugIndex != null) {
                    continue;
                }

//                System.out.println(1);

                rcmdMap.get(plugId).add(resPlugInRcmdDo);

            }


//            System.out.println(2);
            //5 推荐
//            System.out.println(JSON.toJSONString(rcmdMap));
            ret = rcmdWithMap(rcmdMap);

        }


        return ret;

    }


    private static Boolean valid(List<ResPlugInRcmdDo> plugList,
                                 ActFeatureDo actFeatureDo) {
        Boolean ret = true;

        if (AssertUtil.isAnyEmpty(plugList, actFeatureDo)) {
            logger.error("ResPlugInRcmdDo.rcmd() input valid ,params plugList or adxFeatureDo is null");
            ret = false;
        }
        return ret;
    }

    private static Boolean validModel(
            CODER coderModel,
            LocalTFModel ltfModel) {
        Boolean ret = true;


        if (ltfModel == null || coderModel == null) {
            logger.error("ResPlugInRcmdDo.rcmd() input valid ,params ltfModel is null");
            ret = false;
        }


        return ret;
    }


    /**
     * @param plugMap
     * @return
     */
    public static ResPlugInRcmdDo rcmdWithMap(Map<Long, List<ResPlugInRcmdDo>> plugMap) {


        ResPlugInRcmdDo ret = null;

        if (AssertUtil.isNotEmpty(plugMap)) {

            List<ResPlugInRcmdDo> plugList = new ArrayList<>();

            for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugMap.entrySet()) {

                List<ResPlugInRcmdDo> plugIndexList = entry.getValue();

                // 同一插件，最优次序
                if (plugIndexList != null && plugIndexList.size() == 1) {
                    // 只有一个次序时
                    ResPlugInRcmdDo plugRcmdDo = plugIndexList.get(0);
                    plugList.add(plugRcmdDo);
                } else {
//                    System.out.println(3);
                    // 多个次序时
                    ResPlugInRcmdDo plugRcmdDo = rcmd(plugIndexList, true);

                    if (plugRcmdDo != null) {
                        plugList.add(plugRcmdDo);
                    }

                }
            }


            // 不同插件，最优插件
            ret = rcmd(plugList, false);

        }

        //4 返回
        return ret;
    }


    /**
     * @param plugList
     * @return
     */
    public static ResPlugInRcmdDo rcmd(List<ResPlugInRcmdDo> plugList, boolean isIndex) {


        ResPlugInRcmdDo ret = null;


        long size = plugList.size();

        //1 获取最优RPM
        Double bestRpm = null;//最优
        String bestRpmKey = null;
        Double baseRpm = null;//不开启

        for (int i = 0; i < size; i++) {

            ResPlugInRcmdDo plugDo = plugList.get(i);

            Double rpm = plugDo.getMergeRpm();
            if (rpm != null) {
                if (bestRpm == null || bestRpm < rpm) {
                    bestRpm = rpm;
                    bestRpmKey = plugDo.getKey();
                }
            }

            if (plugDo.getResPlugInId() == null && plugDo.getResPlugInIndex() == null) {
                baseRpm = plugDo.getMergeRpm();
            }
        }


        //2 概率分配
        Map<ResPlugInRcmdDo, Double> weightMap = new HashMap<>(MAP_DF_SIZE);

        Double weightSum = 0.0;

        for (int i = 0; i < size; i++) {

            ResPlugInRcmdDo plugDo = plugList.get(i);

            Double rpm = plugDo.getMergeRpm();

            Double weight = getRpmWeight(rpm, bestRpm);

            if (plugDo.getSRpm() == null) {
                weight = MathBase.noiseSmoother(weight, 0.05, 0.1);
            }
            if (weight != null) {
                weightMap.put(plugDo, weight);
                weightSum += weight;
            } else {
                weightMap.put(plugDo, 1.0);
                weightSum += 1.0;
            }

        }
        // 权重调节
        /**
         * base：不低于%5
         * index=0，不大于10%（保守配置）
         *
         */

        for (Map.Entry<ResPlugInRcmdDo, Double> entry : weightMap.entrySet()) {
            ResPlugInRcmdDo plugDo = entry.getKey();
            Double weight = entry.getValue();

            // index=0，挑选次序
            if (isIndex) {
//
//                if (plugDo.getResPlugInIndex() == 0L || plugDo.getResPlugInIndex() == 3L) {
//                    weight = min(weight, (weightSum - weight) * 0.05);
//                }

                if (plugDo.getResPlugInIndex() == 3L) {
                    weight = min(weight, (weightSum - weight) * 0.05);
                }

//
//                if (bestRpmKey != null && plugDo != null) {
//
//                    if (bestRpmKey.equals(plugDo.getKey())) {
//                        weight = max(weight, weightSum * 0.9);
//                    }
//                }
            }

            // base：不低于%5
            if (!isIndex) {

                if (plugDo.getResPlugInIndex() == null) {
                    weight = max(weight, weightSum * 0.05);
//                    weight = weightSum * 0.05;//固定比例
                }

            }

            if (bestRpmKey != null && plugDo != null) {

                if (bestRpmKey.equals(plugDo.getKey())) {
                    weight = max(weight, weightSum * 0.9);
                }
            }

            weightMap.put(plugDo, weight);
        }


//        System.out.println("weightMap=" + JSON.toJSONString(weightMap));

        //3 挑选
        ret = Roulette.doubleMap(weightMap);

        //4 返回
        return ret;
    }


    /**
     * @param rpm
     * @param bestRpm
     * @return
     */
    private static Double getRpmWeight(Double rpm, Double bestRpm) {
        Double ret = null;

        if (rpm != null && bestRpm != null) {

            Double ratio = DataUtil.division(rpm, bestRpm, 3);
            if (bestRpm >= 0) {
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            }

        }

        return ret;
    }


    /**
     * @param pRpm
     * @param sRpm
     * @return
     */
    private static Double getMergeRpm(Double pRpm, Double sRpm) {

        Double ret = pRpm;

        if (pRpm == null) {
            ret = sRpm;
        }

        if (sRpm != null && pRpm != null) {

            if (sRpm <= 0) {
                sRpm = 0.0;
            } else {
                pRpm = MathBase.noiseSmoother(pRpm, 0.5 * sRpm, 2.0 * sRpm);
            }
            ret = 0.1 * pRpm + 0.9 * sRpm;
        }

        return ret;
    }


    private static Double max(Double v1, Double v2) {

        Double ret = null;

        if (v1 == null) {
            ret = v2;
        }
        if (v2 == null) {
            ret = v1;
        }

        if (v1 != null && v2 != null) {
            ret = v1 > v2 ? v1 : v2;
        }
        return ret;
    }

    private static Double min(Double v1, Double v2) {

        Double ret = null;

        if (v1 == null) {
            ret = v2;
        }
        if (v2 == null) {
            ret = v1;
        }

        if (v1 != null && v2 != null) {
            ret = v1 < v2 ? v1 : v2;
        }
        return ret;
    }

}
