package cn.com.duiba.nezha.alg.alg.enums;

public enum AdxIndex {

    /**
     * ADX统计指标-adx消耗(分*10^4/cpm)
     */
    ADX_CONSUME("adxConsume","adx消耗(分*10^4/cpm)"),

    /**
     * ADX统计指标-广告消耗(分)
     */
    ADVERT_CONSUME("advertConsume","广告消耗(分)"),

    /**
     * ADX统计指标-竞价次数
     */
    BID("bid","竞价次数"),

    /**
     * ADX统计指标-竞价成功次数
     */
    BID_SUC("bidSuc", "竞价成功次数"),

    /**
     * ADX统计指标-曝光数
     */
    EXP("exp", "曝光数"),

    /**
     * ADX统计指标-点击数
     */
    CLICK("click","点击数")
    ;

    private String code;
    private String dec;

    AdxIndex(String code, String dec) {
        this.code = code;
        this.dec = dec;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDec() {
        return dec;
    }

    public void setDec(String dec) {
        this.dec = dec;
    }
}
