package cn.com.duiba.nezha.alg.alg.adx.ExampleTest;

import cn.com.duiba.nezha.alg.alg.adx.ExampleTest.AdxUtils;
import cn.com.duiba.nezha.alg.alg.adx.ExampleTest.IdeaPutRatioConfig;
import cn.com.duiba.nezha.alg.alg.adx.ExampleTest.PutRatioDto;
import cn.com.duiba.nezha.alg.alg.adx.ExampleTest.RatioShunt;
import com.alibaba.fastjson.JSON;

import java.util.*;
import java.util.stream.Collectors;

public class RatioTest {





    public static void main(String[] args){

        try {

            PutRatioDto putRatioDto1 = new PutRatioDto();
            putRatioDto1.setId(12L);
            putRatioDto1.setResourceId(80L);
            putRatioDto1.setIdeaId(1885L);
            putRatioDto1.setPutRatio(5);
            putRatioDto1.setDefaultFlag(1);
            putRatioDto1.setDeleteStatus(0);

            PutRatioDto putRatioDto2 = new PutRatioDto();
            putRatioDto2.setId(12L);
            putRatioDto2.setResourceId(80L);
            putRatioDto2.setIdeaId(1886L);
            putRatioDto2.setPutRatio(5);
            putRatioDto2.setDefaultFlag(0);
            putRatioDto2.setDeleteStatus(0);

            PutRatioDto putRatioDto3 = new PutRatioDto();
            putRatioDto3.setId(12L);
            putRatioDto3.setResourceId(80L);
            putRatioDto3.setIdeaId(1887L);
            putRatioDto3.setPutRatio(5);
            putRatioDto3.setDefaultFlag(0);
            putRatioDto3.setDeleteStatus(0);

            List<PutRatioDto> list1 = new ArrayList<>();
            list1.add(putRatioDto1);
            list1.add(putRatioDto2);
            list1.add(putRatioDto3);

            Optional<List<PutRatioDto>> putRatioDtosOpt1= Optional.of(list1);



            Set<Long> validIdeas = new HashSet<>();
            validIdeas.add(1885L);
            validIdeas.add(1886L);
            validIdeas.add(1887L);

            System.out.println("validIdeas"+ JSON.toJSONString(validIdeas));
            Optional<IdeaPutRatioConfig> configOpt =  putRatioDtosOpt1.flatMap(putRatioDtos -> {
                if (org.apache.commons.collections.CollectionUtils.isEmpty(putRatioDtos)) {
                    return Optional.empty();
                }

                System.out.println("config=111");
                List<PutRatioDto> validIdeaPutRatioDto = putRatioDtos.stream().filter(ratioDto -> validIdeas.contains(ratioDto.getIdeaId())).collect(Collectors.toList());
                final int fullRatio = validIdeaPutRatioDto.stream().mapToInt(AdxUtils::getPutRatio).sum();

                return Optional.ofNullable(
                        IdeaPutRatioConfig.buildIdeaPutRatioConfig(fullRatio,
                                RatioShunt.createRatioShuntTree(validIdeaPutRatioDto, AdxUtils::getPutRatio, PutRatioDto::getIdeaId)
                        ));
            });

            Map<Long,Long> retMap=new HashMap<>();
            Map<Long,Long> retMap2=new HashMap<>();
            Optional<Long> ret1 = configOpt.flatMap(config -> RatioShunt.randomRatioShunt(config.getFullRatio(),config.getRatioTree()));
            System.out.println("configOpt="+ JSON.toJSONString(configOpt));



            for (int i=0; i<10000000; i++){

                Long r = 0L+RatioShunt.RANDOM.nextInt(configOpt.get().getFullRatio());

                if(!retMap2.containsKey(r)){
                    retMap2.put(r,0L);
                }
                retMap2.put(r,retMap2.get(r)+1L);

                Optional<Long> ret2 = configOpt.flatMap(config -> RatioShunt.randomRatioShunt(config.getFullRatio(),config.getRatioTree()));

                Long ideaId=ret2.get();
                if(!retMap.containsKey(ideaId)){
                    retMap.put(ideaId,0L);
                }
                retMap.put(ideaId,retMap.get(ideaId)+1L);
            }

            System.out.println("ret="+ JSON.toJSONString(retMap));
            System.out.println("ret2="+ JSON.toJSONString(retMap2));


        } catch (Exception e) {
            e.printStackTrace();
        }


    }


}
