package cn.com.duiba.nezha.alg.alg.adx.algplus;

import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxPdControlDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxPdControlRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.ClickValueRectifyDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.ClickValueRectifyReqDo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class AdxTask {

    private static final Logger logger = LoggerFactory.getLogger(AdxTask.class);


    /**
     * 定时任务–PD决策维稳(20min执行1次)
     *
     * @param pdControlRequestDo
     * @return
     */
    public static AdxPdControlDo adxPdControlTask(AdxPdControlRequestDo pdControlRequestDo) {

        AdxPdControlDo ret = null;

        try {

            ret = PdControlTask.getPdControl(pdControlRequestDo);

        } catch (Exception e) {

            logger.error("AdxTask.adxPdControlTask error", e);
        }
        return ret;
    }



    /**
     * 定时任务–PD创意点击价值纠偏(5min执行1次)
     *
     * @param rectifyRequestDo
     * @return
     */
    public static ClickValueRectifyDo clickValueRectifyTask(ClickValueRectifyReqDo rectifyRequestDo) {

        ClickValueRectifyDo ret = null;

        try {

            ret = ClickValueRectifyTask.getClickValueRectify(rectifyRequestDo);

        } catch (Exception e) {

            logger.error("AdxTask.ClickValueRectifyTask error", e);
        }
        return ret;
    }


}
