package cn.com.duiba.nezha.alg.alg.vo.dpa;

public class PrizeDo implements Comparable {
    private boolean isAd = false;
    private Long id;
    private Long prizeTagId;
    private Double matchScore = 0.0;

    public boolean isAd() {
        return isAd;
    }

    public void setAd(boolean isAd) {
        this.isAd = isAd;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Double getMatchScore() {
        return matchScore;
    }

    public void setMatchScore(Double matchScore) {
        this.matchScore = matchScore;
    }

    public Long getPrizeTagId() {
        return prizeTagId;
    }

    public void setPrizeTagId(Long prizeTagId) {
        this.prizeTagId = prizeTagId;
    }


    public PrizeDo() {
        this.isAd = false;
        this.id = 0L;
        this.prizeTagId = 0L;
        this.matchScore = 0.0;
    }

    public PrizeDo(boolean isAd, Long id) {
        this.isAd = isAd;
        this.id = id;
        this.prizeTagId = 0L;
        this.matchScore = 0.0;
    }

    public PrizeDo(boolean isAd, Long id, Long prizeTagId, Double matchScore){
        this.isAd = isAd;
        this.id = id;
        this.prizeTagId = prizeTagId;
        this.matchScore = matchScore;
    }

    @Override
    public int compareTo(Object o) {
        PrizeDo pd = (PrizeDo)o;
        int firstOrderResult = ((Boolean)this.isAd).compareTo((Boolean)((pd).isAd)) ;
        if(firstOrderResult == 0){
            return this.id.compareTo(pd.id);
        }else{
            return firstOrderResult;
        }
    }

    @Override
    public String toString(){
        return ((Boolean)this.isAd).toString() + "_" + this.id.toString();
    }

}
