package cn.com.duiba.nezha.alg.alg.adx.directly;


import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDircetlyPriceDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyPkDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIdeaInfoDo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;


public class AdxDirectlyAlg {


    private static final Logger logger = LoggerFactory.getLogger(AdxDirectlyAlg.class);


    /**
     * 算法接口1-互动&直投PK
     *
     * @param ideaList      互动&直投创意(1个互动id，1个直投id)
     * @param pkType        pk评判标准：1=按出价高者胜出；2=按收益高者胜出
     * @param ideaStatDoMap 创意统计数据 (key:ideaId)
     * @return
     */

    public static AdxDirectlyPkDo adxDirectlyPk(List<Long> ideaList, Long pkType,
                                                Map<Long, AdxIdeaInfoDo> ideaStatDoMap) {

        AdxDirectlyPkDo ret = null;

        try {
            ret = AdxDirectlyPk.getPk(ideaList, pkType, ideaStatDoMap);

        } catch (Exception e) {
            logger.error("AdxDirectlyAlg.adxDirectlyPk() error " + e);

        }

        return ret;
    }


    /**
     * 算法接口2-直投算法出价
     *
     * @param directlyIdeaDoInfo 直投创意信息
     * @param directlyFactorInfo 直投ROI维稳因子试探表
     * @return
     */
    public static AdxDircetlyPriceDo adxDirectlyBidding(AdxDirectlyIdeaDo directlyIdeaDoInfo,
                                                        AdxDirectlyFactorDo directlyFactorInfo) {
        AdxDircetlyPriceDo ret = null;

        try {
            ret = AdxDirectlyBidding.getAlgoPrice(directlyIdeaDoInfo, directlyFactorInfo);

        } catch (Exception e) {
            logger.error("AdxDirectlyAlg.adxDirectlyBidding() error " + e);

        }

        return ret;
    }


    /**
     * 算法接口3-直投ROI维稳因子试探表(定时任务)
     * (根据缓存数据，调用频率：20min调用1次）
     *
     * @param directlyIdeaDoInfo     直投创意信息
     * @param lastDirectlyFactorInfo 上一次出参（直投ROI维稳因子对象）
     * @return
     */
    public static AdxDirectlyFactorDo directlyFactorExploration(AdxDirectlyIdeaDo directlyIdeaDoInfo,
                                                                AdxDirectlyFactorDo lastDirectlyFactorInfo) {

        AdxDirectlyFactorDo ret = null;

        try {
            ret = AdxDirectlyFactor.getExploreFactor(directlyIdeaDoInfo, lastDirectlyFactorInfo);

        } catch (Exception e) {
            logger.error("AdxDirectlyAlg.AdxDirectlyFactorDo() error " + e);

        }

        return ret;
    }


}
