/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.dpa;

import cn.com.duiba.nezha.alg.alg.vo.dpa.PackageIdDo;
import cn.com.duiba.nezha.alg.alg.vo.dpa.PackageInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.dpa.PackageRecallDo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.WilsonInterval;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageRecall {
    private static final Logger logger = LoggerFactory.getLogger(PackageRecall.class);
    private static Comparator<PackageRecallDo> iComparator = new Comparator<PackageRecallDo>(){

        @Override
        public int compare(PackageRecallDo o1, PackageRecallDo o2) {
            return o2.getMatchScore() > o1.getMatchScore() ? 1 : -1;
        }
    };

    public static List<PackageRecallDo> matchSkin(List<PackageInfoDo> pks) {
        return PackageRecall.ucbPackage(pks, 10, 0, 1);
    }

    public static List<PackageRecallDo> matchPrize(List<PackageInfoDo> pks) {
        return PackageRecall.ucbPackage(pks, 100, 2);
    }

    public static List<PackageRecallDo> matchTitle(List<PackageInfoDo> pks) {
        return PackageRecall.ucbPackage(pks, 2, 4);
    }

    public static List<PackageRecallDo> matchSubTitle(List<PackageInfoDo> pks) {
        return PackageRecall.ucbPackage(pks, 2, 6);
    }

    public static List<PackageRecallDo> matchPackageAct(List<PackageInfoDo> pks) {
        return PackageRecall.ucbPackage(pks, 50, 8);
    }

    public static List<PackageRecallDo> matchPackage(List<PackageInfoDo> pks, int topN, int topK, int recallType) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{pks})) {
            logger.error("PackageRecall matchTitle input params is null");
            return null;
        }
        ArrayList<PackageRecallDo> result = new ArrayList<PackageRecallDo>();
        PriorityBlockingQueue<PackageRecallDo> pkrs = new PriorityBlockingQueue<PackageRecallDo>(pks.size(), iComparator);
        HashSet<PackageIdDo> ids = new HashSet<PackageIdDo>();
        int supportIdLen = 0;
        for (PackageInfoDo pk : pks) {
            PackageRecallDo pkrd = new PackageRecallDo();
            pkrd.setPackageInfoDo(pk);
            if (pk.getRequest() < 10.0 && System.currentTimeMillis() - pk.getPackageIdDo().getCreateTime() < 25920000L) {
                if (!(Math.random() < 0.1) || supportIdLen >= topK) continue;
                result.add(pkrd);
                ids.add(pk.getPackageIdDo());
                ++supportIdLen;
                continue;
            }
            double matchScore = WilsonInterval.wilsonCalc((double)(pk.getCost().doubleValue() / 100.0), (double)pk.getRequest().doubleValue()).lowerBound;
            pkrd.setMatchScore(matchScore);
            pkrd.setMatchType(recallType);
            pkrs.add(pkrd);
        }
        for (int i = 0; i < pkrs.size(); ++i) {
            PackageRecallDo pr = (PackageRecallDo)pkrs.poll();
            if (result.size() >= topN || ids.contains(pr.getPackageInfoDo().getPackageIdDo())) continue;
            result.add(pr);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static List<PackageRecallDo> ucbPackage(List<PackageInfoDo> pks, int ... args) {
        ArrayList<PackageRecallDo> result = new ArrayList<PackageRecallDo>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{pks})) {
            logger.error("PackageRecall ucbPackage input params is null");
            return null;
        }
        if (args.length >= 2) {
            int topN = args[0];
            int recallType = args[1];
            int tagN = args.length >= 3 ? args[2] : 0;
            PriorityBlockingQueue<PackageRecallDo> pkrs = new PriorityBlockingQueue<PackageRecallDo>(pks.size(), iComparator);
            HashSet<PackageIdDo> ids = new HashSet<PackageIdDo>();
            HashMap<Long, Queue> tagMap = new HashMap<Long, Queue>();
            double gtotal = 0.0;
            double gbMax = 0.0;
            double gbMin = 0.0;
            double stotal = 0.0;
            double bMax = 0.0;
            double bMin = 0.0;
            Long tagId = null;
            for (PackageInfoDo packageInfoDo : pks) {
                gtotal += packageInfoDo.getGlobalCost().doubleValue();
                stotal += packageInfoDo.getCost().doubleValue();
                double guvCost = packageInfoDo.getGlobalRequest() > 0.0 ? packageInfoDo.getGlobalCost() / packageInfoDo.getGlobalRequest() : 0.0;
                gbMax = Math.max(guvCost, gbMax);
                gbMin = Math.min(guvCost, gbMin);
                double suvCost = packageInfoDo.getRequest() > 0.0 ? packageInfoDo.getCost() / packageInfoDo.getRequest() : 0.0;
                bMax = Math.max(suvCost, bMax);
                bMin = Math.min(suvCost, bMin);
            }
            for (PackageInfoDo packageInfoDo : pks) {
                if (recallType == 0) {
                    tagId = packageInfoDo.getPackageIdDo().getSkinTagId();
                } else if (recallType == 2) {
                    tagId = packageInfoDo.getPackageIdDo().getPrizeTagId();
                }
                PackageRecallDo pkrd = new PackageRecallDo();
                pkrd.setPackageInfoDo(packageInfoDo);
                double globalProbTemp = packageInfoDo.getGlobalCost() / (packageInfoDo.getGlobalRequest() + 1.0);
                double globalProb = (globalProbTemp - gbMin) / (gbMax - gbMin);
                double globalBonus = Math.sqrt(2.0 * Math.log(gtotal) / (packageInfoDo.getGlobalRequest() + 1.0));
                double matchScore = 0.5 * (globalProb + globalBonus);
                if (packageInfoDo.getCost() > 0.0) {
                    double slotProbTemp = packageInfoDo.getCost() / (packageInfoDo.getRequest() + 1.0);
                    double prob = (slotProbTemp - bMin) / (bMax - bMin);
                    double bonus = Math.sqrt(2.0 * Math.log(stotal) / (packageInfoDo.getRequest() + 1.0));
                    matchScore = prob + bonus + matchScore;
                }
                pkrd.setMatchScore(matchScore);
                pkrd.setMatchType(recallType);
                pkrs.add(pkrd);
                if (tagId == null || tagN <= 0) continue;
                Queue tpkrs = tagMap.getOrDefault(tagId, new PriorityBlockingQueue<PackageRecallDo>(tagN, iComparator));
                tpkrs.add(pkrd);
                tagMap.put(tagId, tpkrs);
            }
            if (tagMap.size() > 0) {
                if (tagMap.keySet().size() > topN) {
                    void var23_23;
                    PriorityBlockingQueue<PackageRecallDo> tagNPrs = new PriorityBlockingQueue<PackageRecallDo>(tagMap.keySet().size(), iComparator);
                    for (Queue tagPackage : tagMap.values()) {
                        for (int i = 0; i < tagPackage.size() && i < tagN; ++i) {
                            PackageRecallDo pkrd = (PackageRecallDo)tagPackage.poll();
                            tagNPrs.add(pkrd);
                        }
                    }
                    boolean bl = false;
                    while (var23_23 < tagNPrs.size() && result.size() < topN) {
                        PackageRecallDo pkrd = (PackageRecallDo)tagNPrs.poll();
                        if (!ids.contains(pkrd.getPackageInfoDo().getPackageIdDo())) {
                            result.add(pkrd);
                            ids.add(pkrd.getPackageInfoDo().getPackageIdDo());
                        }
                        ++var23_23;
                    }
                } else {
                    for (Queue queue : tagMap.values()) {
                        for (int i = 0; i < queue.size() && i < tagN; ++i) {
                            PackageRecallDo pkrd = (PackageRecallDo)queue.poll();
                            if (ids.contains(pkrd.getPackageInfoDo().getPackageIdDo())) continue;
                            result.add(pkrd);
                            ids.add(pkrd.getPackageInfoDo().getPackageIdDo());
                        }
                    }
                }
            }
            for (int i = 0; i < pkrs.size() && result.size() < topN; ++i) {
                PackageRecallDo packageRecallDo = (PackageRecallDo)pkrs.poll();
                if (ids.contains(packageRecallDo.getPackageInfoDo().getPackageIdDo())) continue;
                result.add(packageRecallDo);
                ids.add(packageRecallDo.getPackageInfoDo().getPackageIdDo());
            }
        }
        return result;
    }
}

