/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.sdk;

import cn.com.duiba.nezha.alg.alg.vo.sdk.SdkIndexStatsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;

public class SdkStatData {
    public static Long nullToMinDefault(Long value, Long defaultValue) {
        Long ret = defaultValue;
        if (value != null && value > defaultValue) {
            ret = value;
        }
        return ret;
    }

    public static boolean isLarger(Long value1, Long value2) {
        boolean ret = false;
        if (value1 != null && value2 != null && value1 > value2) {
            ret = true;
        }
        return ret;
    }

    public static boolean isLarger(Double value1, Double value2) {
        boolean ret = false;
        if (value1 != null && value2 != null && value1 > value2) {
            ret = true;
        }
        return ret;
    }

    public static SdkIndexStatsDo sdkIndexCompute(SdkIndexStatsDo sdkStatInfo) {
        SdkIndexStatsDo ret = new SdkIndexStatsDo();
        boolean isConfident = false;
        if (AssertUtil.isNotEmpty((Object)sdkStatInfo)) {
            Long expCnt = SdkStatData.nullToMinDefault(sdkStatInfo.getExpCnt(), 0L);
            Long clickCnt = SdkStatData.nullToMinDefault(sdkStatInfo.getClickCnt(), 0L);
            Long adConsume = SdkStatData.nullToMinDefault(sdkStatInfo.getAdConsume(), 0L);
            if (SdkStatData.isLarger(expCnt, 50L) && SdkStatData.isLarger(clickCnt, 10L) && SdkStatData.isLarger(adConsume, 50L)) {
                isConfident = true;
            }
            if (isConfident) {
                Double ctr = MathUtil.division((Long)clickCnt, (Long)expCnt, (int)6);
                Double ecpm = MathUtil.division((Long)(adConsume * 1000L), (Long)expCnt, (int)6);
                ret.setCtr(ctr);
                ret.setEcpm(ecpm);
            }
        }
        ret.setConfident(isConfident);
        return ret;
    }

    public static boolean isEqual(Double value1, Double value2) {
        boolean ret = false;
        if (value1 != null && value2 != null && value1.equals(value2)) {
            ret = true;
        }
        return ret;
    }
}

