package cn.com.duiba.nezha.alg.alg.dpa;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.constant.DPAConstant;
import cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityMatchInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.WilsonInterval;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.DPAActFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.*;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.util.CollectionUtil;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import static cn.com.duiba.nezha.alg.alg.constant.DPAConstant.RESORT_ROULETTE_TOP1_WEIGHT;

/**
 * @author lijingzhe
 * @description 推荐引擎接口
 * @date 2020/6/17
 */
public class ActRcmderTFServing {
    private static final Logger logger = LoggerFactory.getLogger(ActRcmderTFServing.class);

    static double[] pCpmBucket = {0.4, 0.6, 0.85, 0.95, 0.99, 1};
    static double[] pCpmWeight = {1, 2, 3, 4, 5, 85};

    /**
     * @author: lijingzhe
     * @date: 2020/6/17
     * @methodParameters: [dpaActFeatureDo]
     * @methodReturnType: java.util.Map<java.lang.String, java.lang.String>
     * @description: DPA特征日志解析
     */
    public static Map<String, String> featureParse(DPAActFeatureDo dpa, SlotActFeature slotActFeature, UserProfileFeature userProfileFeature, FeatureDo featureDo, UserActFeature userActFeature) {
        Map<String, String> DPAFeatureMap = DPAActFeatureParse.generateFeatureMapStatic(dpa);
        Map<String, String> DPADynamicFeatureMap = DPAActFeatureParse.generateFeatureMapDynamic(dpa, slotActFeature);
        Map<String, String> slotActFeatureMap = DPAActFeatureParse.generateFeatureMapSlotAct(slotActFeature);
        Map<String, String> userProfileFeatureMap = DPAActFeatureParse.generateFeatureMapUserProfile(userProfileFeature);
        Map<String, String> featureMap = DPAActFeatureParse.generateFeatureMapBase(featureDo);
        Map<String, String> userActFeatureMap = DPAActFeatureParse.generateFeatureMapUserAct(userActFeature);
        DPAFeatureMap.putAll(DPADynamicFeatureMap);
        DPAFeatureMap.putAll(slotActFeatureMap);
        DPAFeatureMap.putAll(userProfileFeatureMap);
        DPAFeatureMap.putAll(featureMap);
        DPAFeatureMap.putAll(userActFeatureMap);
        return DPAFeatureMap;
    }

    /**
     * @author: lijingzhe
     * @date: 2020/6/17
     * @methodParameters: [coderModel, ltfModel, packageRecallDos]
     * @methodReturnType: cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo
     * @description: 排序接口
     */
    public static List<ActRcmdDo> recRank(CODER coderModel,
                                          TFServingClient tfServingClient,
                                          List<CandidateActivityDo> candidateActivityDoList,
                                          List<CandidateActivityDo> activityDos,
                                          DPAActFeatureDo dpa,
                                          SlotActFeature slotActFeature,
                                          UserProfileFeature userProfileFeature,
                                          FeatureDo featureDo,
                                          UserActFeature userActFeature) throws Exception {
        List<ActRcmdDo> rets = null;
        if (AssertUtil.isAnyEmpty(candidateActivityDoList, dpa)) {
            logger.warn("Actcmder recRank input params is null");
            return rets;
        }
        // 静态特征
        Map<String, String> staticFeatureMap = featureParse(dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);

        List<CandidateActivityDo> candidateActivityDos = new ArrayList<>(candidateActivityDoList);
        // 常规活动候选集缩放
        List<CandidateActivityDo> activityZoomDos = activityDos.stream()
                .sorted(Comparator.comparing(CandidateActivityDo::getActivityMatchScore).reversed())
                .limit(DPAConstant.RECALL_ZOOM_MIN_NUM)
                .collect(Collectors.toList());
        candidateActivityDos.addAll(activityZoomDos);
//        candidateActivityDos.addAll(activityDos);
//        for (ActivityMatchInfo activityMatchInfo : activityMatchInfos) {
//            CandidateActivityDo candidateActivityDo = new CandidateActivityDo();
//            candidateActivityDo.setActivityId(activityMatchInfo.getActivityId());
//            double matchScore = getMatchScore(activityMatchInfo);
//            candidateActivityDo.setActivityMatchScore(matchScore);
//            candidateActivityDo.setActPackageType(0);
//            candidateActivityDos.add(candidateActivityDo);
//        }

        Map<CandidateActivityDo, FeatureMapDo> featureDoMap = new HashMap<>();
        Map<CandidateActivityDo, ActRcmdDo> retMap = new HashMap<>();
        for (CandidateActivityDo candidateActivityDo : candidateActivityDos) {
            // 封装
            ActRcmdDo actRcmdDo = new ActRcmdDo();
            actRcmdDo.setCandidateActivityDo(candidateActivityDo);
            actRcmdDo.setActPackageType(candidateActivityDo.getActPackageType());
            actRcmdDo.setAppId(dpa.getAppId());
            actRcmdDo.setSlotId(dpa.getSlotId());
            actRcmdDo.setRid(dpa.getRid());
            actRcmdDo.setDeviceId(dpa.getDeviceId());
            actRcmdDo.setImei(dpa.getImei());
            actRcmdDo.setUa(dpa.getUa());
            actRcmdDo.setAreaCode(dpa.getAreaCode());
            actRcmdDo.setPriceSection(dpa.getPriceSection());

            DPAActFeatureDo dpaActFeatureDo = new DPAActFeatureDo();
            dpaActFeatureDo.setCandidateActivityDo(candidateActivityDo);
            Map<String, String> dynamicFeatureMap = DPAActFeatureParse.generateFeatureMapDynamic(dpaActFeatureDo, slotActFeature);

            Map<String, String> retFeatureMap = new HashMap<>();
            retFeatureMap.putAll(staticFeatureMap);
            retFeatureMap.putAll(dynamicFeatureMap);
            actRcmdDo.setFeatureMap(retFeatureMap);
            retMap.put(candidateActivityDo, actRcmdDo);

            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(candidateActivityDo, featureMapDo);
        }
        Map<CandidateActivityDo, Double> pRpmMap = new HashMap<>();
        // 预估
        try {
            if (validModel(coderModel, tfServingClient)) {
//            logger.info("进入排序组件+常规活动数量 ：" + featureDoMap.keySet().size());
                pRpmMap = coderModel.predictWithTFNew(featureDoMap, tfServingClient);
            }
        } catch (Exception e) {
            logger.warn("TF predict failed: " + e.toString());
        }
        Map<CandidateActivityDo, Map<String, String>> featureMap = new HashMap<CandidateActivityDo, Map<String, String>>();
        Map<Long, Double> predMap = new HashMap<>();
        for (Map.Entry<CandidateActivityDo, Double> pRmp : pRpmMap.entrySet()) {
            CandidateActivityDo candidateActivityDo = pRmp.getKey();
            Double pcpm = pRmp.getValue();
            if (candidateActivityDo.getActivityId() != null && pcpm != null) {
                predMap.put(candidateActivityDo.getActivityId(), pcpm);
            }
            ActRcmdDo actRcmdDo = retMap.get(candidateActivityDo);
            actRcmdDo.setpCpm(pcpm);
            retMap.put(candidateActivityDo, actRcmdDo);
        }

        if (coderModel.getModelId().equals("nz_last_model_new_deep_fm_e2e_dpa_join_v001_")) {
            logger.info(coderModel.getModelId() + dpa.getSlotId() + " predict:" + JSON.toJSONString(predMap));
        }

        rets = retMap.values().stream()
                .filter(e -> e.getpCpm() != null)
                .sorted(Comparator.comparing(ActRcmdDo::getpCpm).reversed())
                .collect(Collectors.toList());

        return rets;
    }

    /**
     * @author: lijingzhe
     * @date: 2020/6/17
     * @methodParameters: [actRcmdDos]
     * @methodReturnType: java.util.Map
     * @description: 冷启动接口
     */
    public static ActRcmdDo recEE(CODER coderModel,
                                  TFServingClient tfServingClient,
                                  List<CandidateActivityDo> candidateActivityDos,
                                  List<CandidateActivityDo> activityDos,
                                  DPAActFeatureDo dpa,
                                  SlotActFeature slotActFeature,
                                  UserProfileFeature userProfileFeature,
                                  FeatureDo featureDo,
                                  UserActFeature userActFeature) throws Exception {
        ActRcmdDo ret = null;
        List<ActRcmdDo> rets = recRank(coderModel, tfServingClient, candidateActivityDos, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (rets == null) {
            logger.warn("Actcmder recEE input params is null");
            return ret;
        }

//        List<ActRcmdDo> packages = rets.stream().filter(e -> e.getActPackageType() == 0).collect(Collectors.toList());
//        List<ActRcmdDo> acts = rets.stream().filter(e -> e.getActPackageType() == 1).collect(Collectors.toList());
//        if(packages != null && Math.random() < DPAConstant.PACKAGE_REC_RATE){
//            ret = ActRoulette(packages);
//        }else if(acts != null){
//            ret = ActRoulette(acts);
//        }else{
//            ret = ActRoulette(rets);
//        }
        return ActRoulette(rets);
    }

    /**
     * @author: tyan
     * @date: 2020/8/21
     * @methodParameters: [actRcmdDos]
     * @methodReturnType: java.util.Map
     * @description: 冷启动接口
     */
    public static ActRcmdDo recEEWithResort(CODER coderModel,
                                            TFServingClient tfServingClient,
                                            List<CandidateActivityDo> candidateActivityDos,
                                            List<CandidateActivityDo> activityDos,
                                            DPAActFeatureDo dpa,
                                            SlotActFeature slotActFeature,
                                            UserProfileFeature userProfileFeature,
                                            FeatureDo featureDo,
                                            UserActFeature userActFeature) throws Exception {
        ActRcmdDo ret = null;
        List<ActRcmdDo> rets = recRank(coderModel, tfServingClient, candidateActivityDos, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (rets == null) {
            logger.warn("Actcmder recEE input params is null");
            return ret;
        }

        List<ActRcmdDo> resortRets = recReSort(rets, slotActFeature);
//        List<ActRcmdDo> packages = resortRets.stream().filter(e -> e.getActPackageType() == 0).collect(Collectors.toList());
//        List<ActRcmdDo> acts = resortRets.stream().filter(e -> e.getActPackageType() == 1).collect(Collectors.toList());
//        if(packages != null && Math.random() < DPAConstant.PACKAGE_REC_RATE){
//            ret = ActRoulette(packages);
//        }else if(acts != null){
//            ret = ActRoulette(acts);
//        }else{
//            ret = ActRoulette(resortRets);
//        }
        return ActRoulette(resortRets);
    }

    /**
     * @author: lijingzhe
     * @date: 2020/6/17
     * @methodParameters: [actRcmdDos]
     * @methodReturnType: java.util.Map<java.lang.Integer, java.util.List < cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo>>
     * @description: 重排序接口
     */
    public static ActRcmdDo recSort(CODER coderModel,
                                    TFServingClient tfServingClient,
                                    List<CandidateActivityDo> candidateActivityDos,
                                    List<CandidateActivityDo> activityDos,
                                    DPAActFeatureDo dpa,
                                    SlotActFeature slotActFeature,
                                    UserProfileFeature userProfileFeature,
                                    FeatureDo featureDo,
                                    UserActFeature userActFeature) throws Exception {
//        logger.info("排序接口 ： 组件活动候选数量" + candidateActivityDos.size());
//        logger.info("排序接口 ： 常规活动候选数量" + activityMatchInfos.size());
        return recEE(coderModel, tfServingClient, candidateActivityDos, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
    }

    /**
     * @author: tyan
     * @date: 2020/8/21
     * @methodParameters: [actRcmdDos]
     * @methodReturnType: java.util.Map<java.lang.Integer, java.util.List < cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo>>
     * @description: 重排序接口
     */
    public static ActRcmdDo recSortWithResort(CODER coderModel,
                                              TFServingClient tfServingClient,
                                              List<CandidateActivityDo> candidateActivityDos,
                                              List<CandidateActivityDo> activityDos,
                                              DPAActFeatureDo dpa,
                                              SlotActFeature slotActFeature,
                                              UserProfileFeature userProfileFeature,
                                              FeatureDo featureDo,
                                              UserActFeature userActFeature) throws Exception {
//        logger.info("排序接口 ： 组件活动候选数量" + candidateActivityDos.size());
//        logger.info("排序接口 ： 常规活动候选数量" + activityMatchInfos.size());
        return recEEWithResort(coderModel, tfServingClient, candidateActivityDos, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
    }

    /**
     * @author: lijingzhe
     * @date: 2020/7/17
     * @methodParameters: [coderModel, ltfModel, activityMatchInfos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature]
     * @methodReturnType: java.util.List<cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo>
     * @description: 只推常规活动
     */
    public static List<ActRcmdDo> recRank(CODER coderModel,
                                          TFServingClient tfServingClient,
                                          List<CandidateActivityDo> candidateActivityDoList,
                                          DPAActFeatureDo dpa,
                                          SlotActFeature slotActFeature,
                                          UserProfileFeature userProfileFeature,
                                          FeatureDo featureDo,
                                          UserActFeature userActFeature) throws Exception {
        List<ActRcmdDo> rets = null;
        if (AssertUtil.isAnyEmpty(dpa, candidateActivityDoList)) {
            logger.warn("Actcmder recRank common input params is null");
            return rets;
        }

        // 常规活动候选集缩放
        List<CandidateActivityDo> candidateActivityDos = candidateActivityDoList.stream()
                .sorted(Comparator.comparing(CandidateActivityDo::getActivityMatchScore).reversed())
                .limit(DPAConstant.RECALL_ZOOM_MIN_NUM)
                .collect(Collectors.toList());

        // 静态特征
        Map<String, String> staticFeatureMap = featureParse(dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
//        for (ActivityMatchInfo activityMatchInfo : activityMatchInfos) {
//            CandidateActivityDo candidateActivityDo = new CandidateActivityDo();
//            candidateActivityDo.setActivityId(activityMatchInfo.getActivityId());
//            double matchScore = getMatchScore(activityMatchInfo);
//            candidateActivityDo.setActivityMatchScore(matchScore);
//            candidateActivityDo.setActPackageType(0);
//            candidateActivityDos.add(candidateActivityDo);
//        }


        Map<CandidateActivityDo, FeatureMapDo> featureDoMap = new HashMap<>();
        Map<CandidateActivityDo, ActRcmdDo> retMap = new HashMap<>();
        for (CandidateActivityDo candidateActivityDo : candidateActivityDos) {
            // 封装
            ActRcmdDo actRcmdDo = new ActRcmdDo();
            actRcmdDo.setCandidateActivityDo(candidateActivityDo);
            actRcmdDo.setActPackageType(candidateActivityDo.getActPackageType());
            actRcmdDo.setAppId(dpa.getAppId());
            actRcmdDo.setSlotId(dpa.getSlotId());
            actRcmdDo.setRid(dpa.getRid());
            actRcmdDo.setDeviceId(dpa.getDeviceId());
            actRcmdDo.setImei(dpa.getImei());
            actRcmdDo.setUa(dpa.getUa());
            actRcmdDo.setAreaCode(dpa.getAreaCode());
            actRcmdDo.setPriceSection(dpa.getPriceSection());

            DPAActFeatureDo dpaActFeatureDo = new DPAActFeatureDo();
            dpaActFeatureDo.setCandidateActivityDo(candidateActivityDo);
            Map<String, String> dynamicFeatureMap = DPAActFeatureParse.generateFeatureMapDynamic(dpaActFeatureDo, slotActFeature);

            Map<String, String> retFeatureMap = new HashMap<>();
            retFeatureMap.putAll(staticFeatureMap);
            retFeatureMap.putAll(dynamicFeatureMap);
            actRcmdDo.setFeatureMap(retFeatureMap);
            retMap.put(candidateActivityDo, actRcmdDo);

            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(candidateActivityDo, featureMapDo);
        }
        Map<CandidateActivityDo, Double> pRpmMap = new HashMap<>();
        // 预估
        if (validModel(coderModel, tfServingClient)) {
//            logger.info("进入排序常规活动数量 ：" + featureDoMap.keySet().size());
//            for (FeatureBaseType featureBaseType : coderModel.getFeatureBaseType()) {
//                logger.info(featureBaseType.getName());
//            }
//            for (CandidateActivityDo candidateActivityDo : featureDoMap.keySet()) {
//                logger.info("staticFeatureMap Size : " + featureDoMap.get(candidateActivityDo).getStaticFeatureMap().size());
//                logger.info("dynamicFeatureMap Size : " + featureDoMap.get(candidateActivityDo).getDynamicFeatureMap().size());
//            }
            pRpmMap = coderModel.predictWithTFNew(featureDoMap, tfServingClient);
            logger.info("coderModel.predictWithTFNew() 返回结果数量 ：" + pRpmMap.keySet().size());
        }
        Map<CandidateActivityDo, Map<String, String>> featureMap = new HashMap<CandidateActivityDo, Map<String, String>>();
        Map<Long, Double> predMap = new HashMap<>();
        for (Map.Entry<CandidateActivityDo, Double> pRmp : pRpmMap.entrySet()) {
            CandidateActivityDo candidateActivityDo = pRmp.getKey();
            Double pcpm = pRmp.getValue();
            if (candidateActivityDo.getActivityId() != null && pcpm != null) {
                predMap.put(candidateActivityDo.getActivityId(), pcpm);
            }
            ActRcmdDo actRcmdDo = retMap.get(candidateActivityDo);
            actRcmdDo.setpCpm(pcpm);
            retMap.put(candidateActivityDo, actRcmdDo);
        }
        if (coderModel.getModelId().equals("nz_last_model_new_deep_fm_e2e_dpa_join_v001_")) {
            logger.info(coderModel.getModelId() + dpa.getSlotId() + " predict:" + JSON.toJSONString(predMap));
        }

        rets = retMap.values().stream()
                .filter(e -> e.getpCpm() != null)
                .sorted(Comparator.comparing(ActRcmdDo::getpCpm).reversed())
                .collect(Collectors.toList());

        return rets;
    }

    /**
     * @author: lijingzhe
     * @date: 2020/7/17
     * @methodParameters: [coderModel, ltfModel, activityMatchInfos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature]
     * @methodReturnType: cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo
     * @description: 常规活动
     */
    public static ActRcmdDo recEE(CODER coderModel,
                                  TFServingClient tfServingClient,
                                  List<CandidateActivityDo> activityDos,
                                  DPAActFeatureDo dpa,
                                  SlotActFeature slotActFeature,
                                  UserProfileFeature userProfileFeature,
                                  FeatureDo featureDo,
                                  UserActFeature userActFeature) throws Exception {
        ActRcmdDo ret = null;
        List<ActRcmdDo> rets = recRank(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (rets == null) {
            logger.warn("Actcmder reEE output is null");
            return ret;
        }

        ret = ActRoulette(rets);
        return ret;
    }

    /**
     * @author:
     * @date: 2020/8/21
     * @methodParameters: [coderModel, ltfModel, activityMatchInfos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature]
     * @methodReturnType: cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo
     * @description: 常规活动
     */
    public static ActRcmdDo recEEWithResort(CODER coderModel,
                                            TFServingClient tfServingClient,
                                            List<CandidateActivityDo> activityDos,
                                            DPAActFeatureDo dpa,
                                            SlotActFeature slotActFeature,
                                            UserProfileFeature userProfileFeature,
                                            FeatureDo featureDo,
                                            UserActFeature userActFeature) throws Exception {
        ActRcmdDo ret = null;
        List<ActRcmdDo> rets = recRank(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (rets == null) {
            logger.warn("Actcmder reEE output is null");
            return ret;
        }

        List<ActRcmdDo> resortRets = recReSort(rets, slotActFeature);
        ret = ActRoulette(resortRets);
        return ret;
    }

    /**
     * @author: lijingzhe
     * @date: 2020/7/17
     * @methodParameters: [coderModel, ltfModel, activityMatchInfos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature]
     * @methodReturnType: cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo
     * @description: 常规活动
     */
    public static ActRcmdDo recSort(CODER coderModel,
                                    TFServingClient tfServingClient,
                                    List<CandidateActivityDo> activityDos,
                                    DPAActFeatureDo dpa,
                                    SlotActFeature slotActFeature,
                                    UserProfileFeature userProfileFeature,
                                    FeatureDo featureDo,
                                    UserActFeature userActFeature) throws Exception {
        logger.info("常规活动候选集数量 ：" + activityDos.size());
        return recEE(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
    }

    /**
     * @author:
     * @date: 2020/8/21
     * @methodParameters: [coderModel, ltfModel, activityMatchInfos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature]
     * @methodReturnType: cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo
     * @description: 常规活动
     */
    public static ActRcmdDo recSortWithResort(CODER coderModel,
                                              TFServingClient tfServingClient,
                                              List<CandidateActivityDo> activityDos,
                                              DPAActFeatureDo dpa,
                                              SlotActFeature slotActFeature,
                                              UserProfileFeature userProfileFeature,
                                              FeatureDo featureDo,
                                              UserActFeature userActFeature) throws Exception {
        logger.info("常规活动候选集数量 ：" + activityDos.size());
        return recEEWithResort(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
    }

    /**
     * @author: lijingzhe
     * @date: 2020/8/25
     * @methodParameters: [coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature]
     * @methodReturnType: java.util.List<cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo>
     * @description: 广告位+活动一周每uv消耗加权
     */
    public static List<ActRcmdDo> recWeightedRank(CODER coderModel,
                                                  TFServingClient tfServingClient,
                                                  List<CandidateActivityDo> activityDos,
                                                  DPAActFeatureDo dpa,
                                                  SlotActFeature slotActFeature,
                                                  UserProfileFeature userProfileFeature,
                                                  FeatureDo featureDo,
                                                  UserActFeature userActFeature) throws Exception {
        List<ActRcmdDo> retTemps = new ArrayList<>();
        List<ActRcmdDo> actRcmdDos = recRank(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (CollectionUtils.isEmpty(actRcmdDos)) {
            return null;
        }
        Double sdCostPerJoin = slotActFeature.getSdCostPerJoin();
        if(sdCostPerJoin == null){
            sdCostPerJoin = 0.0;
        }
        for (ActRcmdDo actRcmdDo : actRcmdDos) {
            ActRcmdDo actRcmdDoTemp = actRcmdDo;
            Double weighted = actRcmdDo.getCandidateActivityDo().getRoutineActFeature().getCAppSlotActJoinDayConsumer();
            if (weighted == null) {
                weighted = 0.0;
            }else if(sdCostPerJoin >0 && weighted > DPAConstant.SLOT_ACT_NORMAL_UPPER_BOUND * sdCostPerJoin){
                weighted = DPAConstant.SLOT_ACT_NORMAL_UPPER_BOUND * sdCostPerJoin;
            }
            Double zdSlotActCostPerTime = actRcmdDo.getCandidateActivityDo().getRoutineActFeature().getZdSlotActCostPerTime();
            if(zdSlotActCostPerTime == null) {
                zdSlotActCostPerTime = 0.0;
            }
            Double pcmp = actRcmdDo.getpCpm() * weighted + zdSlotActCostPerTime;
            if(actRcmdDo.getpCpm() > 1){
                pcmp = (1 + Math.log(actRcmdDo.getpCpm())/Math.log(2)) * weighted + zdSlotActCostPerTime;
            }
            actRcmdDoTemp.setpCpm(pcmp);
            retTemps.add(actRcmdDoTemp);
        }
        List<ActRcmdDo> rets = retTemps.stream().sorted(Comparator.comparing(ActRcmdDo::getpCpm).reversed()).collect(Collectors.toList());
        return rets;
    }

    /**
     * @author: lijingzhe
     * @date: 2020/8/25
     * @methodParameters: [coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature]
     * @methodReturnType: java.util.List<cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo>
     * @description:
     */
    public static ActRcmdDo recWeightedEE(CODER coderModel,
                                          TFServingClient tfServingClient,
                                          List<CandidateActivityDo> activityDos,
                                          DPAActFeatureDo dpa,
                                          SlotActFeature slotActFeature,
                                          UserProfileFeature userProfileFeature,
                                          FeatureDo featureDo,
                                          UserActFeature userActFeature) throws Exception {

        ActRcmdDo ret = null;
        List<ActRcmdDo> rets = recWeightedRank(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (rets == null) {
            logger.warn("Actcmder reWeightedEE output is null");
            return ret;
        }

        ret = ActRoulette(rets);
        return ret;
    }

    /**
     * @author: lijingzhe
     * @date: 2020/8/25
     * @methodParameters: [actRcmdDos]
     * @methodReturnType: java.util.List<cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo>
     * @description:
     */
    public static ActRcmdDo recWeightedSort(CODER coderModel,
                                            TFServingClient tfServingClient,
                                            List<CandidateActivityDo> activityDos,
                                            DPAActFeatureDo dpa,
                                            SlotActFeature slotActFeature,
                                            UserProfileFeature userProfileFeature,
                                            FeatureDo featureDo,
                                            UserActFeature userActFeature) throws Exception {
        logger.info("常规活动候选集数量 ：" + activityDos.size());
        return recWeightedEE(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
    }

    /**
     * @author: lijingzhe
     * @date: 2020/7/5
     * @methodParameters: [activityMatchInfo]
     * @methodReturnType: java.lang.Double
     * @description: 还原4.1cvr召回分
     */
    public static Double getMatchScore(ActivityMatchInfo activityMatchInfo) throws Exception {
        Double matchScore = 0d;
        double slotScore = WilsonInterval.wilsonCalc(activityMatchInfo.getHisRequest().slotVal / DPAConstant.SLOT_VISIT_PV, activityMatchInfo.getHisRequest().slotVal).lowerBound;
        double globalScore = WilsonInterval.wilsonCalc(activityMatchInfo.getHisRequest().globalVal / DPAConstant.GLOBAL_VISIT_PV, activityMatchInfo.getHisRequest().globalVal).lowerBound;
        double appScore = WilsonInterval.wilsonCalc(activityMatchInfo.getHisRequest().appVal / DPAConstant.APP_VISIT_PV, activityMatchInfo.getHisRequest().appVal).lowerBound;

        double sconfidence = Math.min(activityMatchInfo.getHisRequest().slotVal / DPAConstant.SLOT_VISIT_PV, 1);
        double aconfidence = Math.min(activityMatchInfo.getHisRequest().appVal / DPAConstant.APP_VISIT_PV, 1);
        double gconfidence = Math.min(activityMatchInfo.getHisRequest().globalVal / DPAConstant.GLOBAL_VISIT_PV * 10, 1);

        matchScore = sconfidence * slotScore
                + (1 - sconfidence) * aconfidence * appScore * DPAConstant.APP_CONFIDENCE
                + (1 - sconfidence - (1 - sconfidence) * aconfidence) * globalScore * Math.max(DPAConstant.GLOBAL_CONFIDENCE, gconfidence);
        return matchScore;
    }

    public static ActRcmdDo ActRoulette(List<ActRcmdDo> actRcmdDos) throws Exception {
        return ActRoulette(actRcmdDos, RESORT_ROULETTE_TOP1_WEIGHT);
    }

    public static ActRcmdDo ActRoulette(List<ActRcmdDo> actRcmdDos, double top1Weight) throws Exception {
        ActRcmdDo actRcmdDo = null;
        if (actRcmdDos == null) {
            return actRcmdDo;
        }
        // 获取最优RPM
        Double bestCpm = null;
        CandidateActivityDo bestCpmKey = null;
        if (actRcmdDos.size() == 1) {
            return actRcmdDos.get(0);
        }
        for (ActRcmdDo rcmdDo : actRcmdDos) {
            Double cpm = rcmdDo.getpCpm();
            if (cpm != null) {
                if (bestCpm == null || bestCpm < cpm) {
                    bestCpm = cpm;
                    bestCpmKey = rcmdDo.getCandidateActivityDo();
                }
            }
        }
        // 概率分配
        Map<ActRcmdDo, Double> weightMap = new HashMap<>();
        Double weightSum = 0.0;
        for (ActRcmdDo rcmdDo : actRcmdDos) {
            Double cpm = rcmdDo.getpCpm();
            Double weight = getCpmWeight(cpm, bestCpm);
            if (weight == null) {
                weight = 1.0;
            }
            weightSum += weight;
            weightMap.put(rcmdDo, weight);
        }
        for (Map.Entry<ActRcmdDo, Double> entry : weightMap.entrySet()) {
            ActRcmdDo rcmdDo = entry.getKey();
            Double weight = entry.getValue();

            // 权重调节
            if (bestCpmKey != null && bestCpmKey.equals(rcmdDo.getCandidateActivityDo()) && weight < weightSum * top1Weight) {

                Double weightOther = weightSum - weight;
                weight = weightOther * top1Weight / (1 - top1Weight);
                weightSum = weightOther + weight;

                weightMap.put(rcmdDo, weight);
            }
        }
        // 挑选
        actRcmdDo = Roulette.doubleMap(weightMap);

        return actRcmdDo;
    }

    private static Boolean validModel(
            CODER coderModel,
            TFServingClient tfServingClient) {
        Boolean ret = true;

        if (tfServingClient == null || coderModel == null) {
            logger.warn("ActRcmder.rcmd() input valid ,params tfServing is null or coder is null");
            ret = false;
        }

        return ret;
    }

    private static Double getCpmWeight(Double rpm, Double bestRpm) {
        Double ret = 0.001;

        if (rpm != null && bestRpm != null) {

            Double ratio = DataUtil.division(rpm, bestRpm, 3);
            if (bestRpm >= 0) {
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            }
        }

        return ret;
    }


    public static List<ActRcmdDo> recReSort(List<ActRcmdDo> actRcmdDos, SlotActFeature slotActFeature) {
        return recReSort(actRcmdDos, slotActFeature, true);
    }

    /**
     * 参与次数加权
     *
     * @param actRcmdDos
     * @param cntflag
     * @return
     */
    public static List<ActRcmdDo> recReSort(List<ActRcmdDo> actRcmdDos, SlotActFeature slotActFeature, boolean cntflag) {
        Double sdCostPerJoin = slotActFeature.getSdCostPerJoin();
//        double sdCostPerAct = slotActFeature.getSdCostPerAct();
        Double zdCostPerTime = slotActFeature.getZdCostPerTime();

        if (sdCostPerJoin == null || zdCostPerTime == null || slotActFeature.getSdJoinCnt() == null
                || slotActFeature.getSdJoinCnt() < 1000
                || slotActFeature.getZdCnt() == null || slotActFeature.getZdCnt() < 200) {
            sdCostPerJoin = 1.0;
            zdCostPerTime = DPAConstant.DEFAULT_ZD_COST_RATIO;
//            sdCostPerAct = 1.2;
        }

        for (ActRcmdDo actRcmdDo : actRcmdDos) {
            CandidateActivityDo cad = actRcmdDo.getCandidateActivityDo();
            double newSortValue = actRcmdDo.getpCpm();
            if (cntflag) {
                newSortValue *= sdCostPerJoin;
            }
//            else{
//                newSortValue *= sdCostPerAct;
//            }


            newSortValue += cad.getRoutineActFeature().getAutoFirstLaunchStatus() * zdCostPerTime;
//            newSortValue += cad.getRoutineActFeature().getAutoFirstLaunchStatus() * costPerJoinPv;
            actRcmdDo.setpCpm(newSortValue);

        }

        return actRcmdDos.stream().sorted(Comparator.comparing(ActRcmdDo::getpCpm).reversed())
                .collect(Collectors.toList());
    }


    /**
     * @author:
     * @date: 2020/8/25
     * @methodParameters: [coderModel, ltfModel, activityMatchInfos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature]
     * @methodReturnType: cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo
     * @description: 常规活动
     */
    public static ActRcmdDo recSortWithResortAndMapping(CODER coderModel,
                                                        TFServingClient tfServingClient,
                                                        List<CandidateActivityDo> activityDos,
                                                        DPAActFeatureDo dpa,
                                                        SlotActFeature slotActFeature,
                                                        UserProfileFeature userProfileFeature,
                                                        FeatureDo featureDo,
                                                        UserActFeature userActFeature) throws Exception {
        logger.info("常规活动候选集数量 ：" + activityDos.size());
        return recEEWithResortWithMapping(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
    }


    public static ActRcmdDo recEEWithResortWithMapping(CODER coderModel,
                                                       TFServingClient tfServingClient,
                                                       List<CandidateActivityDo> activityDos,
                                                       DPAActFeatureDo dpa,
                                                       SlotActFeature slotActFeature,
                                                       UserProfileFeature userProfileFeature,
                                                       FeatureDo featureDo,
                                                       UserActFeature userActFeature) throws Exception {
        ActRcmdDo ret = null;
        List<ActRcmdDo> rets = recRank(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (rets == null) {
            logger.warn("Actcmder reEE output is null");
            return ret;
        }

        List<ActRcmdDo> resortRets = recReSortWithMapping(rets, slotActFeature);
        ret = ActRoulette(resortRets);
        return ret;
    }

    public static List<ActRcmdDo> recReSortWithMapping(List<ActRcmdDo> actRcmdDos, SlotActFeature slotActFeature) {
        return recReSortWithMapping(actRcmdDos, slotActFeature, true);
    }

    /**
     * 参与次数加权[log映射]
     *
     * @param actRcmdDos
     * @param cntflag
     * @return
     */
    public static List<ActRcmdDo> recReSortWithMapping(List<ActRcmdDo> actRcmdDos, SlotActFeature slotActFeature, boolean cntflag) {
        Double sdCostPerJoin = slotActFeature.getSdCostPerJoin();
        Double zdCostPerTime = slotActFeature.getZdCostPerTime();

        if (sdCostPerJoin == null || zdCostPerTime == null || slotActFeature.getSdJoinCnt() == null
                || slotActFeature.getSdJoinCnt() < 1000
                || slotActFeature.getZdCnt() == null || slotActFeature.getZdCnt() < 200) {
            sdCostPerJoin = 1.0;
            zdCostPerTime = DPAConstant.DEFAULT_ZD_COST_RATIO;
        }

        for (ActRcmdDo actRcmdDo : actRcmdDos) {
            CandidateActivityDo cad = actRcmdDo.getCandidateActivityDo();
            double newSortValue = Math.log(1.0 + actRcmdDo.getpCpm());
            if (cntflag) {
                newSortValue *= Math.log(1.0 + sdCostPerJoin);
            }

            newSortValue += cad.getRoutineActFeature().getAutoFirstLaunchStatus() * Math.log(1.0 + zdCostPerTime);
//            newSortValue += cad.getRoutineActFeature().getAutoFirstLaunchStatus() * costPerJoinPv;
            actRcmdDo.setpCpm(newSortValue);

        }

        return actRcmdDos.stream().sorted(Comparator.comparing(ActRcmdDo::getpCpm).reversed())
                .collect(Collectors.toList());
    }


    /**
     * @date: 2020/8/25
     * @methodParameters: [coderModel, ltfModel, activityMatchInfos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature]
     * @methodReturnType: cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo
     * @description: 常规活动
     */
    public static ActRcmdDo recSortWithResortWithCtr(CODER coderModel,
                                                     TFServingClient tfServingClient,
                                                     List<CandidateActivityDo> activityDos,
                                                     DPAActFeatureDo dpa,
                                                     SlotActFeature slotActFeature,
                                                     UserProfileFeature userProfileFeature,
                                                     FeatureDo featureDo,
                                                     UserActFeature userActFeature) throws Exception{
        logger.info("常规活动候选集数量 ：" + activityDos.size());
        return recCtrWeightedEE(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
    }


    /**
     * @date: 2020/8/25
     * @methodParameters: [coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature]
     * @methodReturnType: java.util.List<cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo>
     * @description:
     */
    public static ActRcmdDo recCtrWeightedEE(CODER coderModel,
                                             TFServingClient tfServingClient,
                                             List<CandidateActivityDo> activityDos,
                                             DPAActFeatureDo dpa,
                                             SlotActFeature slotActFeature,
                                             UserProfileFeature userProfileFeature,
                                             FeatureDo featureDo,
                                             UserActFeature userActFeature) throws Exception {

        ActRcmdDo ret = null;
        List<ActRcmdDo> rets = recCtrWeightedRank(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (rets == null) {
            logger.warn("Actcmder reWeightedEE output is null");
            return ret;
        }

        ret = ActRoulette(rets);
        return ret;
    }





    /**
     * @date: 2020/8/25
     * @methodParameters: [coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature]
     * @methodReturnType: java.util.List<cn.com.duiba.nezha.alg.alg.vo.dpa.ActRcmdDo>
     * @description: 广告位+活动一周每uv消耗加权
     */
    public static List<ActRcmdDo> recCtrWeightedRank(CODER coderModel,
                                                     TFServingClient tfServingClient,
                                                     List<CandidateActivityDo> activityDos,
                                                     DPAActFeatureDo dpa,
                                                     SlotActFeature slotActFeature,
                                                     UserProfileFeature userProfileFeature,
                                                     FeatureDo featureDo,
                                                     UserActFeature userActFeature) throws Exception {
        List<ActRcmdDo> retTemps = new ArrayList<>();
        List<ActRcmdDo> actRcmdDos = recRank(coderModel, tfServingClient, activityDos, dpa, slotActFeature, userProfileFeature, featureDo, userActFeature);
        if (CollectionUtils.isEmpty(actRcmdDos)) {
            return null;
        }
        for (ActRcmdDo actRcmdDo : actRcmdDos) {
            ActRcmdDo actRcmdDoTemp = actRcmdDo;
            Double weighted = actRcmdDo.getCandidateActivityDo().getRoutineActFeature().getCAppSlotCtrPerTime();
            if (weighted == null) {
                weighted = 1d;
            }
            Double pcmp = actRcmdDo.getpCpm() * weighted;
            actRcmdDoTemp.setpCpm(pcmp);
            retTemps.add(actRcmdDoTemp);
        }
        List<ActRcmdDo> rets = retTemps.stream().sorted(Comparator.comparing(ActRcmdDo::getpCpm).reversed()).collect(Collectors.toList());
        return rets;
    }
}


