package cn.com.duiba.nezha.alg.alg.title;

import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInStatDo;
import cn.com.duiba.nezha.alg.alg.vo.title.ActTitleStatDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;

import java.io.Serializable;
import java.util.List;

/**
 * 响应插件-统计对象
 */
public class ActTitleStatModel implements Serializable {


    /**
     * 统计对象融合
     *
     * @param historyStatDo
     * @param hourStatDo
     * @return
     */
    public static ActTitleStatDo merge(ActTitleStatDo historyStatDo, ActTitleStatDo hourStatDo) {

        ActTitleStatDo ret = new ActTitleStatDo();
        if (historyStatDo == null) {
            historyStatDo = new ActTitleStatDo();
        }

        if (hourStatDo == null) {
            hourStatDo = new ActTitleStatDo();
        }


//        Double decayFactorHis = getDecayFactorHistory(historyStatDo.getVisitPv(), 1000L);
//        Double decayFactorCur = getDecayFactorCurrent(hourStatDo.getVisitPv(), 1000L);

        Double decayFactorHis = 0.9;
        Double decayFactorCur = 0.1;


        Long visitPv = mergeNew(historyStatDo.getVisitPv(), hourStatDo.getVisitPv(), decayFactorHis, decayFactorCur);
        Long joinPv = mergeNew(historyStatDo.getJoinPv(), hourStatDo.getJoinPv(), decayFactorHis, decayFactorCur);
        Long launchCnt = mergeNew(historyStatDo.getLaunchCnt(), hourStatDo.getLaunchCnt(), decayFactorHis, decayFactorCur);
        Long clickPv = mergeNew(historyStatDo.getClickPv(), hourStatDo.getClickPv(), decayFactorHis, decayFactorCur);
        Long chargeFees = mergeNew(historyStatDo.getChargeFees(), hourStatDo.getChargeFees(), decayFactorHis, decayFactorCur);
        Long convertPv = mergeNew(historyStatDo.getConvertPv(), hourStatDo.getConvertPv(), decayFactorHis, decayFactorCur);


        ret.setSlotId(hourStatDo.getSlotId());
        ret.setDsm2A(historyStatDo.getDsm2A());
        ret.setActivityPage(hourStatDo.getActivityPage());
        ret.setSlotId(hourStatDo.getSlotId());
        ret.setTitleId(hourStatDo.getTitleId());


        ret.setVisitPv(visitPv);
        ret.setJoinPv(joinPv);
        ret.setLaunchCnt(launchCnt);
        ret.setClickPv(clickPv);
        ret.setChargeFees(chargeFees);
        ret.setConvertPv(convertPv);
        ret.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS));

        return ret;
    }

    public static Double getRpm(ActTitleStatDo statDo) {
        Double ret = null;
        if (statDo != null) {
            if (statDo.getVisitPv() != null &&
                    statDo.getVisitPv() > 300 &&
                    statDo.getChargeFees() != null &&
                    statDo.getChargeFees() > 300) {
                ret = DataUtil.division(statDo.getChargeFees(), statDo.getVisitPv() + 1, 5);
            }
        }
        return ret;
    }

    public static Double getJpv(ActTitleStatDo statDo) {
        Double ret = null;
        if (statDo != null) {
            if (statDo.getVisitPv() != null &&
                    statDo.getVisitPv() > 300 &&
                    statDo.getJoinPv() != null &&
                    statDo.getJoinPv() > 100) {
                ret = DataUtil.division(statDo.getJoinPv(), statDo.getVisitPv() + 1, 5);
            }
        }
        return ret;
    }

    public static Double getCpv(ActTitleStatDo statDo) {
        Double ret = null;
        if (statDo != null) {
            if (statDo.getVisitPv() != null &&
                    statDo.getVisitPv() > 300 &&
                    statDo.getClickPv() != null &&
                    statDo.getClickPv() > 100) {
                ret = DataUtil.division(statDo.getClickPv(), statDo.getVisitPv() + 1, 5);
            }
        }
        return ret;
    }


    public static Double getApv(ActTitleStatDo statDo) {
        Double ret = null;
        if (statDo != null) {
            if (statDo.getVisitPv() != null &&
                    statDo.getVisitPv() > 300 &&
                    statDo.getConvertPv() != null &&
                    statDo.getConvertPv() > 10) {
                ret = DataUtil.division(statDo.getConvertPv(), statDo.getVisitPv() + 1, 5);
            }
        }
        return ret;
    }


    /**
     * 融合-去除误差
     *
     * @param v1
     * @param v2
     * @param decayFactor1
     * @return
     */
    public static Long mergeNew(Long v1, Long v2, Double decayFactor1, Double decayFactor2) {

        if (v1 == null) {
            v1 = 0L;
        }
        if (v2 == null) {
            v2 = 0L;
        }

        return DataUtil.double2Long(decayFactor1 * v1 + decayFactor2 * v2);

    }

    public static Double getDecayFactor(Long visitPv, Long basePv) {
        Double ret = 1.0;
        if (visitPv != null) {
            ret = 1.0 - 0.3 * Math.min((visitPv + 0.0) / basePv, 1.0);
        }
        return ret;
    }

    public static Double getDecayFactorHistory(Long visitPv, Long basePv) {
        Double ret = 1.0;
        if (visitPv != null) {
            ret = Math.min((basePv + 0.0) / (visitPv), 1.0);
        }
        return ret;
    }

    public static Double getDecayFactorCurrent(Long visitPv, Long basePv) {
        Double ret = 1.0;
        if (visitPv != null) {

            ret = Math.min(1.0, (basePv + 0.0) / visitPv);
//            if (visitPv > 200 && visitPv < 500) {
//                ret = 2.0;
//            }

        }
        return ret;
    }
}
