package cn.com.duiba.nezha.alg.alg.vo.adx;

import java.io.Serializable;
import java.util.Map;


/**
 * 策略二：adx价格试探表；调节主要依据
 */
public class AdxPriceExplorationDo implements Serializable {

    /**
     * 价格表({分level：分/千次曝光})
     */
    private Map<String, Double> priceExploreMap;

    /**
     * 价格对应流量比例表({分level：小数})
     */
    private Map<String, Double> priceFlowRateMap;

    /**
     * 上一次实际ROI表({分level：小数})
     */
    private Map<String, Double> lastRealRoiMap;

    /**
     * 上一次实际竞价成功率({分level：小数})
     */
    private Map<String, Double> lastSucRateMap;

    /**
     * 冷启动试探标记(1=冷启动试探)
     */
    private Long tryLabel;

    /**
     * 策略实时ROI
     */
    private Double roiMs;

    /**
     * 策略累计ROI
     */
    private Double roiDay;

    /**
     * 策略实时竞价成功率
     */
    private Double sucMs;

    /**
     * 策略累计竞价成功率
     */
    private Double sucDay;

    /**
     * 策略实时adx消耗
     */
    private Double adxConsumeMs;

    /**
     * 策略累计adx消耗
     */
    private Double adxConsumeDay;

    /**
     * 策略实时advert消耗
     */
    private Double advertConsumeMs;

    /**
     * 策略累计advert消耗
     */
    private Double advertConsumeDay;

    /**
     * 策略实时竞价量级
     */
    private Long bidCntMs;

    /**
     * 策略累计竞价量级
     */
    private Long bidCntDay;

    /**
     * 策略实时竞价成功量级
     */
    private Long sucBidCntMs;

    /**
     * 策略累计竞价成功量级
     */
    private Long sucBidCntDay;

    /**
     * 竞价约束上限
     */
    private Double upLimitBidFee;

    /**
     * 数据是否置信
     */
    private Boolean isConfidence;


    /**
     * 默认出价（分/cpm）
     */
    private Double defaultPrice;


    public Map<String, Double> getPriceExploreMap() {
        return priceExploreMap;
    }

    public void setPriceExploreMap(Map<String, Double> priceExploreMap) {
        this.priceExploreMap = priceExploreMap;
    }

    public Map<String, Double> getPriceFlowRateMap() {
        return priceFlowRateMap;
    }

    public void setPriceFlowRateMap(Map<String, Double> priceFlowRateMap) {
        this.priceFlowRateMap = priceFlowRateMap;
    }

    public Map<String, Double> getLastRealRoiMap() {
        return lastRealRoiMap;
    }

    public void setLastRealRoiMap(Map<String, Double> lastRealRoiMap) {
        this.lastRealRoiMap = lastRealRoiMap;
    }

    public Map<String, Double> getLastSucRateMap() { return lastSucRateMap; }

    public void setLastSucRateMap(Map<String, Double> lastSucRateMap) { this.lastSucRateMap = lastSucRateMap; }

    public Long getTryLabel() { return tryLabel; }

    public void setTryLabel(Long tryLabel) { this.tryLabel = tryLabel; }

    public Double getRoiMs() {
        return roiMs;
    }

    public void setRoiMs(Double roiMs) {
        this.roiMs = roiMs;
    }

    public Double getRoiDay() {
        return roiDay;
    }

    public void setRoiDay(Double roiDay) {
        this.roiDay = roiDay;
    }

    public Double getSucMs() {
        return sucMs;
    }

    public void setSucMs(Double sucMs) {
        this.sucMs = sucMs;
    }

    public Double getSucDay() {
        return sucDay;
    }

    public void setSucDay(Double sucDay) {
        this.sucDay = sucDay;
    }

    public Double getAdxConsumeMs() {
        return adxConsumeMs;
    }

    public void setAdxConsumeMs(Double adxConsumeMs) {
        this.adxConsumeMs = adxConsumeMs;
    }

    public Double getAdxConsumeDay() {
        return adxConsumeDay;
    }

    public void setAdxConsumeDay(Double adxConsumeDay) {
        this.adxConsumeDay = adxConsumeDay;
    }

    public Double getAdvertConsumeMs() {
        return advertConsumeMs;
    }

    public void setAdvertConsumeMs(Double advertConsumeMs) {
        this.advertConsumeMs = advertConsumeMs;
    }

    public Double getAdvertConsumeDay() {
        return advertConsumeDay;
    }

    public void setAdvertConsumeDay(Double advertConsumeDay) {
        this.advertConsumeDay = advertConsumeDay;
    }

    public Long getBidCntMs() {
        return bidCntMs;
    }

    public void setBidCntMs(Long bidCntMs) {
        this.bidCntMs = bidCntMs;
    }

    public Long getBidCntDay() {
        return bidCntDay;
    }

    public void setBidCntDay(Long bidCntDay) {
        this.bidCntDay = bidCntDay;
    }

    public Long getSucBidCntMs() { return sucBidCntMs; }

    public void setSucBidCntMs(Long sucBidCntMs) { this.sucBidCntMs = sucBidCntMs; }

    public Long getSucBidCntDay() { return sucBidCntDay; }

    public void setSucBidCntDay(Long sucBidCntDay) { this.sucBidCntDay = sucBidCntDay; }

    public Double getUpLimitBidFee() { return upLimitBidFee; }

    public void setUpLimitBidFee(Double upLimitBidFee) { this.upLimitBidFee = upLimitBidFee; }

    public Boolean getIsConfidence() { return isConfidence; }

    public void setIsConfidence(Boolean confidence) { this.isConfidence = confidence; }

    public Double getDefaultPrice() { return defaultPrice; }

    public void setDefaultPrice(Double defaultPrice) { this.defaultPrice = defaultPrice; }
}
