/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxAppReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxBidReq;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxBidRet;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.IdeaUnitDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxBid {
    private static final Logger logger = LoggerFactory.getLogger(AdxBid.class);

    public static AdxBidRet bid(AdxBidReq adxBidReq) {
        AdxBidRet ret = new AdxBidRet();
        try {
            if (!AdxBid.valid(adxBidReq) || adxBidReq.getPriceType() != null && adxBidReq.getPriceType() == 2) {
                AdxBid.printBidReq(adxBidReq);
            }
            Integer bidMode = adxBidReq.getBidMode();
            int priceType = Optional.ofNullable(adxBidReq.getPriceType()).orElse(1);
            AdxFactorBaseDo factorBaseDo = Optional.ofNullable(adxBidReq.getAdxFactorBaseDo()).orElse(new AdxFactorBaseDo());
            double factor = factorBaseDo.getFactor();
            Double cpm = factorBaseDo.getCpm();
            cpm = Optional.ofNullable(cpm).orElse(327.0);
            Double preCtr = adxBidReq.getPreCtr();
            Double statCtr = Optional.ofNullable(adxBidReq.getStatCtr()).orElse(factorBaseDo.getStatCtr());
            Double ctr = MathUtil.mean((Double)preCtr, (Double)statCtr, (Double)0.9);
            ctr = Optional.ofNullable(ctr).orElse(0.0269);
            Double preLaunchPv = adxBidReq.getPreLaunchPv();
            Double statLaunchPv = Optional.ofNullable(adxBidReq.getStatLaunchPv()).orElse(factorBaseDo.getLaunchPv());
            Double launchPv = MathUtil.mean((Double)preLaunchPv, (Double)statLaunchPv, (Double)0.9);
            launchPv = Optional.ofNullable(launchPv).orElse(1.025);
            Double arpu = factorBaseDo.getArpu();
            arpu = Optional.ofNullable(arpu).orElse(17.9);
            Double cpc = priceType == 1 ? adxBidReq.getCpc() : adxBidReq.getDirectCpc();
            Double roi = MathUtil.division((Double)adxBidReq.getRoi(), (Long)100L, (int)3);
            Integer expTag = adxBidReq.getAdxExploreDo().getExpTag();
            boolean expSwitch = adxBidReq.getAdxExploreDo().isExpSwitch();
            if (expTag == null) {
                expTag = 99;
            }
            if (expTag == 2 && !expSwitch) {
                AdxBid.getPriceExploreFactor(adxBidReq, ret);
            }
            Double price = priceType == 1 ? (bidMode == 1 ? AdxBid.getRoiPrice(ctr, factor, launchPv, arpu, roi, expTag, ret.getPriceFactor(), expSwitch) : AdxBid.getCpcPrice(ctr, cpc, factor, expTag, ret.getPriceFactor(), expSwitch)) : (priceType == 2 ? AdxBid.getDirectPrice(ctr, cpc, factor, roi, expTag, ret.getPriceFactor(), expSwitch) : adxBidReq.getPrice());
            price = Math.min(price, 50.0 * cpm);
            Double rankScore = !adxBidReq.isConfidence() ? price * 2.0 : price;
            ret.setAdxAlgoPrice(Math.round(price));
            ret.setArpu(arpu);
            ret.setCtr(ctr);
            ret.setPreCtr(preCtr);
            ret.setStatCtr(statCtr);
            ret.setLaunchPv(launchPv);
            ret.setPreLaunchPv(preLaunchPv);
            ret.setStatLaunchPv(statLaunchPv);
            ret.setFactor(factor);
            ret.setIdeaId(adxBidReq.getIdeaId());
            ret.setIdeaUnitId(adxBidReq.getIdeaUnitId());
            ret.setRankScore(rankScore);
        }
        catch (Exception e) {
            logger.error("AdxBid.bid error", (Throwable)e);
        }
        return ret;
    }

    public static List<AdxBidReq> buildAdxBidReq(AdIdeaDo adIdeaDo, AdxFactorBaseDo factorBaseDo, AdxAppReqDo adxAppReqDo) {
        ArrayList<AdxBidReq> adxBidReqs = new ArrayList<AdxBidReq>();
        List<IdeaUnitDo> ideaUnitDos = adIdeaDo.getIdeaUnitDos();
        for (IdeaUnitDo ideaUnitDo : ideaUnitDos) {
            AdxBidReq adxBidReq = new AdxBidReq();
            adxBidReq.setAdxFactorBaseDo(factorBaseDo);
            BeanUtils.copy((Object)adxAppReqDo, (Object)adxBidReq);
            BeanUtils.copy((Object)adIdeaDo, (Object)adxBidReq);
            BeanUtils.copy((Object)ideaUnitDo, (Object)adxBidReq);
            if (ideaUnitDo.getAdxStatsDo() != null) {
                AdxStatsDo adxStatsDo = ideaUnitDo.getAdxStatsDo();
                AdxIndexStatDo adxIndexStatDo = adxStatsDo.getLast1DayStat();
                adxBidReq.setStatCtr(AdxIndexStatDo.getStatCtr(adxIndexStatDo));
                adxBidReq.setStatLaunchPv(AdxIndexStatDo.getStatLaunchPv(adxIndexStatDo));
                adxBidReq.setConfidence(AdxIndexStatDo.isConfidence(adxIndexStatDo));
            }
            adxBidReqs.add(adxBidReq);
        }
        return adxBidReqs;
    }

    public static void getPriceExploreFactor(AdxBidReq adxBidReq, AdxBidRet ret) {
        Double exploreFlowRate = adxBidReq.getAdxExploreDo().getExploreFlowRate();
        if (exploreFlowRate == null) {
            exploreFlowRate = 0.1;
        }
        double expRate = 0.02 / exploreFlowRate;
        double baseRate = Math.max(1.0 - 5.0 * expRate, 0.0);
        double rand = Math.random();
        if (rand < baseRate) {
            double priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault("1", 1.5);
            ret.setPriceFactor(priceFactor);
            ret.setLevel("1");
        } else if (rand < baseRate + expRate) {
            double priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault("2", 1.0);
            ret.setPriceFactor(priceFactor);
            ret.setLevel("2");
        } else if (rand < baseRate + 2.0 * expRate) {
            double priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault("3", 1.5);
            ret.setPriceFactor(priceFactor);
            ret.setLevel("3");
        } else if (rand < baseRate + 3.0 * expRate) {
            double priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault("4", 2.0);
            ret.setPriceFactor(priceFactor);
            ret.setLevel("4");
        } else if (rand < baseRate + 4.0 * expRate) {
            double priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault("5", 2.5);
            ret.setPriceFactor(priceFactor);
            ret.setLevel("5");
        } else {
            double priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault("6", 3.0);
            ret.setPriceFactor(priceFactor);
            ret.setLevel("6");
        }
    }

    public static Double getCpcPrice(Double ctr, Double cpc, double factor, Integer expTag, double exploreFactor, boolean expSwitch) {
        if (expTag == 2 && !expSwitch) {
            return ctr * cpc * exploreFactor * 1000.0 * 100.0;
        }
        return ctr * cpc * factor * 1000.0 * 100.0;
    }

    public static Double getDirectPrice(Double ctr, Double algoCpcPrice, double factor, Double roi, Integer expTag, double exploreFactor, boolean expSwitch) {
        if (expTag == 2 && !expSwitch) {
            return DataUtil.division((Double)(ctr * algoCpcPrice * exploreFactor * 1000.0), (Double)roi, (int)3);
        }
        return DataUtil.division((Double)(ctr * algoCpcPrice * factor * 1000.0), (Double)roi, (int)3);
    }

    public static Double getRoiPrice(Double ctr, double factor, Double launchPv, Double arpu, Double roi, Integer expTag, double exploreFactor, boolean expSwitch) {
        if (expTag == 2 && !expSwitch) {
            return ctr * launchPv * arpu * exploreFactor / roi * 1000.0;
        }
        return ctr * launchPv * arpu * factor / roi * 1000.0;
    }

    public static boolean valid(AdxBidReq adxBidReq) {
        boolean ret = true;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{adxBidReq, adxBidReq.getPreCtr(), adxBidReq.getPriceType()})) {
            return false;
        }
        if (adxBidReq.getPriceType() == 1) {
            if (adxBidReq.getBidMode() == null) {
                return false;
            }
            ret = adxBidReq.getBidMode() == 1 ? adxBidReq.getRoi() != null && adxBidReq.getPreLaunchPv() != null : adxBidReq.getCpc() != null;
        } else if (adxBidReq.getPriceType() == 2) {
            ret = adxBidReq.getDirectCpc() != null && adxBidReq.getRoi() != null;
        }
        return ret;
    }

    public static void printBidReq(AdxBidReq adxBidReq) {
        if (Math.random() < 0.1) {
            logger.info("bidRequestDo2 is not valid, groupId:{}, resourceId:{}, ideaId:{}, appId:{}, priceType:{}, bidMode:{}, preCtr:{}, roi:{}, preLaunchPv:{}, cpc:{}, directCpc:{}", new Object[]{adxBidReq.getGroupId(), adxBidReq.getResId(), adxBidReq.getIdeaId(), adxBidReq.getAppId(), adxBidReq.getPriceType(), adxBidReq.getBidMode(), adxBidReq.getPreCtr(), adxBidReq.getRoi(), adxBidReq.getPreLaunchPv(), adxBidReq.getCpc(), adxBidReq.getDirectCpc()});
        }
    }
}

