/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.AdxPriceExploreDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxStatData {
    private static final Logger logger = LoggerFactory.getLogger(AdxStatData.class);

    public static Map<String, Double> updatePriceExploreList(List<AdxPriceExploreDo> priceExploreDoList, Map<String, Double> lastPriceExploreMap, Double minStepSize) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        if (AssertUtil.isEmpty(lastPriceExploreMap)) {
            logger.info("updatePriceExploreList, lastPriceMap is empty, priceExploreDoList {}", priceExploreDoList);
            retMap.put("1", 1.5);
            retMap.put("2", 1.0);
            retMap.put("3", 1.5);
            retMap.put("4", 2.0);
            retMap.put("5", 2.5);
            retMap.put("6", 3.0);
            return retMap;
        }
        double bestEffect = Double.NEGATIVE_INFINITY;
        String bestKey = "-1";
        for (AdxPriceExploreDo levelDo : priceExploreDoList) {
            if (!AssertUtil.isNotEmpty((Object)levelDo) || levelDo.getLevel().equals("1")) continue;
            String key = levelDo.getLevel();
            Double effect = AdxPriceExploreDo.getEffect(levelDo);
            if (!AssertUtil.isNotEmpty((Object)effect) || !(effect > bestEffect)) continue;
            bestEffect = effect;
            bestKey = key;
        }
        if (bestKey.equals("-1")) {
            logger.info("updatePriceExploreList, data no confidence {}, {}", priceExploreDoList, lastPriceExploreMap);
            return lastPriceExploreMap;
        }
        double bestFactor = MathUtil.stdwithBoundary((double)lastPriceExploreMap.get(bestKey), (double)0.2, (double)8.0);
        double oldBase = lastPriceExploreMap.get("1");
        double stepSize = Math.max((bestFactor - oldBase) / 2.0, minStepSize);
        retMap.put("1", bestFactor);
        retMap.put("2", bestFactor - stepSize);
        retMap.put("3", bestFactor);
        retMap.put("4", bestFactor + stepSize);
        retMap.put("5", bestFactor + 2.0 * stepSize);
        retMap.put("6", bestFactor + 3.0 * stepSize);
        logger.info("updatePriceExploreList, curPriceMap {}, lastPriceMap{}, minStepSize{}, priceDoList{}", new Object[]{retMap, lastPriceExploreMap, minStepSize, priceExploreDoList});
        return retMap;
    }
}

