/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rtbbid2;

import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorSubDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxStatBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxStatSubDo;
import cn.com.duiba.nezha.alg.common.model.ocpxControl.PidController;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxRoiFactor {
    private static final Logger logger = LoggerFactory.getLogger(AdxRoiFactor.class);

    public static AdxFactorDo run(AdxFactorReqDo adxFactorReqDo) {
        AdxFactorDo adxFactorDo = Optional.ofNullable(adxFactorReqDo.getAdxFactorDo()).orElse(new AdxFactorDo());
        try {
            Map<Long, Map<Long, AdxIdeaDo>> resIdeaDoMap = adxFactorReqDo.getResIdeaDoMap();
            resIdeaDoMap.forEach((resId, adxIdeaDoMap) -> {
                String prefix1 = "resId" + resId;
                AdxFactorSubDo resFactorSubDo = adxFactorDo.getFactorSubDo((Long)resId, 1);
                AdxStatDo resStatDo = adxFactorReqDo.getStatDo((Long)resId, 1);
                AdxRoiFactor.runFactor(resFactorSubDo, resStatDo, new AdxIdeaDo(), prefix1);
                adxFactorDo.putFactorSubDo((Long)resId, resFactorSubDo, 1);
                adxIdeaDoMap.forEach((ideaId, adxIdeaDo) -> {
                    String prefix2 = "ideaId" + ideaId;
                    AdxFactorSubDo ideaFactorSubDo = adxFactorDo.getFactorSubDo((Long)ideaId, 0);
                    AdxStatDo ideaStatDo = adxFactorReqDo.getStatDo((Long)ideaId, 0);
                    AdxRoiFactor.runFactor(ideaFactorSubDo, ideaStatDo, adxIdeaDo, prefix2);
                    adxFactorDo.putFactorSubDo((Long)ideaId, ideaFactorSubDo, 0);
                });
            });
        }
        catch (Exception e) {
            logger.error("AdxRoiFactor.run error:", (Throwable)e);
        }
        return adxFactorDo;
    }

    public static void runFactor(AdxFactorSubDo adxFactorSubDo, AdxStatDo adxStatDo, AdxIdeaDo adxIdeaDo, String prefix) {
        try {
            if (AssertUtil.isAnyEmpty((Object[])new Object[]{adxFactorSubDo, adxStatDo, adxIdeaDo})) {
                return;
            }
            if (adxIdeaDo == null) {
                adxIdeaDo = new AdxIdeaDo();
            }
            Integer bidMode = adxIdeaDo.getBidMode();
            Double target = AdxIdeaDo.getTarget(adxIdeaDo);
            boolean reset = false;
            if (bidMode != null && target != null && adxFactorSubDo.getAdxIdeaDo() != null && !adxIdeaDo.equals(adxFactorSubDo.getAdxIdeaDo())) {
                reset = true;
            }
            AdxStatSubDo statSubDoMins = adxStatDo.getStatSubDo1();
            AdxStatBaseDo statBaseDoMins = statSubDoMins.getAdxStatBaseDo();
            AdxStatSubDo statSubDoDay = adxStatDo.getStatSubDo2();
            AdxStatBaseDo statBaseDoDay = statSubDoDay.getAdxStatBaseDo();
            AdxStatSubDo statSubDo3Day = adxStatDo.getStatSubDo3();
            AdxStatBaseDo statBaseDo3Days = statSubDo3Day.getAdxStatBaseDo();
            AdxFactorBaseDo factorBaseDo = adxFactorSubDo.getFactorBaseDo();
            prefix = prefix + ",bidMode" + bidMode + ",target" + target;
            AdxRoiFactor.getFactor(prefix, target, factorBaseDo, null, bidMode, statBaseDoMins, statBaseDoDay, statBaseDo3Days, reset);
            Map<String, AdxStatBaseDo> adxStatBaseDoMap = statSubDoMins.getAdxStatBaseDoMap();
            if (AssertUtil.isNotEmpty(adxStatBaseDoMap)) {
                boolean finalReset = reset;
                String finalPrefix = prefix;
                adxStatBaseDoMap.forEach((appId, appStatBaseDo) -> {
                    String prefix1 = finalPrefix + ",appId" + appId;
                    AdxFactorBaseDo appFactor = adxFactorSubDo.getAppFactor((String)appId);
                    AdxStatBaseDo appStatBaseDoDay = statSubDoDay.getStatBaseDo((String)appId);
                    AdxStatBaseDo appStatBaseDo3Days = statSubDo3Day.getStatBaseDo((String)appId);
                    AdxRoiFactor.getFactor(prefix1, target, appFactor, factorBaseDo, bidMode, appStatBaseDo, appStatBaseDoDay, appStatBaseDo3Days, finalReset);
                    adxFactorSubDo.putAppFactor((String)appId, appFactor);
                });
            }
            adxFactorSubDo.setAdxIdeaDo(adxIdeaDo);
            adxFactorSubDo.setFactorBaseDo(factorBaseDo);
        }
        catch (Exception e) {
            logger.error("AdxRoiFactor.runFactor error:", (Throwable)e);
        }
    }

    public static void getFactor(String prefix, Double target, AdxFactorBaseDo factorBaseDo, AdxFactorBaseDo factorBaseDo2, Integer bidMode, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay, AdxStatBaseDo statBaseDo3Days, boolean reset) {
        if (target != null && bidMode != null) {
            AdxRoiFactor.updateFactor(prefix, target, factorBaseDo, bidMode, adxStatBaseDo, statBaseDoDay, statBaseDo3Days, reset);
        }
        AdxRoiFactor.updateStatValue(factorBaseDo, factorBaseDo2, adxStatBaseDo, statBaseDoDay);
    }

    public static void updateFactor(String prefix, Double target, AdxFactorBaseDo factorBaseDo, Integer bidMode, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay, AdxStatBaseDo statBaseDo3Days, boolean reset) {
        try {
            if (factorBaseDo == null) {
                factorBaseDo = new AdxFactorBaseDo();
            }
            double factor = factorBaseDo.getFactor();
            if (reset) {
                factor = 1.0;
                factorBaseDo.setConfidence(true);
                factorBaseDo.setFactor(factor);
                logger.info("reset prefix{}", (Object)prefix);
                return;
            }
            if (!AdxStatBaseDo.isCostConfidence(statBaseDoDay) && !AdxStatBaseDo.isImpConfidence(adxStatBaseDo)) {
                factor += (1.0 - factor) * 0.1;
                factorBaseDo.setConfidence(false);
                factorBaseDo.setFactor(factor);
                return;
            }
            Double realValueMins = AdxRoiFactor.getRealValue(adxStatBaseDo, bidMode, target);
            Double realValueDay = AdxRoiFactor.getRealValue(statBaseDoDay, bidMode, target);
            Double realValue3Days = AdxRoiFactor.getRealValue(statBaseDo3Days, bidMode, target);
            Double costWeigh = AdxRoiFactor.getCostWeigh(adxStatBaseDo, statBaseDoDay);
            boolean winRateStatus = AdxRoiFactor.getWinRateStatus(adxStatBaseDo, statBaseDoDay);
            PidController pidController = new PidController();
            double signal = pidController.runPid2(target.doubleValue(), realValueMins.doubleValue(), realValueDay.doubleValue(), realValue3Days.doubleValue(), costWeigh.doubleValue());
            factor += signal;
            factor = AdxRoiFactor.limitFactor(factor, realValueDay, target, statBaseDoDay.getAdxConsume2(), winRateStatus, prefix);
            factor = MathUtil.stdwithBoundary((double)factor, (double)0.2, (double)3.0);
            factorBaseDo.setConfidence(true);
            factorBaseDo.setFactor(factor);
            logger.info("roitask prefix{}, 20mins{}, day{}, 3days{}, factorDo{}", new Object[]{prefix, adxStatBaseDo, statBaseDoDay, statBaseDo3Days, factorBaseDo});
        }
        catch (Exception e) {
            logger.error("AdxRoiFactor.updateFactor error:", (Throwable)e);
        }
    }

    public static double limitFactor(double factor, Double realValueDay, Double target, Double adxCost, boolean winRateStatus, String prefix) {
        double ret = factor;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{realValueDay, target, adxCost})) {
            return ret;
        }
        if (realValueDay > 3.0 && adxCost > 50000.0) {
            ret = factor + (0.2 - factor) * 0.1;
        } else if (realValueDay / target - 1.0 > 0.2 && adxCost > 10000.0) {
            factor += (0.2 - factor) * 0.01;
            ret = Math.min(factor, 1.0);
        } else if (realValueDay / target - 1.0 < -0.05) {
            ret = factor + (3.0 - factor) * 0.03;
        }
        if (realValueDay / target - 1.0 < 0.05 || winRateStatus) {
            ret = Math.max(ret, 1.0);
        }
        return ret;
    }

    public static void updateStatValue(AdxFactorBaseDo factorBaseDo, AdxFactorBaseDo factorBaseDo2, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {
        try {
            Double arpu = factorBaseDo.getArpu();
            Double launchPv = factorBaseDo.getLaunchPv();
            Double statCtr = factorBaseDo.getStatCtr();
            Double cpm = factorBaseDo.getCpm();
            Double clickValue = factorBaseDo.getClickValue();
            if (AdxStatBaseDo.isCostConfidence(statBaseDoDay)) {
                arpu = AdxRoiFactor.getArpu(arpu, adxStatBaseDo, statBaseDoDay);
                launchPv = AdxRoiFactor.getLaunchPv(launchPv, adxStatBaseDo, statBaseDoDay);
                statCtr = AdxRoiFactor.getStatCtr(statCtr, adxStatBaseDo, statBaseDoDay);
                cpm = AdxRoiFactor.getStatCpm(cpm, adxStatBaseDo, statBaseDoDay);
                clickValue = AdxRoiFactor.getStatClickValue(clickValue, adxStatBaseDo, statBaseDoDay);
            } else if (factorBaseDo2 != null) {
                arpu = MathUtil.mean((Double)arpu, (Double)factorBaseDo2.getArpu(), (Double)0.9);
                launchPv = MathUtil.mean((Double)launchPv, (Double)factorBaseDo2.getLaunchPv(), (Double)0.9);
                statCtr = MathUtil.mean((Double)statCtr, (Double)factorBaseDo2.getStatCtr(), (Double)0.9);
                cpm = MathUtil.mean((Double)cpm, (Double)factorBaseDo2.getCpm(), (Double)0.9);
                clickValue = MathUtil.mean((Double)clickValue, (Double)factorBaseDo2.getClickValue(), (Double)0.9);
            }
            factorBaseDo.setArpu(arpu);
            factorBaseDo.setLaunchPv(launchPv);
            factorBaseDo.setStatCtr(statCtr);
            factorBaseDo.setCpm(cpm);
            factorBaseDo.setClickValue(clickValue);
        }
        catch (Exception e) {
            logger.info("AdxRoiFactor.updateStatValue:", (Throwable)e);
        }
    }

    public static Double getArpu(Double arpu, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {
        Double arpu1 = AdxStatBaseDo.getStatArpu(adxStatBaseDo);
        Double arpu2 = AdxStatBaseDo.getStatArpu(statBaseDoDay);
        Double statArpu = MathUtil.mean((Double)arpu1, (Double)arpu2, (Double)0.8);
        arpu = MathUtil.mean((Double)arpu, (Double)statArpu, (Double)0.8);
        return arpu;
    }

    public static Double getLaunchPv(Double launchPv, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {
        Double launchPv1 = AdxStatBaseDo.getStatLaunchPv(adxStatBaseDo);
        Double launchPv2 = AdxStatBaseDo.getStatLaunchPv(statBaseDoDay);
        Double statlaunchPv = MathUtil.mean((Double)launchPv1, (Double)launchPv2, (Double)0.8);
        launchPv = MathUtil.mean((Double)launchPv, (Double)statlaunchPv, (Double)0.8);
        return launchPv;
    }

    public static Double getStatCtr(Double ctr, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {
        Double ctr2;
        Double ctr1 = AdxStatBaseDo.getStatCtr(adxStatBaseDo);
        Double statCtr = MathUtil.mean((Double)ctr1, (Double)(ctr2 = AdxStatBaseDo.getStatCtr(statBaseDoDay)), (Double)0.8);
        if ((ctr = MathUtil.mean((Double)ctr, (Double)statCtr, (Double)0.8)) != null) {
            ctr = MathUtil.stdwithBoundary((double)ctr, (double)0.0, (double)0.2);
        }
        return ctr;
    }

    public static Double getStatCpm(Double cpm, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {
        Double cpm1 = AdxStatBaseDo.getStatCpm(adxStatBaseDo);
        Double cpm2 = AdxStatBaseDo.getStatCpm(statBaseDoDay);
        Double statCpm = MathUtil.mean((Double)cpm1, (Double)cpm2, (Double)0.8);
        cpm = MathUtil.mean((Double)cpm, (Double)statCpm, (Double)0.2);
        cpm = MathUtil.stdwithBoundary((double)cpm, (double)30.0, (double)3000.0);
        return cpm;
    }

    public static Double getStatClickValue(Double clickValue, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {
        Double cv1 = AdxStatBaseDo.getStatClickValue(adxStatBaseDo);
        Double cv2 = AdxStatBaseDo.getStatClickValue(statBaseDoDay);
        Double statCv = MathUtil.mean((Double)cv1, (Double)cv2, (Double)0.8);
        clickValue = MathUtil.mean((Double)clickValue, (Double)statCv, (Double)0.8);
        return clickValue;
    }

    public static Double getRoi(AdxStatBaseDo adxStatBaseDo) {
        Double ret = null;
        if (adxStatBaseDo != null) {
            Long advertConsume = adxStatBaseDo.getAdvertConsume();
            Double adxConsume = adxStatBaseDo.getAdxConsume2();
            if (adxConsume != null && adxConsume > 1000.0) {
                ret = DataUtil.division((Double)adxConsume, (Long)advertConsume, (int)3);
            }
        }
        return ret;
    }

    public static Double getCpc(AdxStatBaseDo adxStatBaseDo) {
        Double ret = null;
        if (adxStatBaseDo != null) {
            Long click = adxStatBaseDo.getClick();
            Double adxConsume = adxStatBaseDo.getAdxConsume2();
            if (adxConsume != null && adxConsume > 1000.0) {
                ret = DataUtil.division((Double)adxConsume, (Long)click, (int)3);
            }
        }
        return ret;
    }

    public static boolean getWinRateStatus(AdxStatBaseDo adxStatBaseDoMin, AdxStatBaseDo adxStatBaseDoDay) {
        Double winRateDay;
        boolean ret = false;
        Double winRate = AdxRoiFactor.getWinRate(adxStatBaseDoMin);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{winRate, winRateDay = AdxRoiFactor.getWinRate(adxStatBaseDoDay)}) && winRate < winRateDay * 0.5 && Math.random() < 0.3) {
            ret = true;
        }
        return ret;
    }

    public static double getCostWeigh(AdxStatBaseDo adxStatBaseDoMin, AdxStatBaseDo adxStatBaseDoDay) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{adxStatBaseDoMin, adxStatBaseDoDay})) {
            ret = MathUtil.division((Double)adxStatBaseDoDay.getAdxConsume3(), (Double)adxStatBaseDoMin.getAdxConsume3(), (int)3);
            ret = MathUtil.log((Double)ret);
        }
        if (ret == null) {
            ret = 1.0;
        }
        ret = MathUtil.stdwithBoundary((double)ret, (double)1.0, (double)10.0);
        return ret;
    }

    public static Double getRealValue(AdxStatBaseDo adxStatBaseDo, Integer bidMode, Double defaultValue) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{adxStatBaseDo, bidMode})) {
            Double d = ret = bidMode == 2 ? AdxRoiFactor.getCpc(adxStatBaseDo) : AdxRoiFactor.getRoi(adxStatBaseDo);
        }
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public static Double getStatValue(Double ... values) {
        Double ret = null;
        double sum = 0.0;
        int cnt = 0;
        for (Double v : values) {
            if (v == null) continue;
            sum += v.doubleValue();
            ++cnt;
        }
        ret = MathUtil.division((double)sum, (int)cnt, (int)3);
        return ret;
    }

    public static Double getWinRate(AdxStatBaseDo adxStatBaseDo) {
        Double ret = null;
        if (adxStatBaseDo != null) {
            ret = DataUtil.division((Long)adxStatBaseDo.getExp(), (Long)adxStatBaseDo.getBid(), (int)3);
        }
        return ret;
    }
}

