/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.coldstartandexplore;

import cn.com.duiba.nezha.alg.alg.vo.NdAdvertInfo;
import cn.com.duiba.nezha.alg.alg.vo.NdAdvertParams;
import cn.com.duiba.nezha.alg.alg.vo.NdAdvertResultDo;
import cn.com.duiba.nezha.alg.alg.vo.NdAdvertStatusDo;
import cn.com.duiba.nezha.alg.alg.vo.NdFilterAppInfo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NdAdvertSupportOrigin {
    private static final Logger logger = LoggerFactory.getLogger(NdAdvertSupportOrigin.class);
    public static Comparator<RectifyNdAdvertResInfo> iComparator = new Comparator<RectifyNdAdvertResInfo>(){

        @Override
        public int compare(RectifyNdAdvertResInfo r1, RectifyNdAdvertResInfo r2) {
            return r2.rectifyBid - r1.rectifyBid >= 0.0 ? 1 : -1;
        }
    };

    public static List<NdAdvertResultDo> NDAdvertColdStartAndExpose(NdFilterAppInfo ndFilterAppInfo, NdAdvertParams ndAdvertParams, List<NdAdvertInfo> ndAdvertInfoList) {
        ArrayList<NdAdvertResultDo> res = new ArrayList<NdAdvertResultDo>();
        PriorityQueue<RectifyNdAdvertResInfo> candis = new PriorityQueue<RectifyNdAdvertResInfo>(iComparator);
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{ndAdvertInfoList, ndFilterAppInfo, ndAdvertParams})) {
            return res;
        }
        Long hisAppConvert = ndFilterAppInfo.getHisAppConvert();
        Double hisAppCVR = ndFilterAppInfo.getHisAppCVR();
        Long hisAppConsume = ndFilterAppInfo.getHisAppConsume();
        if (hisAppConvert <= (long)ndAdvertParams.getAppConvertThreshold().intValue() || hisAppCVR <= ndAdvertParams.getAppCVRThreshold() || (double)hisAppConsume.longValue() <= ndAdvertParams.getAppConsumeThreshold()) {
            return res;
        }
        for (int i = 0; i < ndAdvertInfoList.size(); ++i) {
            double curRectifyBid = 0.0;
            NdAdvertInfo curNdAdvertInfo = ndAdvertInfoList.get(i);
            RectifyNdAdvertResInfo rectifyNdAdvertResInfo = new RectifyNdAdvertResInfo();
            Long hisSlotAdvExpose = curNdAdvertInfo.getHisExpose();
            Long hisAdvertExploreConsume = curNdAdvertInfo.getHisAdvertExploreConsume();
            Long hisAdvertConsume = curNdAdvertInfo.getHisAdvertConsume();
            Map<String, Double> AdjustCVRRes = NdAdvertSupportOrigin.getAdjustCVR(ndAdvertParams, curNdAdvertInfo);
            double adjustWeight = AdjustCVRRes.get("adjustWeight");
            double adjustCvr = AdjustCVRRes.get("adjustCvr");
            double preCtr = ndAdvertInfoList.get(i).getPreCtr();
            Long bid = ndAdvertInfoList.get(i).getBid();
            if (hisSlotAdvExpose <= (long)ndAdvertParams.getExposeConfidenceThreshold().intValue()) {
                curRectifyBid = hisSlotAdvExpose <= (long)ndAdvertParams.getExposeConfidenceThreshold2().intValue() ? preCtr * adjustCvr * (double)bid.longValue() * NdAdvertSupportOrigin.functionOfExpose(hisSlotAdvExpose) : preCtr * adjustCvr * (double)bid.longValue();
                rectifyNdAdvertResInfo.ndAdvertResult = NdAdvertSupportOrigin.fillData(ndAdvertInfoList.get(i), 1.0, 1.0, adjustWeight, preCtr, adjustCvr);
                rectifyNdAdvertResInfo.rectifyBid = curRectifyBid;
                candis.add(rectifyNdAdvertResInfo);
                continue;
            }
            res.add(NdAdvertSupportOrigin.fillData(ndAdvertInfoList.get(i), 1.0, 1.0, adjustWeight, preCtr, adjustCvr));
        }
        int lengthOfCandis = candis.size();
        List<Double> functionOfRectifyFacList = NdAdvertSupportOrigin.functionOfRectifyFac(lengthOfCandis);
        for (int idx = 0; idx < lengthOfCandis; ++idx) {
            double curFactor = functionOfRectifyFacList.get(idx);
            RectifyNdAdvertResInfo curRectifyNdAdvertResInfo = (RectifyNdAdvertResInfo)candis.poll();
            curRectifyNdAdvertResInfo.ndAdvertResult.setAdjustFactor(curFactor);
            res.add(curRectifyNdAdvertResInfo.ndAdvertResult);
        }
        return res;
    }

    public static Map<String, Double> getAdjustCVR(NdAdvertParams ndAdvertParams, NdAdvertInfo ndAdvertInfo) {
        HashMap<String, Double> res = new HashMap<String, Double>();
        if (AssertUtil.isEmpty((Object)ndAdvertInfo)) {
            return null;
        }
        Double preCvr = ndAdvertInfo.getPreCvr();
        Long hisClick = ndAdvertInfo.getHisClick();
        Long hisConvert = ndAdvertInfo.getHisConvert();
        Double staCvr = Optional.ofNullable(MathUtil.division((Long)hisConvert, (Long)hisClick, (int)6)).orElse(0.0);
        Long advTradeSlotDayClick = ndAdvertInfo.getAdvTradeSlotDayStats().getClick();
        Long advTradeAppDayClick = ndAdvertInfo.getAdvTradeAppDayStats().getClick();
        Long advTradeAppTradeDayClick = ndAdvertInfo.getAdvTradeAppTradeDayStats().getClick();
        Long advTradeSlotTriDayClick = ndAdvertInfo.getAdvTradeSlotTriDayStats().getClick();
        Long advTradeAppTriDayClick = ndAdvertInfo.getAdvTradeAppTriDayStats().getClick();
        Long advTradeAppTradeTriDayClick = ndAdvertInfo.getAdvTradeAppTradeTriDayStats().getClick();
        double minDimsStatCvr = 0.0;
        Long[] clickList = new Long[]{advTradeSlotDayClick, advTradeAppDayClick, advTradeAppTradeDayClick, advTradeSlotTriDayClick, advTradeAppTriDayClick, advTradeAppTradeTriDayClick};
        NdAdvertStatusDo[] itemList = new NdAdvertStatusDo[]{ndAdvertInfo.getAdvTradeSlotDayStats(), ndAdvertInfo.getAdvTradeAppDayStats(), ndAdvertInfo.getAdvTradeAppTradeDayStats(), ndAdvertInfo.getAdvTradeSlotTriDayStats(), ndAdvertInfo.getAdvTradeAppTriDayStats(), ndAdvertInfo.getAdvTradeAppTradeTriDayStats()};
        if (clickList[clickList.length - 1] <= (long)ndAdvertParams.getClickConfidenceThreshold().intValue()) {
            minDimsStatCvr = Optional.ofNullable(MathUtil.division((Long)itemList[clickList.length - 1].getConvert(), (Long)clickList[clickList.length - 1], (int)6)).orElse(0.0);
        } else {
            for (int index = 0; index < clickList.length; ++index) {
                if (clickList[index] < (long)ndAdvertParams.getClickConfidenceThreshold().intValue()) continue;
                minDimsStatCvr = Optional.ofNullable(MathUtil.division((Long)itemList[index].getConvert(), (Long)clickList[index], (int)6)).orElse(0.0);
                break;
            }
        }
        double adjustWeight = 1.0;
        double adjustCvr = preCvr;
        if (hisClick < (long)ndAdvertParams.getSepStageThreshold().intValue()) {
            boolean b;
            boolean bl = b = staCvr <= Math.pow(10.0, -8.0) || staCvr < 0.4 * minDimsStatCvr;
            adjustWeight = (long)ndAdvertParams.getColdStartThreshold1().intValue() <= hisClick && hisClick < (long)ndAdvertParams.getColdStartThreshold2().intValue() ? (b ? 0.9 : 1.0) : ((long)ndAdvertParams.getColdStartThreshold2().intValue() <= hisClick && hisClick < (long)ndAdvertParams.getColdStartThreshold3().intValue() ? (b ? 0.8 : (staCvr < 0.7 * minDimsStatCvr ? 0.9 : 1.0)) : (hisClick >= (long)ndAdvertParams.getColdStartThreshold3().intValue() ? (b ? 0.7 : (staCvr < 0.7 * minDimsStatCvr ? 0.8 : 1.0)) : 1.0));
        } else {
            adjustWeight = staCvr <= Math.pow(10.0, -8.0) ? 0.1 : 0.3 + 0.4 * Math.min(1.0, MathUtil.division((double)hisClick.longValue(), (int)2000, (int)6));
        }
        adjustCvr = hisClick >= (long)ndAdvertParams.getSepStageThreshold().intValue() && staCvr != 0.0 ? (1.0 - adjustWeight) * preCvr + adjustWeight * staCvr : (adjustCvr *= adjustWeight);
        res.put("adjustWeight", adjustWeight);
        res.put("adjustCvr", adjustCvr);
        return res;
    }

    public static double functionOfExpose(Long exposeCnt) {
        double res = 1.0;
        if (exposeCnt <= 3000L) {
            double k = -7.0 * Math.pow(10.0, -4.0);
            double b = 1.21;
            res = k * (double)exposeCnt.longValue() + b;
        }
        return res;
    }

    public static List<Double> functionOfRectifyFac(int size) {
        ArrayList<Double> res = new ArrayList<Double>();
        double weight = 1.0;
        Map<String, Double> KBMap1 = NdAdvertSupportOrigin.calculateKAndB(0, (int)(0.1 * (double)size), 1.2, 1.1);
        Map<String, Double> KBMap2 = NdAdvertSupportOrigin.calculateKAndB((int)(0.1 * (double)size), (int)(0.2 * (double)size), 1.1, 1.0);
        double k1 = KBMap1.get("K");
        double k2 = KBMap2.get("K");
        double b1 = KBMap1.get("B");
        double b2 = KBMap1.get("B");
        for (int i = 0; i < size; ++i) {
            weight = i <= (int)(0.1 * (double)size) ? k1 * (double)i + b1 : ((int)(0.1 * (double)size) < i && i <= (int)(0.2 * (double)size) ? k2 * (double)i + b2 : 1.0);
            weight = (double)Math.round(weight * 1000000.0) / 1000000.0;
            res.add(Math.max(weight, 1.0));
        }
        return res;
    }

    private static Map<String, Double> calculateKAndB(int x0, int x1, double y0, double y1) {
        HashMap<String, Double> res = new HashMap<String, Double>();
        double k = MathUtil.division((double)(y1 - y0), (int)(x1 - x0), (int)6);
        double b = y0 - k * (double)x0;
        res.put("K", k);
        res.put("B", b);
        return res;
    }

    private static NdAdvertResultDo fillData(NdAdvertInfo ndAdvertInfo, double adjustFactor, double ctrRectifyFactor, double cvrRectifyFactor, double rectifyCtr, double rectifyCvr) {
        NdAdvertResultDo ndAdvertRes = new NdAdvertResultDo();
        ndAdvertRes.setAdvertId(ndAdvertInfo.getAdvertId());
        ndAdvertRes.setPlanId(ndAdvertInfo.getPlanId());
        ndAdvertRes.setSlotId(ndAdvertInfo.getSlotId());
        ndAdvertRes.setAppId(ndAdvertInfo.getAppId());
        ndAdvertRes.setAdvertType(ndAdvertInfo.getAdvertType());
        ndAdvertRes.setAdjustFactor(adjustFactor);
        ndAdvertRes.setCtrRectifyFactor(ctrRectifyFactor);
        ndAdvertRes.setCvrRectifyFactor(cvrRectifyFactor);
        ndAdvertRes.setRectifyCtr(rectifyCtr);
        ndAdvertRes.setRectifyCvr(rectifyCvr);
        return ndAdvertRes;
    }

    static class RectifyNdAdvertResInfo {
        double rectifyBid = 0.0;
        NdAdvertResultDo ndAdvertResult;

        RectifyNdAdvertResInfo() {
        }
    }
}

