/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.FeatureIndex;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.Model;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.PredictType;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FilterReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FilterRetDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowFilterAlg {
    private static final Logger logger = LoggerFactory.getLogger(FlowFilterAlg.class);

    public static Map<String, String> getStaticFeatureMap(AdxFeatureDo adxFeatureDo, AdxStatsDo resoAppStats) {
        AdxIndexStatsDo resoApp1HourInfo = AdxStatData.getAdxTimeIndex(resoAppStats, "1hour");
        adxFeatureDo.setResoAppExpCntDay(resoApp1HourInfo.getExpCnt());
        adxFeatureDo.setResoAppClickCntDay(resoApp1HourInfo.getClickCnt());
        adxFeatureDo.setResoAppAdCostDay(resoApp1HourInfo.getAdvertConsume());
        if (AssertUtil.isEmpty((Object)adxFeatureDo)) {
            logger.warn("FlowFilterAlg.getStaticFeatureMap adxFeatureDo is not valid");
        }
        Map featureMap = AdxFeatureParse.generateFeatureMapStatic((AdxFeatureDo)adxFeatureDo);
        return featureMap;
    }

    public static Double predict(Map<String, String> staticFeatureMap, Model model, PredictType predictType) throws Exception {
        Double ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{staticFeatureMap, model, predictType})) {
            logger.warn("FlowFilterAlg.predict params is not valid featureMap:{},predictType:{}", (Object)JSON.toJSONString(staticFeatureMap), (Object)JSON.toJSONString((Object)((Object)predictType)));
            return ret;
        }
        HashMap<FeatureIndex, FeatureMapDo> featureMap = new HashMap<FeatureIndex, FeatureMapDo>();
        FeatureIndex featureIndex = new FeatureIndex(1L, 1L);
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(staticFeatureMap);
        featureMap.put(featureIndex, featureMapDo);
        if (PredictType.CTR.equals((Object)predictType)) {
            Map<FeatureIndex, Double> preMap = model.predictCtr(featureMap);
            if (AssertUtil.isEmpty(preMap)) {
                logger.warn("FlowFilterAlg.predict preMap is null");
                return ret;
            }
            ret = preMap.get(featureIndex);
            if (AssertUtil.isEmpty((Object)ret)) {
                logger.warn("FlowFilterAlg.predict preValue is null");
            }
        }
        return ret;
    }

    public static FilterRetDo getFilter(FilterReqDo filterReqDo) {
        FilterRetDo ret = new FilterRetDo();
        try {
            if (!FlowFilterAlg.isValid(filterReqDo).booleanValue()) {
                return ret;
            }
            Double statCtr = null;
            Double statClickValue = null;
            if (filterReqDo.getFlowPolyIdStatsDo() != null) {
                AdxStatsDo statsDo = filterReqDo.getFlowPolyIdStatsDo();
                statCtr = AdxStatsDo.mergeStatCtr(statsDo, 0.7, 0.2, 0.1);
                statClickValue = AdxStatsDo.mergeStatClickValue(statsDo, 0.7, 0.2, 0.1);
            }
            AdxIndexStatDo group0 = filterReqDo.getGroupTag0StatsDo();
            AdxIndexStatDo group1 = filterReqDo.getGroupTag0StatsDo();
            AdxIndexStatDo group2 = filterReqDo.getGroupTag0StatsDo();
            AdxIndexStatDo sumStatDo = FlowFilterAlg.getSumStatDo(group0, group1, group2);
            if (statCtr == null && (sumStatDo.getExp() > 100L || sumStatDo.getClick() > 50L)) {
                statCtr = MathUtil.stdwithBoundary((double)DataUtil.division((Long)sumStatDo.getClick(), (Long)sumStatDo.getExp()), (double)0.0, (double)1.0);
            }
            if (statClickValue == null && (sumStatDo.getClick() > 50L || sumStatDo.getAdCost() > 2000L)) {
                statClickValue = DataUtil.division((Long)sumStatDo.getAdCost(), (Long)sumStatDo.getClick());
            }
            Double preCtr = filterReqDo.getFilterPreCtr();
            Double ctr = MathUtil.mean((Double)preCtr, (Double)statCtr, (Double)0.9);
            if (statClickValue == null) {
                logger.info("FlowFilterAlg.getFilter statClickValue is null, resId = {}", (Object)filterReqDo.getResId());
                return ret;
            }
            Double ecpm = ctr * statClickValue * 1000.0;
            Double basePrice = filterReqDo.getBasePrice();
            double p = 0.0;
            Double filterWeight = FlowFilterAlg.getFilterWeight(group1, group2);
            if (ecpm < basePrice * 0.5) {
                p = 0.8;
            } else if (ecpm < basePrice * 0.7) {
                p = 0.5;
            } else if (ecpm < basePrice * 0.9) {
                p = 0.2;
            }
            double random = Math.random();
            boolean isFilter = random < (p *= filterWeight.doubleValue());
            ret.setFilter(isFilter);
            return ret;
        }
        catch (Exception e) {
            logger.error("FlowFilterAlg.getFilter", (Throwable)e);
            return ret;
        }
    }

    public static Boolean isValid(FilterReqDo filterReqDo) {
        if (AssertUtil.isEmpty((Object)filterReqDo)) {
            logger.warn("FlowFilterAlg.getFilter filterReqDo is null");
            return false;
        }
        Integer pmpType = filterReqDo.getPmpType();
        if (AssertUtil.isEmpty((Object)pmpType) || !pmpType.equals(0)) {
            return false;
        }
        Double preCtr = filterReqDo.getFilterPreCtr();
        if (AssertUtil.isEmpty((Object)preCtr)) {
            logger.warn("FlowFilterAlg.getFilter filterPreCtr is null, resId = {}, pmpType = {}", (Object)filterReqDo.getResId(), (Object)filterReqDo.getPmpType());
            return false;
        }
        Double basePrice = filterReqDo.getBasePrice();
        if (AssertUtil.isEmpty((Object)basePrice) || basePrice <= 0.0) {
            logger.warn("FlowFilterAlg.getFilter basePrice is null, resId = {}, appId = {}, slotId = {}", new Object[]{filterReqDo.getResId(), filterReqDo.getAppId(), filterReqDo.getSlotId()});
            return false;
        }
        return true;
    }

    public static double getFilterWeight(AdxIndexStatDo group1, AdxIndexStatDo group2) {
        Long group1BidCnt = AdxIndexStatDo.getBidCnt(group1);
        Long group2BidCnt = AdxIndexStatDo.getBidCnt(group2);
        Double ret = 1.0;
        if (group1BidCnt > 1000L && group2BidCnt > 1000L) {
            double filterRate = MathUtil.stdwithBoundary((double)DataUtil.division((Long)(group1BidCnt - group2BidCnt), (Long)group1BidCnt, (int)3), (double)0.0, (double)1.0);
            ret = filterRate < 0.2 ? 1.1 : (filterRate < 0.5 ? 1.0 : (filterRate < 0.8 ? 0.9 : 0.8));
        }
        return ret;
    }

    public static AdxIndexStatDo getSumStatDo(AdxIndexStatDo group0, AdxIndexStatDo group1, AdxIndexStatDo group2) {
        AdxIndexStatDo ret = new AdxIndexStatDo();
        Long group0BidCnt = AdxIndexStatDo.getBidCnt(group0);
        Long group1BidCnt = AdxIndexStatDo.getBidCnt(group1);
        Long group2BidCnt = AdxIndexStatDo.getBidCnt(group2);
        ret.setBid(group0BidCnt + group1BidCnt + group2BidCnt);
        Long group0ExpCnt = AdxIndexStatDo.getExpCnt(group0);
        Long group1ExpCnt = AdxIndexStatDo.getExpCnt(group1);
        Long group2ExpCnt = AdxIndexStatDo.getExpCnt(group2);
        ret.setExp(group0ExpCnt + group1ExpCnt + group2ExpCnt);
        Long group0ClickCnt = AdxIndexStatDo.getClickCnt(group0);
        Long group1ClickCnt = AdxIndexStatDo.getClickCnt(group1);
        Long group2ClickCnt = AdxIndexStatDo.getClickCnt(group2);
        ret.setClick(group0ClickCnt + group1ClickCnt + group2ClickCnt);
        Long group0AdxCost = AdxIndexStatDo.getAdxCost(group0);
        Long group1AdxCost = AdxIndexStatDo.getAdxCost(group1);
        Long group2AdxCost = AdxIndexStatDo.getAdxCost(group2);
        ret.setAdxCost(group0AdxCost + group1AdxCost + group2AdxCost);
        Long group0AdCost = AdxIndexStatDo.getAdCost(group0);
        Long group1AdCost = AdxIndexStatDo.getAdCost(group1);
        Long group2AdCost = AdxIndexStatDo.getAdCost(group2);
        ret.setAdCost(group0AdCost + group1AdCost + group2AdCost);
        return ret;
    }
}

