/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxBid;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxRcmdAlg;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxRcmdBase;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxRecommend;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.FeatureIndex;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.Model;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.PredictType;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxAppReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxBidRet;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxRecallReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxRecallRetDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.IdeaUnitDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.SlotFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.SlotFactorReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorReqDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxRcmd {
    private static final Logger logger = LoggerFactory.getLogger(AdxRcmd.class);
    public static final double COLD_RATE = 0.25;

    public static List<AdIdeaDo> rawRank(List<AdIdeaDo> adIdeaDos, List<AdIdeaDo> recallDos, Integer limitSize) {
        try {
            if (AssertUtil.isEmpty(adIdeaDos) || adIdeaDos.size() < 1) {
                logger.warn("AdxRcmd.rawRank adIdeaDos is null");
                return null;
            }
            List<IdeaUnitDo> ideaUnitList = adIdeaDos.stream().flatMap(ideaUnit -> ideaUnit.getIdeaUnitDos().stream()).collect(Collectors.toList());
            Map<Long, Boolean> coldStartMap = adIdeaDos.stream().collect(Collectors.toMap(AdIdeaDo::getIdeaId, AdIdeaDo::getIsColdStart));
            if (AssertUtil.isEmpty(recallDos) || recallDos.size() < 1) {
                logger.warn("AdxRcmd.rawRank recallDos is null\uff0cresId is {}, ideaUnitList size is {}", (Object)adIdeaDos.get(0).getResId(), (Object)ideaUnitList.size());
                return AdxRcmdBase.getRandomList(ideaUnitList, limitSize, coldStartMap);
            }
            List<AdIdeaDo> interDos = AdxRcmdBase.getIntersection(adIdeaDos, recallDos);
            if (interDos == null || interDos.size() < 1) {
                logger.warn("AdxRcmd.rawRank getIntersection is null\uff0cresId is {}, ideaUnitList size is {}", (Object)adIdeaDos.get(0).getResId(), (Object)ideaUnitList.size());
                logger.info("AdxRcmd.rawRank getIntersection is null\uff0cresId is {}, ideaUnitList size is {}, adIdeaDos is {}, recallDos is {}", new Object[]{adIdeaDos.get(0).getResId(), ideaUnitList.size(), JSON.toJSONString(adIdeaDos), JSON.toJSONString(recallDos)});
                return AdxRcmdBase.getRandomList(ideaUnitList, limitSize, coldStartMap);
            }
            List interList = interDos.stream().flatMap(ideaUnit -> ideaUnit.getIdeaUnitDos().stream()).collect(Collectors.toList());
            logger.info("AdxRcmd.rawRank getIntersection size is {}, resId is {},", (Object)interList.size(), (Object)adIdeaDos.get(0).getResId());
            if (interList.size() > limitSize) {
                List<IdeaUnitDo> newList = interList.stream().filter(ideaUnitDo -> ideaUnitDo.getIsNew()).collect(Collectors.toList());
                List<IdeaUnitDo> oldList = interList.stream().filter(ideaUnitDo -> ideaUnitDo.getIsNew() == false).collect(Collectors.toList());
                long coldSize = AdxRcmdBase.getRecallSize(newList, oldList, limitSize, 0.25, "COLD");
                long bestSize = AdxRcmdBase.getRecallSize(newList, oldList, limitSize, 0.25, "BEST");
                List coldList = newList.stream().sorted(Comparator.comparing(IdeaUnitDo::getLast1DayExpCnt)).limit(coldSize).collect(Collectors.toList());
                List bestList = oldList.stream().sorted(Comparator.comparing(IdeaUnitDo::getStatAdEcpm).reversed()).limit(bestSize).collect(Collectors.toList());
                ArrayList<IdeaUnitDo> interList2 = new ArrayList<IdeaUnitDo>();
                interList2.addAll(coldList);
                interList2.addAll(bestList);
                List<AdIdeaDo> interCandidates = AdxRcmdBase.getCovertList(interList2);
                interCandidates.forEach(s -> s.setIsColdStart((Boolean)coldStartMap.get(s.getIdeaId())));
                return interCandidates;
            }
            return interDos;
        }
        catch (Exception e) {
            logger.error("AdxRcmd.rawRank error", (Throwable)e);
            return null;
        }
    }

    public static Map<FeatureIndex, FeatureMapDo> getFeatureMap(List<AdxIdeaFeatureDo> adxIdeaFeatureDos, AdxFeatureDo adxFeatureDo, Map<Long, AdxStatsDo> ideaAppStatsList, AdxStatsDo resoAppStats) {
        return AdxRecommend.getFeatureMap(adxIdeaFeatureDos, adxFeatureDo, ideaAppStatsList, resoAppStats);
    }

    public static Map<FeatureIndex, Double> predict(Map<FeatureIndex, FeatureMapDo> featureMap, Model model, PredictType predictType) throws Exception {
        return AdxRecommend.predict(featureMap, model, predictType);
    }

    public static List<AdxBidRet> bidding(List<AdIdeaDo> adIdeaDos, AdxAppReqDo adxAppReqDo) {
        List<AdxBidRet> adxBidRets = new ArrayList<AdxBidRet>();
        try {
            adxBidRets = adIdeaDos.stream().map(adIdeaDo -> {
                Long ideaId = adIdeaDo.getIdeaId();
                Long resId = adIdeaDo.getResId();
                AdxFactorDo adxfactorDo = Optional.ofNullable(adIdeaDo.getAdxFactorDo()).orElse(new AdxFactorDo());
                return AdxBid.buildAdxBidReq(adIdeaDo, adxfactorDo, adxAppReqDo);
            }).flatMap(Collection::stream).map(AdxBid::getBid).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("AdxRcmd.bidding", (Throwable)e);
        }
        return adxBidRets;
    }

    public static List<AdxBidRet> fineRank(List<AdxBidRet> adxBidRets) {
        List fineRankRets = adxBidRets.stream().sorted(Comparator.comparing(AdxBidRet::getRankScore).reversed()).collect(Collectors.toList());
        AdxBidRet ret = (AdxBidRet)fineRankRets.get(0);
        if (Math.random() < 0.2) {
            Map<AdxBidRet, Double> scoreMap = adxBidRets.stream().collect(Collectors.toMap(s -> s, AdxBidRet::getRankScore));
            ret = Roulette.doubleMap(scoreMap);
        }
        if (ret != null && ret.getBasePrice() != null && ret.getIsNew() != null && ret.getIsNew().booleanValue() && Math.random() < 0.1) {
            Long basePrice = DataUtil.double2Long((Double)ret.getBasePrice());
            ret.setAdxAlgoPrice(Math.max(ret.getAdxAlgoPrice(), basePrice + 1L));
        }
        return Arrays.asList(ret);
    }

    public static AdxRecallRetDo recallIdea(AdxRecallReqDo recallReqDo) {
        AdxRecallRetDo ret = new AdxRecallRetDo();
        try {
            ret = AdxRcmdAlg.recallIdeaRun(recallReqDo);
        }
        catch (Exception e) {
            logger.error("AdxRcmd.recallIdea", (Throwable)e);
        }
        return ret;
    }

    public static AdxRecallRetDo recallAdIdea(AdxRecallReqDo recallReqDo) {
        AdxRecallRetDo ret = new AdxRecallRetDo();
        try {
            ret = AdxRcmdAlg.recallAdIdeaRun(recallReqDo);
        }
        catch (Exception e) {
            logger.error("AdxRcmd.recallAdIdea", (Throwable)e);
        }
        return ret;
    }

    public static AdxFactorDo adIdeaFactorRun(AdxFactorReqDo adxFactorReqDo) {
        AdxFactorDo ret = adxFactorReqDo.getAdxFactorDo();
        try {
            ret = AdxRcmdAlg.adIdeaFactorRun(adxFactorReqDo);
        }
        catch (Exception e) {
            logger.error("AdxRcmd.ideaFactorRun", (Throwable)e);
        }
        return ret;
    }

    public static SlotFactorDo slotFactorRun(SlotFactorReqDo slotFactorReqDo) {
        SlotFactorDo ret = slotFactorReqDo.getSlotFactorDo();
        try {
            ret = AdxRcmdAlg.slotFactorRun(slotFactorReqDo);
        }
        catch (Exception e) {
            logger.error("AdxRcmd.slotFactorRun", (Throwable)e);
        }
        return ret;
    }
}

