package cn.com.duiba.nezha.alg.alg.advert;

public class ChargeControl {


    /**
     * 计费环节，成本控制
     * <p>
     * 解决成本偏高情况下，计费问题
     * <p>
     * 策略:超成本金额大于阈值时，熔断，使用底价计费
     *
     * @param fee      本次点击计费，单位：分
     * @param cost     当日实际消耗，单位：分
     * @param deepCost 当日深度消耗，单位：分
     * @return
     */
    public static int getNewFee(int fee, int cost, int deepCost) {
        int ret = fee;


        int minCost= 500*100;//触发控制，最小消耗
        int minDiffCost= 200*100;//最小超/欠成本金额
        int maxDiffCost= 200*100;//最大超/欠成本金额
        int floorFee= 300;//计费熔断，最低计费

        int addFee =30;//欠成本情况下，补计费金额
        double raito = 0.04;//超成本比例




        int costLevel =Math.max(cost,deepCost);//判断消耗是否置信使用

        /**
         * 1、冗余超成本金额计算（最大多收费）
         * 默认不大于5% 且 不小于50元 且不大于250元
         */
        int diffCost = (int) Math.round(deepCost * raito);//多收费
        diffCost = Math.max(minDiffCost, diffCost);
        diffCost = Math.min(maxDiffCost, diffCost);


        /**
         * 2、计费熔断
         * 判断：实际消耗大于50元，且大于 深度消耗+冗余超成本
         */
        if (costLevel > minCost && cost > (deepCost + diffCost)) {
            ret = Math.min(floorFee,fee);
        }


        /**
         * 3、欠费用，补计费
         */
        if (costLevel > minCost && cost < (deepCost - minDiffCost)) {
            ret = fee + addFee;
        }


        return ret;
    }


    public static void main(String[] args) {

        int s = getNewFee(293, 28942100, 29844400);
        System.out.println(s);
    }



}
