package cn.com.duiba.nezha.alg.alg.cost;


import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.vo.BackendAdvertStatDo;
import cn.com.duiba.nezha.alg.alg.vo.BackendFactor;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.alg.vo.StatDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;

import java.util.HashMap;
import java.util.Map;

public class BackendCostOptimizer {

    public static Map<String, Double> backendTypePriorityMap = new HashMap<>();


    static {
        backendTypePriorityMap.put("1", 1.0);
        backendTypePriorityMap.put("2", 1.0);
        backendTypePriorityMap.put("3", 1.0);
        backendTypePriorityMap.put("4", 1.0);
        backendTypePriorityMap.put("5", 0.9);
        backendTypePriorityMap.put("6", 0.7);
        backendTypePriorityMap.put("7", 0.5);
        backendTypePriorityMap.put("8", 0.3);
    }

    /**
     * 后端转化，可优化后端行为&广告认定
     *
     * @param appAdvertStatMap
     * @param globalAdvertStatMap
     * @return （广告ID、后端转化数据类型、统计信息）
     */
    public static Map<Long, BackendAdvertStatDo> getBackendAdvertStatInfo(Map<Long, StatDo> appAdvertStatMap,
                                                                          Map<Long, StatDo> globalAdvertStatMap) {
        Map<Long, BackendAdvertStatDo> ret = new HashMap<>();

        if (AssertUtil.isAllNotEmpty(globalAdvertStatMap)) {
            if (appAdvertStatMap == null) {
                appAdvertStatMap = new HashMap<>();
            }


            for (Map.Entry<Long, StatDo> entry : globalAdvertStatMap.entrySet()) {
                Long advertId = entry.getKey();
                StatDo globalStatDo = entry.getValue();
                StatDo appStatDo = appAdvertStatMap.get(advertId);

                String type = getTaskBackendType(globalStatDo);

                if (type != null) {
                    BackendAdvertStatDo backendAdvertStatDo = new BackendAdvertStatDo();
                    backendAdvertStatDo.setAdvertId(advertId);
                    backendAdvertStatDo.setBackendType(type);
                    backendAdvertStatDo.setAvgBackendCvr(getTaskBackendCvr(globalStatDo, type));
                    Double currentBCvr = getTaskBackendCvr(appStatDo, type);
                    if (currentBCvr == null) {
                        currentBCvr = getTaskBackendCvr(globalStatDo, type);
                    }

                    backendAdvertStatDo.setCBackendCvr(currentBCvr);

                    ret.put(advertId, backendAdvertStatDo);
                }


            }

        }

        return ret;
    }

    /**
     * 广告后端转化优化-智能竞价因子
     *
     * @param advertPreInfo    预估数据
     * @param advertStatInfo   统计数据
     * @param advertBudgetInfo 预算消耗数据 ** 新增 **
     * @return 优化因子
     */
    public static <T> Map<T, BackendFactor> getBackendAdvertInfo(Map<T, Double> advertPreInfo,
                                                                 Map<T, BackendAdvertStatDo> advertStatInfo,
                                                                 Map<T, BudgetSmoothDo> advertBudgetInfo) {
        Map<T, BackendFactor> ret = new HashMap<>();

        if (AssertUtil.isAllNotEmpty(advertPreInfo, advertStatInfo)) {
            if (advertBudgetInfo == null) {
                advertBudgetInfo = new HashMap<>();
            }

            for (Map.Entry<T, BackendAdvertStatDo> entry : advertStatInfo.entrySet()) {

                T advertId = entry.getKey();
                BackendAdvertStatDo backendAdvertStatDo = entry.getValue();
                Double preBackendCvr = advertPreInfo.get(advertId);
                BudgetSmoothDo budgetSmoothDo = advertBudgetInfo.get(advertId);

                if (backendAdvertStatDo != null && preBackendCvr != null) {
                    Double mergeCvr = getMergeBackendCvr(backendAdvertStatDo.getCBackendCvr(), preBackendCvr);
                    BackendFactor optFactor = getBackendOptFactor(mergeCvr, backendAdvertStatDo.getAvgBackendCvr(), budgetSmoothDo);
                    ret.put(advertId, optFactor);
                }
            }
        }

        return ret;
    }

    public static BackendFactor getBackendOptFactor(Double mergeCvr, Double avgCvr, BudgetSmoothDo budgetSmoothDo) {

        if (budgetSmoothDo == null) {
            budgetSmoothDo = new BudgetSmoothDo();
        }

        BackendFactor backendFactor = new BackendFactor();
        backendFactor.setBudgetRatio(budgetSmoothDo.getRatio());
        backendFactor.setBudgetType(budgetSmoothDo.getTimeType());
        Double ret = 1.0;
        if (AssertUtil.isAllNotEmpty(mergeCvr, avgCvr)) {


            Double absoluteFactor = 1.0;
            Double relativeFactor = 1.0;

            Double ratio = (mergeCvr + 0.001) / (avgCvr + 0.001);

            Double budgetSmoothRatio = null;
            if (budgetSmoothDo != null) {
                budgetSmoothRatio = budgetSmoothDo.getRatio();
            }


            // 1、绝对值 打压 （绝对值 小 && 相对值 小） 激励（绝对值 大）  辅助
            if (mergeCvr <= 0.05 && ratio <= 0.7) {
                absoluteFactor = MathBase.sigmoidWithZoomAndIntervalMap((mergeCvr / 0.05 - 0.5), 0.9, 1.0, 8);

            } else if (mergeCvr > 0.5) {
                absoluteFactor = 1.02;
            }

            // 2、相对值 打压（相对值 小 && 绝对值 小 ） 激励（相对值 大） 主
            if (mergeCvr <= 0.7 && ratio <= 0.99) {

                Double relativeFactor1 = MathBase.sigmoidWithZoomAndIntervalMap((ratio - 0.4), 0.4, 1.0, 8);

                Double relativeFactor2 = MathBase.sigmoidWithZoomAndIntervalMap((ratio - 0.5), 0.4, 1.0, 8);

                if (mergeCvr <= 0.05) {
                    relativeFactor = relativeFactor1;
                } else if (mergeCvr < 0.2) {
                    relativeFactor = ((0.2 - mergeCvr) * relativeFactor1 + (mergeCvr - 0.1) * relativeFactor2) / (0.2 - 0.1);
                } else if (mergeCvr < 0.4) {
                    relativeFactor = relativeFactor2;
                }

            } else if (ratio > 1.5) {
                relativeFactor = 1.02;
            }


            // 预算消耗速度未知 0.8 速度越快，smmothFactor越大

//            double smoothFactor = 0.6;
//            if (budgetSmoothRatio != null) {
//
//                smoothFactor = MathBase.sigmoidWithZoomAndIntervalMap((budgetSmoothRatio - 1.0), 0.1, 1.1, 8);
//            }
//            ret = getBudgetSmooth(ret, smoothFactor);
////            System.out.println("ratio=" + ratio + ",mCvr=" + mergeCvr + ",aCvr=" + avgCvr + ",rel=" + relativeFactor + ",abs=" + absoluteFactor);

            if (budgetSmoothRatio != null && budgetSmoothRatio > 1.0 && avgCvr < 0.8) {
                ret = absoluteFactor * relativeFactor;
                double smoothFactor = MathBase.sigmoidWithZoomAndIntervalMap((budgetSmoothRatio - 1.0), 0.1, 1.3, 8);
                ret = getBudgetSmooth(ret, smoothFactor);
                ret = DataUtil.formatDouble(ret, 4);
            }


            System.out.println("mergeCvr=" + mergeCvr + ",avgCvr=" + avgCvr + ",ratio=" + ratio + ",budgetratio=" + budgetSmoothDo.getRatio()
                    + ",absoluteFactor=" + absoluteFactor + ",relativeFactor=" + relativeFactor + ",smoothFactor=");
        }
        backendFactor.setBackendFactor(ret);
        return backendFactor;
    }

    public static Double getBudgetSmooth(Double factor, Double weight) {
        Double ret = 1.0;
        if (factor != null && weight != null) {
            ret = (factor - 1) * weight + 1;
        }
        return ret;
    }

    public static Double getMergeBackendCvr(Double statCvr, Double preCvr) {
        Double ret = null;
        if (statCvr != null && preCvr != null) {
            ret = 0.3 * statCvr + 0.7 * preCvr;
        }

        return ret;
    }

    /**
     * 计算目标后端类型的转化率
     *
     * @param statDo
     * @param backendType
     * @return
     */
    public static Double getTaskBackendCvr(StatDo statDo, String backendType) {
        Double ret = null;
        if (statDo != null && backendType != null) {
            Long actClickCnt = statDo.getActClickCnt();
            Map<String, Long> backendCntMap = statDo.getBackendCntMap();
            if (actClickCnt != null && actClickCnt >= 50 && AssertUtil.isNotEmpty(backendCntMap)) {
                Long cnt = backendCntMap.get(backendType);
                if (cnt != null) {
                    ret = DataUtil.division(cnt, actClickCnt, 4);
                    ret = Math.min(ret, 1.01);
                }
            }

        }

        return ret;

    }

    /**
     * 计算目标后端类型
     *
     * @param statDo
     * @return
     */
    public static String getTaskBackendType(StatDo statDo) {
        String ret = null;
        if (statDo != null) {
            Long actClickCnt = statDo.getActClickCnt();
            Map<String, Long> backendCntMap = statDo.getBackendCntMap();
            if (actClickCnt != null && actClickCnt >= 50 && AssertUtil.isNotEmpty(backendCntMap)) {

                // 添加优先级权重，并过滤
                Map<String, Double> filterMap = new HashMap<>();
                for (Map.Entry<String, Long> entry : backendCntMap.entrySet()) {
                    String type = entry.getKey();
                    Long cnt = entry.getValue();
                    Double weight = backendTypePriorityMap.get(type);
                    if (cnt != null && cnt >= 10L && weight != null) {
                        filterMap.put(type, cnt * weight);
                    }
                }

                // 返回得分Top
                ret = getValueTopOneFromMap(filterMap);

            }

        }

        return ret;

    }


    /**
     * 获取map 依据value大小排序的 top1 key
     *
     * @param map
     * @return
     */
    public static String getValueTopOneFromMap(Map<String, Double> map) {
        String ret = null;
        if (AssertUtil.isNotEmpty(map)) {
            Double maxValue = 1.0;
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                Double val = entry.getValue();
                if (val != null && val > maxValue) {
                    maxValue = val;
                    ret = entry.getKey();
                }
            }
        }


        return ret;
    }


    public static void main(String[] args) {

        StatDo statDo = new StatDo();
        statDo.setAdvertId(1L);
        statDo.setActClickCnt(90L);
        Map<String, Long> bcMap = new HashMap<>();
        bcMap.put("1", 10L);
        statDo.setBackendCntMap(bcMap);


        Map<Long, StatDo> appAdvertStatMap = new HashMap<>();
        appAdvertStatMap.put(1L, statDo);

        StatDo statDo2 = new StatDo();
        statDo2.setAdvertId(1L);
        statDo2.setActClickCnt(300L);

        Map<String, Long> bcMap2 = new HashMap<>();
//        bcMap2.put("2", 40L);
        bcMap2.put("1", 50L);
        statDo2.setBackendCntMap(bcMap2);

        Map<Long, StatDo> globalAdvertStatMap = new HashMap<>();
        globalAdvertStatMap.put(1L, statDo2);

        Map<Long, BackendAdvertStatDo> ret1 = BackendCostOptimizer.getBackendAdvertStatInfo(appAdvertStatMap, globalAdvertStatMap);
        //Map<Long, BackendAdvertStatDo> ret1= getBackendAdvertStatInfo(null,null);
        System.out.println("ret1=" + JSON.toJSONString(ret1));


        Map<Long, Double> advertPreInfo = new HashMap<>();
        advertPreInfo.put(1L, 0.1);

        Map<Long, BudgetSmoothDo> advertBudgetInfo = new HashMap<>();
        BudgetSmoothDo bdo1 = new BudgetSmoothDo();
        bdo1.setRatio(1.9);
        advertBudgetInfo.put(1L, bdo1);
        Map<Long, BackendFactor> ret2 = getBackendAdvertInfo(advertPreInfo, ret1, advertBudgetInfo);
        System.out.println("ret2=" + JSON.toJSONString(ret2));
    }
}
