package cn.com.duiba.nezha.alg.api.facade.recall.channel;

import cn.com.duiba.nezha.alg.api.dto.recall.RandomAdvertDTO;
import cn.com.duiba.nezha.alg.api.dto.recall.RandomRequest;
import cn.com.duiba.nezha.alg.api.dto.recall.RecallChannelResult;
import cn.com.duiba.nezha.alg.api.enums.RecallEnums.RecallChannelType;
import cn.com.duiba.nezha.alg.api.facade.recall.AbstractRecallChanelFacade;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

/**
 * 随机召回
 * @author lijicong
 * @since 2021-09-07
 */
public class RandomRecallChannelFacadeImpl extends AbstractRecallChanelFacade<RandomAdvertDTO, RandomRequest>
        implements RandomRecallChannelFacade {

    @Override
    public RecallChannelType getType() {
        return RecallChannelType.Random;
    }

    @Override
    public Map<String, RecallChannelResult> execute(Map<String, RandomAdvertDTO> adverts, RandomRequest randomRequest) {
        if (MapUtils.isEmpty(adverts)) {
            return Collections.emptyMap();
        }
        Integer nums = randomRequest.getNum().getOrDefault("0", 5);
        if (nums != null && nums > 0) {
            List<RandomAdvertDTO> retained;
            retained = adverts.values().stream()
                    .filter(Objects::nonNull)
                    .collect(Collectors.toList());
            if (retained.size() < nums) {
                return retained.stream().map(this::buildRecallChannelResult).collect(Collectors.toMap(RecallChannelResult::buildKey, e -> e));
            }
            Collections.shuffle(retained);
            return retained.stream().limit(nums).map(this::buildRecallChannelResult).collect(Collectors.toMap(RecallChannelResult::buildKey, e -> e));
        }
        return Collections.emptyMap();
    }

    private RecallChannelResult buildRecallChannelResult(RandomAdvertDTO pkg) {
        RecallChannelResult result = newResult(pkg);
        result.setScore(-1.0D);
        return result;
    }

}
