package cn.com.duiba.nezha.alg.api.facade.recall;

import cn.com.duiba.nezha.alg.api.dto.base.BaseAdvertDTO;
import cn.com.duiba.nezha.alg.api.dto.base.BaseRequestDTO;
import cn.com.duiba.nezha.alg.api.dto.recall.RecallChannelResult;
import cn.com.duiba.nezha.alg.api.enums.RecallEnums.RecallChannelType;
import cn.com.duiba.nezha.alg.api.facade.TemplateFacade;

import java.util.Map;

/**
 * 召回通道接口
 * @param <Advert>
 * @param <Request>
 */
public interface RecallChannelFacade<Advert extends BaseAdvertDTO, Request extends BaseRequestDTO>
        extends TemplateFacade<Advert, Request, RecallChannelResult> {

    /**
     * 召回通道类型
     * @return
     */
    RecallChannelType getType();

    /**
     * 召回接口-传Map返回Map
     * @param adverts
     * @param request
     * @return
     */
    @Override
    Map<String, RecallChannelResult> execute(Map<String, Advert> adverts, Request request);
}
