package cn.com.duiba.nezha.alg.api.facade.recall.channel;

import cn.com.duiba.nezha.alg.api.dto.recall.RecallChannelResult;
import cn.com.duiba.nezha.alg.api.dto.recall.VectorAdvertDTO;
import cn.com.duiba.nezha.alg.api.dto.recall.VectorRequest;
import cn.com.duiba.nezha.alg.api.facade.recall.RecallChannelFacade;

import java.util.Map;

/**
 * 向量召回
 * @author lijicong
 * @since 2021-08-17
 */
public interface VectorRecallChannelFacade extends RecallChannelFacade<VectorAdvertDTO, VectorRequest> {

    /**
     * 向量召回--基于 embedding 的召回
     *
     * 离线模型：读取样本对模型进行离线训练
     * 线上服务：读取离线模型并根据nezha调用数据计算与当前流量匹配程度高的广告进行召回
     * @param adverts
     * @param vectorRequest
     * @return
     */
    @Override
    Map<String, RecallChannelResult> execute(Map<String, VectorAdvertDTO> adverts, VectorRequest vectorRequest);
}
