/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.api.model;

import cn.com.duiba.nezha.alg.api.model.TFModel;
import cn.com.duiba.nezha.alg.api.model.util.E2EPredResult;
import cn.com.duiba.nezha.alg.api.model.util.E2ETFUtils;
import cn.com.duiba.nezha.alg.api.model.util.TensorflowUtils;
import cn.com.duiba.nezha.alg.api.model.util.WuWuTFUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.nashorn.internal.ir.debug.ObjectSizeCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.SavedModelBundle;
import org.tensorflow.Session;
import org.tensorflow.Tensor;
import org.tensorflow.framework.DataType;
import org.tensorflow.framework.MetaGraphDef;
import org.tensorflow.framework.SignatureDef;
import org.tensorflow.framework.TensorInfo;

public class E2ELocalTFModel
implements TFModel {
    private static final Logger logger = LoggerFactory.getLogger(E2ELocalTFModel.class);
    private static final String SIGNATURE_DEF = "serving_default";
    private SavedModelBundle bundle;
    private String path;
    private Long version;
    private Map<String, TensorInfo> inputSpecMap;
    private Map<String, TensorInfo> outputSpecMap;

    public void loadLatestModel(String path) throws Exception {
        Long lastVersion = E2ETFUtils.getLastVersion(path);
        SavedModelBundle bundle = E2ETFUtils.loadModel(path, lastVersion + "");
        logger.info("loadModel ,path=" + path + "with version=" + lastVersion);
        this.setModel(bundle);
        this.path = path;
        this.version = lastVersion;
    }

    public void close() throws Exception {
        if (this.bundle != null) {
            logger.info("close model  ,path=" + this.path + "with version=" + this.version);
            logger.info("bundle.size before close :" + ObjectSizeCalculator.getObjectSize((Object)this.bundle));
            this.bundle.close();
            this.bundle = null;
        }
    }

    private void setModel(SavedModelBundle bundle) throws Exception {
        this.bundle = bundle;
        this.inputSpecMap = this.getInputSpecMap(bundle);
        this.outputSpecMap = this.getOutputSpecMap(bundle);
    }

    private Map<String, TensorInfo> getInputSpecMap(SavedModelBundle bundle) throws Exception {
        SignatureDef sig = MetaGraphDef.parseFrom((byte[])bundle.metaGraphDef()).getSignatureDefOrThrow(SIGNATURE_DEF);
        return sig.getInputsMap();
    }

    private Map<String, TensorInfo> getOutputSpecMap(SavedModelBundle bundle) throws Exception {
        SignatureDef sig = MetaGraphDef.parseFrom((byte[])bundle.metaGraphDef()).getSignatureDefOrThrow(SIGNATURE_DEF);
        return sig.getOutputsMap();
    }

    private <T> Map<String, Tensor<?>> preprocessInput(List<T> sampleKeyList, Map<T, Map<String, String>> sampleWithFeatureMap) {
        HashMap formattedInput = new HashMap();
        for (String featureKey : this.inputSpecMap.keySet()) {
            TensorInfo inputInfo = this.inputSpecMap.get(featureKey);
            String tfInputKey = inputInfo.getName();
            ArrayList<String> oneFeatureList = new ArrayList<String>();
            for (T sampleKey : sampleKeyList) {
                Map<String, String> featureMap = sampleWithFeatureMap.get(sampleKey);
                oneFeatureList.add(featureMap.getOrDefault(featureKey, null));
            }
            Tensor<?> oneFeatureTensor = E2ETFUtils.listToTensor(oneFeatureList, inputInfo);
            formattedInput.put(tfInputKey, oneFeatureTensor);
        }
        return formattedInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Map<String, Object[][]> executeTfGraph(Map<String, Tensor<?>> formattedInput) {
        HashMap<String, Object[][]> resultMap;
        List result = null;
        try {
            void var7_10;
            ArrayList<String> outputKeyList = new ArrayList<String>();
            ArrayList<String> outputTfKeyList = new ArrayList<String>();
            for (String string : this.outputSpecMap.keySet()) {
                outputKeyList.add(string);
                outputTfKeyList.add(this.outputSpecMap.get(string).getName());
            }
            Session.Runner runner = this.bundle.session().runner();
            for (String inputTfKey : formattedInput.keySet()) {
                runner.feed(inputTfKey, formattedInput.get(inputTfKey));
            }
            for (String outputTfKey : outputTfKeyList) {
                runner.fetch(outputTfKey);
            }
            result = runner.run();
            resultMap = new HashMap<String, Object[][]>();
            boolean bl = false;
            while (var7_10 < outputKeyList.size()) {
                Tensor tensorResult = (Tensor)result.get((int)var7_10);
                resultMap.put((String)outputKeyList.get((int)var7_10), WuWuTFUtils.tensorToArray(tensorResult));
                ++var7_10;
            }
        }
        finally {
            TensorflowUtils.closeQuitely(formattedInput.values());
            TensorflowUtils.closeQuitely(result);
        }
        return resultMap;
    }

    private <T> Map<T, Map<String, E2EPredResult>> formatOutputs(List<T> sampleKeyList, Map<String, Object[][]> rawOutputs) {
        HashMap resultMap = new HashMap();
        ArrayList<String> outputKeyList = new ArrayList<String>(this.outputSpecMap.keySet());
        for (int i = 0; i < sampleKeyList.size(); ++i) {
            HashMap<String, E2EPredResult> outputMap = new HashMap<String, E2EPredResult>();
            for (String outputKey : outputKeyList) {
                E2EPredResult wuWuPredResult = new E2EPredResult(outputKey);
                Object[] oneOutputs = rawOutputs.get(outputKey)[i];
                DataType dtype = this.outputSpecMap.get(outputKey).getDtype();
                if (oneOutputs.length == 1) {
                    wuWuPredResult.setSingleResult(oneOutputs[0], dtype);
                } else {
                    wuWuPredResult.setArrayResult(oneOutputs, dtype);
                }
                outputMap.put(outputKey, wuWuPredResult);
            }
            resultMap.put(sampleKeyList.get(i), outputMap);
        }
        return resultMap;
    }

    public <T> Map<T, Double> predict(Map<T, Map<String, String>> sampleWithFeatureMap) {
        ArrayList<T> sampleKeyList = new ArrayList<T>(sampleWithFeatureMap.keySet());
        Map<String, Tensor<?>> formattedInput = this.preprocessInput(sampleKeyList, sampleWithFeatureMap);
        Map<String, Object[][]> rawOutputs = this.executeTfGraph(formattedInput);
        Map<T, Map<String, E2EPredResult>> predResults = this.formatOutputs(sampleKeyList, rawOutputs);
        HashMap<T, Double> fina = new HashMap<T, Double>();
        for (T key : predResults.keySet()) {
            fina.put(key, E2ELocalTFModel.formatDouble(predResults.get(key).get("prob").getFloatResult().floatValue(), 6));
        }
        return fina;
    }

    public static double formatDouble(float d, int newScala) {
        BigDecimal bg = new BigDecimal(d).setScale(newScala, RoundingMode.UP);
        return bg.doubleValue();
    }

    public static void main(String[] args) throws Exception {
        HashMap sampleWithFeatureMap = new HashMap();
        HashMap<String, String> featureMap = new HashMap<String, String>();
        for (int i = 1; i <= 23; ++i) {
            String Label = "f000";
            String newLabel = String.format("%s%02d", Label, i);
            featureMap.put(newLabel, "a");
        }
        sampleWithFeatureMap.put(1L, featureMap);
        sampleWithFeatureMap.put(2L, featureMap);
        E2ELocalTFModel model = new E2ELocalTFModel();
        model.loadLatestModel("/Users/pengzhixiong/Downloads/pengzong/full");
        Map result = model.predict(sampleWithFeatureMap);
        System.out.println(result);
    }

    public SavedModelBundle getBundle() {
        return this.bundle;
    }

    public String getPath() {
        return this.path;
    }

    public Long getVersion() {
        return this.version;
    }

    public Map<String, TensorInfo> getInputSpecMap() {
        return this.inputSpecMap;
    }

    public Map<String, TensorInfo> getOutputSpecMap() {
        return this.outputSpecMap;
    }

    public void setBundle(SavedModelBundle bundle) {
        this.bundle = bundle;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public void setInputSpecMap(Map<String, TensorInfo> inputSpecMap) {
        this.inputSpecMap = inputSpecMap;
    }

    public void setOutputSpecMap(Map<String, TensorInfo> outputSpecMap) {
        this.outputSpecMap = outputSpecMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof E2ELocalTFModel)) {
            return false;
        }
        E2ELocalTFModel other = (E2ELocalTFModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SavedModelBundle this$bundle = this.getBundle();
        SavedModelBundle other$bundle = other.getBundle();
        if (this$bundle == null ? other$bundle != null : !this$bundle.equals(other$bundle)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Map<String, TensorInfo> this$inputSpecMap = this.getInputSpecMap();
        Map<String, TensorInfo> other$inputSpecMap = other.getInputSpecMap();
        if (this$inputSpecMap == null ? other$inputSpecMap != null : !((Object)this$inputSpecMap).equals(other$inputSpecMap)) {
            return false;
        }
        Map<String, TensorInfo> this$outputSpecMap = this.getOutputSpecMap();
        Map<String, TensorInfo> other$outputSpecMap = other.getOutputSpecMap();
        return !(this$outputSpecMap == null ? other$outputSpecMap != null : !((Object)this$outputSpecMap).equals(other$outputSpecMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof E2ELocalTFModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SavedModelBundle $bundle = this.getBundle();
        result = result * 59 + ($bundle == null ? 43 : $bundle.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Map<String, TensorInfo> $inputSpecMap = this.getInputSpecMap();
        result = result * 59 + ($inputSpecMap == null ? 43 : ((Object)$inputSpecMap).hashCode());
        Map<String, TensorInfo> $outputSpecMap = this.getOutputSpecMap();
        result = result * 59 + ($outputSpecMap == null ? 43 : ((Object)$outputSpecMap).hashCode());
        return result;
    }

    public String toString() {
        return "E2ELocalTFModel(bundle=" + this.getBundle() + ", path=" + this.getPath() + ", version=" + this.getVersion() + ", inputSpecMap=" + this.getInputSpecMap() + ", outputSpecMap=" + this.getOutputSpecMap() + ")";
    }
}

