package cn.com.duiba.nezha.alg.api.facade;

import cn.com.duiba.nezha.alg.api.dto.base.BaseAdvertDTO;
import cn.com.duiba.nezha.alg.api.dto.base.BaseRequestDTO;
import cn.com.duiba.nezha.alg.api.dto.base.BaseResult;

import java.util.List;
import java.util.Map;

/**
 * @author lijicong
 * @since 2021-08-18
 */
public interface TemplateFacade<Advert extends BaseAdvertDTO, Request extends BaseRequestDTO, Result extends BaseResult> {

    /**
     * 算法模板接口-传List返回List
     * @param adverts
     * @param request
     * @return
     */
    List<Result> execute(List<Advert> adverts, Request request);

    /**
     * 算法模板接口-传Map返回Map
     * @param adverts
     * @param request
     * @return
     */
    Map<String, Result> execute(Map<String, Advert> adverts, Request request);

    /**
     * 算法模板接口-单个处理
     * @param advert
     * @param request
     * @return
     */
    Result execute(Advert advert, Request request);

}
