/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.materialrecommend;

import cn.com.duiba.nezha.alg.common.model.materialrecommend.AlgUtils;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.Constant;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialDataInfo;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialMatchInfo;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialNormInfo;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialRankInfo;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.RankInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialRec20 {
    private static final Logger logger = LoggerFactory.getLogger(MaterialRec20.class);

    public static List<MaterialMatchInfo> match(List<MaterialDataInfo> materialList, List<MaterialNormInfo> exScks) {
        int i;
        double prob = Constant.PROB;
        double exposureThreshold = Constant.EXPOSURE_THRESHOLD;
        int topn = Constant.RECALL_TOPN;
        int exTopN = Constant.EXCELLENT_TOPN;
        if (materialList.size() == 0) {
            return null;
        }
        PriorityQueue<? super MatchInfo> gCandisCTR = new PriorityQueue<MatchInfo>(materialList.size(), AlgUtils.iComparator);
        PriorityQueue<? super MatchInfo> sCandisCTR = new PriorityQueue<MatchInfo>(materialList.size(), AlgUtils.iComparator);
        PriorityQueue<? super MatchInfo> gCandisUC = new PriorityQueue<MatchInfo>(materialList.size(), AlgUtils.iComparator);
        PriorityQueue<? super MatchInfo> sCandisUC = new PriorityQueue<MatchInfo>(materialList.size(), AlgUtils.iComparator);
        PriorityQueue<? super MatchInfo> normCandis = new PriorityQueue<MatchInfo>(exTopN, AlgUtils.normComparator);
        ArrayList<MaterialMatchInfo> result = new ArrayList<MaterialMatchInfo>();
        ArrayList<MaterialMatchInfo> sckModel = new ArrayList<MaterialMatchInfo>();
        double exposures = 0.0;
        double clicks = 0.0;
        double costs = 0.0;
        for (MaterialDataInfo mat2 : materialList) {
            exposures += mat2.getExposureCnt().getSlotVal();
            clicks += mat2.getClickCnt().getSlotVal();
            costs += mat2.getCost().getSlotVal();
        }
        double ctr = clicks / exposures;
        double uc = costs / exposures;
        HashMap<Long, MaterialNormInfo> exHashMap = new HashMap<Long, MaterialNormInfo>();
        if (exScks != null) {
            for (MaterialNormInfo exSck : exScks) {
                exHashMap.put(exSck.getMaterialId(), exSck);
            }
        }
        HashSet<Long> sckIds = new HashSet<Long>(exHashMap.keySet());
        HashSet hisSckIds = new HashSet(materialList.stream().map(MaterialDataInfo::getMaterialId).collect(Collectors.toSet()));
        HashSet<Long> idset = new HashSet<Long>();
        for (MaterialDataInfo materialDataInfo : materialList) {
            try {
                MaterialMatchInfo sckM = AlgUtils.fillData(materialDataInfo, sckIds, exHashMap);
                sckM.setCtr(ctr);
                sckM.setUc(uc);
                sckModel.add(sckM);
                if (sckM.exposureCnt.getGlobalVal() < exposureThreshold) {
                    if (System.currentTimeMillis() - materialDataInfo.createTime < 259200000L) {
                        if (Math.random() < prob) {
                            result.add(sckM);
                            --topn;
                            idset.add(sckM.materialId);
                        }
                    } else if (materialList.size() > topn && Math.random() < 0.1 * prob) {
                        result.add(sckM);
                        --topn;
                        idset.add(sckM.materialId);
                    }
                }
                double wctr = AlgUtils.getMatchScore(sckM.exposureCnt, sckM.clickCnt, 100.0, 1000.0, false);
                double wuc = AlgUtils.getMatchScore(sckM.exposureCnt, sckM.clickCnt, 100.0, 1000.0, true);
                if (sckM.isExcellent) {
                    MatchInfo emi = new MatchInfo();
                    emi.mat = sckM;
                    emi.score = sckM.score;
                    normCandis.add(emi);
                    continue;
                }
                MatchInfo wctrm = new MatchInfo();
                wctrm.mat = sckM;
                wctrm.score = wctr;
                gCandisCTR.add(wctrm);
                MatchInfo wucm = new MatchInfo();
                wucm.mat = sckM;
                wucm.score = wuc;
                gCandisUC.add(wucm);
                if (!(sckM.exposureCnt.getSlotVal() > 99.0) && !(sckM.clickCnt.getSlotVal() > 5.0)) continue;
                MatchInfo uctrm = new MatchInfo();
                uctrm.mat = sckM;
                uctrm.score = sckM.clickCnt.getSlotVal() / sckM.exposureCnt.getSlotVal();
                sCandisCTR.add(uctrm);
                MatchInfo uckmi = new MatchInfo();
                uckmi.mat = sckM;
                uckmi.score = sckM.cost.getSlotVal() / (100.0 * sckM.exposureCnt.getSlotVal());
                sCandisUC.add(uckmi);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        for (i = 0; i < Constant.RECALL_SCTR_TOPN && i < sCandisCTR.size(); ++i) {
            MaterialMatchInfo materialMatchInfo = ((MatchInfo)sCandisCTR.poll()).mat;
            if (idset.contains(materialMatchInfo.materialId)) continue;
            result.add(materialMatchInfo);
            idset.add(materialMatchInfo.materialId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_GCTR_TOPN && i < gCandisCTR.size(); ++i) {
            MaterialMatchInfo materialMatchInfo = ((MatchInfo)gCandisCTR.poll()).mat;
            if (idset.contains(materialMatchInfo.materialId)) continue;
            result.add(materialMatchInfo);
            idset.add(materialMatchInfo.materialId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_GUC_TOPN && i < gCandisUC.size(); ++i) {
            MaterialMatchInfo materialMatchInfo = ((MatchInfo)gCandisUC.poll()).mat;
            if (idset.contains(materialMatchInfo.materialId)) continue;
            result.add(materialMatchInfo);
            idset.add(materialMatchInfo.materialId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_SUC_TOPN && i < sCandisUC.size(); ++i) {
            MaterialMatchInfo materialMatchInfo = ((MatchInfo)sCandisUC.poll()).mat;
            if (idset.contains(materialMatchInfo.materialId)) continue;
            result.add(materialMatchInfo);
            idset.add(materialMatchInfo.materialId);
            --topn;
        }
        if (exScks != null) {
            for (MaterialNormInfo materialNormInfo : exScks) {
                if (hisSckIds.contains(materialNormInfo.getMaterialId())) continue;
                MatchInfo mci = new MatchInfo();
                MaterialMatchInfo aim = new MaterialMatchInfo();
                aim.setAppId(materialList.get(0).getAppId());
                aim.setSlotId(materialList.get(0).getSlotId());
                aim.setMaterialId(materialNormInfo.getMaterialId());
                aim.setnCtr(materialNormInfo.getnCtr());
                aim.setnPvCost(materialNormInfo.getnPvCost());
                aim.setScore(materialNormInfo.getScore());
                aim.setExcellent(true);
                mci.score = materialNormInfo.getScore();
                mci.mat = aim;
                normCandis.add(mci);
            }
            for (int i2 = 0; i2 < exTopN && i2 < normCandis.size(); ++i2) {
                MatchInfo matchInfo = (MatchInfo)normCandis.poll();
                if (idset.contains(matchInfo.mat.getMaterialId())) continue;
                result.add(matchInfo.mat);
                idset.add(matchInfo.mat.getMaterialId());
                --topn;
            }
        }
        return result;
    }

    public static MaterialRankInfo select(List<MaterialMatchInfo> matchInfos, List<MaterialRankInfo> materialModels) {
        HashMap map = new HashMap();
        if (matchInfos.size() == 0 || materialModels.size() == 0) {
            return null;
        }
        if (matchInfos.size() != materialModels.size()) {
            return null;
        }
        List<MaterialMatchInfo> matchInfoList = matchInfos.stream().sorted(Comparator.comparing(MaterialMatchInfo::getMaterialId).reversed()).collect(Collectors.toList());
        List<MaterialRankInfo> materialModelList = materialModels.stream().sorted(Comparator.comparing(MaterialRankInfo::getMaterialId).reversed()).collect(Collectors.toList());
        for (int i = 0; i < matchInfoList.size(); ++i) {
            long modelMaterailId;
            long intoMaterialId = ((MaterialMatchInfo)matchInfoList.get(i)).getMaterialId();
            if (intoMaterialId != (modelMaterailId = ((MaterialRankInfo)materialModelList.get(i)).getMaterialId())) {
                return null;
            }
            materialModelList.get(i).setMatchScore(matchInfoList.get(i).getMatchScore());
            materialModelList.get(i).setExcellent(matchInfoList.get((int)i).isExcellent);
            materialModelList.get(i).setnCtr(matchInfoList.get((int)i).nCtr);
            materialModelList.get(i).setScore(matchInfoList.get((int)i).score);
            materialModelList.get(i).setCtr(matchInfoList.get(i).getCtr());
            materialModelList.get(i).setUc(matchInfoList.get(i).getUc());
            materialModelList.get(i).setScore(matchInfoList.get(i).getScore());
        }
        ArrayList<RankInfo> ris = new ArrayList<RankInfo>();
        List<Object> mris = new ArrayList();
        mris = AlgUtils.getSingleOptCandis(ris, matchInfoList, materialModelList, Constant.ALG_CTR, 100, 100);
        MaterialDetail md = AlgUtils.selectMultiOptInfo(ris, matchInfoList, materialModelList);
        return materialModelList.get(md.index);
    }

    static class MaterialDetail {
        int index;
        ArrayList<RankInfo> condi;
        int strategyType;

        MaterialDetail() {
        }
    }

    static class MatchInfo {
        double score = 0.0;
        MaterialMatchInfo mat;

        MatchInfo() {
        }
    }

    static class Material {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;

        Material() {
        }
    }
}

