package cn.com.duiba.nezha.alg.common.model.slotmaterialselect;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

/**
 * Created by Administrator on 2019/2/18.
 */
public class SlotMaterialSelect {

    private static final Logger logger = LoggerFactory.getLogger(SlotMaterialSelect.class);

    static class Constant {
        static double MIN_REWARD = 0.3;
        static double DECAY = 0.99;  //200次以前的观察，无效
        static int SEARANK_TOPN = 30;
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }
    
    public static double getRate(double cnt, double partCnt){
        return cnt > 0 ? (partCnt < cnt ? partCnt / cnt : 0) : 0;
    }

    private double getCtr(double ... parms)
    {
        if(parms.length == 2){
            double exposure = parms[0];
            double click = parms[1];
            double ctr = getRate(exposure, click);
            return exposure > 5000 ? getRate(exposure, click) : Math.min(ctr, Constant.MIN_REWARD);
        }else if(parms.length == 3){
            double exposure = parms[0];
            double click =parms[1];
            double biasCtr = parms[2];
            double ctr = getRate(exposure, click);
            return ctr <= 2 * biasCtr ? (exposure > 5000 ? ctr : Math.min(ctr, Constant.MIN_REWARD)) : 0;
        }else{
            return 0;
        }
    }

    public double getWilsonCtr(double ... parms){
        if(parms.length == 2){
            double exposure = parms[0];
            double click = parms[1];
            double ctr = getCtr(exposure, click);
            return  WilsonInterval.wilsonCalc((long) (exposure * ctr), (long) exposure).lowerBound;
        }else if(parms.length == 3){
            double exposure = parms[0];
            double click = parms[1];
            double biasCtr = parms[2];
            double ctr = getCtr(exposure, click, biasCtr);
            return WilsonInterval.wilsonCalc((long) (exposure * ctr), (long) exposure).lowerBound;
        }else{
            return 0;
        }
    }

    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>() {

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return (int) (c2.matchScore - c1.matchScore >= 0 ? 1 : -1); //按score大小排序
        }
    };

    public static Comparator<MatchInfo> normComparator = new Comparator<MatchInfo>() {
        @Override
        public int compare(MatchInfo m1, MatchInfo m2) {
            return (int) (m2.nCtr - m1.nCtr >= 0 ? 1 : -1);
        }
    };

    /**
     *功能描述
     * SDK海选 1500-30
     * 广告位ctr+全局ctr+归一化ctr分别召回10个
     * prob 新素材试投概率 初版设为万分之一 0.0001
     * exposureThreshold 新素材试投曝光阈值 ，初版设为200
     * @author lijingzhe
     * @date 2019/7/11
     * @return java.util.List<cn.com.duiba.nezha.alg.common.model.slotmaterialselect.MatchInfo>
     */
    public  List<MatchInfo> matchSDK(List<SlotMaterialInfo> materialList) {
        //prob 新素材试投概率
        double prob = 0.0001;
        //exposureThreshold 新素材试投曝光阈值
        int exposureThreshold = 200;
        if (materialList.size()==0){
            return null;
        }

        Queue<MatchInfo> candis = new PriorityQueue<>(materialList.size(), iComparator);
        Queue<MatchInfo> slotCandis = new PriorityQueue<>(materialList.size(), iComparator);
        Queue<MatchInfo> normCandis = new PriorityQueue<>(materialList.size(), normComparator);
        List<MatchInfo> result = new ArrayList<MatchInfo>();
        // 归一化ctr初始map
        Map<Long,NormInfo> materialSet = new HashMap<>();
        // 初始化，归一化素材id是否曾出现在历史三天数据中，key为appId+slotId+materialId
        Map<AppSlot,HashSet<Long>> normMap = new HashMap<>();

        //初始化
        int topn = Constant.SEARANK_TOPN;
        HashSet<Long> idset = new HashSet();  //topn——id
        int limitTopn = topn;

        HashMap<Long,MatchInfo> mMap = new HashMap();
        //广告位点击和曝光
        HashMap<Long,SlotCtr> sMap = new HashMap();

        //去除广告位偏差(SDK广告位)
        for(SlotMaterialInfo m : materialList) {
            if(m.type == 1){
                long slot_id = m.slotId;
                //素材ctr<广告位素材ctr*1.2，7.24干掉
                SlotCtr sctr = sMap.getOrDefault(slot_id,new SlotCtr());
                double slotExposure = m.getExposureCnt().getSlotVal();
                double globalExposure = m.getExposureCnt().getGlobalVal();
                double slotClick = m.getClickCnt().getSlotVal();
                double globalClick = m.getClickCnt().getGlobalVal();
                sctr.click += slotClick;
                sctr.exposure += slotExposure;
                sMap.put(slot_id,sctr);
                //广告位和全局素材ctr<=0.5
                double slotCtr = getCtr(slotExposure, slotClick);
                double globalCtr = getCtr(globalExposure, globalClick);
//                double globalActivityCnt = m.activityCnt.globalVal;
//                double slotActivityCnt = m.activityCnt.slotVal;
//                double globalnPartRate = getRate(m.exposureCnt.globalVal, m.activityPartCnt.globalVal);
//                double slotnPartRate = getRate(m.exposureCnt.slotVal, m.activityPartCnt.slotVal);
                //计算素材在全局归一化ctr和活动参与率
                NormInfo nf = materialSet.containsKey(m.materialId) ? materialSet.get(m.materialId) : new NormInfo();
                nf.materialId = m.materialId;
                nf.nCtr = nf.nCtr + slotExposure/globalExposure * globalCtr/slotCtr;
//                nf.nPartRate = nf.nPartRate + slotActivityCnt/globalActivityCnt * globalnPartRate/slotnPartRate;
                materialSet.put(m.materialId, nf);
            }
        }

        //取全局top 30
        List<NormInfo> materials = new ArrayList<>(materialSet.values()).stream()
                .sorted(Comparator.comparing(NormInfo::getnCtr).reversed())
                .limit(30)
                .collect(Collectors.toList());

        //封装
        for (SlotMaterialInfo m : materialList) {
            AppSlot appSlot = new AppSlot();
            appSlot.setAppId(m.appId);
            appSlot.setSlotId(m.slotId);
            HashSet set1 = normMap.getOrDefault(appSlot, new HashSet<Long>());
            set1.add(m.materialId);
            normMap.put(appSlot,set1);

            try {
                double slotClick = m.getClickCnt().getSlotVal();
                double appClick = m.getClickCnt().getAppVal();
                double globalClick = m.getClickCnt().getGlobalVal();

                double slotExposure = m.getExposureCnt().getSlotVal();
                double appExposure = m.getExposureCnt().getAppVal();
                double globalExposure = m.getExposureCnt().getGlobalVal();

                MatchInfo info = mMap.containsKey(m.materialId) ? mMap.get(m.materialId) : new MatchInfo();
                fillMatchInfo(info, m);
                info.setnCtr(materialSet.get(m.materialId).nCtr);
//                info.setnPartRate(materialSet.get(m.materialId).nPartRate);
                double biasCtr = getRate(sMap.get(m.slotId).exposure, sMap.get(m.slotId).click);

                //新素材试投
                if (globalExposure < exposureThreshold) {
                    if(System.currentTimeMillis() -m.getCreateTime() < 60 * 1000 * 60 * 24 * 3) //上架时间小于三天
                    {
                        if (Math.random() < prob) {
                            result.add(info);
                            topn--; //占用一个名额
                            idset.add(info.materialId);
                        }
                    }
                    else if (materialList.size() > limitTopn) {
                        if (Math.random() < 0.1 * prob) {
                            result.add(info);
                            topn--;
                            idset.add(info.materialId);
                        }
                    }
                }

                //计算matchscore
                double slotScore = getWilsonCtr(slotExposure, slotClick, biasCtr);
                double matchscore = 0;
                //SDK计算全局ctr
                if(info.type == 1){
                    double globalScore = getWilsonCtr(globalExposure, globalClick);
                    double appScore = getWilsonCtr(appExposure, appClick);
                    double sconfidence = Math.min(slotExposure / 200, 1);
                    double aconfidence = Math.min(appExposure / 200, 1);
                    double gconfidence = Math.min(globalExposure / 2000, 1);
                    // SDK全局ctr、媒体ctr和广告位ctr有效
                    matchscore = sconfidence * slotScore
                            + (1 - sconfidence) * aconfidence * appScore * 0.9
                            + (1 - sconfidence - (1 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);
                    info.setMatchScore(matchscore);
                    candis.add(info);
                }

                mMap.put(m.materialId, info);

                if (slotExposure > 199 || slotClick > 60) { //广告位请求数大于199
                    // 或点击大于60
                    double matchScore3 = getCtr(slotExposure, slotClick, biasCtr);

                    MatchInfo info3=new MatchInfo();
                    fillMatchInfo(info3,m);
                    info3.setnCtr(materialSet.get(m.materialId).nCtr);
//                    info3.setnPartRate(materialSet.get(m.materialId).nPartRate);
                    info3.setMatchScore(matchScore3);
                    //广告位SDK放入队列
                    if(info3.type == 1){
                        slotCandis.add(info3);
                    }
                }
            } catch (Exception e)
            {
               logger.error("error,materialId: m.materialId= " +m.materialId);
               logger.error(e.getMessage(), e);
            }
        }

        //取前topn
        int slotCandiSize = slotCandis.size();

        for (int i = 0; i < 10 && i < slotCandiSize; i++) {
            MatchInfo infoSlot =  slotCandis.poll();
            if(idset.contains(infoSlot.materialId))
                continue;
            result.add(infoSlot);
            idset.add(infoSlot.materialId);
            topn-- ;
            if(result.size() >= limitTopn)
                break;
        }

        int candiSize = candis.size();

        for(Map.Entry<AppSlot,HashSet<Long>> entry : normMap.entrySet()){
            AppSlot appSlot = entry.getKey();
            Set<Long> set1 = entry.getValue();
            for(NormInfo nf : materials){
                if(!set1.contains(nf.materialId)){
                    MatchInfo mci = new MatchInfo();
                    mci.setAppId(appSlot.appId);
                    mci.setSlotId(appSlot.slotId);
                    mci.setMaterialId(nf.materialId);
                    mci.setnCtr(nf.nCtr);
//                    mci.setnPartRate(nf.nPartRate);
                    mci.setType(1);
                    normCandis.add(mci);
                }
            }
        }

        for (int i = 0; i < 10 && i < normCandis.size(); i++) {
            MatchInfo candisInfo =  normCandis.poll();
            candisInfo.setNorm(true);
            if(idset.contains(candisInfo.materialId))
                continue;
            result.add(candisInfo);
            idset.add(candisInfo.materialId);
            topn--;
            if(result.size()>=limitTopn)
                break;
        }

        int resultSize=result.size();

        for (int i = 0; resultSize < limitTopn && i < candiSize; i++) {
            MatchInfo candisInfo =  candis.poll();
            if(idset.contains(candisInfo.materialId))
                continue;
            result.add(candisInfo);
            resultSize = result.size();
            idset.add(candisInfo.materialId);   //凑齐topn个活动
            topn--;
            if(result.size()>=limitTopn)
                break;
        }

        return result;
    }

    /**
     *功能描述
     * API 海选 1500-30
     * 广告位ctr召回30个
     * prob 新素材试投概率 初版设为万分之一 0.0001
     * exposureThreshold 新素材试投曝光阈值 ，初版设为200
     * @author lijingzhe
     * @date 2019/7/11
     * @return java.util.List<cn.com.duiba.nezha.alg.common.model.slotmaterialselect.MatchInfo>
     */
    public  List<MatchInfo> matchAPI(List<SlotMaterialInfo> materialList){
        //prob 新素材试投概率
        double prob = 0.0001;
        //exposureThreshold 新素材试投曝光阈值
        int exposureThreshold = 200;

        if (materialList.size()==0){
            return null;
        }

        Queue<MatchInfo> candis = new PriorityQueue<>(materialList.size(), iComparator);
        Queue<MatchInfo> slotCandis = new PriorityQueue<>(materialList.size(), iComparator);
        List<MatchInfo> result = new ArrayList<MatchInfo>();

        int topn = Constant.SEARANK_TOPN;
        HashSet<Long> idset = new HashSet();
        int limitTopn = topn;

        HashMap<Long,MatchInfo> mMap = new HashMap();
        HashMap<Long,SlotCtr> sMap = new HashMap<>();

        for(SlotMaterialInfo m : materialList) {
            if(m.type == 2){
                long slot_id = m.slotId;
                SlotCtr sctr = sMap.getOrDefault(slot_id,new SlotCtr());
                double slotExposure = m.getExposureCnt().getSlotVal();
                double slotClick = m.getClickCnt().getSlotVal();
                sctr.click += slotClick;
                sctr.exposure += slotExposure;
                sMap.put(slot_id,sctr);
            }
        }

        for (SlotMaterialInfo m : materialList) {
            try {
                double slotClick = m.getClickCnt().getSlotVal();
                double appClick = m.getClickCnt().getAppVal();
                double globalClick = m.getClickCnt().getGlobalVal();

                double slotExposure = m.getExposureCnt().getSlotVal();
                double appExposure = m.getExposureCnt().getAppVal();
                double globalExposure = m.getExposureCnt().getGlobalVal();
                double biasCtr = getRate(sMap.get(m.slotId).exposure, sMap.get(m.slotId).click);

                MatchInfo info = mMap.containsKey(m.materialId) ? mMap.get(m.materialId) : new MatchInfo();
                fillMatchInfo(info, m);

                //新素材试投
                if (globalExposure < exposureThreshold) {
                    if(System.currentTimeMillis() -m.getCreateTime() < 60 * 1000 * 60 * 24 * 3) //上架时间小于三天
                    {
                        if (Math.random() < prob) {
                            result.add(info);
                            topn--;
                            idset.add(info.materialId) ;
                        }
                    }
                    else if (materialList.size() > limitTopn) {
                        if (Math.random() < 0.1 * prob) {
                            result.add(info);
                            topn--;
                            idset.add(info.materialId) ;
                        }
                    }
                }

                //计算matchscore
                double slotScore = getWilsonCtr(slotExposure, slotClick, biasCtr);
                double matchscore = 0;
                //API计算全局ctr
                if(info.type == 2){
                    double globalScore = getWilsonCtr(globalExposure, globalClick);
                    double appScore = getWilsonCtr(appExposure, appClick);
                    double sconfidence = Math.min(slotExposure / 200, 1);
                    double aconfidence = Math.min(appExposure / 200, 1);
                    double gconfidence = Math.min(globalExposure / 2000, 1);
                    //API全局ctr、媒体ctr和广告位ctr有效
                    matchscore = sconfidence * slotScore
                            + (1 - sconfidence) * aconfidence * appScore * 0.9
                            + (1 - sconfidence - (1 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);
                    info.setMatchScore(matchscore);
                    candis.add(info);
                }

                if (slotExposure > 199 || slotClick > 60) { //广告位请求数大于199
                    // 或点击大于60
                    double matchScore3 = getCtr(slotExposure, slotClick, biasCtr);
                    MatchInfo info3 = new MatchInfo();
                    fillMatchInfo(info3,m);
                    info3.setMatchScore(matchScore3);
                    //广告位API放入队列
                    if(info3.type == 2){
                        slotCandis.add(info3);
                    }
                }

                mMap.put(m.materialId, info);
            } catch (Exception e)
            {
                logger.error("error,materialId: m.materialId= " +m.materialId);
                logger.error(e.getMessage(), e);
            }
        }

        //取前topn
        int slotCandiSize = slotCandis.size();

        for (int i = 0; i < 10 && i < slotCandiSize; i++) {
            MatchInfo infoSlot =  slotCandis.poll();
            if(idset.contains(infoSlot.materialId))
                continue;
            result.add(infoSlot);
            idset.add(infoSlot.materialId);
            topn-- ;
            if(result.size()>=limitTopn)
                break;
        }

        int resultSize = result.size();
        for (int i = 0; resultSize < limitTopn && i < candis.size(); i++) {
            MatchInfo candisInfo =  candis.poll();
            if(idset.contains(candisInfo.materialId))
                continue;
            result.add(candisInfo);
            resultSize = result.size();
            idset.add(candisInfo.materialId);   //凑齐topn个活动
            topn--;
            if(result.size()>=limitTopn)
                break;
        }

        return result;
    }

    /**
     *功能描述
     * SDK优选 30-1
     * @author lijingzhe
     * @date 2019/7/11
     * @param matchInfos, materialModels
     * @return cn.com.duiba.nezha.alg.common.model.slotmaterialselect.SlotMaterialModel
     */
    public  SlotMaterialModel selectSDK(List<MatchInfo> matchInfos, List<SlotMaterialModel>  materialModels) {

        //1、两个列表为空，或者长度不一致,或者顺序不一致，报错,返回空值
        if (matchInfos.size() == 0 || materialModels.size() == 0) {
            return null;
        }

        if (matchInfos.size() != materialModels.size()) {
            return null;
        }

        List<MatchInfo> matchInfoList = sortByIdWithMatchInfo(matchInfos);
        List<SlotMaterialModel> materialModelList = sortByIdWithMaterials(materialModels);
        //归一化海选结果集
        List<MatchInfo> normInfos = new ArrayList<>();

        for (int i = 0; i < matchInfoList.size(); i++) {
            long intoMaterialId = matchInfoList.get(i).getMaterialId();
            long modelMaterailId = materialModelList.get(i).getMaterialId();
            if(matchInfoList.get(i).isNorm){
                normInfos.add(matchInfoList.get(i));
            }
            if (intoMaterialId != modelMaterailId) {
                return null;
            }
            materialModelList.get(i).matchScore = matchInfoList.get(i).matchScore;
        }

        //初始化
        double decay = Constant.DECAY;

        ArrayList<Double> counts = new ArrayList<>();
        ArrayList<Double> alphas = new ArrayList<>();
        ArrayList<Double> betas = new ArrayList<>();
        ArrayList<Double> matchscores = new ArrayList<>();
        ArrayList<Long> materials = new ArrayList<>();
        ArrayList<Integer> types = new ArrayList<>();
        ArrayList<Double> arpus = new ArrayList<>();

        List<SlotMaterialModel> modeCopyList = materialModelList;

        SlotMaterialModel result = new SlotMaterialModel();

        //计算回报
        List<MatchInfo> candiList = new ArrayList<>();

        try {
            for (int i = 0; i < matchInfoList.size(); i++) {
                MatchInfo info = matchInfoList.get(i);
                SlotMaterialModel model = materialModelList.get(i);
                SlotMaterialModel modelCopy = modeCopyList.get(i);

                if (info.exposureCnt.globalVal > 0) {
                    // 8.19 新增每pv消耗
                    double spc = Math.min(info.cost.slotVal / 200, 1);
                    double apc = Math.min(info.cost.appVal / 200, 1);
                    double gpc = Math.min(info.cost.globalVal / 1000, 1);

                    double spr = getRate(info.exposureCnt.slotVal, info.cost.slotVal);
                    double apr = getRate(info.exposureCnt.appVal, info.cost.appVal);
                    double gpr = getRate(info.exposureCnt.globalVal, info.cost.globalVal);

                    double arpu = spc * spr + (1 - spc) * apc * apr + (1 - spc - (1 - spc) * apc) * gpc * gpr;

                    double reward = 0.04;
                    double sConfidence = Math.min(info.exposureCnt.slotVal / 200, 1);
                    double aConfidence = Math.min(info.exposureCnt.appVal / 200, 1);
                    double gConfidence = Math.min(info.exposureCnt.globalVal / 2000, 1);
                    //素材点击率，7.19版本
                    double globalCtr = normlize(getCtr(info.exposureCnt.globalVal, info.clickCnt.globalVal) * 0.8, reward, 0.8);
                    double slotCtr = normlize(getCtr(info.exposureCnt.slotVal, info.clickCnt.slotVal) * 0.7, reward, 0.7);
                    double appCtr = normlize(getCtr(info.exposureCnt.appVal, info.clickCnt.appVal) * 0.5, reward, 0.6);

                    reward = sConfidence * slotCtr
                            + (1 - sConfidence) * aConfidence * appCtr
                            + (1 - sConfidence - (1 - sConfidence) * aConfidence) * gConfidence * globalCtr;


                    reward = reward * reward;
                    reward = Math.max(reward, 0);

                    modeCopyList.get(i).reward = modeCopyList.get(i).reward * decay + reward;
                    modeCopyList.get(i).count = modeCopyList.get(i).count * decay + 1.0;
                    modeCopyList.get(i).alpha =
                            0.25 + modeCopyList.get(i).reward;
                    modeCopyList.get(i).beta =
                            0.91 + (modeCopyList.get(i).count - modeCopyList.get(i).reward);

                    counts.add(modeCopyList.get(i).count);
                    alphas.add(modeCopyList.get(i).alpha);
                    betas.add(modeCopyList.get(i).beta);
                    matchscores.add(modeCopyList.get(i).matchScore);
                    materials.add(modeCopyList.get(i).materialId);
                    types.add(modeCopyList.get(i).type);
                    arpus.add(arpu);
                }
            }

            // select one
            int numMachines = alphas.size();
            if(numMachines > 0){
//                int bestSelect = selectMachine(alphas, betas, numMachines);
                int bestSelect = selectMachine(alphas, betas,matchscores, arpus, materials, types, numMachines);
//                int bestSelect = selectMachine(alphas, betas, rates, materials, types, numMachines);
                result = modeCopyList.get(bestSelect);
            }else{
                result.materialId = matchInfos.get(0).materialId;
                result.appId = matchInfos.get(0).appId;
                result.slotId = matchInfos.get(0).slotId;
                result.matchScore = matchInfos.get(0).matchScore;
            }

            if(Math.random() < 0.1 && normInfos.size() > 0){
//                double sum_nPartRate = 0;
//                for(MatchInfo nf : normInfos){
//                    sum_nPartRate += nf.nPartRate;
//                }
//                double avg_nPartRate = sum_nPartRate / normInfos.size();
                // 筛选归一化活动参与率>大盘均值 候选集再按照归一化ctr降序排
                MatchInfo norminfo = normInfos
                        .stream()
//                        .filter(e -> e.nPartRate > avg_nPartRate)
                        .sorted(Comparator.comparing(MatchInfo::getnCtr).reversed())
                        .collect(Collectors.toList()).get(0);
                SlotMaterialModel smi = new SlotMaterialModel();
                smi.setMaterialId(norminfo.materialId);
                smi.setSlotId(norminfo.slotId);
                smi.setAppId(norminfo.appId);
                smi.setType(norminfo.type);
                smi.setnCtr(norminfo.nCtr);
                smi.setnPartRate(norminfo.nPartRate);
                return smi;
            }else{
                return result;
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            logger.error("error, size:{},candi:{},list:{},", matchInfoList.size(), JSON.toJSONString(candiList), JSON.toJSONString(result));
        }
        return null;
    }


    /**
     *功能描述
     * API优选 30-1
     * @author lijingzhe
     * @date 2019/7/12
     * @param matchInfos, materialModels
     * @return cn.com.duiba.nezha.alg.common.model.slotmaterialselect.SlotMaterialModel
     */
    public  SlotMaterialModel selectAPI(List<MatchInfo> matchInfos, List<SlotMaterialModel>  materialModels) {
        HashMap<Long,SlotMaterialModel> map = new HashMap<>();
        //1、两个列表为空，或者长度不一致,或者顺序不一致，报错,返回空值
        if (matchInfos.size() == 0 || materialModels.size() == 0) {
            return null;
        }

        if (matchInfos.size() != materialModels.size()) {
            return null;
        }

        List<MatchInfo> matchInfoList = sortByIdWithMatchInfo(matchInfos);
        List<SlotMaterialModel> materialModelList = sortByIdWithMaterials(materialModels);

        for (int i = 0; i < matchInfoList.size(); i++) {
            long intoMaterialId = matchInfoList.get(i).getMaterialId();
            long modelMaterailId = materialModelList.get(i).getMaterialId();
            if (intoMaterialId != modelMaterailId) {
                return null;
            }
            materialModelList.get(i).matchScore = matchInfoList.get(i).matchScore;
        }

        //init
        double decay = Constant.DECAY;

        ArrayList<Double> counts = new ArrayList<>();
        ArrayList<Double> alphas = new ArrayList<>();
        ArrayList<Double> betas = new ArrayList<>();
        ArrayList<Double> matchscores = new ArrayList<>();
        ArrayList<Long> materials = new ArrayList<>();
        ArrayList<Integer> types = new ArrayList<>();
        ArrayList<Double> arpus = new ArrayList<>();

        List<SlotMaterialModel> modeCopyList = materialModelList;

        SlotMaterialModel result = new SlotMaterialModel();

        //计算回报
        List<MatchInfo> candiList = new ArrayList<>();

        try {
            for (int i = 0; i < matchInfoList.size(); i++) {
                MatchInfo info = matchInfoList.get(i);
                SlotMaterialModel model = materialModelList.get(i);
                SlotMaterialModel modelCopy = modeCopyList.get(i);

                if (info.exposureCnt.globalVal > 0 ) {
                    //活动参与率，7.22版本，业务硬性要求
                    double spc = Math.min(info.cost.slotVal / 200, 1);
                    double apc = Math.min(info.cost.appVal / 200, 1);
                    double gpc = Math.min(info.cost.globalVal / 1000, 1);

                    double spr = getRate(info.exposureCnt.slotVal, info.cost.slotVal);
                    double apr = getRate(info.exposureCnt.appVal, info.cost.appVal);
                    double gpr = getRate(info.exposureCnt.globalVal, info.cost.globalVal);

                    double arpu = spc * spr + (1 - spc) * apc * apr + (1 - spc - (1 - spc) * apc) * gpc * gpr;

                    double reward = 0.04;
                    //素材点击率，7.19版本
                    double sConfidence = Math.min(info.exposureCnt.slotVal / 200, 1);
                    double aConfidence = Math.min(info.exposureCnt.appVal / 200, 1);
                    double gConfidence = Math.min(info.exposureCnt.globalVal / 2000, 1);

                    double globalCtr = normlize(getCtr(info.exposureCnt.globalVal, info.clickCnt.globalVal) * 0.8, reward, 0.8);
                    double slotCtr = normlize(getCtr(info.exposureCnt.slotVal, info.clickCnt.slotVal) * 0.7, reward, 0.7);
                    double appCtr = normlize(getCtr(info.exposureCnt.appVal, info.clickCnt.appVal) * 0.5, reward, 0.6);

                    reward = sConfidence * slotCtr
                            + (1 - sConfidence) * aConfidence * appCtr
                            + (1 - sConfidence - (1 - sConfidence) * aConfidence) * gConfidence * globalCtr;


                    reward = reward * reward;
                    reward = Math.max(reward, 0);

                    modeCopyList.get(i).reward = modeCopyList.get(i).reward * decay + reward;
                    modeCopyList.get(i).count = modeCopyList.get(i).count * decay + 1.0;
                    modeCopyList.get(i).alpha =
                            0.25 + modeCopyList.get(i).reward;
                    modeCopyList.get(i).beta =
                            0.91 + (modeCopyList.get(i).count - modeCopyList.get(i).reward);

                    counts.add(modeCopyList.get(i).count);
                    alphas.add(modeCopyList.get(i).alpha);
                    betas.add(modeCopyList.get(i).beta);
                    matchscores.add(modeCopyList.get(i).matchScore);
                    materials.add(modeCopyList.get(i).materialId);
                    types.add(modeCopyList.get(i).type);
                    arpus.add(arpu);
                }
            }

            // 3 select one
            int numMachines = alphas.size();
            if(numMachines > 0){
//                int bestSelect = selectMachine(alphas, betas, numMachines);
                int bestSelect = selectMachine(alphas, betas, matchscores, arpus, materials, types, numMachines);
//            int bestSelect = selectMachine(alphas, betas, rates, materials, types, numMachines);

                result = modeCopyList.get(bestSelect);
                return result;
            }else{
                result.materialId = matchInfos.get(0).materialId;
                result.appId = matchInfoList.get(0).appId;
                result.slotId = matchInfoList.get(0).slotId;
                result.matchScore = matchInfoList.get(0).matchScore;
                return result;
            }


        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            logger.error("error, size:{},candi:{},list:{},", matchInfoList.size(), JSON.toJSONString(candiList), JSON.toJSONString(result));
        }
        return null;
    }

    private int selectMachine(List<Double> alphas, List<Double> betas,
                              List<Double> matchScore, List<Double> arpus,
                              List<Long> materials, List<Integer>types, int numMachines) {
        List<SelectInfo> selectInfos = new ArrayList<>();
        for (int i = 0; i < numMachines; i++) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            SelectInfo selectInfo = new SelectInfo();
            selectInfo.materialId = materials.get(i);
            selectInfo.index = i;
            selectInfo.matchscore = matchScore.get(i);
            selectInfo.arpu = arpus.get(i);
            selectInfo.reward = theta;
            selectInfo.type = types.get(i);
            selectInfos.add(selectInfo);
        }

        //先对活动参与率降序排过滤排名靠前一半，然后筛选点击率收益最高的素材索引
        SelectInfo info = selectInfos
                .stream()
                .sorted(Comparator.comparing(SelectInfo::getArpu).reversed())
                .limit((int)(numMachines/4 +1))
                .sorted(Comparator.comparing(SelectInfo::getReward).reversed())
//                .sorted(Comparator.comparing(SelectInfo::getRate).reversed().thenComparing(SelectInfo::getReward).reversed())
                .limit((int)(numMachines/8 +1))
                .sorted(Comparator.comparing(SelectInfo::getMatchscore).reversed())
                .collect(Collectors.toList()).get(0);
        return info.index;
    }

//        private int selectMachine(List<Double> alphas, List<Double> betas, List<Double> matchScore, List<Long> materials, List<Integer>types, int numMachines) {
//        List<SelectInfo> selectInfos = new ArrayList<>();
//        for (int i = 0; i < numMachines; i++) {
//            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
//            SelectInfo selectInfo = new SelectInfo();
//            selectInfo.materialId = materials.get(i);
//            selectInfo.matchscore = matchScore.get(i);
//            selectInfo.index = i;
//            selectInfo.reward = theta;
//            selectInfo.type = types.get(i);
//            selectInfos.add(selectInfo);
//        }
//
//        //先对活动参与率降序排过滤排名靠前一半，然后筛选点击率收益最高的素材索引
//        SelectInfo info = selectInfos
//                .stream()
//                .sorted(Comparator.comparing(SelectInfo::getReward).reversed())
//                .limit((int)(numMachines/2 +1))
//                .sorted(Comparator.comparing(SelectInfo::getMatchscore).reversed())
//                .collect(Collectors.toList()).get(0);
//
//        return info.index;
//    }

    private int selectMachine(List<Double> alphas, List<Double> betas,int numMachines) {
        int selectMachine = 0;
        double maxTheta = 0;
        for (int i = 0; i < numMachines; i++) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            if (theta > maxTheta) {
                maxTheta = theta;
                selectMachine = i;
            }
        }
        return selectMachine;
    }

    private void fillMatchInfo(MatchInfo info,SlotMaterialInfo m){
        info.setMaterialId(m.materialId);
        info.setMaterialTag(m.materialTag);
        info.setType(m.type);
        info.setAppId(m.appId);
        info.setSlotId(m.slotId);
        info.exposureCnt = new Val();
        info.exposureCnt.globalVal = m.getExposureCnt().globalVal;
        info.exposureCnt.slotVal = m.getExposureCnt().slotVal;
        info.exposureCnt.appVal = m.getExposureCnt().appVal;
        info.clickCnt = new Val();
        info.clickCnt.globalVal = m.getClickCnt().globalVal;
        info.clickCnt.slotVal = m.getClickCnt().slotVal;
        info.clickCnt.appVal = m.getClickCnt().appVal;
//        info.activityCnt = new Val();
//        info.activityCnt.globalVal = m.getActivityCnt().globalVal;
//        info.activityCnt.slotVal = m.getActivityCnt().slotVal;
//        info.activityCnt.appVal = m.getActivityCnt().appVal;
//        info.activityPartCnt = new Val();
//        info.activityPartCnt.globalVal = m.getActivityPartCnt().globalVal;
//        info.activityPartCnt.slotVal = m.getActivityPartCnt().slotVal;
//        info.activityPartCnt.appVal = m.getActivityPartCnt().appVal;
        info.setDiffTime(System.currentTimeMillis()-m.createTime);
        // 8.19 新增消耗数据
        info.cost = new Val();
        info.cost.globalVal = m.getCost().globalVal;
        info.cost.slotVal = m.getCost().slotVal;
        info.cost.appVal = m.getCost().appVal;
    }

    /**
     *功能描述
     * 按照素材id降序排
     * @author lijingzhe
     * @date 2019/7/12
     * @param infos
     * @return java.util.List<cn.com.duiba.nezha.alg.common.model.slotmaterialselect.MatchInfo>
     */
    private static List<MatchInfo> sortByIdWithMatchInfo(List<MatchInfo> infos){

        List<MatchInfo> info = infos;
        Collections.sort(info, new Comparator<MatchInfo>() {
            public int compare(MatchInfo info1, MatchInfo info2) {
                if(info1.materialId > info2.materialId) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return info;
    }

    /**
     *功能描述
     * 按照素材id降序排
     * @author lijingzhe
     * @date 2019/7/12
     * @param materials
     * @return java.util.List<cn.com.duiba.nezha.alg.common.model.slotmaterialselect.SlotMaterialModel>
     */
    private static List<SlotMaterialModel> sortByIdWithMaterials(List<SlotMaterialModel> materials){

        List<SlotMaterialModel> material = materials;
        Collections.sort(material, new Comparator<SlotMaterialModel>() {
            public int compare(SlotMaterialModel material1, SlotMaterialModel material2) {
                if(material1.materialId > material2.materialId) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return material;
    }

}
