/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.deeptarget;

import cn.com.duiba.nezha.alg.common.model.deeptarget.ConsumeInfo;
import cn.com.duiba.nezha.alg.common.model.deeptarget.DeepTargetInfo;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepTargetControl {
    private static final Logger logger = LoggerFactory.getLogger(DeepTargetControl.class);

    public static DeepTargetInfo getFactor(DeepTargetInfo info) {
        if (info == null) {
            return null;
        }
        double factor = 0.5 * info.getTargetCvr();
        double sdkFactor = 0.5 * info.getTargetCvr();
        if ((double)info.getAdDeepConvert().longValue() > Constant.THRESHOLD1 && info.getSelectFactor() != null) {
            double ratio;
            double selectFactor = info.getSelectFactor();
            double sdkSelectFactor = info.getSdkSelectFactor();
            double lastSelectFactor = info.getSelectFactor();
            double lastSdkSelectFactor = info.getSdkSelectFactor();
            if (info.getAdDCvr() < info.getTargetCvr()) {
                ratio = info.getAdDCvr() / info.getTargetCvr();
                factor = DeepTargetControl.getPredLevelFactor(info.getPreDcvrSum(), info.getPreDcvrPost(), info.getTargetCvr());
                sdkFactor = DeepTargetControl.getPredLevelFactor(info.getPreDcvrSum(), info.getPreDcvrPost(), info.getTargetCvr() * 1.2);
                selectFactor = factor / 100.0;
                selectFactor = Math.max(Math.min(selectFactor, 0.9), lastSelectFactor);
                sdkSelectFactor = sdkFactor / 100.0;
                sdkSelectFactor = Math.max(Math.min(sdkSelectFactor, 0.9), lastSdkSelectFactor);
            }
            if (info.getAdDCvr() > info.getTargetCvr()) {
                ratio = info.getTargetCvr() / info.getAdDCvr();
                selectFactor = lastSelectFactor * ratio;
                selectFactor = Math.max(Math.min(selectFactor, 1.0E-5), lastSelectFactor);
            }
            info.setSelectFactor(selectFactor);
            info.setSdkSelectFactor(sdkSelectFactor);
            System.out.println("selectFactor:  " + selectFactor);
            System.out.println("sdkSelectFactor:  " + sdkSelectFactor);
        }
        return info;
    }

    private static Double getLevelPostRatio(double target, double interval, Set<Double> preLevel, Map<Double, Long> preDcvrSum, Map<Double, Long> preDcvrPost) {
        double targetLevel = target % interval == 0.0 ? Math.floor(target / interval) * interval : Math.floor(target / interval) * interval + interval;
        double sum_preDcvrSum = (double)preDcvrSum.get(targetLevel).longValue() * (targetLevel - target) / interval;
        double sum_preDcvrPost = (double)preDcvrPost.get(targetLevel).longValue() * (targetLevel - target) / interval;
        for (Double level : preLevel) {
            if (!(targetLevel < level)) continue;
            sum_preDcvrSum += (double)preDcvrSum.get(level).longValue();
            sum_preDcvrPost += (double)preDcvrPost.get(level).longValue();
        }
        return sum_preDcvrPost / sum_preDcvrSum;
    }

    public static Double getPredLevelFactor(Map<Double, Long> preDcvrSum, Map<Double, Long> preDcvrPost, double target) {
        Set<Double> preLevel = preDcvrSum.keySet();
        double minLevel = 5.0;
        for (Double level : preLevel) {
            double ratio = level - target * 100.0;
            if (!(ratio >= 0.0) || !(ratio < 5.0)) continue;
            minLevel = level;
        }
        int interval = 5;
        int start = (int)minLevel;
        double ratio_minlevel = DeepTargetControl.getLevelPostRatio(target * 100.0, interval, preLevel, preDcvrSum, preDcvrPost);
        double minGap = Math.abs(target - ratio_minlevel);
        double targetLevel = minLevel;
        for (int i = start; i > 0; --i) {
            double postRatio = DeepTargetControl.getLevelPostRatio(i, interval, preLevel, preDcvrSum, preDcvrPost);
            if (!(Math.abs(postRatio - target) < minGap)) continue;
            targetLevel = i;
            minGap = Math.abs(postRatio - target);
        }
        return targetLevel;
    }

    public static ConsumeInfo getConsumeFactor(ConsumeInfo info) {
        double consume = info.getConsume().longValue();
        Double costConfWeight = DeepTargetControl.getConfidenceWeight(consume, Constant.costWeightBucket, Constant.costWeight, 0.5);
        Double costDayRatio = (double)info.getLastConsume().longValue() != 0.0 ? consume / (double)info.getLastConsume().longValue() : costConfWeight + 1.25;
        double costRatio = costConfWeight * costDayRatio;
        info.setConsumeFactor(costRatio);
        return info;
    }

    public static Double getConfidenceWeight(Double value, double[] bucketList, double[] weightList, double defaultValue) {
        Double ret = defaultValue;
        if (value != null && bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {
            double lastWeight = weightList[0];
            double lastBound = bucketList[0];
            int size = bucketList.length;
            for (int i = 0; i < size; ++i) {
                double curWeight = weightList[i];
                double curBound = bucketList[i];
                double bound = bucketList[i];
                if (value <= bound) {
                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                        break;
                    }
                    ret = weightList[0];
                    break;
                }
                if (i == size - 1) {
                    ret = weightList[size - 1];
                }
                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }
        }
        return DataUtil.formatDouble(ret, 3);
    }

    public static void main(String[] args) {
        HashMap<Double, Long> preDcvrSum = new HashMap<Double, Long>();
        HashMap<Double, Long> preDcvrPost = new HashMap<Double, Long>();
        preDcvrSum.put(5.0, 314314L);
        preDcvrSum.put(10.0, 141234L);
        preDcvrSum.put(15.0, 54030L);
        preDcvrSum.put(20.0, 23968L);
        preDcvrSum.put(25.0, 8349L);
        preDcvrSum.put(30.0, 3408L);
        preDcvrSum.put(35.0, 1783L);
        preDcvrSum.put(40.0, 869L);
        preDcvrSum.put(45.0, 573L);
        preDcvrSum.put(50.0, 399L);
        preDcvrSum.put(55.0, 287L);
        preDcvrSum.put(60.0, 284L);
        preDcvrSum.put(65.0, 210L);
        preDcvrSum.put(70.0, 164L);
        preDcvrSum.put(75.0, 185L);
        preDcvrSum.put(80.0, 414L);
        preDcvrSum.put(85.0, 1077L);
        preDcvrSum.put(90.0, 2401L);
        preDcvrSum.put(95.0, 2050L);
        preDcvrSum.put(100.0, 236L);
        preDcvrPost.put(5.0, 7489L);
        preDcvrPost.put(10.0, 9936L);
        preDcvrPost.put(15.0, 6577L);
        preDcvrPost.put(20.0, 4159L);
        preDcvrPost.put(25.0, 1860L);
        preDcvrPost.put(30.0, 914L);
        preDcvrPost.put(35.0, 546L);
        preDcvrPost.put(40.0, 278L);
        preDcvrPost.put(45.0, 239L);
        preDcvrPost.put(50.0, 176L);
        preDcvrPost.put(55.0, 135L);
        preDcvrPost.put(60.0, 161L);
        preDcvrPost.put(65.0, 126L);
        preDcvrPost.put(70.0, 103L);
        preDcvrPost.put(75.0, 135L);
        preDcvrPost.put(80.0, 357L);
        preDcvrPost.put(85.0, 947L);
        preDcvrPost.put(90.0, 2131L);
        preDcvrPost.put(95.0, 1864L);
        preDcvrPost.put(100.0, 221L);
        double ret = DeepTargetControl.getPredLevelFactor(preDcvrSum, preDcvrPost, 0.14);
        System.out.println(ret);
        DeepTargetInfo info = new DeepTargetInfo();
        info.setTargetCvr(0.14);
        info.setPreDcvrPost(preDcvrPost);
        info.setPreDcvrSum(preDcvrSum);
        info.setAdDeepConvert(100L);
        info.setAdDCvr(0.05);
        info.setSelectFactor(0.05);
        info.setSdkSelectFactor(0.05);
        DeepTargetControl.getFactor(info);
    }

    static class Constant {
        static double DEFAULT_FACTOR = 0.1;
        static double THRESHOLD1 = 20.0;
        static double THRESHOLD2 = 20.0;
        static double DEFAULT_P = 0.5;
        static double DEFAULT_I = 0.01;
        static double DEFAULT_D = 0.5;
        static double[] consumeBucket = new double[]{0.0, 100.0, 200.0, 50.0, 100.0, 200.0};
        static double[] consumeWeight = new double[]{0.0, 0.3, 0.5, 0.8, 1.0, 1.2};
        static double[] convertBucket = new double[]{0.0, 1.0, 2.0, 5.0, 10.0, 20.0};
        static double[] convertWeight = new double[]{0.0, 0.3, 0.5, 0.8, 1.0, 1.2};
        static double[] costWeightBucket = new double[]{0.0, 5000.0, 10000.0, 20000.0, 50000.0, 100000.0};
        static double[] costWeight = new double[]{0.0, 0.1, 0.2, 0.4, 0.6, 1.0};

        Constant() {
        }
    }
}

