package cn.com.duiba.nezha.alg.common.model.materialrecommend;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author lijingzhe
 * @description 算法工具类
 * @date 2019/12/12
 */
public class AlgUtils {

    static class Material {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;
    }

    static class MatchInfo{
        double score;
        MaterialMatchInfo mat;
    }

    static class MaterialDetail{
        int index;
        ArrayList<RankInfo> condi;
        int strategyType;
    }

    public static Comparator<? super MatchInfo> iComparator = new Comparator<MatchInfo>() {
        @Override
        public int compare(MatchInfo o1, MatchInfo o2) {
            return (o2.score >= o1.score ? 1 : -1);
        }
    };
    public static Comparator<? super MatchInfo> normComparator = new Comparator<MatchInfo>() {
        @Override
        public int compare(MatchInfo o1, MatchInfo o2) {
            return (o2.mat.score >= o1.score ? 1 : -1);
        }
    };

    public static double normlize(double val, double max, double limit) {
        double norm=Math.min(val * limit / max, limit);
        return norm;
    }

    /**
     * @author: lijingzhe
     * @date: 2019/12/17
     * @methodParameters:
     * @methodReturnType:
     * @description: 单一beta分布累积收益
     */
    public static List<MaterialRankInfo> getSingleOptCandis(List<RankInfo> ris, List<MaterialMatchInfo> matchInfoList, List<MaterialRankInfo> materialModelList, String oppAlg, int hthr, int athr) {
        // 素材曝光参数
        ArrayList<Double> exposures=new ArrayList<>();
        // ctr收益
        ArrayList<Double> rewards=new ArrayList<>();
        ArrayList<Double> counts=new ArrayList<>();
        // 贝塔分布alpha和beta
        ArrayList<Double> alphas=new ArrayList<>();
        ArrayList<Double> betas=new ArrayList<>();
        ArrayList<Long> materialIds=new ArrayList<>();
        // 每pv消耗
        ArrayList<Double> grpms=new ArrayList<>();
        ArrayList<Double> arpms=new ArrayList<>();
        ArrayList<Double> hrpms=new ArrayList<>();
        // ctr
        ArrayList<Double> ctrs=new ArrayList<>();
        // 每访问pv消耗
        ArrayList<Double> ucas = new ArrayList<>();
        // 每pv消耗
        ArrayList<Double> pvCosts=new ArrayList<>();
        // 是否是优质素材
        ArrayList<Boolean> excellents=new ArrayList<>();
        // 归一化score
        ArrayList<Double> scores=new ArrayList<>();

        List<MaterialRankInfo> candis = new ArrayList<>();

        Map<Long, Material> mMap = new HashMap<>();
        double maxG= Constant.MIN_REWARD, maxH= Constant.MIN_REWARD, maxA= Constant.MIN_REWARD;
        double minG=0, minH= Constant.MIN_REWARD, minA= Constant.MIN_REWARD;
        double oppH=0,oppA=0,oppG=0;
        double sconfidence=0,aconfidence=0;

        for (int i = 0; i < matchInfoList.size(); i++) {
            Material ml = mMap.getOrDefault(matchInfoList.get(i).getMaterialId(), new Material());
            if(oppAlg.equals(Constant.ALG_CTR)){
                oppG = matchInfoList.get(i).exposureCnt.getGlobalVal() > 0 ? matchInfoList.get(i).clickCnt.getGlobalVal()/matchInfoList.get(i).exposureCnt.getGlobalVal() : 0;
                ml.grpm = oppG;
                ml.gexp = matchInfoList.get(i).exposureCnt.getGlobalVal();
                maxG = Math.max(oppG, maxG);

                oppA = matchInfoList.get(i).exposureCnt.getAppVal() > 0 ? matchInfoList.get(i).clickCnt.getAppVal()/matchInfoList.get(i).exposureCnt.getAppVal() : 0;
                ml.arpm = oppA;
                ml.aexp = matchInfoList.get(i).exposureCnt.getAppVal();
                if(ml.aexp > athr){
                    maxA = Math.max(oppA, maxA);
                }
                minA = Math.min(oppA, minA);

                oppH = matchInfoList.get(i).exposureCnt.getSlotVal() > 0 ? matchInfoList.get(i).clickCnt.getSlotVal()/matchInfoList.get(i).exposureCnt.getSlotVal() : 0;
                ml.hrpm = oppH;
                ml.hexp = matchInfoList.get(i).exposureCnt.getSlotVal();
                if(ml.hexp > hthr){
                    maxH = Math.max(oppH, maxH);
                }
                minH = Math.min(oppH, minH);
                sconfidence = Math.min(matchInfoList.get(i).exposureCnt.getSlotVal() / hthr, 1);
                aconfidence = Math.min(matchInfoList.get(i).exposureCnt.getAppVal() / athr, 1);
            }else if(oppAlg.equals(Constant.ALG_UC)){
                oppG = matchInfoList.get(i).exposureCnt.getGlobalVal() > 0 ? matchInfoList.get(i).cost.getGlobalVal()/(100 * matchInfoList.get(i).exposureCnt.getGlobalVal()) : 0;
                ml.grpm = oppG;
                ml.gexp = matchInfoList.get(i).exposureCnt.getGlobalVal();
                maxG = Math.max(oppG, maxG);

                oppA = matchInfoList.get(i).exposureCnt.getAppVal() > 0 ? matchInfoList.get(i).cost.getAppVal()/(100 * matchInfoList.get(i).exposureCnt.getAppVal()) : 0;
                ml.arpm = oppA;
                ml.aexp = matchInfoList.get(i).exposureCnt.getAppVal();
                if(ml.aexp > athr){
                    maxA = Math.max(oppA, maxA);
                }
                minA = Math.min(oppA, minA);

                oppH = matchInfoList.get(i).exposureCnt.getSlotVal() > 0 ? matchInfoList.get(i).cost.getSlotVal()/(100 * matchInfoList.get(i).exposureCnt.getSlotVal()) : 0;
                ml.hrpm = oppH;
                ml.hexp = matchInfoList.get(i).exposureCnt.getSlotVal();
                if(ml.hexp > hthr){
                    maxH = Math.max(oppH, maxH);
                }
                minH = Math.min(oppH, minH);
                sconfidence = Math.min(matchInfoList.get(i).exposureCnt.getSlotVal() / hthr, 1);
                aconfidence = Math.min(matchInfoList.get(i).exposureCnt.getAppVal() / athr, 1);
            }else if(oppAlg.equals(Constant.ALG_UCA)){
                oppG = matchInfoList.get(i).request.getGlobalVal() > 0 ? matchInfoList.get(i).validClick.getGlobalVal()/matchInfoList.get(i).request.getGlobalVal() : 0;
                ml.grpm = oppG;
                ml.gexp = matchInfoList.get(i).request.getGlobalVal();
                maxG = Math.max(oppG, maxG);

                oppA = matchInfoList.get(i).request.getAppVal() > 0 ? matchInfoList.get(i).validClick.getAppVal()/matchInfoList.get(i).request.getAppVal() : 0;
                ml.arpm = oppA;
                ml.aexp = matchInfoList.get(i).request.getAppVal();
                if(ml.aexp > athr){
                    maxA = Math.max(oppA, maxA);
                }
                minA = Math.min(oppA, minA);

                oppH = matchInfoList.get(i).request.getSlotVal() > 0 ? matchInfoList.get(i).validClick.getSlotVal()/matchInfoList.get(i).request.getSlotVal() : 0;
                ml.hrpm = oppH;
                ml.hexp = matchInfoList.get(i).request.getSlotVal();
                if(ml.hexp > hthr){
                    maxH = Math.max(oppH, maxH);
                }
                minH = Math.min(oppH, minH);
                sconfidence = Math.min(matchInfoList.get(i).request.getSlotVal() / 50, 1);
                aconfidence = Math.min(matchInfoList.get(i).request.getAppVal() / 50, 1);
            }
            mMap.put(matchInfoList.get(i).getMaterialId(), ml);
        }

        double ctr = matchInfoList.get(0).ctr;
        double uc = matchInfoList.get(0).uc/100;
        double uca = matchInfoList.get(0).uca;
        for (int i = 0; i < matchInfoList.size(); i++) {
            double sCtr = matchInfoList.get(i).exposureCnt.getSlotVal() > 0 ? matchInfoList.get(i).clickCnt.getSlotVal()/matchInfoList.get(i).exposureCnt.getSlotVal() : 0;
            double sUca = matchInfoList.get(i).request.getSlotVal() > 0 ? matchInfoList.get(i).validClick.getSlotVal()/matchInfoList.get(i).request.getSlotVal() : 0;
            double sUc = matchInfoList.get(i).exposureCnt.getSlotVal() > 0 ? matchInfoList.get(i).cost.getSlotVal()/(100 * matchInfoList.get(i).exposureCnt.getSlotVal()) : 0;
            ctrs.add(sCtr);
            ucas.add(sUca);
            pvCosts.add(sUc);
            exposures.add(matchInfoList.get(i).exposureCnt.getSlotVal());
            double hrpm = mMap.get(matchInfoList.get(i).getMaterialId()).hrpm;
            double arpm = mMap.get(matchInfoList.get(i).getMaterialId()).arpm;
            double grpm = mMap.get(matchInfoList.get(i).getMaterialId()).grpm;
            hrpms.add(hrpm);
            arpms.add(arpm);
            grpms.add(grpm);
            excellents.add(matchInfoList.get(i).isExcellent);
            scores.add(matchInfoList.get(i).score);

            double reward= Constant.MIN_REWARD;

            reward=sconfidence * normlize( hrpm * 0.8, maxH, 0.8) +
                    (1 - sconfidence) * aconfidence * normlize(arpm * 0.7, maxA, 0.7) +
                    (1 - sconfidence - (1 - sconfidence) * aconfidence) * normlize(grpm * 0.5, maxG, 0.6);

            reward=reward * reward;

            reward=Math.max(reward, 0);

            materialModelList.get(i).reward=materialModelList.get(i).reward * Constant.DECAY+reward;
            materialModelList.get(i).count=materialModelList.get(i).count * Constant.DECAY+1.0;
            materialModelList.get(i).alpha=1.5+materialModelList.get(i).reward;
            materialModelList.get(i).beta=2.0+(materialModelList.get(i).count - materialModelList.get(i).reward);

            rewards.add(materialModelList.get(i).reward);
            counts.add(materialModelList.get(i).count);
            alphas.add(materialModelList.get(i).alpha);
            betas.add(materialModelList.get(i).beta);
            materialIds.add(materialModelList.get(i).materialId);
            candis.add(materialModelList.get(i));
        }
        mMap.clear();
        getSinfos(ris, candis.size(), alphas, betas, materialIds, exposures, excellents, scores, ctrs, pvCosts, ucas, ctr, uc, uca);
        return candis;
    }

    /**
     * @author: lijingzhe
     * @date: 2019/12/17
     * @methodParameters:
     * @methodReturnType:
     * @description: 对冲+试投，对冲仅对ctr比基准高20%，且每pv消耗低于基准80%
     */
    public static MaterialDetail selectMultiOptInfo(List<RankInfo> ris, List<MaterialMatchInfo> matchInfoList, List<MaterialRankInfo> materialModelList, String oppAlg) {
        MaterialDetail md = new MaterialDetail();
        if(ris.size() > 0){
            // 优质素材数量
            long excellentCnt = ris.stream().filter(e -> e.isExcellent()).count();
            // 优质素材扶持概率
            double avgFcProb = excellentCnt > 0 ? Constant.EXCELLENT_FC_PROB/excellentCnt : 0;
            List<RankInfo> ranks = ris.stream()
                    .sorted(Comparator.comparing(RankInfo::getReward).reversed())
                    .collect(Collectors.toList());

            md.condi = new ArrayList<>(ranks.subList(0, Math.min(ranks.size(),5)));
            // 投放次数>=100 && 投放次数<=500的素材，优质素材兜底
            for (int i = 0; i < ranks.size(); i++) {
                if(ranks.get(i).getExposure() < Constant.EXPOSURE_THRESHOLD){
                    if(ranks.get(i).isExcellent()){
                        // 优质素材以1%概率试投，合计5%
                        if(Math.random() < avgFcProb){
                            md.index = ranks.get(i).getIndex();
                            md.strategyType = 1;
                            break;
                        }
                    }else{
                        if(i > 0 && i < 5){
                            // 消耗高的素材以1%概率试投，合计试投概率4%
                            if(Math.random() < Constant.CTR_FC_PROB/4){
                                md.index = ranks.get(i).getIndex();
                                md.strategyType = 1;
                                break;
                            }
                        }
                    }
                }else if(ranks.get(i).getExposure() <= Constant.DD_THRESHOLD){
                    // 排名top 2-5 每个素材以0.5%概率随机投放
                    if(ranks.get(i).isExcellent() && i >1 && i < 5 && Math.random() < Constant.DD_PROB_HIGH/4){
                        md.index=ranks.get(i).getIndex();
                        md.strategyType = 2;
                        break;
                        // 排名top 5-15 每个素材以0.1%概率投放
                    }else if(ranks.get(i).isExcellent() && i < 15 && Math.random() < Constant.DD_PROB_MID/10) {
                        md.index = ranks.get(i).getIndex();
                        md.strategyType = 3;
                        break;
                    }
                }

                // ecpm or uv导向计费
                int feeMark = matchInfoList.get(0).getFeeMark();
                int algType = matchInfoList.get(0).getAlgType();
                if(algType == 4 && feeMark == 1){
                    if(ranks.get(i).getUca() > 1.2 * ranks.get(i).getSuca()){
                        if(ranks.get(i).getPvCost() < 0.8 * ranks.get(i).getsPvCost()){
                            md = getPairWise(matchInfoList, materialModelList, oppAlg, Constant.ALG_UC);
                            break;
                        }else if(ranks.get(i).getCtr() < 0.8 * ranks.get(i).getsCtr()){
                            md = getPairWise(matchInfoList, materialModelList, oppAlg, Constant.ALG_CTR);
                        }
                    }
                    if(ranks.get(i).getPvCost() >= 0.95 * ranks.get(i).getsPvCost()){
                        md.index = ranks.get(i).getIndex();
                        md.strategyType = 7;
                        break;
                    }
                }else{
                    // 真实cvr约束+真实uv券点击*真实cvr二次约束
                    if(ranks.get(i).getCtr() >= 0.95 * ranks.get(i).getsCtr()){
                        if(ranks.get(i).getPvCost() >= 0.95 * ranks.get(i).getsPvCost()){
                            //最优素材索引
                            md.index = ranks.get(i).getIndex();
                            //最大转化分
                            md.strategyType = 4;
                            break;
                        }
                        if(oppAlg.equals(Constant.ALG_CTR) && ranks.get(i).getCtr() > 1.2 * ranks.get(i).getsCtr()){
                            if(ranks.get(i).getPvCost() < 0.8 * ranks.get(i).getsPvCost()){
                                // 组合推荐
                                md = getPairWise(matchInfoList, materialModelList, oppAlg, Constant.ALG_UC);
                                break;
                            }
                        }
                    }
                }
            }

            if(md==null || md.strategyType == 0){
                List<RankInfo> rkf = ranks.stream()
                        .filter(e->e.getPvCost() >= 0.8 * e.getsPvCost())
                        .collect(Collectors.toList());
                md.index = ranks.get(0).getIndex();
                md.condi = new ArrayList<>(ranks.subList(0, Math.min(ranks.size(), 5)));
                md.strategyType = 6;
            }
        }else{
            md.index = 0;
            md.condi = new ArrayList<>();
            md.strategyType = 0;
        }
        return md;
    }

    /**
     * @author: lijingzhe
     * @date: 2019/12/17
     * @methodParameters:
     * @methodReturnType:
     * @description: 每pv消耗对冲
     */
    public static MaterialDetail getPairWise(List<MaterialMatchInfo> matchInfoList, List<MaterialRankInfo> materialModelList, String oppAlg, String oppAlgN) {
        MaterialDetail md = new MaterialDetail();
        int feeMark = matchInfoList.get(0).getFeeMark();
        int algType = matchInfoList.get(0).getAlgType();
//        String oppAlgN = oppAlg.equals(Constant.ALG_UC) ? Constant.ALG_CTR : Constant.ALG_UC;
        // 获取key
        List<RankInfo> ris = new ArrayList<>();
        List<MaterialRankInfo> mris = getSingleOptCandis(ris, matchInfoList, materialModelList, oppAlgN, 100 ,100);
        if(mris.size() > 0){
            List<RankInfo> uc_ranks = ris.stream()
                    .sorted(Comparator.comparing(RankInfo::getReward).reversed())
                    .collect(Collectors.toList());
            if(feeMark == 1 && algType == 4){
                List<RankInfo> uca_ranks = uc_ranks.stream()
                        .filter(e->e.getUca() >= 0.95 * e.getSuca())
                        .collect(Collectors.toList());
                md.index = uca_ranks.get(0).getIndex();
                md.strategyType = 8;
            }else{
                md.index = uc_ranks.get(0).getIndex();
                md.strategyType = 5;
            }
        }

        return md;
    }

    /**
     * @author: lijingzhe
     * @date: 2019/12/17
     * @methodParameters:
     * @methodReturnType:
     * @description: 封装
     */
    public static void getSinfos(List<RankInfo> ris, int numMachines, ArrayList<Double> alphas, ArrayList<Double> betas, ArrayList<Long> materialIds, ArrayList<Double> exposures, ArrayList<Boolean> excellents, ArrayList<Double> scores, ArrayList<Double> ctrs, ArrayList<Double> pvCosts, ArrayList<Double> ucas, double ctr, double uc, double uca) {
        for (int i=0; i < numMachines; i++) {
            double theta= BetaDist(alphas.get(i), betas.get(i));
            RankInfo rankInfo=new RankInfo();
            rankInfo.setReward(theta);
            rankInfo.setIndex(i);
            rankInfo.setMaterialId(materialIds.get(i));
            rankInfo.setExposure(exposures.get(i));
            rankInfo.setExcellent(excellents.get(i));
            rankInfo.setScores(scores.get(i));
            rankInfo.setCtr(ctrs.get(i));
            rankInfo.setUca(ucas.get(i));
            rankInfo.setPvCost(pvCosts.get(i));
            rankInfo.setsCtr(ctr);
            rankInfo.setSuca(uca);
            rankInfo.setsPvCost(uc);
            ris.add(rankInfo);
        }
    }

    /**
     * @author: lijingzhe
     * @date: 2019/12/17
     * @methodParameters:
     * @methodReturnType:
     * @description: 封装数据
     */
    public static MaterialMatchInfo fillData(MaterialDataInfo mat, Set<Long> sckIds, Map<Long, MaterialNormInfo> exHashMap) {
        MaterialMatchInfo sckM = new MaterialMatchInfo();
        sckM.algType = mat.algType;
        sckM.slotId = mat.slotId;
        sckM.appId = mat.appId;
        sckM.materialId = mat.materialId;
        sckM.feeMark = mat.feeMark;
        sckM.setExcellent(sckIds.contains(mat.materialId));

        sckM.exposureCnt = new MaterialVal();
        sckM.exposureCnt.setAlgSlotVal(mat.exposureCnt.getAlgSlotVal());
        sckM.exposureCnt.setSlotVal(mat.exposureCnt.getSlotVal());
        sckM.exposureCnt.setAppVal(mat.exposureCnt.getAppVal());
        sckM.exposureCnt.setGlobalVal(mat.exposureCnt.getGlobalVal());

        sckM.clickCnt = new MaterialVal();
        sckM.clickCnt.setAlgSlotVal(mat.clickCnt.getAlgSlotVal());
        sckM.clickCnt.setSlotVal(mat.clickCnt.getSlotVal());
        sckM.clickCnt.setAppVal(mat.clickCnt.getAppVal());
        sckM.clickCnt.setGlobalVal(mat.clickCnt.getGlobalVal());

        sckM.request = new MaterialVal();
        sckM.request.setAlgSlotVal(mat.request.getAlgSlotVal());
        sckM.request.setSlotVal(mat.request.getSlotVal());
        sckM.request.setAppVal(mat.request.getAppVal());
        sckM.request.setGlobalVal(mat.request.getGlobalVal());

        sckM.cost = new MaterialVal();
        sckM.cost.setAlgSlotVal(mat.cost.getAlgSlotVal());
        sckM.cost.setSlotVal(mat.cost.getSlotVal());
        sckM.cost.setAppVal(mat.cost.getAppVal());
        sckM.cost.setGlobalVal(mat.cost.getGlobalVal());

        sckM.validClick = new MaterialVal();
        sckM.validClick.setAlgSlotVal(mat.validClick.getAlgSlotVal());
        sckM.validClick.setSlotVal(mat.validClick.getSlotVal());
        sckM.validClick.setAppVal(mat.validClick.getAppVal());
        sckM.validClick.setGlobalVal(mat.validClick.getGlobalVal());

        sckM.nCtr = exHashMap.getOrDefault(mat.getMaterialId(), new MaterialNormInfo()).getnCtr();
        sckM.nPvCost = exHashMap.getOrDefault(mat.getMaterialId(), new MaterialNormInfo()).getnPvCost();
        sckM.score = exHashMap.getOrDefault(mat.getMaterialId(), new MaterialNormInfo()).getScore();
        return sckM;
    }

    /**
     * @author: lijingzhe
     * @date: 2019/12/17
     * @methodParameters:
     * @methodReturnType:
     * @description: 计算融合海选得分
     */
    public static double getMatchScore(MaterialVal num, MaterialVal den, Double thr1, Double thr2, Boolean isUC) {
        double slotScore=WilsonInterval.wilsonCalc(num.getSlotVal(), den.getSlotVal()).lowerBound;
        double globalScore=WilsonInterval.wilsonCalc(num.getGlobalVal(), den.getGlobalVal()).lowerBound;
        double appScore=WilsonInterval.wilsonCalc(num.getAppVal(), den.getAppVal()).lowerBound;
        if(isUC){
            slotScore=WilsonInterval.wilsonCalc(num.getSlotVal(), den.getSlotVal()/100).lowerBound;
            globalScore=WilsonInterval.wilsonCalc(num.getGlobalVal(), den.getGlobalVal()/100).lowerBound;
            appScore=WilsonInterval.wilsonCalc(num.getAppVal(), den.getAppVal()/100).lowerBound;
        }

        double sconfidence=Math.min(den.getSlotVal() / thr1, 1);
        double aconfidence=Math.min(den.getAppVal() / thr1, 1);
        double gconfidence=Math.min(den.getGlobalVal() / thr2, 1);

        double matchscore=sconfidence * slotScore
                +(1 - sconfidence) * aconfidence * appScore * 0.9
                +(1 - sconfidence - (1 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);

        return matchscore;
    }

    public static WilsonPair wilsonCalc(double numerator, double denominator){
        if(denominator == 0)
            return new WilsonPair(0, 0);
        numerator = numerator > denominator ? denominator : numerator;
        double z = 1.6;         //置信度95%
        double phat = (numerator)/denominator;
        double denorm = 1. + (z*z/denominator);
        double enum1 = phat + z*z/(2*denominator);
        double enum2 = z*Math.sqrt(phat*(1-phat)/denominator + z*z/(4*denominator*denominator));
        return new WilsonPair((enum1-enum2)/denorm, (enum1+enum2)/denorm);
    }

    /**
     * @author: lijingzhe
     * @date: 2019/12/17
     * @methodParameters:
     * @methodReturnType:
     * @description: beta分布
     */
    public static double BetaDist(double alpha, double beta) {
        double a = alpha + beta;
        double b = Math.sqrt((a - 2) / (2 * alpha * beta - a));
        if (Math.min(alpha, beta) <= 1) {
            b = Math.max(1 / alpha, 1 / beta);
        }
        double c = alpha + 1 / b;
        double W = 0;
        boolean reject = true;
        while (reject) {
            double U1 = Math.random();
            double U2 = Math.random();
            double V = b * Math.log(U1 / (1 - U1));
            W = alpha * Math.exp(V);
            reject = (a * Math.log(a / (beta + W)) + c * V - Math.log(4)) < Math.log(U1 * U1 * U2);
        }
        return (W / (beta + W));
    }
}
