/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.advertexplore;

import cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcbData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreParams;
import cn.com.duiba.nezha.alg.common.model.advertexplore.UcbResult;
import java.util.HashMap;
import java.util.Map;

public class AdExploreUcb {
    public static Double concatUcb(Double val1, Double val2, Double explore1, Double explore2) {
        return val1 == null || val2 == null || explore1 == null || explore2 == null ? 0.0 : val1 + val2 + explore1 + explore2;
    }

    public static Double division(Long v1, Long v2) {
        return v1 != null && v2 != null && v2 != 0L ? v1.doubleValue() / v2.doubleValue() : 0.0;
    }

    public static Double division(Double v1, Long v2) {
        return v1 != null && v2 != null && v2 != 0L ? v1 / v2.doubleValue() : 0.0;
    }

    public static Double dot(Long v1, Long v2) {
        return v1 != null && v2 != null ? v1.doubleValue() / v2.doubleValue() : 0.0;
    }

    public static Double dot(Double v1, Double v2) {
        return v1 != null && v2 != null ? v1 / v2 : 0.0;
    }

    public static Map<Long, UcbResult> calcUcb(ExploreData app3dRt, AdExploreUcbData adExploreUcbData, ExploreParams params) {
        HashMap<Long, UcbResult> tradeUcb = new HashMap<Long, UcbResult>();
        double appWeight = 1.0;
        if (adExploreUcbData.getTest3dRt() != null && adExploreUcbData.getAppTest3dRt() != null) {
            appWeight = Math.sqrt(Math.log(adExploreUcbData.getTest3dRt().longValue()) / (double)(adExploreUcbData.getAppTest3dRt().getExposure() + 1L)) * params.getUcbAlpha3();
        }
        if (app3dRt != null) {
            Map<Long, ExploreData> acc3dRt;
            double appCtr = AdExploreUcb.division(app3dRt.getClick(), app3dRt.getExposure()) + (app3dRt.getExposure() > params.getAppExposeCnt() ? 0.0 : 0.5 / (Math.log(app3dRt.getExposure().longValue()) + 1.0) - params.getAppSmooth());
            HashMap<Integer, Double> appConv = new HashMap<Integer, Double>();
            Map<Integer, Long> appCvr = app3dRt.getConv();
            if (appCvr != null) {
                for (Map.Entry<Integer, Long> objConv : appCvr.entrySet()) {
                    appConv.put(objConv.getKey(), AdExploreUcb.division(objConv.getValue(), app3dRt.getClick()));
                }
            }
            if ((acc3dRt = adExploreUcbData.getAppAcc3dRt()) != null) {
                for (Map.Entry<Long, ExploreData> at3dRt : acc3dRt.entrySet()) {
                    double accWeight = Math.sqrt(AdExploreUcb.division(adExploreUcbData.getAppTest3dRt().getExposure(), (Long)(at3dRt.getValue().getExposure() + 1L))) * params.getUcbAlpha4();
                    double concatCtr = AdExploreUcb.concatUcb(params.getUcbAlpha1() * appCtr, params.getUcbAlpha2() * AdExploreUcb.division(at3dRt.getValue().getClick(), at3dRt.getValue().getExposure()) + (at3dRt.getValue().getExposure() > params.getAppAccExposeCnt() ? 0.0 : 0.5 / (Math.log(at3dRt.getValue().getExposure().longValue()) + 1.0) - params.getAppAccSmooth()), appWeight, accWeight);
                    HashMap<Integer, Double> result = new HashMap<Integer, Double>();
                    HashMap<Integer, Double> resultS1 = new HashMap<Integer, Double>();
                    HashMap<Integer, Double> resultS2 = new HashMap<Integer, Double>();
                    for (Map.Entry<Integer, Long> objConv : at3dRt.getValue().getConv().entrySet()) {
                        double concatCvr = AdExploreUcb.concatUcb(AdExploreUcb.dot(params.getUcbAlpha1(), (Double)appConv.get(objConv.getKey())), AdExploreUcb.dot(params.getUcbAlpha2(), AdExploreUcb.division(objConv.getValue(), at3dRt.getValue().getClick())), appWeight, accWeight);
                        result.put(objConv.getKey(), concatCtr * concatCvr);
                        resultS1.put(objConv.getKey(), concatCtr);
                        resultS2.put(objConv.getKey(), concatCvr);
                    }
                    UcbResult ucbResult = new UcbResult();
                    ucbResult.setObjUcb(result);
                    ucbResult.setObjUcbScore1(resultS1);
                    ucbResult.setObjUcbScore2(resultS2);
                    tradeUcb.put(at3dRt.getKey(), ucbResult);
                }
            }
        }
        return tradeUcb;
    }

    public static void main(String[] args) {
        AdExploreUcb.test3();
    }

    public static void test1() {
        HashMap<Integer, Long> conv = new HashMap<Integer, Long>();
        conv.put(0, 1000L);
        conv.put(2, 500L);
        conv.put(3, 250L);
        ExploreData app3dRt = new ExploreData();
        app3dRt.setExposure(100000L);
        app3dRt.setClick(10000L);
        app3dRt.setConv(conv);
        conv = new HashMap();
        conv.put(0, 500L);
        conv.put(2, 100L);
        conv.put(3, 50L);
        ExploreData account1 = new ExploreData();
        account1.setExposure(5000L);
        account1.setClick(2500L);
        account1.setConv(conv);
        conv = new HashMap();
        conv.put(0, 5L);
        conv.put(2, 5L);
        conv.put(3, 2L);
        ExploreData account2 = new ExploreData();
        account2.setExposure(2000L);
        account2.setClick(100L);
        account2.setConv(conv);
        HashMap<Long, ExploreData> appAcc = new HashMap<Long, ExploreData>();
        appAcc.put(1L, account1);
        appAcc.put(2L, account2);
        AdExploreUcbData adExploreUcbData = new AdExploreUcbData();
        adExploreUcbData.setAppAcc3dRt(appAcc);
        adExploreUcbData.setTest3dRt(200000L);
        ExploreData appTest = new ExploreData();
        appTest.setExposure(10000L);
        adExploreUcbData.setAppTest3dRt(appTest);
        ExploreData appAccTest1 = new ExploreData();
        appAccTest1.setExposure(5000L);
        ExploreData appAccTest2 = new ExploreData();
        appAccTest2.setExposure(200L);
        HashMap<Long, ExploreData> appAccTest = new HashMap<Long, ExploreData>();
        appAccTest.put(1L, appAccTest1);
        appAccTest.put(2L, appAccTest2);
        adExploreUcbData.setAppAccTest3dRt(appAccTest);
        ExploreParams exploreParams = new ExploreParams();
        exploreParams.setUcbAlpha1(0.2);
        exploreParams.setUcbAlpha2(0.8);
        exploreParams.setUcbAlpha3(0.004);
        exploreParams.setUcbAlpha4(0.016);
        exploreParams.setAppAccExposeCnt(100L);
        exploreParams.setAppExposeCnt(1000L);
        Map<Long, UcbResult> result = AdExploreUcb.calcUcb(app3dRt, adExploreUcbData, exploreParams);
        for (Map.Entry<Long, UcbResult> entry : result.entrySet()) {
            System.out.println("Result: " + entry.getKey() + ", " + entry.getValue());
        }
    }

    public static void test2() {
        HashMap<Integer, Long> conv = new HashMap<Integer, Long>();
        conv.put(0, 1000L);
        conv.put(2, 500L);
        conv.put(3, 250L);
        ExploreData app3dRt = new ExploreData();
        app3dRt.setExposure(100000L);
        app3dRt.setClick(10000L);
        app3dRt.setConv(conv);
        conv = new HashMap();
        conv.put(0, 500L);
        conv.put(2, 100L);
        conv.put(3, 50L);
        ExploreData account1 = new ExploreData();
        account1.setExposure(5000L);
        account1.setClick(2500L);
        account1.setConv(conv);
        conv = new HashMap();
        conv.put(0, 5L);
        conv.put(2, 5L);
        conv.put(3, 2L);
        ExploreData account2 = new ExploreData();
        account2.setExposure(5000L);
        account2.setClick(100L);
        account2.setConv(conv);
        HashMap<Long, ExploreData> appAcc = new HashMap<Long, ExploreData>();
        appAcc.put(1L, account1);
        appAcc.put(2L, account2);
        AdExploreUcbData adExploreUcbData = new AdExploreUcbData();
        adExploreUcbData.setAppAcc3dRt(appAcc);
        adExploreUcbData.setTest3dRt(200000L);
        ExploreData appTest = new ExploreData();
        appTest.setExposure(10000L);
        adExploreUcbData.setAppTest3dRt(appTest);
        ExploreData appAccTest1 = new ExploreData();
        appAccTest1.setExposure(5000L);
        ExploreData appAccTest2 = new ExploreData();
        appAccTest2.setExposure(200L);
        HashMap<Long, ExploreData> appAccTest = new HashMap<Long, ExploreData>();
        appAccTest.put(1L, appAccTest1);
        appAccTest.put(2L, appAccTest2);
        adExploreUcbData.setAppAccTest3dRt(appAccTest);
        ExploreParams exploreParams = new ExploreParams();
        exploreParams.setUcbAlpha1(0.2);
        exploreParams.setUcbAlpha2(0.8);
        exploreParams.setUcbAlpha3(0.004);
        exploreParams.setUcbAlpha4(0.016);
        exploreParams.setAppAccExposeCnt(100L);
        exploreParams.setAppExposeCnt(1000L);
        Map<Long, UcbResult> result = AdExploreUcb.calcUcb(app3dRt, adExploreUcbData, exploreParams);
        for (Map.Entry<Long, UcbResult> entry : result.entrySet()) {
            System.out.println("Result: " + entry.getKey() + ", " + entry.getValue());
        }
    }

    public static void test3() {
        HashMap<Integer, Long> conv = new HashMap<Integer, Long>();
        conv.put(0, 1000L);
        conv.put(2, 500L);
        conv.put(3, 250L);
        ExploreData app3dRt = new ExploreData();
        app3dRt.setExposure(100000L);
        app3dRt.setClick(10000L);
        app3dRt.setConv(conv);
        conv = new HashMap();
        conv.put(0, 0L);
        conv.put(2, 0L);
        conv.put(3, 0L);
        ExploreData account1 = new ExploreData();
        account1.setExposure(5000L);
        account1.setClick(0L);
        account1.setConv(conv);
        conv = new HashMap();
        conv.put(0, 0L);
        conv.put(2, 0L);
        conv.put(3, 0L);
        ExploreData account2 = new ExploreData();
        account2.setExposure(5000L);
        account2.setClick(50L);
        account2.setConv(conv);
        HashMap<Long, ExploreData> appAcc = new HashMap<Long, ExploreData>();
        appAcc.put(1L, account1);
        appAcc.put(2L, account2);
        AdExploreUcbData adExploreUcbData = new AdExploreUcbData();
        adExploreUcbData.setAppAcc3dRt(appAcc);
        adExploreUcbData.setTest3dRt(200000L);
        ExploreData appTest = new ExploreData();
        appTest.setExposure(10000L);
        adExploreUcbData.setAppTest3dRt(appTest);
        ExploreData appAccTest1 = new ExploreData();
        appAccTest1.setExposure(5000L);
        ExploreData appAccTest2 = new ExploreData();
        appAccTest2.setExposure(5000L);
        HashMap<Long, ExploreData> appAccTest = new HashMap<Long, ExploreData>();
        appAccTest.put(1L, appAccTest1);
        appAccTest.put(2L, appAccTest2);
        adExploreUcbData.setAppAccTest3dRt(appAccTest);
        ExploreParams exploreParams = new ExploreParams();
        exploreParams.setUcbAlpha1(0.2);
        exploreParams.setUcbAlpha2(0.8);
        exploreParams.setUcbAlpha3(0.004);
        exploreParams.setUcbAlpha4(0.016);
        exploreParams.setAppAccExposeCnt(100L);
        exploreParams.setAppExposeCnt(1000L);
        Map<Long, UcbResult> result = AdExploreUcb.calcUcb(app3dRt, adExploreUcbData, exploreParams);
        for (Map.Entry<Long, UcbResult> entry : result.entrySet()) {
            System.out.println("Result: " + entry.getKey() + ", " + entry.getValue());
        }
    }
}

