package cn.com.duiba.nezha.alg.common.model.advertexplore;

import com.alibaba.fastjson.JSON;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class ExploreV1Params {
    private double filterRatio = 0.3; // 媒体过滤比例

    private double faithLevel = 2;  // 置信等级

    private Long orientExpThreshold = 2000L;    // 配置维度的曝光数量上限

    // CTR
    // 默认值按照(150,0.5),(300,0.9)设置
    private double ctrWeightThreshold = 0.9;  // ctr单个维度上的权重阈值
    private double thetaCtr=0.014;   // 线性函数参数
    private double betaCtr=2.2;    // 偏移参数

    // CVR
    // 默认值按照(200,0.5),(400,0.9)设置
    private double cvrWeightThreshold = 0.7;  // cvr单个维度上的权重阈值
    private double thetaCvr=0.011;   // 线性函数参数
    private double betaCvr=2.2;    // 偏移参数

    // COST
    private long costExpThreshold = Long.MAX_VALUE;  // 成本偏差，数量置信阈值, 默认为Long的最大值，此时成本权重不生效（为1）
    private double costWeightThreshold = 0.1;   // 成本权重上限，取值[1 - value, 1 + value]

    // NUM，默认值按(100, 0.08), (300, 0.001)设置
    private double thetaNum = 0.03;    // sigmoid系数函数
    private double betaNum = 4.5;     // sigmoid偏移函数
    private double numWeightThreshold = 0.001;    // 数量权重上限，最终数量权重取值[1, 1 + value]

    // cvr上限
    private double cvrBoundWeightThreshold=0.5;  // 当预估值权重大于cvrBoundWeightThreshold的时候cvr上限生效
    private double cvrBoundRatio=2; // cvr上限生效时，上限为统计值的cvrBoundRatio倍
}
