/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.advertexplore;

import cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcbData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreParams;
import cn.com.duiba.nezha.alg.common.model.advertexplore.UcbResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdExploreUcb {
    private static double calWilsonScore(Long exposeCnt, Long clickCnt) {
        if (exposeCnt == null || clickCnt == null || exposeCnt == 0L) {
            return 0.0;
        }
        double ratio = (double)clickCnt.longValue() * 1.0 / (double)exposeCnt.longValue();
        double faithLevel = 0.95;
        double faithSquare = faithLevel * faithLevel;
        return (ratio + faithSquare / (double)(2L * exposeCnt) - faithLevel * Math.sqrt((double)(4L * exposeCnt) * ratio * (1.0 - ratio) + faithSquare) / (double)(2L * exposeCnt)) / (1.0 + faithSquare / (double)exposeCnt.longValue());
    }

    public static Double concatUcb(Double val1, Double val2, Double explore1, Double explore2, List<Double> alpha) {
        return val1 == null || val2 == null || explore1 == null || explore2 == null ? 0.0 : alpha.get(0) * val1 + alpha.get(1) * val2 + alpha.get(2) * explore1 + alpha.get(3) * explore2;
    }

    public static Double division(Long v1, Long v2) {
        return v1 != null && v2 != null && v2 != 0L ? v1.doubleValue() / v2.doubleValue() : 0.0;
    }

    public static Double division(Double v1, Long v2) {
        return v1 != null && v2 != null && v2 != 0L ? v1 / v2.doubleValue() : 0.0;
    }

    public static Double dot(Long v1, Long v2) {
        return v1 != null && v2 != null ? v1.doubleValue() * v2.doubleValue() : 0.0;
    }

    public static Double dot(Double v1, Double v2) {
        return v1 != null && v2 != null ? v1 * v2 : 0.0;
    }

    public static Long add(Long v1, Long v2) {
        return v1 != null && v2 != null ? v1 + v2 : 0L;
    }

    public static Double add(Double v1, Double v2) {
        return v1 != null && v2 != null ? v1 + v2 : 0.0;
    }

    public static Double subtract(Double v1, Double v2) {
        return v1 != null && v2 != null ? v1 - v2 : 0.0;
    }

    public static Double log(Long v1) {
        return v1 != null ? Math.log(v1.longValue()) : 0.0;
    }

    public static Double log10(Long v1) {
        return v1 != null ? Math.log10(v1.longValue()) : 0.0;
    }

    public static Map<Long, UcbResult> calcUcb(ExploreData app3dRt, AdExploreUcbData adExploreUcbData, ExploreParams params) throws IllegalArgumentException {
        HashMap<Long, UcbResult> accUcb = new HashMap<Long, UcbResult>();
        double appWeight = Math.sqrt(AdExploreUcb.log10(adExploreUcbData.getTestExpose3dRt()) / (double)AdExploreUcb.add(adExploreUcbData.getAppTestExpose3dRt(), 1L).longValue());
        if (app3dRt != null) {
            double appCtr = AdExploreUcb.calWilsonScore(app3dRt.getExposure(), app3dRt.getClick());
            HashMap appConv = new HashMap();
            HashMap<Integer, Long> appCvr = app3dRt.getConv() != null ? app3dRt.getConv() : new HashMap<Integer, Long>();
            for (int i = 0; i < 9; ++i) {
                if (appCvr.containsKey(i)) continue;
                appCvr.put(i, 0L);
            }
            for (Map.Entry objConv : appCvr.entrySet()) {
                appConv.put(objConv.getKey(), AdExploreUcb.calWilsonScore(app3dRt.getClick(), (Long)objConv.getValue()));
            }
            Map<Long, ExploreData> acc3dRt = adExploreUcbData.getAppAcc3dRt();
            if (acc3dRt != null) {
                for (Map.Entry<Long, ExploreData> at3dRt : acc3dRt.entrySet()) {
                    List<Double> ucbAlpha2;
                    List<Double> ucbAlpha1 = at3dRt.getValue().getExposure() != null && at3dRt.getValue().getExposure() > params.getUcbAlphaCnt1() ? params.getUcbAlpha1() : params.getUcbAlpha1start();
                    List<Double> list = ucbAlpha2 = at3dRt.getValue().getClick() != null && at3dRt.getValue().getExposure() > params.getUcbAlphaCnt2() ? params.getUcbAlpha2() : params.getUcbAlpha2start();
                    if (ucbAlpha1 == null || ucbAlpha1.size() != 4 || ucbAlpha2 == null || ucbAlpha2.size() != 4) {
                        throw new IllegalArgumentException("Params is illegal");
                    }
                    double accWeight = Math.sqrt(AdExploreUcb.division(AdExploreUcb.log10(adExploreUcbData.getAppTestExpose3dRt()), AdExploreUcb.add(adExploreUcbData.getAppAccTestExpose3dRt().get(at3dRt.getKey()), 1L)));
                    double subAppAccCtr = AdExploreUcb.calWilsonScore(app3dRt.getExposure(), app3dRt.getClick());
                    double concatCtr = AdExploreUcb.concatUcb(appCtr, subAppAccCtr, appWeight, accWeight, ucbAlpha1);
                    HashMap<Integer, Double> result = new HashMap<Integer, Double>();
                    HashMap<Integer, String> resultInfo = new HashMap<Integer, String>();
                    Map<Object, Object> subAppCvr = at3dRt.getValue().getConv() != null ? at3dRt.getValue().getConv() : new HashMap();
                    for (int i = 0; i < 9; ++i) {
                        if (subAppCvr.containsKey(i)) continue;
                        subAppCvr.put(i, 0L);
                    }
                    for (Map.Entry<Object, Object> objConv : subAppCvr.entrySet()) {
                        double subAppAccCvr = AdExploreUcb.calWilsonScore(at3dRt.getValue().getClick(), (Long)objConv.getValue());
                        double concatCvr = AdExploreUcb.concatUcb((Double)appConv.get(objConv.getKey()), subAppAccCvr, appWeight, accWeight, ucbAlpha2);
                        result.put((Integer)objConv.getKey(), concatCtr * concatCvr);
                        resultInfo.put((Integer)objConv.getKey(), appCtr + "_" + subAppAccCtr + "_" + appWeight + "_" + accWeight + "_" + appConv.get(objConv.getKey()) + "_" + subAppAccCvr);
                    }
                    UcbResult ucbResult = new UcbResult();
                    ucbResult.setObjUcb(result);
                    ucbResult.setObjUcbInfo(resultInfo);
                    accUcb.put(at3dRt.getKey(), ucbResult);
                }
            }
        }
        return accUcb;
    }
}

