/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.advertexplore;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.HashMap;
import java.util.Map;

public class ExploreData {
    String id;
    Long exposure = 0L;
    Long click = 0L;
    Map<Integer, Long> conv = new HashMap<Integer, Long>();
    Long consume = 0L;
    Long ocpcConsume = 0L;
    Double costBias = 0.0;

    public double getCtr() {
        if (this.exposure <= 0L) {
            return 0.0;
        }
        return DataUtil.formatDouble((double)this.click.longValue() * 1.0 / (double)this.exposure.longValue(), 4);
    }

    public double getWCtr(double faithLevel) {
        return DataUtil.formatDouble(DataUtil.calWilsonScore(this.exposure, this.click, faithLevel), 4);
    }

    public double getCvr(Integer convertSubtype) {
        if (this.click <= 0L) {
            return 0.0;
        }
        return DataUtil.formatDouble((double)this.conv.getOrDefault(convertSubtype, 0L).longValue() * 1.0 / (double)this.click.longValue(), 4);
    }

    public double getWCvr(Integer convertSubtype, double faithLevel) {
        return DataUtil.formatDouble(DataUtil.calWilsonScore(this.click, this.conv.getOrDefault(convertSubtype, 0L), faithLevel), 4);
    }

    public double getCtCvr(Integer convertSubtype) {
        if (this.exposure <= 0L) {
            return 0.0;
        }
        return DataUtil.formatDouble((double)this.conv.getOrDefault(convertSubtype, 0L).longValue() * 1.0 / (double)this.exposure.longValue(), 4);
    }

    public double getWCtCvr(Integer convertSubtype, double faithLevel) {
        return DataUtil.formatDouble(DataUtil.calWilsonScore(this.exposure, this.conv.getOrDefault(convertSubtype, 0L), faithLevel), 4);
    }

    public String getId() {
        return this.id;
    }

    public Long getExposure() {
        return this.exposure;
    }

    public Long getClick() {
        return this.click;
    }

    public Map<Integer, Long> getConv() {
        return this.conv;
    }

    public Long getConsume() {
        return this.consume;
    }

    public Long getOcpcConsume() {
        return this.ocpcConsume;
    }

    public Double getCostBias() {
        return this.costBias;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setExposure(Long exposure) {
        this.exposure = exposure;
    }

    public void setClick(Long click) {
        this.click = click;
    }

    public void setConv(Map<Integer, Long> conv) {
        this.conv = conv;
    }

    public void setConsume(Long consume) {
        this.consume = consume;
    }

    public void setOcpcConsume(Long ocpcConsume) {
        this.ocpcConsume = ocpcConsume;
    }

    public void setCostBias(Double costBias) {
        this.costBias = costBias;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExploreData)) {
            return false;
        }
        ExploreData other = (ExploreData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Long this$exposure = this.getExposure();
        Long other$exposure = other.getExposure();
        if (this$exposure == null ? other$exposure != null : !((Object)this$exposure).equals(other$exposure)) {
            return false;
        }
        Long this$click = this.getClick();
        Long other$click = other.getClick();
        if (this$click == null ? other$click != null : !((Object)this$click).equals(other$click)) {
            return false;
        }
        Map<Integer, Long> this$conv = this.getConv();
        Map<Integer, Long> other$conv = other.getConv();
        if (this$conv == null ? other$conv != null : !((Object)this$conv).equals(other$conv)) {
            return false;
        }
        Long this$consume = this.getConsume();
        Long other$consume = other.getConsume();
        if (this$consume == null ? other$consume != null : !((Object)this$consume).equals(other$consume)) {
            return false;
        }
        Long this$ocpcConsume = this.getOcpcConsume();
        Long other$ocpcConsume = other.getOcpcConsume();
        if (this$ocpcConsume == null ? other$ocpcConsume != null : !((Object)this$ocpcConsume).equals(other$ocpcConsume)) {
            return false;
        }
        Double this$costBias = this.getCostBias();
        Double other$costBias = other.getCostBias();
        return !(this$costBias == null ? other$costBias != null : !((Object)this$costBias).equals(other$costBias));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExploreData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Long $exposure = this.getExposure();
        result = result * 59 + ($exposure == null ? 43 : ((Object)$exposure).hashCode());
        Long $click = this.getClick();
        result = result * 59 + ($click == null ? 43 : ((Object)$click).hashCode());
        Map<Integer, Long> $conv = this.getConv();
        result = result * 59 + ($conv == null ? 43 : ((Object)$conv).hashCode());
        Long $consume = this.getConsume();
        result = result * 59 + ($consume == null ? 43 : ((Object)$consume).hashCode());
        Long $ocpcConsume = this.getOcpcConsume();
        result = result * 59 + ($ocpcConsume == null ? 43 : ((Object)$ocpcConsume).hashCode());
        Double $costBias = this.getCostBias();
        result = result * 59 + ($costBias == null ? 43 : ((Object)$costBias).hashCode());
        return result;
    }

    public String toString() {
        return "ExploreData(id=" + this.getId() + ", exposure=" + this.getExposure() + ", click=" + this.getClick() + ", conv=" + this.getConv() + ", consume=" + this.getConsume() + ", ocpcConsume=" + this.getOcpcConsume() + ", costBias=" + this.getCostBias() + ")";
    }
}

