package cn.com.duiba.nezha.alg.common.model.advertexplore;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import static cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcb.division;

public class AdjustPrice {

    public static List<AdjPriceResult> adjustFactor(List<AdjPriceInfo> exploreInfos,
                                      ExploreParams exploreParams) {

        List<Double> biasBucket = exploreParams.getBiasBucket();
        List<Double> factorBucket = exploreParams.getFactorBucket();
        List<Double> expBiasBucket = exploreParams.getExpBiasBucket();
        List<Double> expFactorBucket = exploreParams.getExpFactorBucket();

        double biasWeight = exploreParams.getBiasWeight();
        double supportLimit = exploreParams.getSupportLimit();

        Double[] biasBucket1 = new Double[biasBucket.size()];
        Double[] factorBucket1 = new Double[factorBucket.size()];
        biasBucket1 = biasBucket.toArray(biasBucket1);
        factorBucket1 = factorBucket.toArray(factorBucket1);

        Double[] expbiasBucket1 = expBiasBucket.toArray(new Double[expBiasBucket.size()]);
        Double[] expFactorBucket1 = expFactorBucket.toArray(new Double[expFactorBucket.size()]);
        Double[] finalBiasBucket = biasBucket1;
        Double[] finalFactorBucket = factorBucket1;
        return exploreInfos.stream().map(info ->
                adjustFactor(info, finalBiasBucket, finalFactorBucket,
                        expbiasBucket1, expFactorBucket1, biasWeight, supportLimit)).collect(Collectors.toList());
    }

    /**
     * 加价接口2
     */
    public static AdjPriceResult adjustFactor(AdjPriceInfo exploreInfo,
                                       Double[] biasBucket,
                                       Double[] factor,
                                       Double[] expBiasBucket,
                                       Double[] expFactor,
                                       Double biasWeight,
                                       Double supportLimit) {
        AdjPriceResult adjPriceResult = new AdjPriceResult();
        adjPriceResult.setOrientId(exploreInfo.getOrientId());
        double f = 1.0;
        if (!AssertUtil.isAnyEmpty(
                exploreInfo.getAppAdvertInfo(),
                exploreInfo.getAppAccountInfo())) {
            //配置成本
            long consume = exploreInfo.getOrientOcpcConsume();//消耗
            long conv = exploreInfo.getOrientConv().getOrDefault(exploreInfo.getConvertType(), 0L);//转化
            double cost = conv >= 5 ? division(division(consume, conv), exploreInfo.getTarget()) : 1.0;

            double f1 = getConfidenceWeight(cost, biasBucket, factor, 1.0);

            //拓量成本
            double exploreCost = 1.0;
            if(exploreInfo.getOrientExpCost() != null && exploreInfo.getOrientExpCost().getExploreAdjConsume() > 3000) {
                exploreCost = division(exploreInfo.getOrientExpCost().getExploreConsume(),
                        exploreInfo.getOrientExpCost().getExploreAdjConsume());
            }else if(exploreInfo.getAppAdvertInfo().getConsume() != null &&
                    exploreInfo.getAppAdvertInfo().getConsume().getExploreAdjConsume() != null &&
                    exploreInfo.getAppAdvertInfo().getConsume().getExploreAdjConsume() > 5000) {
                exploreCost = division(exploreInfo.getAppAdvertInfo().getConsume().getExploreConsume(),
                        exploreInfo.getAppAdvertInfo().getConsume().getExploreAdjConsume());
            }else if(exploreInfo.getAppAccountInfo().getConsume() != null &&
                    exploreInfo.getAppAccountInfo().getConsume().getExploreAdjConsume() != null &&
                    exploreInfo.getAppAccountInfo().getConsume().getExploreAdjConsume() > 5000){
                exploreCost = division(exploreInfo.getAppAccountInfo().getConsume().getExpConsume(),
                        exploreInfo.getAppAccountInfo().getConsume().getExploreAdjConsume());
            }else{
                biasWeight = 1.0;
            }

            double f2 = getConfidenceWeight(exploreCost, expBiasBucket, expFactor, 1.0);

            f = biasWeight * f1 + (1 - biasWeight) * f2;

            double ratio = (double) exploreInfo.getAppAdvertInfo().getAppAdBidCnt() / exploreInfo.getAppAdvertInfo().getAppAdExpCnt();
            // TO DO：根据参竞失败率调整加价系数
        }
        adjPriceResult.setExpAdjustFactor(f);
        return adjPriceResult;
    }


    public static Double getConfidenceWeight(Double value, Double[] bucketList, Double[] weightList, double defaultValue) {

        Double ret = defaultValue;

        if (value != null && bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {

            double lastWeight = weightList[0];
            double lastBound = bucketList[0];

            for (int i = 0, size = bucketList.length; i < size; i++) {
                double curWeight = weightList[i];
                double curBound = bucketList[i];

                double bound = bucketList[i];
                if (value <= bound) {

                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                    } else {
                        ret = weightList[0];
                    }
                    break;

                } else if (i == size - 1) {
                    ret = weightList[size - 1];
                }

                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }

        }

        return DataUtil.formatDouble(ret, 3);
    }



    public static void main(String[] args) {

    }


}
