/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.advertexplore;

import cn.com.duiba.nezha.alg.common.model.advertexplore.AppAdvertInfo;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExpHourData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreInfo;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreV1Params;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreV1PkgData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreV1Result;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreV1Type;
import cn.com.duiba.nezha.alg.common.model.advertexplore.PredictData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightDimEnum;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightInfo;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightInfoList;
import cn.com.duiba.nezha.alg.common.model.advertexplore.expcontroller.BidPidController;
import cn.com.duiba.nezha.alg.common.model.advertexplore.expcontroller.CvrPidController;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

public class AdvertExploreV1 {
    public static ExploreV1Result explore(List<ExploreInfo> exploreInfos, ExploreV1Params params) {
        if (AssertUtil.isAnyEmpty(exploreInfos, params)) {
            return null;
        }
        ArrayList<ExploreV1PkgData> resList = new ArrayList<ExploreV1PkgData>();
        HashMap<ExploreV1Type, Integer> exploreTypeMap = new HashMap<ExploreV1Type, Integer>();
        boolean isKeepMedia = AdvertExploreV1.mediaFilter(exploreInfos.get(0).getAppDataInfo().getData3Day(), params);
        if (!isKeepMedia) {
            exploreTypeMap.put(ExploreV1Type.G0, exploreInfos.size());
        } else {
            Map<ExploreV1Type, List<ExploreInfo>> exposureFilterMap = exploreInfos.stream().collect(Collectors.groupingBy(p -> {
                ExploreData data = p.getAppAdvertInfo().getData3day();
                return AdvertExploreV1.exposureFilter(data.getExposure(), data.getConv().getOrDefault(p.getConvertType(), 0L), data.getOcpcConsume(), data.getCostBias(), params);
            }));
            exploreTypeMap.put(ExploreV1Type.G2, ((List)exposureFilterMap.getOrDefault((Object)ExploreV1Type.G2, new ArrayList(0))).size());
            List etList = ((List)exposureFilterMap.getOrDefault((Object)ExploreV1Type.ET, new ArrayList(0))).stream().map(p -> new ExploreV1PkgData(p.getOrientationId(), p.getAdvertId(), 1, p.getTarget(), -1.0, -1.0)).collect(Collectors.toList());
            exploreTypeMap.put(ExploreV1Type.ET, etList.size());
            exploreInfos = exposureFilterMap.getOrDefault((Object)ExploreV1Type.EE, new ArrayList(0));
            Map<ExploreV1Type, List<ExploreInfo>> exploreFilterMap = exploreInfos.stream().collect(Collectors.groupingBy(p -> {
                AppAdvertInfo appAdvertInfo = p.getAppAdvertInfo();
                return AdvertExploreV1.exploreFilter(appAdvertInfo.getAdvertExploreV1Consume(), appAdvertInfo.getAdvertOcpcConsume(), params);
            }));
            exploreTypeMap.put(ExploreV1Type.G1, ((List)exploreFilterMap.getOrDefault((Object)ExploreV1Type.G1, new ArrayList(0))).size());
            exploreInfos = exploreFilterMap.getOrDefault((Object)ExploreV1Type.EE, new ArrayList(0));
            List explorePkgs = exploreInfos.stream().map(p -> AdvertExploreV1.calExploreData(p.getOrientationId(), p.getAdvertId(), p.getAdvertPkBase(), p.getAdvertPkExpV1(), p.getAdvertPkAppBase(), p.getAdvertPkAppExpV1(), p.appDataInfo.data3Day, p.appTradeInfo.data3day, p.appAccountInfo.data3day, p.appAdvertInfo.data3day, p.appOrientExp3day, p.appOrientClick3day, p.appOrientConv3day, p.predictData, p.convertType, p.target, params)).collect(Collectors.toList());
            Map<ExploreV1Type, List<ExploreV1PkgData>> bidFilterMap = explorePkgs.stream().collect(Collectors.groupingBy(p -> AdvertExploreV1.bidFilter(p, params)));
            exploreTypeMap.put(ExploreV1Type.G3, ((List)bidFilterMap.getOrDefault((Object)ExploreV1Type.G3, new ArrayList(0))).size());
            List eeList = bidFilterMap.getOrDefault((Object)ExploreV1Type.EE, new ArrayList(0));
            exploreTypeMap.put(ExploreV1Type.EE, eeList.size());
            resList.addAll(eeList);
            resList.addAll(etList);
        }
        return new ExploreV1Result(params, exploreTypeMap, resList);
    }

    private static ExploreV1PkgData calExploreData(Long orientationId, Long advertId, ExpHourData orientBase, ExpHourData orientExpV1, ExpHourData mediaOrientBase, ExpHourData mediaOrientExpV1, ExploreData media, ExploreData mediaAndTrade, ExploreData mediaAndAccount, ExploreData mediaAndAdvert, Long mediaOrientExp, Long mediaOrientClick, Map<Integer, Long> mediaOrientConv, PredictData predictData, Integer convertSubType, Long target, ExploreV1Params params) {
        media.setId(WeightDimEnum.MEDIA.getId());
        mediaAndTrade.setId(WeightDimEnum.MEDIA_AND_TRADE.getId());
        mediaAndAccount.setId(WeightDimEnum.MEDIA_AND_ACCOUNT.getId());
        mediaAndAdvert.setId(WeightDimEnum.MEDIA_AND_ADVERT.getId());
        ExploreData mediaAndOrient = new ExploreData();
        mediaAndOrient.setId(WeightDimEnum.MEDIA_AND_ORIENT.getId());
        mediaAndOrient.setExposure(mediaOrientExp);
        mediaAndOrient.setClick(mediaOrientClick);
        mediaAndOrient.setConv(mediaOrientConv);
        ExploreData[] statDatas = new ExploreData[]{mediaAndAdvert, mediaAndAccount, media};
        predictData.setId(WeightDimEnum.MODEL.getId());
        WeightInfoList ctrWeightInfos = AdvertExploreV1.calCtrWeights(params, predictData, mediaAndOrient, statDatas);
        double mergeCtr = ctrWeightInfos.stream().map(w -> w.getW() * w.getV()).reduce(0.0, Double::sum);
        WeightInfoList cvrWeightInfos = AdvertExploreV1.calCvrWeightInfos(params, predictData, mediaAndOrient, convertSubType, statDatas);
        double mergeCvr = cvrWeightInfos.stream().map(w -> w.getW() * w.getV()).reduce(0.0, Double::sum);
        WeightInfo costWeightInfo = CvrPidController.calcControlFactor(orientExpV1, convertSubType, params.getCostFactorUpperBound(), params.getCostFactorLowerBound(), params.getKp(), params.getKi(), params.getCostControlClickCntThreshold(), WeightDimEnum.CVR_FACTOR);
        WeightInfo cvrNumWeightInfo = AdvertExploreV1.numWeight(mediaAndAdvert, params, mergeCvr *= costWeightInfo.getV(), false);
        mergeCvr *= cvrNumWeightInfo.getW();
        WeightInfo bidWeightInfo = BidPidController.calcControlFactor(mediaOrientBase, orientBase, params.getBidReqCntThreshold(), params.getTargetRatio(), params.getBidFactorUpperBound(), params.getBidFactorLowerBound(), params.getBidKp(), params.getBidKi(), WeightDimEnum.BID_FACTOR_MEDIA);
        mergeCvr *= bidWeightInfo.getV();
        mergeCvr = AdvertExploreV1.boundCvr(mergeCvr, cvrWeightInfos, mediaAndAdvert, predictData, convertSubType, params);
        return new ExploreV1PkgData(orientationId, advertId, 0, target, DataUtil.formatdouble(mergeCtr, 6), DataUtil.formatdouble(mergeCvr, 6), ctrWeightInfos, cvrWeightInfos, costWeightInfo, bidWeightInfo, cvrNumWeightInfo);
    }

    public static WeightInfo numWeight(ExploreData statData, ExploreV1Params params, double value, boolean isCtr) {
        Long cnt = statData.getExposure();
        String dimName = isCtr ? WeightDimEnum.CTR_NUM.getId() : WeightDimEnum.CVR_NUM.getId();
        double sigmoidValue = AdvertExploreV1.calSigmoid(params.getThetaNum(), params.getBetaNum(), cnt.longValue());
        double weight = 1.0 + (1.0 - sigmoidValue) * params.getNumWeightThreshold();
        return new WeightInfo(dimName, cnt, DataUtil.formatDouble(weight, 4), DataUtil.formatDouble(value, 6));
    }

    public static WeightInfo calCostWeight(ExploreData statData, ExploreV1Params params, double value) {
        double costWeight;
        if (statData.getExposure() < params.getCostExpThreshold()) {
            costWeight = 1.0;
        } else {
            double linerWeight = 1.02 / (statData.getCostBias() + 1.0);
            costWeight = Math.min(Math.max(linerWeight, 1.0 - params.getCostWeightThreshold()), 1.0 + params.getCostWeightThreshold());
        }
        return new WeightInfo(WeightDimEnum.COST.getId(), statData.getExposure(), DataUtil.formatDouble(costWeight, 4), DataUtil.formatDouble(value, 4));
    }

    public static WeightInfoList calCtrWeights(ExploreV1Params params, PredictData predictData, ExploreData modelStatData, ExploreData ... statDatas) {
        double remainWeight = 1.0;
        double modelWeight = AdvertExploreV1.calDimWeight(remainWeight, params.getCtrWeightThreshold(), params.getThetaCtr(), params.getBetaCtr(), modelStatData.getExposure().longValue());
        WeightInfo modelWeightInfo = new WeightInfo(predictData.getId(), modelStatData.getExposure(), modelWeight, DataUtil.formatDouble(predictData.getCtr(), 4));
        List<WeightInfo> statWeightInfos = AdvertExploreV1.getStatWeightInfos(remainWeight - modelWeight, true, 0, params, statDatas);
        WeightInfoList weightInfos = new WeightInfoList(statWeightInfos.size() + 1);
        weightInfos.add(modelWeightInfo);
        weightInfos.addAll(statWeightInfos);
        return weightInfos.reWeight();
    }

    public static WeightInfoList calCvrWeightInfos(ExploreV1Params params, PredictData predictData, ExploreData modelStatData, Integer convertSubtype, ExploreData ... statDatas) {
        double remainWeight = 1.0;
        double modelWeight = AdvertExploreV1.calDimWeight(remainWeight, params.getCvrWeightThreshold(), params.getThetaCvr(), params.getBetaCvr(), modelStatData.getClick().longValue());
        WeightInfo modelWeightInfo = new WeightInfo(predictData.getId(), modelStatData.getClick(), modelWeight, DataUtil.formatDouble(predictData.getCvr(), 4));
        List<WeightInfo> statWeightInfos = AdvertExploreV1.getStatWeightInfos(remainWeight - modelWeight, false, convertSubtype, params, statDatas);
        WeightInfoList weightInfos = new WeightInfoList(statWeightInfos.size() + 1);
        weightInfos.add(modelWeightInfo);
        weightInfos.addAll(statWeightInfos);
        return weightInfos.reWeight();
    }

    public static List<WeightInfo> getStatWeightInfos(double remainWeight, boolean isCtr, Integer convertSubtype, ExploreV1Params params, ExploreData ... statDatas) {
        ArrayList<WeightInfo> weights = new ArrayList<WeightInfo>(statDatas.length);
        if (isCtr) {
            for (ExploreData data : statDatas) {
                double dimWeight = AdvertExploreV1.calDimWeight(remainWeight, params.getCtrWeightThreshold(), params.getThetaCtr(), params.getBetaCtr(), data.getExposure().longValue());
                remainWeight -= dimWeight;
                weights.add(new WeightInfo(data.getId(), data.getExposure(), dimWeight, data.getCtr()));
            }
        } else {
            for (ExploreData data : statDatas) {
                double dimWeight = AdvertExploreV1.calDimWeight(remainWeight, params.getCvrWeightThreshold(), params.getThetaCvr(), params.getBetaCvr(), data.getClick().longValue());
                if (data.getId() == WeightDimEnum.MEDIA_AND_TRADE.getId()) {
                    dimWeight = 0.0;
                }
                remainWeight -= dimWeight;
                weights.add(new WeightInfo(data.getId(), data.getClick(), dimWeight, data.getCvr(convertSubtype)));
            }
        }
        return weights;
    }

    public static double calDimWeight(double remainWeight, double weightThreshold, double theta, double beta, double value) {
        if (remainWeight < 0.001) {
            return remainWeight;
        }
        double res = 0.0;
        double resWeight = 1.0 / (1.0 + Math.exp(-theta * value + beta));
        res = remainWeight * resWeight;
        res = Math.min(res, weightThreshold);
        return res;
    }

    public static double calSigmoid(double theta, double beta, double value) {
        return 1.0 / (1.0 + Math.exp(-1.0 * theta * value + beta));
    }

    public static double calLogValue(double alpha, double beta, double value) {
        if (value + beta <= 0.0 || alpha <= 0.0) {
            return 0.0;
        }
        return Math.log(value + beta) / Math.log(alpha);
    }

    public static ExploreV1Type bidFilter(ExploreV1PkgData pkgData, ExploreV1Params params) {
        if (pkgData.getTarget() != null && pkgData.getE2() != null && pkgData.getE2() > 0.0) {
            double bid = pkgData.getE2() * (double)pkgData.getTarget().longValue();
            double prob = Math.min(1.0, bid / (params.getBottomFee() * params.getBottomRatio()));
            Random random = new Random();
            return random.nextDouble() < prob ? ExploreV1Type.EE : ExploreV1Type.G3;
        }
        return ExploreV1Type.EE;
    }

    public static boolean isExploit(Long consume, long consumeThreshold, Long convert, long convertThreshold, Double bias, double biasThreshold) {
        return consume != null && consume > consumeThreshold && convert != null && convert > convertThreshold && bias != null && bias < biasThreshold;
    }

    public static ExploreV1Type exposureFilter(Long exp, Long convert, Long consume, Double bias, ExploreV1Params params) {
        if (exp != null && exp < params.getMediaAdExpThreshold()) {
            return ExploreV1Type.EE;
        }
        return AdvertExploreV1.isExploit(consume, params.getExploitConsumeThreshold(), convert, params.getExploitConvertThreshold(), bias, params.getExploitCostBiasThreshold()) ? ExploreV1Type.ET : ExploreV1Type.G2;
    }

    public static ExploreV1Type exploreFilter(Long exploreConsume, Long consume, ExploreV1Params params) {
        double exploreConsumeRatio = 0.0;
        if (exploreConsume != null && consume != null) {
            double d = exploreConsumeRatio = consume > 0L ? (double)exploreConsume.longValue() * 1.0 / (double)consume.longValue() : 0.0;
        }
        if (exploreConsume != null && exploreConsume > params.getExploreMinConsume() && exploreConsumeRatio > params.getExploreConsumeRatio() || exploreConsume != null && exploreConsume > params.getExploreMaxConsume()) {
            return ExploreV1Type.G1;
        }
        return ExploreV1Type.EE;
    }

    public static boolean mediaFilter(ExploreData appDataInfo, ExploreV1Params params) {
        double cpm = 0.0;
        double cvr = 0.0;
        if (appDataInfo.getConsume() > 1000L) {
            double d = cpm = appDataInfo.getExposure() > 0L ? (double)appDataInfo.getConsume().longValue() * 1.0 / (double)appDataInfo.getExposure().longValue() : 0.0;
        }
        if (appDataInfo.getConv().get(0) != null && appDataInfo.getClick() > 50L) {
            cvr = appDataInfo.getClick() > 0L ? (double)appDataInfo.getConv().get(0).longValue() * 1.0 / (double)appDataInfo.getClick().longValue() : 0.0;
        }
        double cpmProb = Math.min(1.0, cpm / (params.getAppCpmRatio() * params.getAppCpmBase()));
        double cvrProb = Math.min(1.0, cvr / (params.getAppCvrRatio() * params.getAppCvrBase()));
        double prob = Math.max(params.getAppMinRatio(), Math.min(cpmProb, cvrProb));
        Random random = new Random();
        return random.nextDouble() < prob;
    }

    public static double boundCvr(double mergeCvr, WeightInfoList cvrWeighInfoList, ExploreData mediaAndAdvert, PredictData predictData, Integer convertSubType, ExploreV1Params params) {
        if (cvrWeighInfoList.getMw() < params.getCvrBoundWeightThreshold()) {
            double predCvr = predictData.getCvr();
            double boundCvr = Math.min(mergeCvr, params.getCvrBoundRatio() * predCvr);
            return boundCvr;
        }
        double statCvr = mediaAndAdvert.getCvr(convertSubType);
        double boundCvr = Math.min(mergeCvr, params.getCvrBoundRatio() * statCvr);
        return boundCvr;
    }

    public static void main(String[] args) {
        System.out.println(Long.MAX_VALUE);
    }
}

