/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.advertexplore;

import cn.com.duiba.nezha.alg.common.model.advertexplore.HourDto;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightDimEnum;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ExpHourData {
    private WeightDimEnum dataType;
    private String id;
    private String lastHour;
    private Map<String, HourDto> hourDtoMap;

    private double division(Long v1, Long v2) {
        return v1 != null && v2 != null && v2 != 0L ? v1.doubleValue() / v2.doubleValue() : 0.0;
    }

    public double getSuccessLastHour() {
        HourDto lastHourDto = this.hourDtoMap.get(this.lastHour);
        if (lastHourDto == null) {
            return 0.0;
        }
        Long biddingCountLastHour = lastHourDto.getBidReqCount();
        Long exposureCountLastHour = lastHourDto.getAdvertExposure();
        Double result = this.division(exposureCountLastHour, biddingCountLastHour);
        return DataUtil.formatDouble(result, 5);
    }

    public double getSuccess24Hour() {
        Collection<HourDto> hourDtoList = this.hourDtoMap.values();
        Long biddingCount24Hour = 0L;
        Long exposureCount24Hour = 0L;
        for (HourDto hourDto : hourDtoList) {
            biddingCount24Hour = biddingCount24Hour + hourDto.getBidReqCount();
            exposureCount24Hour = exposureCount24Hour + hourDto.getAdvertExposure();
        }
        Double result = this.division(exposureCount24Hour, biddingCount24Hour);
        return DataUtil.formatDouble(result, 5);
    }

    public double getCvrLastHour(Integer convertSubtype) {
        HourDto lastHourDto = this.hourDtoMap.get(this.lastHour);
        if (lastHourDto == null) {
            return 0.0;
        }
        Long convertCountLastHour = lastHourDto.getBackendCntMap().getOrDefault(convertSubtype, 0L);
        Long clickCountLastHour = lastHourDto.getClickCnt();
        Double result = this.division(convertCountLastHour, clickCountLastHour);
        return DataUtil.formatDouble(result, 5);
    }

    public double getCvr24Hour(Integer convertSubtype) {
        Long convertCount24Hour = 0L;
        Long clickCount24Hour = 0L;
        for (HourDto hourDto : this.hourDtoMap.values()) {
            convertCount24Hour = convertCount24Hour + hourDto.getBackendCntMap().getOrDefault(convertSubtype, 0L);
            clickCount24Hour = clickCount24Hour + hourDto.getClickCnt();
        }
        Double result = this.division(convertCount24Hour, clickCount24Hour);
        return DataUtil.formatDouble(result, 5);
    }

    public double getMergeCvrLastHour() {
        HourDto lastHourDto = this.hourDtoMap.get(this.lastHour);
        if (lastHourDto == null) {
            return 0.0;
        }
        Double result = lastHourDto.getCvr();
        return DataUtil.formatDouble(result, 5);
    }

    public double getMergeCvr24Hour() {
        long expCount24Hour = 0L;
        double temp = 0.0;
        for (HourDto hourDto : this.hourDtoMap.values()) {
            expCount24Hour += hourDto.getAdvertExposure().longValue();
            temp += (double)hourDto.getAdvertExposure().longValue() * hourDto.getCvr();
        }
        if (expCount24Hour <= 0L) {
            return 0.0;
        }
        Double result = temp / (double)expCount24Hour;
        return DataUtil.formatDouble(result, 5);
    }

    public double getBidSuccessRatioLastHour() {
        HourDto lastHourDto = this.hourDtoMap.get(this.lastHour);
        if (lastHourDto == null) {
            return 0.0;
        }
        Long bidReqCount = lastHourDto.getBidReqCount();
        Long exposure = lastHourDto.getAdvertExposure();
        double bidSuccessRatio = this.division(exposure, bidReqCount);
        return DataUtil.formatDouble(bidSuccessRatio, 5);
    }

    public double getBidSuccessRatio24Hour() {
        long exposure24Hour = 0L;
        long bidReq24Hour = 0L;
        for (HourDto hourDto : this.hourDtoMap.values()) {
            exposure24Hour += hourDto.getAdvertExposure().longValue();
            bidReq24Hour += hourDto.getBidReqCount().longValue();
        }
        double bidSuccessRatio = this.division(exposure24Hour, bidReq24Hour);
        return DataUtil.formatDouble(bidSuccessRatio, 5);
    }

    public static void main(String[] args) {
        HourDto hourDto1 = HourDto.getInstance(10000L, 4000L, 2222L, 1113L, 123L, 44444L, 40022L, 0.02222);
        HourDto hourDto2 = HourDto.getInstance(1000L, 400L, 222L, 113L, 12L, 4444L, 4022L, 0.2222);
        HashMap<String, HourDto> hourDtoMap = new HashMap<String, HourDto>();
        hourDtoMap.put("2020121013", hourDto1);
        hourDtoMap.put("2020121012", hourDto2);
        ExpHourData expHourData = new ExpHourData();
        expHourData.setHourDtoMap(hourDtoMap);
        expHourData.setLastHour("2020121013");
        System.out.println(expHourData.getSuccessLastHour());
        System.out.println(expHourData.getSuccess24Hour());
        System.out.println(expHourData.getCvrLastHour(0));
        System.out.println(expHourData.getCvr24Hour(0));
        System.out.println(expHourData.getCvrLastHour(3));
        System.out.println(expHourData.getCvr24Hour(3));
        System.out.println(expHourData.getMergeCvrLastHour());
        System.out.println(expHourData.getMergeCvr24Hour());
    }

    public WeightDimEnum getDataType() {
        return this.dataType;
    }

    public String getId() {
        return this.id;
    }

    public String getLastHour() {
        return this.lastHour;
    }

    public Map<String, HourDto> getHourDtoMap() {
        return this.hourDtoMap;
    }

    public void setDataType(WeightDimEnum dataType) {
        this.dataType = dataType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLastHour(String lastHour) {
        this.lastHour = lastHour;
    }

    public void setHourDtoMap(Map<String, HourDto> hourDtoMap) {
        this.hourDtoMap = hourDtoMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpHourData)) {
            return false;
        }
        ExpHourData other = (ExpHourData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WeightDimEnum this$dataType = this.getDataType();
        WeightDimEnum other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$lastHour = this.getLastHour();
        String other$lastHour = other.getLastHour();
        if (this$lastHour == null ? other$lastHour != null : !this$lastHour.equals(other$lastHour)) {
            return false;
        }
        Map<String, HourDto> this$hourDtoMap = this.getHourDtoMap();
        Map<String, HourDto> other$hourDtoMap = other.getHourDtoMap();
        return !(this$hourDtoMap == null ? other$hourDtoMap != null : !((Object)this$hourDtoMap).equals(other$hourDtoMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExpHourData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WeightDimEnum $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $lastHour = this.getLastHour();
        result = result * 59 + ($lastHour == null ? 43 : $lastHour.hashCode());
        Map<String, HourDto> $hourDtoMap = this.getHourDtoMap();
        result = result * 59 + ($hourDtoMap == null ? 43 : ((Object)$hourDtoMap).hashCode());
        return result;
    }

    public String toString() {
        return "ExpHourData(dataType=" + (Object)((Object)this.getDataType()) + ", id=" + this.getId() + ", lastHour=" + this.getLastHour() + ", hourDtoMap=" + this.getHourDtoMap() + ")";
    }
}

